/*
 * Decompiled with CFR 0.152.
 */
package search.local;

import constraints.Constraint;
import constraints.CtrHard;
import dashboard.ControlPanel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.IntStream;
import org.xcsp.common.Types;
import search.local.SolverLocal;
import utility.Kit;
import utility.sets.SetSparse;
import variables.Variable;

public class ConflictManager {
    private final SolverLocal solverLocal;
    private final SetSparse set;
    private int currEvaluation;
    private final int[] currVariableEvaluations;
    private long currCost = 0L;

    public int nConflictingConstraints() {
        return this.set.limit + 1;
    }

    public int currEvaluation() {
        return this.currEvaluation;
    }

    public int currEvaluationOf(Variable x) {
        return this.currVariableEvaluations[x.num];
    }

    public int currEvaluationOf(Variable x, Variable y) {
        int evaluation = this.currVariableEvaluations[x.num] + this.currVariableEvaluations[y.num];
        for (Constraint c : x.ctrs) {
            if (!c.involves(y) || ((CtrHard)c).checkCurrentInstantiation()) continue;
            evaluation = (int)((double)evaluation - c.wdeg());
        }
        return evaluation;
    }

    public void clear() {
        this.set.clear();
        Arrays.fill(this.currVariableEvaluations, 0);
    }

    public ConflictManager(SolverLocal localSolver) {
        this.solverLocal = localSolver;
        this.set = new SetSparse(localSolver.pb.constraints.length);
        this.currVariableEvaluations = new int[localSolver.pb.variables.length];
    }

    public void recomputeEvaluations() {
        this.currEvaluation = 0;
        Arrays.fill(this.currVariableEvaluations, 0);
        Constraint[] ctrs = this.solverLocal.pb.constraints;
        ControlPanel cp = this.solverLocal.rs.cp;
        for (int i = this.set.limit; i >= 0; --i) {
            Constraint c = ctrs[this.set.dense[i]];
            cp.hardCoding.getClass();
            c.incrementWdegBy(1.0);
            this.currEvaluation = (int)((double)this.currEvaluation + c.wdeg());
            for (Variable x : c.scp) {
                if (x.decision) {
                    int n = x.num;
                    this.currVariableEvaluations[n] = (int)((double)this.currVariableEvaluations[n] + c.wdeg());
                    continue;
                }
                int[] predecessors = this.solverLocal.getPredecessors(x.num);
                for (int j = 0; j < predecessors.length; ++j) {
                    int n = this.solverLocal.decisionVars[predecessors[j]].num;
                    this.currVariableEvaluations[n] = (int)((double)this.currVariableEvaluations[n] + c.wdeg());
                }
            }
        }
    }

    public void initializeConflictingConstraints() {
        this.clear();
        this.recomputeEvaluations();
        if (this.solverLocal.pb.framework == Types.TypeFramework.COP) {
            this.currCost = this.solverLocal.pb.optimizationPilot.value();
        }
    }

    public boolean checkConflictingConstraints() {
        for (Constraint c : this.solverLocal.pb.constraints) {
            if (!((CtrHard)c).checkCurrentInstantiation() && !this.set.isPresent(c.num)) {
                Kit.log.severe(c + " not satisfied and absent in sparse set.");
                return false;
            }
            if (!((CtrHard)c).checkCurrentInstantiation() || !this.set.isPresent(c.num)) continue;
            Kit.log.severe(c + " satisfied but present in sparse set.");
            return false;
        }
        return true;
    }

    public int computeEvolutionFor(Variable x, int a, int acceptableEvaluationLimit, Long currCostEvolution) {
        int evaluation = -this.currEvaluationOf(x);
        this.solverLocal.propagateDependentVariables();
        HashSet<Constraint> constraintsToCheck = new HashSet<Constraint>();
        for (int i : this.solverLocal.getSuccessors(x.num)) {
            for (Constraint c : this.solverLocal.pb.variables[i].ctrs) {
                constraintsToCheck.add(c);
            }
        }
        Object object = constraintsToCheck.iterator();
        while (object.hasNext()) {
            Constraint c = (Constraint)object.next();
            if (!((CtrHard)c).checkCurrentInstantiation()) {
                evaluation = (int)((double)evaluation + c.wdeg());
            }
            if (evaluation <= acceptableEvaluationLimit) continue;
            break;
        }
        if (this.solverLocal.pb.framework == Types.TypeFramework.COP) {
            assert (currCostEvolution != null);
            currCostEvolution = this.solverLocal.pb.optimizationPilot.value() - this.currCost;
        }
        return evaluation;
    }

    public int computeEvolutionFor(Variable x, int a, int acceptableEvaluationLimit) {
        return this.computeEvolutionFor(x, a, acceptableEvaluationLimit, null);
    }

    public int computeEvolutionFor(Variable x, int a, Variable y, int b, int acceptableEvaluationLimit) {
        int evaluation = -this.currEvaluationOf(x, y);
        this.solverLocal.propagateDependentVariables();
        for (Constraint c : x.ctrs) {
            if (!((CtrHard)c).checkCurrentInstantiation()) {
                evaluation = (int)((double)evaluation + c.wdeg());
            }
            if (evaluation > acceptableEvaluationLimit) break;
        }
        for (Constraint c : y.ctrs) {
            if (c.involves(x)) continue;
            if (!((CtrHard)c).checkCurrentInstantiation()) {
                evaluation = (int)((double)evaluation + c.wdeg());
            }
            if (evaluation > acceptableEvaluationLimit) break;
        }
        return evaluation;
    }

    public int computeEvolutionFor(Variable x, int a) {
        return this.computeEvolutionFor(x, a, Integer.MAX_VALUE);
    }

    public void displayConflictingConstraints() {
        IntStream.rangeClosed(0, this.set.limit).mapToObj(i -> this.solverLocal.pb.constraints[this.set.dense[i]]).forEach(c -> c.display(false));
    }
}

