/*
 * Decompiled with CFR 0.152.
 */
package search.backtrack.localBranching;

import constraints.Constraint;
import java.util.ArrayList;
import java.util.Arrays;
import problem.Problem;
import utility.Kit;
import variables.Variable;

public abstract class LocalBranchingConstraints {
    protected Constraint ctr;
    protected final Variable[] decisionVars;
    private final int[] decisionVaps;

    public LocalBranchingConstraints(Problem pb) {
        int i;
        Variable[] objectiveVars = (Variable[])pb.stuff.stuffOptimization.collectedCostVarsFunctionalPropagatorsAtInit.stream().map(fp -> fp.ctr.scp[fp.outputPos]).toArray(Variable[]::new);
        ArrayList<Variable> decisionVarsList = new ArrayList<Variable>();
        ArrayList<Integer> decisionVapsList = new ArrayList<Integer>();
        for (i = 0; i < pb.variables.length; ++i) {
            if (Kit.isPresent(pb.variables[i], objectiveVars)) continue;
            decisionVarsList.add(pb.variables[i]);
            decisionVapsList.add(i);
        }
        this.decisionVars = decisionVarsList.toArray(new Variable[decisionVarsList.size()]);
        this.decisionVaps = Kit.intArray(decisionVapsList);
        for (i = 0; i < this.decisionVaps.length; ++i) {
            int min = this.decisionVaps[i];
            int minPos = i;
            for (int j = i + 1; j < this.decisionVaps.length; ++j) {
                if (this.decisionVaps[j] >= min) continue;
                min = this.decisionVaps[j];
                minPos = j;
            }
            if (minPos == i) continue;
            this.decisionVaps[minPos] = this.decisionVaps[i];
            this.decisionVaps[i] = min;
            Variable tmp = this.decisionVars[i];
            this.decisionVars[i] = this.decisionVars[minPos];
            this.decisionVars[minPos] = tmp;
        }
    }

    public int[] toDecisionVals(int[] completeInstantiationIdxs) {
        ArrayList<Integer> decisionIdxs = new ArrayList<Integer>();
        for (int i = 0; i < this.decisionVaps.length; ++i) {
            decisionIdxs.add(completeInstantiationIdxs[this.decisionVaps[i]]);
        }
        int[] decisionVals = new int[decisionIdxs.size()];
        for (int i = 0; i < decisionVals.length; ++i) {
            decisionVals[i] = this.decisionVars[i].dom.toVal((Integer)decisionIdxs.get(i));
        }
        return decisionVals;
    }

    public abstract void modifyConstraint(int[] var1, int var2);

    public void updateWithNewSolution(int[] instantiationIdxs, int newDist) {
        this.modifyConstraint(this.toDecisionVals(instantiationIdxs), newDist);
    }

    public boolean isDecisionVap(int vap) {
        return Arrays.binarySearch(this.decisionVaps, vap) >= 0;
    }

    public void setIgnored(boolean b) {
        this.ctr.ignored = b;
    }
}

