/*
 * Decompiled with CFR 0.152.
 */
package search.backtrack.decomposers;

import constraints.Constraint;
import constraints.CtrHard;
import heuristics.values.dynamic.Aic;
import problem.Problem;
import propagation.soft.pfc.RDAC;
import search.backtrack.decomposers.Decomposer;
import search.backtrack.decomposers.DecomposerSolver;
import utility.Kit;
import variables.Variable;
import variables.domains.Domain;

public class Decomposer2
extends Decomposer {
    private Variable var;
    private int a;
    private int k;
    private int nbConstraintsToBeViolated;
    private Constraint[] constraintsToBeViolated;
    private boolean active;
    private RDAC maxCSP;
    private int offset;

    public int getIndex() {
        return this.a;
    }

    public Decomposer2(DecomposerSolver solver) {
        super(solver);
        Problem problem = solver.pb;
        this.maxCSP = (RDAC)solver.propagation;
        Kit.control(problem.variables[0].heuristicVal instanceof Aic);
        this.constraintsToBeViolated = new Constraint[problem.stuff.maxVarDegree()];
    }

    @Override
    public int getNbPieces() {
        return 1;
    }

    private int getAicOf(Variable var) {
        int[] aic = this.maxCSP.aic[var.num];
        this.offset = Integer.MAX_VALUE;
        Domain dom = var.dom;
        int bestIndex = dom.first();
        int idx = dom.next(bestIndex);
        while (idx != -1) {
            if (aic[idx] < aic[bestIndex]) {
                bestIndex = idx;
                this.offset = aic[bestIndex] - aic[idx];
            } else {
                this.offset = Math.min(this.offset, aic[idx] - aic[bestIndex]);
            }
            idx = dom.next(idx);
        }
        return bestIndex;
    }

    @Override
    public void initialize(Variable x) {
        assert (!x.isAssigned() && this.maxCSP.control());
        this.var = x;
        this.active = false;
        if (x.dom.size() == 1) {
            return;
        }
        this.a = this.getAicOf(x);
        assert (this.a == x.heuristicVal.bestValueIndex());
        this.k = this.offset + 1;
        long[][][] minCosts = this.maxCSP.minCosts;
        this.nbConstraintsToBeViolated = 0;
        for (Constraint c : x.ctrs) {
            if (c.futvars.size() == 1) continue;
            int i = c.num;
            int j = c.positionOf(x);
            assert (((CtrHard)c).seekFirstSupportWith(j, this.a) != minCosts[i][j][this.a] > 0L);
            if (minCosts[i][j][this.a] > 0L) continue;
            this.constraintsToBeViolated[this.nbConstraintsToBeViolated++] = c;
        }
    }

    @Override
    public void split() {
        this.active = true;
    }

    @Override
    public int buildPiece(int num) {
        return 1;
    }

    public boolean isSatisfied() {
        if (!this.active) {
            return true;
        }
        int cnt = 0;
        for (int i = 0; cnt < this.k && i < this.nbConstraintsToBeViolated; ++i) {
            if (!((CtrHard)this.constraintsToBeViolated[i]).seekFirstConflictWith(this.constraintsToBeViolated[i].positionOf(this.var), this.a)) continue;
            if (cnt < i) {
                Kit.swap(this.constraintsToBeViolated, cnt, i);
            }
            ++cnt;
        }
        return cnt >= this.k;
    }
}

