/*
 * Decompiled with CFR 0.152.
 */
package search.backtrack;

import constraints.Constraint;
import constraints.CtrHard;
import executables.Resolution;
import heuristics.values.HeuristicValues;
import heuristics.variables.HeuristicVariables;
import heuristics.variables.direct.Rand;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Utilities;
import org.xcsp.modeler.entities.CtrEntities;
import search.backtrack.SolverBacktrack;
import utility.Kit;
import utility.Reflector;
import utility.observers.ObserverBacktrackingSystematic;
import utility.observers.ObserverConstructionProblem;
import utility.sets.SetSparseReversible;
import variables.Variable;
import variables.VariableInteger;
import variables.domains.Domain;

public class SolverBacktrackStatistics
extends SolverBacktrack {
    private static final int FACTOR = 2;
    private int[] nDecisions;
    private final int[][] nImpacts;
    private final int[][] nWipeouts;
    private boolean samplingPhase = true;
    private int clusterSize = 5;
    private int nbClusters = 5;
    private boolean save = true;

    public boolean isDelElementAtLevel(Domain dom, int depth) {
        int a = dom.lastRemoved();
        while (a != -1) {
            if (dom.getRemovedLevelOf(a) == depth) {
                return true;
            }
            a = dom.prevRemoved(a);
        }
        return false;
    }

    public SolverBacktrackStatistics(Resolution resolution) {
        super(resolution);
        int nbVariables = resolution.problem.variables.length;
        this.nDecisions = new int[nbVariables];
        this.nImpacts = new int[nbVariables][nbVariables];
        this.nWipeouts = new int[nbVariables][nbVariables];
        Kit.control(Stream.of(resolution.problem.constraints).allMatch(c -> c.scp.length > 1), () -> "Unary constraints");
    }

    @Override
    public void explore() {
        if (this.samplingPhase) {
            this.minDepth = 0;
            this.rs.solver.propagation.queue.clear();
            while (this.futVars.size() != 0 && !this.hasFinished() && !this.restarter.hasFinishedRun()) {
                int a;
                Variable x = this.heuristicVars.bestVar();
                boolean consistent = this.tryAssignment(x, a = x.heuristicVal.bestValueIndex());
                if (consistent) continue;
                for (int i = 0; i < this.dr.decisions.size(); ++i) {
                    int dec = this.dr.decisions.dense[i];
                    Variable y = this.dr.varIn(dec);
                    Kit.control(dec > 0);
                    int n = y.num;
                    this.nDecisions[n] = this.nDecisions[n] + 1;
                    for (Variable z : this.rs.problem.variables) {
                        if (!this.isDelElementAtLevel(z.dom, i + 1)) continue;
                        int[] nArray = this.nImpacts[y.num];
                        int n2 = z.num;
                        nArray[n2] = nArray[n2] + 1;
                    }
                }
                int[] nArray = this.nWipeouts[x.num];
                int n = this.rs.solver.propagation.lastWipeoutVar.num;
                nArray[n] = nArray[n] + 1;
                break;
            }
        } else {
            super.explore();
        }
    }

    private void saveStats() {
        Throwable throwable;
        PrintWriter out;
        if (!this.save) {
            return;
        }
        String name = this.rs.problem.name();
        name = name.substring(name.lastIndexOf(File.separatorChar) >= 0 ? name.lastIndexOf(File.separatorChar) + 1 : 0) + ".stats";
        Variable[] vars = this.rs.problem.variables;
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(name)));
            throwable = null;
            try {
                out.println(vars.length + " variables");
                for (Variable variable : vars) {
                    out.println(variable.id() + " #decs= " + this.nDecisions[variable.num]);
                    out.println(Stream.of(vars).filter(y -> y != x && this.nImpacts[x.num][y.num] > 0).map(y -> y.id() + ":" + this.nImpacts[x.num][y.num]).collect(Collectors.joining(" ")));
                    out.println(Stream.of(vars).filter(y -> y != x && this.nWipeouts[x.num][y.num] > 0).map(y -> y.id() + ":" + this.nWipeouts[x.num][y.num]).collect(Collectors.joining(" ")));
                }
                Kit.log.info("File " + name + " has been saved");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        name = this.rs.problem.name();
        name = name.substring(name.lastIndexOf(File.separatorChar) >= 0 ? name.lastIndexOf(File.separatorChar) + 1 : 0) + ".network";
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(name)));
            throwable = null;
            try {
                out.println(this.rs.problem.constraints.length + " constraints");
                for (Comparable<Variable> comparable : this.rs.problem.constraints) {
                    out.println(Kit.join((Object)((Constraint)comparable).scp, new String[0]));
                }
                Kit.log.info("File " + name + " has been saved");
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (out != null) {
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private double score(int i, int j) {
        return this.nImpacts[i][j] + 2 * this.nWipeouts[i][j] + this.nImpacts[j][i] + 2 * this.nWipeouts[j][i];
    }

    private double score(Set<Integer> set, int i) {
        return set.stream().mapToDouble(j -> this.score(i, (int)j)).sum();
    }

    private Set<Variable> buildCluster(boolean[] unfree) {
        int i2;
        Variable[] vars = this.rs.problem.variables;
        HashSet<Integer> set = new HashSet<Integer>();
        int bestI = 0;
        int bestJ = 0;
        double bestScore = -1.0;
        for (i2 = 0; i2 < vars.length; ++i2) {
            if (unfree[i2]) continue;
            for (int j = i2 + 1; j < vars.length; ++j) {
                double score;
                if (unfree[j] || !((score = this.score(i2, j)) > bestScore)) continue;
                bestI = i2;
                bestJ = j;
                bestScore = score;
            }
        }
        set.add(bestI);
        set.add(bestJ);
        while (set.size() < this.clusterSize) {
            bestI = 0;
            bestScore = -1.0;
            for (i2 = 0; i2 < vars.length; ++i2) {
                double score;
                if (unfree[i2] || set.contains(i2) || !((score = this.score(set, i2)) > bestScore)) continue;
                bestI = i2;
                bestScore = score;
            }
            set.add(bestI);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            int i3 = (Integer)iterator.next();
            unfree[i3] = true;
        }
        return set.stream().map(i -> vars[i]).collect(Collectors.toSet());
    }

    private void subsearch(Variable[] globalScp, CtrHard[] ctrs, int i, int[] tmp, List<int[]> tuples, Map<Variable, List<CtrHard>> byVar) {
        if (i == globalScp.length) {
            tuples.add((int[])tmp.clone());
        } else {
            int a = globalScp[i].dom.first();
            while (a != -1) {
                tmp[i] = globalScp[i].dom.toVal(a);
                boolean consistent = true;
                if (byVar.containsKey(globalScp[i])) {
                    for (CtrHard c : byVar.get(globalScp[i])) {
                        int[] t = c.tupleManager.localTuple;
                        for (int j = 0; j < c.scp.length; ++j) {
                            t[j] = tmp[Utilities.indexOf((Object)c.scp[j], (Object[])globalScp)];
                        }
                        if (c.checkValues(t)) continue;
                        consistent = false;
                        break;
                    }
                }
                if (consistent) {
                    this.subsearch(globalScp, ctrs, i + 1, tmp, tuples, byVar);
                }
                a = globalScp[i].dom.next(a);
            }
        }
    }

    private int[][] subsearch(Variable[] globalScp, CtrHard[] ctrs) {
        Map<Variable, List<CtrHard>> byVar = Stream.of(ctrs).collect(Collectors.groupingBy(c -> {
            Variable last = null;
            for (int i = globalScp.length - 1; i >= 0; --i) {
                if (!c.involves(globalScp[i])) continue;
                last = globalScp[i];
                break;
            }
            return last;
        }));
        for (Variable x : globalScp) {
            System.out.println("Sub " + x + " => " + (byVar.containsKey(x) ? Kit.join((Collection<? extends Object>)byVar.get(x), new String[0]) : ""));
        }
        System.out.println();
        ArrayList<int[]> tuples = new ArrayList<int[]>();
        int[] tmp = new int[globalScp.length];
        this.subsearch(globalScp, ctrs, 0, tmp, tuples, byVar);
        return Kit.intArray2D(tuples);
    }

    private void subsearch2(Variable[] globalScp, CtrHard[] ctrs, int i, int[] tmp, List<int[]> tuples, Map<Constraint, Variable> ctrVarLast, Map<Variable, List<CtrHard>> byVarButLastOne, SetSparseReversible[] ssets) {
        if (i == globalScp.length) {
            tuples.add((int[])tmp.clone());
        } else {
            Variable x = globalScp[i];
            int[] dense = ssets[i].dense;
            for (int k = ssets[i].limit; k >= 0; --k) {
                int a = dense[k];
                tmp[i] = x.dom.toVal(a);
                boolean consistent = true;
                if (byVarButLastOne.containsKey(x)) {
                    for (CtrHard c : byVarButLastOne.get(x)) {
                        Variable y = ctrVarLast.get(c);
                        int py = c.positionOf(y);
                        int[] t = Pool.tuple(c.scp.length);
                        for (int p = 0; p < c.scp.length; ++p) {
                            if (p == py) continue;
                            t[p] = tmp[Utilities.indexOf((Object)c.scp[p], (Object[])globalScp)];
                        }
                        int j = Utilities.indexOf((Object)y, (Object[])globalScp);
                        int[] dense2 = ssets[j].dense;
                        for (int k2 = ssets[j].limit; k2 >= 0; --k2) {
                            int b = dense2[k2];
                            t[py] = y.dom.toVal(b);
                            if (c.checkValues(t)) continue;
                            ssets[j].remove(b, i);
                        }
                        if (ssets[j].size() != 0) continue;
                        consistent = false;
                        break;
                    }
                }
                if (consistent) {
                    this.subsearch2(globalScp, ctrs, i + 1, tmp, tuples, ctrVarLast, byVarButLastOne, ssets);
                }
                for (SetSparseReversible set : ssets) {
                    set.restoreLimitAtLevel(i);
                }
            }
        }
    }

    private int[][] subsearch2(Variable[] globalScp, CtrHard[] ctrs) {
        HashMap<Constraint, Variable> ctrVarLast = new HashMap<Constraint, Variable>();
        Map<Variable, List<CtrHard>> byVarLastButOne = Stream.of(ctrs).collect(Collectors.groupingBy(c -> {
            Variable last = null;
            Variable lastButOne = null;
            for (int i = globalScp.length - 1; i >= 0; --i) {
                if (!c.involves(globalScp[i])) continue;
                if (last == null) {
                    last = globalScp[i];
                    ctrVarLast.put((Constraint)c, last);
                    continue;
                }
                lastButOne = globalScp[i];
                break;
            }
            return lastButOne;
        }));
        ArrayList<int[]> tuples = new ArrayList<int[]>();
        int[] tmp = new int[globalScp.length];
        SetSparseReversible[] ssets = (SetSparseReversible[])Stream.of(globalScp).map(x -> new SetSparseReversible(x.dom.size(), globalScp.length + 1)).toArray(SetSparseReversible[]::new);
        this.subsearch2(globalScp, ctrs, 0, tmp, tuples, ctrVarLast, byVarLastButOne, ssets);
        return Kit.intArray2D(tuples);
    }

    public final boolean isValid(Variable[] scp, int[] tuple) {
        for (int i = tuple.length - 1; i >= 0; --i) {
            if (scp[i].dom.isPresent(tuple[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void doSearch() {
        if (this.samplingPhase) {
            HeuristicVariables hvar = this.heuristicVars;
            HeuristicValues[] hvals = (HeuristicValues[])Stream.of(this.pb.variables).map(x -> x.heuristicVal).toArray(HeuristicValues[]::new);
            this.heuristicVars = Reflector.buildObject(Rand.class.getSimpleName(), HeuristicVariables.class, this, false);
            Stream.of(this.pb.variables).forEach(x -> {
                x.heuristicVal = Reflector.buildObject(heuristics.values.direct.Rand.class.getSimpleName(), HeuristicValues.class, x, false);
            });
            super.doSearch();
            Kit.control(this.futVars.nDiscarded() == 0);
            this.samplingPhase = false;
            boolean[] unfree = new boolean[this.pb.variables.length];
            ArrayList<CtrEntities.CtrAlone> cas = new ArrayList<CtrEntities.CtrAlone>();
            for (int i2 = 0; i2 < this.nbClusters && 2 * this.clusterSize * i2 < this.pb.variables.length; ++i2) {
                Set<Variable> set = this.buildCluster(unfree);
                CtrHard[] ctrs = (CtrHard[])Stream.of(this.pb.constraints).filter(c -> Stream.of(c.scp).allMatch(x -> set.contains(x))).toArray(CtrHard[]::new);
                Variable[] globalScp = set.toArray(new VariableInteger[0]);
                int[][] tuples = (int[][])Kit.sort(this.subsearch(globalScp, ctrs), Utilities.lexComparatorInt);
                System.out.println(Kit.join((Object)globalScp, new String[0]) + " NbTuples = " + tuples.length);
                cas.add(this.pb.extension((IVar.Var[])globalScp, tuples, true));
            }
            this.pb.storeConstraintsToArray();
            for (CtrEntities.CtrAlone ca : cas) {
                if (ca.ctr instanceof ObserverConstructionProblem) {
                    ((ObserverConstructionProblem)ca.ctr).onConstructionProblemFinished();
                }
                if (ca.ctr instanceof ObserverBacktrackingSystematic) {
                    this.observersBacktrackingSystematic.add((ObserverBacktrackingSystematic)ca.ctr);
                }
                if (!(ca.ctr instanceof ObserverConstructionProblem)) continue;
                this.rs.observersConstructionProblem.add((ObserverConstructionProblem)ca.ctr);
            }
            System.out.println("Restarting");
            this.heuristicVars = hvar;
            IntStream.range(0, this.pb.variables.length).forEach(i -> {
                this.pb.variables[i].heuristicVal = hvals[i];
            });
            this.rs.cp.restarting.cutoff = 10L;
            this.rs.cp.restarting.factor = 1.1;
            this.rs.cp.restarting.n = Integer.MAX_VALUE;
            this.restoreAtDepthBefore(0);
            this.reset();
            this.solve();
        } else {
            super.doSearch();
        }
    }

    static class Pool {
        static Map<Integer, int[]> map = new HashMap<Integer, int[]>();

        Pool() {
        }

        static int[] tuple(int i) {
            int[] t = map.get(i);
            if (t == null) {
                t = new int[i];
                map.put(i, t);
            }
            return t;
        }
    }
}

