/*
 * Decompiled with CFR 0.152.
 */
package search.backtrack.LNS;

import search.Restarter;
import search.Solver;
import search.backtrack.LNS.heuristics.HeuristicFreezing;
import search.backtrack.SolverBacktrack;
import utility.Kit;
import utility.Reflector;

public class RestarterLNS
extends Restarter {
    private final HeuristicFreezing h;

    public RestarterLNS(Solver solver) {
        super(solver);
        Kit.control(solver instanceof SolverBacktrack, () -> "For LNS, only a SolverBacktrack can be used.");
        this.h = Reflector.buildObject(solver.rs.cp.lns.freezingHeuristic, HeuristicFreezing.class, this);
    }

    @Override
    public void beforeRun() {
        super.beforeRun();
        int[] solution = this.solver.solManager.lastSolution;
        if (solution != null) {
            this.h.freezeVariables(solution);
            for (int i = 0; i < this.h.freezingSize; ++i) {
                this.solver.assign(this.solver.pb.variables[this.h.freezingShuffled[i]], solution[this.h.freezingShuffled[i]]);
            }
            this.solver.propagation.runInitially();
        }
    }

    @Override
    public void afterRun() {
        ((SolverBacktrack)this.solver).backtrackToTheRoot();
    }
}

