/*
 * Decompiled with CFR 0.152.
 */
package search;

import java.util.Iterator;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import utility.Kit;
import variables.Variable;

public final class FutureVariables
implements Iterable<Variable> {
    private SimpleIterator iterator1 = new SimpleIterator();
    private SimpleIterator iterator2 = new SimpleIterator();
    public int first = 0;
    public int last;
    public final int[] prevs;
    public final int[] nexts;
    public final int[] pasts;
    public int pastTop;
    private final Variable[] vars;

    @Override
    public Iterator<Variable> iterator() {
        if (this.iterator1.cursor == -1) {
            this.iterator1.cursor = this.first;
            return this.iterator1;
        }
        if (this.iterator2.cursor == -1) {
            this.iterator2.cursor = this.first;
            return this.iterator2;
        }
        System.out.println("CURSORS=" + this.iterator1.cursor + " " + this.iterator2.cursor);
        Kit.control(true, () -> "Only two nested iterations can only be used for the moment");
        return null;
    }

    public FutureVariables(Variable[] vars) {
        this.last = vars.length - 1;
        this.prevs = IntStream.range(-1, vars.length - 1).toArray();
        this.nexts = IntStream.range(1, vars.length + 1).map(i -> i < vars.length ? i : -1).toArray();
        this.pasts = new int[vars.length];
        this.pastTop = -1;
        this.vars = vars;
        Kit.control(Variable.areNumsNormalized(vars));
    }

    public int size() {
        return this.vars.length - this.pastTop - 1;
    }

    public int nDiscarded() {
        return this.pastTop + 1;
    }

    public boolean isPresent(int e) {
        return IntStream.rangeClosed(0, this.pastTop).noneMatch(i -> this.pasts[i] == e);
    }

    private void pop() {
        assert (this.pastTop >= 0);
        int e = this.pasts[this.pastTop--];
        int prev = this.prevs[e];
        int next = this.nexts[e];
        if (prev == -1) {
            this.first = e;
        } else {
            this.nexts[prev] = e;
        }
        if (next == -1) {
            this.last = e;
        } else {
            this.prevs[next] = e;
        }
    }

    private void push(int e) {
        assert (this.isPresent(e));
        int prev = this.prevs[e];
        int next = this.nexts[e];
        if (prev == -1) {
            this.first = next;
        } else {
            this.nexts[prev] = next;
        }
        if (next == -1) {
            this.last = prev;
        } else {
            this.prevs[next] = prev;
        }
        this.pasts[++this.pastTop] = e;
    }

    public Variable first() {
        return this.first == -1 ? null : this.vars[this.first];
    }

    public Variable next(Variable x) {
        assert (x.isFuture());
        int e = this.nexts[x.num];
        return e == -1 ? null : this.vars[e];
    }

    public Variable get(int i) {
        assert (0 <= i && i < this.size());
        int e = this.first;
        for (int cnt = 0; cnt < i; ++cnt) {
            e = this.nexts[e];
        }
        return this.vars[e];
    }

    public Variable lastPast() {
        return this.pastTop == -1 ? null : this.vars[this.pasts[this.pastTop]];
    }

    public void assign(Variable x) {
        this.push(x.num);
    }

    public void unassign(Variable x) {
        assert (this.pastTop >= 0 && x.num == this.pasts[this.pastTop]);
        this.pop();
    }

    public void execute(Consumer<Variable> consumer) {
        int e = this.first;
        while (e != -1) {
            consumer.accept(this.vars[e]);
            e = this.nexts[e];
        }
    }

    public Variable[] toArray() {
        Variable[] t = new Variable[this.size()];
        int cnt = 0;
        int e = this.first;
        while (e != -1) {
            t[cnt++] = this.vars[e];
            e = this.nexts[e];
        }
        return t;
    }

    private class SimpleIterator
    implements Iterator<Variable> {
        private int cursor = -1;

        private SimpleIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != -1;
        }

        @Override
        public Variable next() {
            Variable x = FutureVariables.this.vars[this.cursor];
            this.cursor = FutureVariables.this.nexts[this.cursor];
            return x;
        }
    }
}

