/*
 * Decompiled with CFR 0.152.
 */
package propagation.structures.supporters;

import constraints.CtrSoft;
import constraints.soft.extension.CtrSoftExtension;
import java.util.stream.Stream;
import propagation.structures.supporters.SupporterSoft;
import utility.Kit;

public final class SupporterSoftNary
extends SupporterSoft {
    private final int[][][] residues;
    private int[][][] fdacResidues;

    public SupporterSoftNary(CtrSoft c) {
        super(c);
        Kit.control(c.scp.length > 2);
        this.residues = (int[][][])Stream.of(c.scp).map(x -> Kit.repeat(-1, x.dom.initSize(), c.scp.length)).toArray(x$0 -> new int[x$0][][]);
    }

    @Override
    public long findMinCostFor(int p, int a) {
        int[] residue = this.residues[p][a];
        int q = p == 0 ? 1 : 0;
        if (residue[q] != -1 && ((CtrSoft)this.c).isValid(residue) && ((CtrSoft)this.c).costOfIdxs(residue) == 0L) {
            return 0L;
        }
        int[] t = ((CtrSoft)this.c).getMinCostTupleFor(p, a);
        if (this.multidirectionality) {
            for (int i = 0; i < this.residues.length; ++i) {
                Kit.copy(t, this.residues[i][t[i]]);
            }
        } else {
            Kit.copy(t, this.residues[p][a]);
        }
        return ((CtrSoft)this.c).costOfIdxs(t);
    }

    @Override
    public long findMinFullCostFor(int p, int a, int sourcePosition) {
        if (this.fdacResidues == null) {
            this.fdacResidues = (int[][][])Stream.of(((CtrSoft)this.c).scp).map(x -> Kit.repeat(-1, x.dom.initSize(), ((CtrSoft)this.c).scp.length)).toArray(x$0 -> new int[x$0][][]);
        }
        long[] c1 = ((CtrSoftExtension)this.c).getC1For(sourcePosition);
        int[] fdacResidue = this.fdacResidues[p][a];
        if (fdacResidue[sourcePosition] != -1 && c1[fdacResidue[sourcePosition]] == 0L && ((CtrSoft)this.c).isValid(fdacResidue) && ((CtrSoft)this.c).costOfIdxs(fdacResidue) == 0L) {
            return 0L;
        }
        int[] t = ((CtrSoft)this.c).getMinFullCostTupleFor(p, a, sourcePosition);
        Kit.copy(t, this.fdacResidues[p][a]);
        return ((CtrSoft)this.c).costOfIdxs(t) + c1[t[sourcePosition]];
    }
}

