/*
 * Decompiled with CFR 0.152.
 */
package propagation.soft.sac;

import constraints.Constraint;
import constraints.soft.extension.CtrSoftExtensionSTR1;
import java.util.Arrays;
import propagation.soft.sac.SoftAC;
import search.Solver;
import utility.Kit;
import utility.operations.Calculator;
import utility.sets.SetSparseMapLong;
import variables.Variable;
import variables.domains.Domain;

public class SoftAC2
extends SoftAC {
    private SetSparseMapLong variablesRequiringUnaryProjections;
    private long[] maxUnaryCosts;
    private long globalMaxUnaryCost;

    @Override
    public void restoreAtDepthBefore(int depthBeforeBacktrack) {
        super.restoreAtDepthBefore(depthBeforeBacktrack);
        Arrays.fill(this.maxUnaryCosts, this.solver.solManager.bestBound);
        this.globalMaxUnaryCost = this.solver.solManager.bestBound;
    }

    private void updateMaxUnaryCostOf(Variable var) {
        long[] c1 = this.c1s[var.num];
        long maxUnaryCost = 0L;
        Domain dom = var.dom;
        int idx = dom.first();
        while (idx != -1) {
            maxUnaryCost = Math.max(maxUnaryCost, c1[idx]);
            idx = dom.next(idx);
        }
        this.maxUnaryCosts[var.num] = maxUnaryCost;
        this.globalMaxUnaryCost = Math.max(this.globalMaxUnaryCost, maxUnaryCost);
    }

    public SetSparseMapLong getVariablesRequiringUnaryProjections() {
        return this.variablesRequiringUnaryProjections;
    }

    public SoftAC2(Solver solver) {
        super(solver);
        this.variablesRequiringUnaryProjections = new SetSparseMapLong(solver.pb.variables.length, false);
        this.maxUnaryCosts = Kit.repeat(solver.solManager.bestBound, solver.pb.variables.length);
        this.globalMaxUnaryCost = solver.solManager.bestBound;
    }

    @Override
    public boolean propagate() {
        while (this.queue.size() != 0) {
            Variable x = this.queue.pickAndDelete();
            if (!this.queue.isNogoodConsistent(x)) {
                return false;
            }
            this.variablesRequiringUnaryProjections.clear();
            for (Constraint c : x.ctrs) {
                if (c.ignored || ((CtrSoftExtensionSTR1)c).findSupports()) continue;
                return false;
            }
            for (int i = this.variablesRequiringUnaryProjections.limit; i >= 0; --i) {
                int ynum = this.variablesRequiringUnaryProjections.dense[i];
                long alpha = this.variablesRequiringUnaryProjections.values[ynum];
                Variable y = this.solver.pb.variables[ynum];
                if (alpha > 0L) {
                    this.unaryProjectAndStack(y, alpha);
                }
                this.updateMaxUnaryCostOf(y);
            }
            long ub = this.solver.solManager.bestBound;
            if (Calculator.add(Calculator.add(this.c0, -ub), this.globalMaxUnaryCost) >= 0L) {
                this.globalMaxUnaryCost = 0L;
                Variable y = this.solver.futVars.first();
                while (y != null) {
                    if (Calculator.add(Calculator.add(this.c0, -ub), this.maxUnaryCosts[y.num]) >= 0L) {
                        if (!this.pruneVar(y, null)) {
                            return false;
                        }
                        this.updateMaxUnaryCostOf(y);
                    } else {
                        this.globalMaxUnaryCost = Math.max(this.globalMaxUnaryCost, this.maxUnaryCosts[y.num]);
                    }
                    y = this.solver.futVars.next(y);
                }
            }
            assert (this.controlMaxUnaryCosts());
        }
        assert (this.controlMaxUnaryCosts());
        return true;
    }

    private boolean controlMaxUnaryCosts() {
        long max = 0L;
        Variable x = this.solver.futVars.first();
        while (x != null) {
            long[] c1 = this.c1s[x.num];
            long m = 0L;
            Domain dom = x.dom;
            int idx = dom.first();
            while (idx != -1) {
                m = Math.max(m, c1[idx]);
                idx = dom.next(idx);
            }
            Kit.control(this.maxUnaryCosts[x.num] >= this.solver.solManager.bestBound || this.maxUnaryCosts[x.num] >= m, () -> "pb with maxUnaryCost");
            max = Math.max(max, m);
            x = this.solver.futVars.next(x);
        }
        Kit.control(this.globalMaxUnaryCost >= this.solver.solManager.bestBound || this.globalMaxUnaryCost >= max, () -> "pb with globalMaxUnaryCost " + this.globalMaxUnaryCost);
        return true;
    }
}

