/*
 * Decompiled with CFR 0.152.
 */
package propagation.soft.sac;

import constraints.Constraint;
import constraints.CtrSoft;
import constraints.soft.extension.CtrSoftExtension;
import constraints.soft.extension.CtrSoftExtensionSTR1;
import constraints.soft.extension.structures.SoftMatrix1D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Stream;
import propagation.order1.AC;
import propagation.soft.LowerBoundCapability;
import propagation.soft.sac.SoftSubstitutor;
import propagation.structures.supporters.SupporterSoft;
import search.Solver;
import utility.Enums;
import utility.Kit;
import utility.observers.ObserverBacktrackingSystematic;
import utility.operations.Calculator;
import utility.sets.SetSparseMapLong;
import variables.Variable;
import variables.domains.Domain;

public class SoftAC
extends AC
implements ObserverBacktrackingSystematic,
LowerBoundCapability {
    protected final long[] levelsConsistencyUpperbounds;
    public long c0;
    public final long[][] c1s;
    private final int[] stackedLevels;
    private int top = -1;
    private final SetSparseMapLong[] sparseMaps;
    public final SoftSubstitutor softSubstitutor;
    private boolean projectionPerformed;
    public int nbNCRemovals;
    private boolean test = false;
    boolean collectStats = false;

    @Override
    public void restoreAtDepthBefore(int depthBeforeBacktrack) {
        if (this.top == -1 || this.stackedLevels[this.top] < depthBeforeBacktrack) {
            return;
        }
        SetSparseMapLong map = this.sparseMaps[this.top];
        for (int i = map.limit; i >= 0; --i) {
            int id = map.dense[i];
            long cost = map.values[id];
            this.unaryProject(this.solver.pb.variables[id], cost);
        }
        --this.top;
    }

    @Override
    public final long getLowerBound() {
        return this.c0;
    }

    public boolean isProjectionPerformedDuringRevision() {
        return this.projectionPerformed;
    }

    public SoftAC(Solver solver) {
        super(solver);
        Kit.control(this.fvbc == null);
        Variable[] variables = solver.pb.variables;
        this.levelsConsistencyUpperbounds = Kit.repeat(solver.solManager.bestBound, variables.length + 1);
        this.c0 = this.cp().optimizing.lowerBound;
        this.c1s = Variable.litterals(variables).longArray();
        for (Constraint ctr : solver.pb.constraints) {
            if (!(ctr instanceof CtrSoft)) continue;
            if (ctr.scp.length == 1) {
                long[] c1 = this.c1s[ctr.scp[0].num];
                long[] costs = ((SoftMatrix1D)((CtrSoftExtension)ctr).extStructure()).getCosts();
                for (int i = 0; i < c1.length; ++i) {
                    Calculator.add(c1, i, costs[i]);
                }
                ctr.ignored = true;
                continue;
            }
            if (this.cp().optimizing.costTranfer == Enums.ECostTranfer.INVARIABLE) continue;
            ((CtrSoftExtension)ctr).buildScopeC1s(this.c1s);
        }
        this.stackedLevels = new int[variables.length + 1];
        this.sparseMaps = new SetSparseMapLong[variables.length + 1];
        this.sparseMaps[0] = new SetSparseMapLong(variables.length, false);
        this.softSubstitutor = new SoftSubstitutor(solver, this.c1s, this.queue);
    }

    protected void unaryProject(Variable var, long cost) {
        this.c0 = Calculator.add(this.c0, cost);
        long[] c1 = this.c1s[var.num];
        for (int i = 0; i < c1.length; ++i) {
            Calculator.add(c1, i, -cost);
        }
    }

    protected void unaryProjectAndStack(Variable var, long cost) {
        int id;
        assert (cost > 0L);
        this.unaryProject(var, cost);
        if (this.top == -1 || this.solver.depth() != this.stackedLevels[this.top]) {
            ++this.top;
            this.stackedLevels[this.top] = this.solver.depth();
            if (this.sparseMaps[this.top] == null) {
                this.sparseMaps[this.top] = new SetSparseMapLong(this.sparseMaps[this.top - 1].capacity(), false);
            } else {
                this.sparseMaps[this.top].clear();
            }
        }
        if (this.sparseMaps[this.top].isPresent(id = var.num)) {
            this.sparseMaps[this.top].incrementPresentEntry(id, -cost);
        } else {
            this.sparseMaps[this.top].add(id, -cost);
        }
    }

    protected void handleIncreasedUnaryCostFromBottomFor(Variable var) {
    }

    public boolean pruneVar(Variable var, Constraint ctr) {
        long upperBound = this.solver.solManager.bestBound;
        long[] c1 = this.c1s[var.num];
        Domain dom = var.dom;
        int sizeBefore = dom.size();
        int idx = dom.first();
        while (idx != -1) {
            if (Calculator.add(this.c0, c1[idx]) >= upperBound) {
                dom.removeElementary(idx);
            }
            idx = dom.next(idx);
        }
        int nbRemovals = sizeBefore - dom.size();
        if (nbRemovals == 0) {
            return true;
        }
        if (this.test) {
            return this.handleReduction(var, dom.size());
        }
        if (ctr != null) {
            return this.handleReduction(var, dom.size());
        }
        if (dom.size() == 0) {
            return false;
        }
        this.queue.add(var);
        return true;
    }

    protected boolean pruneVars() {
        Variable x = this.solver.futVars.first();
        while (x != null) {
            if (!this.pruneVar(x, null)) {
                return false;
            }
            x = this.solver.futVars.next(x);
        }
        return true;
    }

    public boolean pruneVars(Constraint ctr) {
        for (int i = ctr.futvars.limit; i >= 0; --i) {
            if (this.pruneVar(ctr.scp[ctr.futvars.dense[i]], ctr)) continue;
            return false;
        }
        return true;
    }

    public boolean findSupports(Constraint ctr, Variable var) {
        if (!ctr.canBeCurrentlyGenericallyFiltered()) {
            return false;
        }
        boolean flag = false;
        long[] c1 = this.c1s[var.num];
        Domain dom = var.dom;
        long minUnaryCost = Long.MAX_VALUE;
        if (ctr.scp.length == 1) {
            assert (var.ctrs.length == 1);
            int idx = dom.first();
            while (idx != -1) {
                minUnaryCost = Math.min(minUnaryCost, c1[idx]);
                idx = dom.next(idx);
            }
        } else {
            int vap = ctr.positionOf(var);
            int idx = dom.first();
            while (idx != -1) {
                long minCost = ctr.minCostOfTuplesWith(vap, idx);
                assert (ctr instanceof CtrSoftExtensionSTR1 || ctr.minCostOfTuplesWith(vap, idx) == ((SupporterSoft)ctr.supporter()).findMinCostFor(vap, idx));
                if (minCost > 0L) {
                    if (c1[idx] == 0L) {
                        flag = true;
                    }
                    assert (((CtrSoftExtension)ctr).seekMinCostFor(vap, idx) == minCost) : ctr + " " + vap + " " + idx + " mc=" + minCost + " " + ((CtrSoftExtension)ctr).seekMinCostFor(vap, idx);
                    ((CtrSoftExtension)ctr).extStructure().projectAndStack(vap, idx, minCost);
                    this.projectionPerformed = true;
                    assert (((CtrSoftExtension)ctr).seekMinCostFor(vap, idx) == 0L || ((CtrSoftExtension)ctr).seekMinCostFor(vap, idx) == this.solver.solManager.bestBound) : ctr + " " + ((CtrSoftExtension)ctr).seekMinCostFor(vap, idx);
                }
                minUnaryCost = Math.min(minUnaryCost, c1[idx]);
                idx = dom.next(idx);
            }
        }
        if (minUnaryCost > 0L) {
            this.unaryProjectAndStack(var, minUnaryCost);
        }
        if (this.c0 >= this.solver.solManager.bestBound) {
            this.handleWipeout(var);
        }
        return flag;
    }

    public final boolean revise(Constraint ctr, Variable var) {
        assert (!var.isAssigned() && ctr.involves(var));
        if (ctr.scp.length == 1 && var.ctrs.length > 1) {
            return true;
        }
        this.projectionPerformed = false;
        if (this.findSupports(ctr, var)) {
            this.handleIncreasedUnaryCostFromBottomFor(var);
        }
        return true;
    }

    private boolean makeNodeConsistent() {
        assert (this.solver.depth() == 0);
        for (Variable var : this.solver.pb.variables) {
            long[] c1 = this.c1s[var.num];
            Domain dom = var.dom;
            long minUnaryCost = Long.MAX_VALUE;
            int idx = dom.first();
            while (idx != -1) {
                minUnaryCost = Math.min(minUnaryCost, c1[idx]);
                idx = dom.next(idx);
            }
            if (minUnaryCost <= 0L) continue;
            this.unaryProjectAndStack(var, minUnaryCost);
        }
        return this.pruneVars();
    }

    @Override
    public boolean propagate() {
        int nbLocalPicks = 0;
        while (this.queue.size() != 0) {
            ++nbLocalPicks;
            if (!this.pickAndFilter()) {
                if (this.collectStats && nbLocalPicks > 1) {
                    Kit.log.finer(nbLocalPicks + " " + false + " " + this.solver.depth() + " " + this.solver.solManager.bestBound);
                }
                return false;
            }
            if (this.pruneVars()) continue;
            return false;
        }
        if (this.collectStats && nbLocalPicks > 1) {
            Kit.log.finer(nbLocalPicks + " " + true + " " + this.solver.depth() + " " + this.solver.solManager.bestBound);
        }
        return true;
    }

    @Override
    public boolean runInitially() {
        assert (this.solver.depth() == 0);
        int nbValuesRemovedBefore = this.pb().nValuesRemoved;
        if (!this.makeNodeConsistent()) {
            return false;
        }
        this.nbNCRemovals = this.pb().nValuesRemoved - nbValuesRemovedBefore;
        nbValuesRemovedBefore = this.pb().nValuesRemoved;
        this.queue.fill();
        if (!this.propagate()) {
            return false;
        }
        this.nPreproRemovals = this.pb().nValuesRemoved - nbValuesRemovedBefore;
        if (!this.softSubstitutor.removeSubstitutableValues()) {
            return false;
        }
        while (this.queue.size() != 0) {
            if (this.propagate() && this.softSubstitutor.removeSubstitutableValues()) continue;
            return false;
        }
        assert (this.isNodeConsistent() && this.controlArcConsistency() && this.softSubstitutor.isSubConsistent());
        return true;
    }

    protected boolean updateQueuesWhenDecreasedUpperBound() {
        this.queue.addFutureVariables();
        return true;
    }

    @Override
    public boolean runAfterAssignment(Variable var) {
        assert (this.queue.size() == 0);
        this.softSubstitutor.timestamp = this.softSubstitutor.timestamp > 0L ? this.incrementTime() : 0L;
        this.queue.add(var);
        long ub = this.solver.solManager.bestBound;
        if (this.levelsConsistencyUpperbounds[this.solver.depth() - 1] != ub && !this.updateQueuesWhenDecreasedUpperBound()) {
            return false;
        }
        do {
            if (this.propagate() && this.softSubstitutor.removeSubstitutableValues()) continue;
            return false;
        } while (this.queue.size() != 0);
        this.levelsConsistencyUpperbounds[this.solver.depth()] = ub;
        assert (this.isNodeConsistent() && this.controlArcConsistency());
        assert (this.softSubstitutor.isSubConsistent());
        return true;
    }

    private long getMinUnaryCostOf(Variable x) {
        long[] c1 = this.c1s[x.num];
        long minUnaryCost = Long.MAX_VALUE;
        Domain dom = x.dom;
        int idx = dom.first();
        while (idx != -1) {
            minUnaryCost = Math.min(minUnaryCost, c1[idx]);
            idx = dom.next(idx);
        }
        return minUnaryCost;
    }

    @Override
    public boolean runAfterRefutation(Variable x) {
        long minUnaryCost;
        assert (this.queue.size() == 0 && !x.isAssigned() && x.dom.size() > 0);
        this.softSubstitutor.timestamp = 0L;
        this.queue.add(x);
        long ub = this.solver.solManager.bestBound;
        if (this.levelsConsistencyUpperbounds[this.solver.depth()] != ub) {
            for (int num = this.solver.futVars.pastTop; num >= 0; --num) {
                if (Calculator.add(this.c0, this.c1s[num][this.solver.pb.variables[num].dom.unique()]) < ub) continue;
                return false;
            }
            if (!this.updateQueuesWhenDecreasedUpperBound()) {
                return false;
            }
            this.levelsConsistencyUpperbounds[this.solver.depth()] = ub;
        }
        if ((minUnaryCost = this.getMinUnaryCostOf(x)) > 0L) {
            this.unaryProjectAndStack(x, minUnaryCost);
        }
        if (!this.propagate()) {
            return false;
        }
        assert (this.isNodeConsistent() && this.controlArcConsistency());
        return true;
    }

    public boolean isNodeConsistent(Variable var) {
        long ub = this.solver.solManager.bestBound;
        long[] c1 = this.c1s[var.num];
        long minUnaryCost = Long.MAX_VALUE;
        Domain dom = var.dom;
        int idx = dom.first();
        while (idx != -1) {
            Kit.control(c1[idx] >= 0L && Calculator.add(this.c0, c1[idx]) < ub, () -> "pb NC " + var + " c0=" + this.c0 + " ub=" + ub);
            minUnaryCost = Math.min(minUnaryCost, c1[idx]);
            idx = dom.next(idx);
        }
        Kit.control(minUnaryCost == 0L, () -> "pb NC with " + var);
        return true;
    }

    public boolean isNodeConsistent(Variable[] vars) {
        return Stream.of(vars).noneMatch(x -> !this.isNodeConsistent((Variable)x));
    }

    public boolean isNodeConsistent() {
        return this.isNodeConsistent(this.solver.pb.variables);
    }

    protected void genereStatsTuplesCosts(String propagation, int margeAlmostHard, long c0) {
        StringTokenizer st = new StringTokenizer(this.solver.pb.name(), "/");
        String shortName = "instance";
        while (st.hasMoreTokens()) {
            shortName = st.nextToken();
        }
        File fileDat = new File(propagation + "_" + shortName + "Node_" + this.solver.stats.nAssignments + ".dat");
        File fileGpl = new File(propagation + "_" + shortName + "Node_" + this.solver.stats.nAssignments + ".gpl");
        File fileRepartitions = new File(propagation + "_" + shortName + "_costRepartition.txt");
        try {
            PrintWriter outDat = new PrintWriter(new BufferedWriter(new FileWriter(fileDat, false)));
            PrintWriter outGpl = new PrintWriter(new BufferedWriter(new FileWriter(fileGpl, false)));
            PrintWriter outRepartitions = new PrintWriter(new BufferedWriter(new FileWriter(fileRepartitions, true)));
            outDat.println("Constraints\tSoft\tAlmost Hard\tHard\tTOTAL");
            outRepartitions.println("Level " + this.solver.depth() + "\n");
            outRepartitions.print("Constraints\tDefaultCost\tK\tc0\tNbFutureVariables\tNbTuplesSoft\tNbTuples Almost Hard(" + margeAlmostHard + ")\tNbTuplesHard\tTOTAL\tNbTuplesByCost\n");
            for (Constraint ctr : this.solver.pb.constraints) {
                if (!(ctr instanceof CtrSoftExtensionSTR1)) continue;
                int nbTuples = ((CtrSoftExtensionSTR1)ctr).getNbHardTuples() + ((CtrSoftExtensionSTR1)ctr).getNbSoftTuples();
                int nbAlmostHardTuples = ((CtrSoftExtensionSTR1)ctr).getNbAlmostHardTuples(margeAlmostHard, c0);
                int nbSoftTuples = ((CtrSoftExtensionSTR1)ctr).getNbSoftTuples() - nbAlmostHardTuples;
                int nbHardTuples = ((CtrSoftExtensionSTR1)ctr).getNbHardTuples();
                outDat.println(ctr.getId() + "(" + ctr.futvars.size() + ")\t" + nbSoftTuples + "\t" + nbAlmostHardTuples + "\t" + nbHardTuples + "\t" + nbTuples);
                outRepartitions.print(ctr.getId() + "\t" + ((CtrSoftExtensionSTR1)ctr).extStructure().getDefaultCost() + "\t" + this.solver.solManager.bestBound + "\t" + c0 + "\t" + ctr.futvars.size() + "\t" + nbSoftTuples + "\t" + nbAlmostHardTuples + "\t" + nbHardTuples + "\t" + nbTuples + "\t");
                outRepartitions.print("[");
                for (Map.Entry<Long, Integer> entry : ((CtrSoftExtensionSTR1)ctr).getRepartition().entrySet()) {
                    outRepartitions.print(" " + entry.getKey() + ":" + entry.getValue() + " ");
                }
                outRepartitions.println("]");
            }
            outRepartitions.println("\n");
            outRepartitions.close();
            outDat.close();
            outGpl.println("#");
            outGpl.println("# Stacked histograms by percent");
            outGpl.println("#");
            outGpl.println("set terminal pngcairo size 1920,1200 enhanced font 'Verdana,10'");
            outGpl.print("set output '" + propagation + "_" + shortName + "Node_");
            outGpl.format("%08d", this.solver.stats.nAssignments);
            outGpl.println(".png'");
            outGpl.println("set title 'Evolution of pourcent of Hard/Soft tuples during search at level " + this.solver.depth() + " (nb assignments = " + this.solver.stats.nAssignments + ", nb backtracks = " + this.solver.stats.nBacktracks + ", nb variables = " + this.solver.pb.variables.length + ")'");
            outGpl.println("set key invert reverse Left outside");
            outGpl.println("set yrange [0:100]");
            outGpl.println("set ylabel \"% of total\"");
            outGpl.println("unset ytics");
            outGpl.println("set grid y");
            outGpl.println("set border 3");
            outGpl.println("set style data histograms");
            outGpl.println("set style histogram rowstacked");
            outGpl.println("set style fill solid border -1");
            outGpl.println("set boxwidth 0.75");
            outGpl.println("#");
            outGpl.println("plot '" + propagation + "_" + shortName + "Node_" + this.solver.stats.nAssignments + ".dat' using (100.*$2/$5):xtic(1) title column(2), \\");
            outGpl.println("'' using (100.*$3/$5) title column(3), '' using (100.*$4/$5) title column(4)");
            outGpl.println("#");
            outGpl.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

