/*
 * Decompiled with CFR 0.152.
 */
package propagation.soft.sac;

import constraints.Constraint;
import propagation.soft.sac.AdvancedSoftAC;
import search.Solver;
import utility.interfaces.FilteringSpecific;
import utility.sets.SetSparse;
import variables.Variable;

public final class FDAC
extends AdvancedSoftAC {
    private SetSparse queueR;

    public FDAC(Solver solver) {
        super(solver);
        this.queueR = new SetSparse(solver.pb.variables.length);
    }

    @Override
    protected void handleIncreasedUnaryCostFromBottomFor(Variable var) {
        this.queueR.add(var.num);
    }

    private boolean dac() {
        while (this.queueR.size() != 0) {
            Variable var = this.pickAndDeleteVariableIn(this.queueR, true);
            if (!var.isAssigned() && !this.pruneVar(var, null)) {
                return false;
            }
            for (Constraint ctr : var.ctrs) {
                Variable lowestVariable = this.constraintsMembership[ctr.num];
                if (ctr.scp.length <= 1 || ctr instanceof FilteringSpecific || lowestVariable == var || !ctr.canBeCurrentlyGenericallyFiltered() || !this.findFullSupports(ctr, var, lowestVariable)) continue;
                this.handleIncreasedUnaryCostFromBottomFor(lowestVariable);
            }
        }
        return this.pruneVars();
    }

    @Override
    public boolean runInitially() {
        if (!super.runInitially()) {
            return false;
        }
        this.queueR.fill();
        do {
            if (this.dac() && this.propagate()) continue;
            return false;
        } while (this.queue.size() != 0 || this.queueR.size() != 0);
        assert (this.isNodeConsistent() && this.controlArcConsistency() && this.isDACConsistent());
        return true;
    }

    @Override
    protected boolean updateQueuesWhenDecreasedUpperBound() {
        if (!super.updateQueuesWhenDecreasedUpperBound()) {
            return false;
        }
        this.solver.futVars.execute(x -> this.queueR.add(x.num));
        return true;
    }

    @Override
    public boolean runAfterAssignment(Variable var) {
        if (!super.runAfterAssignment(var)) {
            return false;
        }
        this.queueR.add(var.num);
        do {
            if (this.dac() && this.propagate()) continue;
            return false;
        } while (this.queue.size() != 0 || this.queueR.size() != 0);
        assert (this.isNodeConsistent() && this.controlArcConsistency() && this.isDACConsistent());
        return true;
    }

    @Override
    public boolean runAfterRefutation(Variable var) {
        if (!super.runAfterRefutation(var)) {
            return false;
        }
        this.queueR.add(var.num);
        do {
            if (this.dac() && this.propagate()) continue;
            return false;
        } while (this.queue.size() != 0 || this.queueR.size() != 0);
        assert (this.isNodeConsistent() && this.controlArcConsistency() && this.isDACConsistent());
        return true;
    }
}

