/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1.singleton;

import propagation.order1.singleton.SingletonConsistency;
import search.Solver;
import utility.Kit;
import variables.Variable;

public abstract class SAC
extends SingletonConsistency {
    public SAC(Solver solver) {
        super(solver);
    }

    protected boolean checkSAC(Variable x, int a) {
        this.solver.assign(x, a);
        boolean consistent = this.enforceArcConsistencyAfterAssignment(x);
        this.solver.backtrack(x);
        ++this.nSingletonTests;
        if (!consistent) {
            ++this.nEffectiveSingletonTests;
        }
        return consistent;
    }

    @Override
    protected int makeSingletonTestsOn(Variable x) {
        int sizeBefore = x.dom.size();
        if (this.onlyBounds) {
            while (x.dom.size() > 0 && !this.checkSAC(x, x.dom.first())) {
                x.dom.removeElementary(x.dom.first());
            }
            while (x.dom.size() > 1 && !this.checkSAC(x, x.dom.last())) {
                x.dom.removeElementary(x.dom.last());
            }
        } else {
            int a = x.dom.first();
            while (a != -1) {
                if (!this.checkSAC(x, a)) {
                    x.dom.removeElementary(a);
                }
                a = x.dom.next(a);
            }
        }
        return sizeBefore - x.dom.size();
    }

    private boolean controlSingleton(Variable x, int a) {
        this.solver.assign(x, a);
        boolean consistent = this.enforceArcConsistencyAfterAssignment(x);
        this.solver.backtrack(x);
        if (!consistent) {
            Kit.log.warning(x + " " + a + " not singleton consistent");
        }
        return consistent;
    }

    protected final boolean controlSingletonArcConsistency() {
        if (this.nPassesLimit == Integer.MAX_VALUE) {
            return true;
        }
        Variable x = this.solver.futVars.first();
        while (x != null) {
            int a = x.dom.first();
            while (a != -1) {
                if (!this.controlSingleton(x, a)) {
                    return false;
                }
                a = x.dom.next(a);
            }
            x = this.solver.futVars.next(x);
        }
        return true;
    }
}

