/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1.partial;

import propagation.order1.partial.SACPartial;
import search.Solver;
import utility.Kit;
import variables.Variable;
import variables.domains.Domain;

public class SACPartialMulti
extends SACPartial {
    private int[][] residues;
    private int[] nResidues;

    public SACPartialMulti(Solver solver) {
        super(solver);
        this.residues = Variable.litterals(solver.pb.variables).intArray();
        this.nResidues = new int[solver.pb.variables.length];
    }

    @Override
    protected int makeSingletonTestsOn(Variable x) {
        Domain dom = x.dom;
        int sizeBefore = dom.size();
        boolean mustContinue = true;
        int num = x.num;
        for (int i = 0; i < this.nResidues[num]; ++i) {
            int residue = this.residues[num][i];
            if (!dom.isPresent(residue)) continue;
            if (!this.checkSAC(x, residue)) {
                x.dom.removeElementary(residue);
                continue;
            }
            mustContinue = false;
            int n = num;
            int n2 = this.nResidues[n] - 1;
            this.nResidues[n] = n2;
            Kit.swap(this.residues[num], n2, i);
            --i;
        }
        if (mustContinue) {
            int a = dom.first();
            while (a != -1 && !this.checkSAC(x, a)) {
                x.dom.removeElementary(a);
                this.residues[num][this.nResidues[num]] = a;
                int n = num;
                this.nResidues[n] = this.nResidues[n] + 1;
                a = dom.next(a);
            }
        }
        return sizeBefore - dom.size();
    }
}

