/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1.partial;

import propagation.order1.partial.PickThresholdManager;
import propagation.order1.singleton.SAC;
import search.Solver;
import utility.interfaces.TagExperimental;
import variables.Variable;
import variables.domains.Domain;

public class SACPartial
extends SAC
implements TagExperimental {
    private final int[] residues;
    private PickThresholdManager pickThresholdManager;

    @Override
    public boolean propagate() {
        int nLocalPicks = 0;
        while (this.queue.size() != 0) {
            ++nLocalPicks;
            if (!this.pickAndFilter()) {
                return false;
            }
            if (this.pickThresholdManager == null || !this.pickThresholdManager.mustStopPropagation(nLocalPicks)) continue;
            break;
        }
        return true;
    }

    public SACPartial(Solver solver) {
        super(solver);
        this.residues = new int[solver.pb.variables.length];
        this.cp().propagating.strongOnlyAtPreprocessing = false;
        if (this.cp().shaving.limitedPropagationSamplingSize >= 0) {
            this.pickThresholdManager = new PickThresholdManager(250, this.cp().shaving.limitedPropagationSamplingSize);
        }
    }

    private boolean isEligible(Variable x) {
        Domain dom = x.dom;
        if (dom.size() < 2) {
            return false;
        }
        int nDeletedElements = 0;
        long wsumOfDeletedElements = 0L;
        int k = this.cp().shaving.parameter;
        int prevDepth = -1;
        int depth = this.solver.depth();
        int stopDepth = depth < k ? -1 : depth - k;
        int delCntOfLevel = 0;
        int a = dom.lastRemoved();
        while (a != -1 && dom.getRemovedLevelOf(a) > stopDepth) {
            ++nDeletedElements;
            if (dom.getRemovedLevelOf(a) != prevDepth) {
                wsumOfDeletedElements += (long)(delCntOfLevel * (k - depth + prevDepth));
                delCntOfLevel = 0;
                prevDepth = dom.getRemovedLevelOf(a);
            }
            ++delCntOfLevel;
            a = dom.prevRemoved(a);
        }
        double score = (double)(wsumOfDeletedElements += (long)(delCntOfLevel * (k - depth + prevDepth))) / (double)(dom.size() + nDeletedElements);
        return score > this.cp().shaving.eligibilityThreshod;
    }

    @Override
    protected boolean checkSAC(Variable x, int a) {
        if (this.pickThresholdManager != null) {
            this.pickThresholdManager.actBeforeSingletonCheck(this.queue.nPicks);
        }
        boolean consistent = super.checkSAC(x, a);
        if (this.pickThresholdManager != null) {
            this.pickThresholdManager.actAfterSingletonCheck(this.queue.nPicks, consistent);
        }
        return consistent;
    }

    @Override
    protected int makeSingletonTestsOn(Variable x) {
        Domain dom = x.dom;
        int sizeBefore = dom.size();
        boolean mustStop = false;
        if (dom.isPresent(this.residues[x.num]) && !(mustStop = this.checkSAC(x, this.residues[x.num]))) {
            x.dom.removeElementary(this.residues[x.num]);
        }
        if (!mustStop) {
            int a = dom.first();
            while (a != -1 && !this.checkSAC(x, a)) {
                x.dom.removeElementary(a);
                this.residues[x.num] = a;
                a = dom.next(a);
            }
        }
        return sizeBefore - dom.size();
    }

    @Override
    protected boolean enforceStrongConsistency() {
        Variable x = this.solver.futVars.first();
        while (x != null) {
            if (this.isEligible(x)) {
                if (this.makeSingletonTestsOn(x) > 0) {
                    if (x.dom.size() == 0) {
                        return false;
                    }
                    if (!this.enforceArcConsistencyAfterRefutation(x)) {
                        return false;
                    }
                }
                if (this.solver.hasFinished()) {
                    return true;
                }
            }
            x = this.solver.futVars.next(x);
        }
        return true;
    }
}

