/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1.inverse;

import constraints.Constraint;
import constraints.hard.extension.CtrExtensionSTR1;
import constraints.hard.extension.CtrExtensionSTR2;
import constraints.hard.extension.structures.Table;
import java.util.stream.Stream;
import propagation.order1.StrongConsistency;
import search.Solver;
import utility.Enums;
import utility.Kit;
import utility.sets.SetDenseReversible;
import variables.Variable;

public class TIInverse1
extends StrongConsistency {
    private int rate = 10;
    private Constraint selectedConstraint;
    private Constraint[] ignoredConstraints;
    private int[][] residues;

    private void selectConstraints() {
        Constraint[] ctrs = this.solver.pb.constraints;
        this.selectedConstraint = ctrs[11];
        this.ignoredConstraints = new Constraint[Math.round(ctrs.length * this.rate / 100)];
        for (int i = 0; i < this.ignoredConstraints.length; ++i) {
            int id;
            while (true) {
                if ((id = this.solver.rs.random.nextInt(ctrs.length)) == this.selectedConstraint.num) {
                    continue;
                }
                boolean alreadyIgnored = false;
                for (int j = 0; !alreadyIgnored && j < i; ++j) {
                    if (id != this.ignoredConstraints[j].num) continue;
                    alreadyIgnored = true;
                }
                if (!alreadyIgnored) break;
            }
            this.ignoredConstraints[i] = ctrs[id];
            this.ignoredConstraints[i].ignored = true;
        }
        int nTuples = ((Table)this.selectedConstraint.extStructure()).tuples.length;
        Kit.log.info(this.selectedConstraint + " nbTuples=" + nTuples);
        Kit.log.info(Kit.join((Object)this.ignoredConstraints, new String[0]));
        this.residues = new int[nTuples][];
    }

    public TIInverse1(Solver solver) {
        super(solver);
        Kit.control(Stream.of(solver.pb.constraints).allMatch(c -> c.getClass().isAssignableFrom(CtrExtensionSTR2.class)));
        this.selectConstraints();
    }

    protected boolean isInverse(Variable[] scope, int[] tuple) {
        this.solver.resetNoSolutions();
        boolean consistent = true;
        Kit.control(this.solver.futVars.nDiscarded() == 0, () -> " BnbPast=" + this.solver.futVars.nDiscarded());
        int nVariablesAssignedBefore = this.solver.futVars.nDiscarded();
        for (int i = 0; consistent && i < scope.length; ++i) {
            if (scope[i].dom.isPresent(tuple[i])) {
                this.solver.assign(scope[i], tuple[i]);
                consistent = consistent && this.enforceArcConsistencyAfterAssignment(scope[i]);
                continue;
            }
            consistent = false;
        }
        boolean inverse = consistent && this.solver.doRun().stoppingType == Enums.EStopping.REACHED_GOAL;
        for (int j = this.solver.futVars.nDiscarded() - nVariablesAssignedBefore - 1; j >= 0; --j) {
            this.solver.backtrack(scope[j]);
        }
        Kit.control(this.solver.futVars.nDiscarded() == 0, () -> " AnbPast=" + this.solver.futVars.nDiscarded());
        return inverse;
    }

    private int filterConstraint(Constraint ctr) {
        int cnt = 0;
        int[][] tuples = ((Table)ctr.extStructure()).tuples;
        SetDenseReversible denseSetOfTuples = ((CtrExtensionSTR1)ctr).set;
        int[] dense = denseSetOfTuples.dense;
        for (int i = denseSetOfTuples.limit; i >= 0; --i) {
            if (this.residues[dense[i]] != null && this.solver.solManager.control(this.residues[dense[i]])) continue;
            denseSetOfTuples.swapAtPositions(0, i);
            int prevLimit = denseSetOfTuples.limit;
            denseSetOfTuples.limit = 0;
            boolean inverse = this.isInverse(ctr.scp, tuples[dense[0]]);
            denseSetOfTuples.swapAtPositions(0, i);
            denseSetOfTuples.limit = prevLimit;
            if (!inverse) {
                ++cnt;
                denseSetOfTuples.removeAtPosition(i, this.solver.depth());
                continue;
            }
            int[] solution = this.solver.solManager.lastSolution;
            if (this.residues[dense[i]] == null) {
                this.residues[dense[i]] = new int[this.solver.pb.variables.length];
            }
            Kit.copy(solution, this.residues[dense[i]]);
        }
        if (cnt > 0) {
            Kit.log.info(cnt + " tuples removed from " + ctr);
        }
        Kit.control(denseSetOfTuples.size() > 0, () -> "Impossible because the CN is GIC");
        return cnt;
    }

    @Override
    public boolean enforceStrongConsistency() {
        if (this.solver.depth() > 0) {
            return true;
        }
        this.performingProperSearch = true;
        Kit.log.info("Filter tuples from " + this.selectedConstraint + " nbTuples=" + ((Table)this.selectedConstraint.extStructure()).tuples.length);
        this.filterConstraint(this.selectedConstraint);
        for (int i = 0; i < this.ignoredConstraints.length; ++i) {
            this.ignoredConstraints[i].ignored = false;
            this.filterConstraint(this.selectedConstraint);
        }
        this.solver.resetNoSolutions();
        this.performingProperSearch = false;
        return true;
    }
}

