/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1.inverse;

import constraints.Constraint;
import constraints.hard.extension.CtrExtensionSTR1;
import constraints.hard.extension.CtrExtensionSTR2;
import constraints.hard.extension.structures.Table;
import java.util.stream.Stream;
import propagation.order1.inverse.GIC4;
import search.Solver;
import utility.Enums;
import utility.Kit;
import utility.sets.SetDenseReversible;
import variables.Variable;

public class TIC4
extends GIC4 {
    private int[][] tsolutions;
    protected int currentLimitOfTSolutions;

    protected void checkTSolutions() {
        Variable[] variables = this.solver.pb.variables;
        for (int i = this.currentLimitOfTSolutions; i >= 0; --i) {
            int[] solution = this.tsolutions[i];
            boolean valid = true;
            for (int j = variables.length - 1; j >= 0; --j) {
                if (variables[j].dom.isPresent(solution[j])) continue;
                valid = false;
                break;
            }
            if (valid) continue;
            Kit.swap(this.tsolutions, i, this.currentLimitOfTSolutions--);
        }
    }

    int[][] increaseArray(int[][] m) {
        int[][] tmp = new int[m.length * 2][];
        for (int i = 0; i < m.length; ++i) {
            tmp[i] = m[i];
        }
        return tmp;
    }

    protected void handleNewTSolution() {
        ++this.currentLimitOfTSolutions;
        if (this.currentLimitOfTSolutions >= this.tsolutions.length) {
            this.tsolutions = this.increaseArray(this.tsolutions);
        }
        if (this.tsolutions[this.currentLimitOfTSolutions] == null) {
            this.tsolutions[this.currentLimitOfTSolutions] = new int[this.solver.pb.variables.length];
        }
        int[] solution = this.solver.solManager.lastSolution;
        Kit.copy(solution, this.tsolutions[this.currentLimitOfTSolutions]);
    }

    protected boolean isSupported(Variable[] scope, int[] tuple) {
        for (int i = this.currentLimitOfTSolutions; i >= 0; --i) {
            int[] solution = this.tsolutions[i];
            boolean supported = true;
            for (int j = scope.length - 1; j >= 0; --j) {
                int id = scope[j].num;
                if (solution[id] == tuple[j]) continue;
                supported = false;
                break;
            }
            if (!supported) continue;
            return true;
        }
        return false;
    }

    public TIC4(Solver solver) {
        super(solver);
        Kit.control(Stream.of(solver.pb.constraints).allMatch(c -> c.getClass().isAssignableFrom(CtrExtensionSTR2.class)));
        Kit.control(Variable.areNumsNormalized(solver.pb.variables));
        this.tsolutions = new int[solver.pb.constraints.length * 100][];
        this.currentLimitOfTSolutions = -1;
    }

    protected boolean isInverse(Variable[] scope, int[] tuple) {
        boolean inverse;
        this.solver.resetNoSolutions();
        boolean consistent = true;
        Kit.control(this.solver.futVars.nDiscarded() == 0, () -> " BnbPast=" + this.solver.futVars.nDiscarded());
        int nVariablesAssignedBefore = this.solver.futVars.nDiscarded();
        for (int i = 0; consistent && i < scope.length; ++i) {
            if (scope[i].dom.isPresent(tuple[i])) {
                this.solver.assign(scope[i], tuple[i]);
                consistent = consistent && this.enforceArcConsistencyAfterAssignment(scope[i]);
                continue;
            }
            consistent = false;
        }
        boolean bl = inverse = consistent && this.solver.doRun().stoppingType == Enums.EStopping.REACHED_GOAL;
        if (inverse) {
            this.handleNewTSolution();
        }
        for (int j = this.solver.futVars.nDiscarded() - nVariablesAssignedBefore - 1; j >= 0; --j) {
            this.solver.backtrack(scope[j]);
        }
        Kit.control(this.solver.futVars.nDiscarded() == 0, () -> " AnbPast=" + this.solver.futVars.nDiscarded());
        return inverse;
    }

    private int filterConstraint(Constraint ctr) {
        int cnt = 0;
        Kit.log.info("Filter tuples from " + ctr);
        int[][] tuples = ((Table)ctr.extStructure()).tuples;
        SetDenseReversible denseSetOfTuples = ((CtrExtensionSTR1)ctr).set;
        int[] dense = denseSetOfTuples.dense;
        for (int i = denseSetOfTuples.limit; i >= 0; --i) {
            if (this.isSupported(ctr.scp, tuples[dense[i]])) continue;
            denseSetOfTuples.swapAtPositions(0, i);
            int prevLimit = denseSetOfTuples.limit;
            denseSetOfTuples.limit = 0;
            boolean inverse = this.isInverse(ctr.scp, tuples[dense[0]]);
            denseSetOfTuples.swapAtPositions(0, i);
            denseSetOfTuples.limit = prevLimit;
            if (inverse) continue;
            ++cnt;
            denseSetOfTuples.removeAtPosition(i, this.solver.depth());
        }
        if (cnt > 0) {
            Kit.log.info(cnt + " tuples removed from " + ctr);
        }
        Kit.control(denseSetOfTuples.size() > 0, () -> "Impossible because the CN is GIC");
        return cnt;
    }

    @Override
    public boolean enforceStrongConsistency() {
        boolean consistent = super.enforceStrongConsistency();
        Kit.control(consistent);
        if (this.solver.depth() > 0) {
            return true;
        }
        this.performingProperSearch = true;
        int nTuplesRemoved = 0;
        for (Constraint ctr : this.solver.pb.constraints) {
            nTuplesRemoved += this.filterConstraint(ctr);
        }
        if (this.cp().verbose >= 1 && nTuplesRemoved > 0) {
            Kit.log.info("nbTICInconsistentTuples=" + nTuplesRemoved + " at depth=" + this.solver.depth() + "\n");
        }
        this.solver.resetNoSolutions();
        this.performingProperSearch = false;
        return true;
    }
}

