/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1.failed;

import constraints.Constraint;
import constraints.CtrHard;
import java.util.ArrayList;
import java.util.List;
import propagation.order1.AC;
import propagation.order1.failed.FailedValueBasedConsistency;
import search.Solver;
import search.backtrack.DecisionRecorder;
import search.backtrack.SolverBacktrack;
import utility.Kit;
import variables.Variable;
import variables.domains.Domain;

public class ArcFailedValueConsistency
extends FailedValueBasedConsistency {
    private Variable[][][] conflictsVariable;
    private int[][][] conflictsIndex;
    private Variable[][][][] residuesVariable;
    private int[][][][] residuesIndex;
    private CtrHard[][] binaryConstraints;
    private List<Variable>[][] conflictsVariableList;
    private List<Integer>[][] conflictsIndexList;
    private int[] tuple = new int[2];

    public ArcFailedValueConsistency(AC arcConsistency) {
        super(arcConsistency);
    }

    private void updateConflictsList(CtrHard cxy) {
        assert (cxy.scp.length == 2);
        int[] tuple = cxy.tupleManager.localTuple;
        Variable x = cxy.scp[0];
        Domain dom1 = x.dom;
        Variable y = cxy.scp[1];
        Domain dom2 = y.dom;
        int a = dom1.first();
        while (a != -1) {
            tuple[0] = a;
            int b = dom2.first();
            while (b != -1) {
                tuple[1] = b;
                if (!cxy.checkIndexes(tuple)) {
                    this.conflictsVariableList[x.num][a].add(y);
                    this.conflictsIndexList[x.num][a].add(b);
                    this.conflictsVariableList[y.num][b].add(x);
                    this.conflictsIndexList[y.num][b].add(a);
                }
                b = dom2.next(b);
            }
            a = dom1.next(a);
        }
    }

    @Override
    public void buildStructures() {
        int i;
        Constraint[] ctrs;
        Solver solver = this.arcConsistency.solver;
        if (solver.pb.stuff.maxCtrArity() > 2) {
            throw new IllegalArgumentException();
        }
        Variable[] variables = solver.pb.variables;
        this.conflictsVariableList = new List[variables.length][];
        this.conflictsIndexList = new List[variables.length][];
        for (int i2 = 0; i2 < variables.length; ++i2) {
            Constraint[] dom = variables[i2].dom;
            this.conflictsVariableList[i2] = new List[dom.initSize()];
            this.conflictsIndexList[i2] = new List[dom.initSize()];
            int idx = dom.first();
            while (idx != -1) {
                this.conflictsVariableList[i2][idx] = new ArrayList<Variable>();
                this.conflictsIndexList[i2][idx] = new ArrayList<Integer>();
                idx = dom.next(idx);
            }
        }
        for (Constraint ctr : ctrs = solver.pb.constraints) {
            this.updateConflictsList((CtrHard)ctr);
        }
        this.conflictsVariable = new Variable[variables.length][][];
        this.conflictsIndex = new int[variables.length][][];
        this.residuesVariable = new Variable[variables.length][][][];
        this.residuesIndex = new int[variables.length][][][];
        for (i = 0; i < variables.length; ++i) {
            Domain dom = variables[i].dom;
            this.conflictsVariable[i] = new Variable[dom.initSize()][];
            this.conflictsIndex[i] = new int[dom.initSize()][];
            int idx = dom.first();
            while (idx != -1) {
                this.conflictsVariable[i][idx] = this.conflictsVariableList[i][idx].toArray(new Variable[0]);
                List<Integer> list = this.conflictsIndexList[i][idx];
                this.conflictsIndex[i][idx] = Kit.intArray(list);
                idx = dom.next(idx);
            }
            this.residuesVariable[i] = new Variable[dom.initSize()][variables.length][];
            this.residuesIndex[i] = new int[dom.initSize()][variables.length][];
            for (int j = 0; j < this.residuesVariable[i].length; ++j) {
                for (int k = 0; k < this.residuesVariable[i][j].length; ++k) {
                    this.residuesVariable[i][j][k] = new Variable[variables[k].dom.initSize()];
                    this.residuesIndex[i][j][k] = new int[variables[k].dom.initSize()];
                }
            }
        }
        this.binaryConstraints = new CtrHard[variables.length][variables.length];
        for (i = 0; i < ctrs.length; ++i) {
            Variable var1 = ctrs[i].scp[0];
            Variable var2 = ctrs[i].scp[1];
            this.binaryConstraints[var1.num][var2.num] = (CtrHard)ctrs[i];
            this.binaryConstraints[var2.num][var1.num] = (CtrHard)ctrs[i];
        }
    }

    @Override
    public boolean enforce() {
        DecisionRecorder dr = ((SolverBacktrack)this.arcConsistency.solver).dr;
        for (int i = dr.decisions.limit; i >= 0; --i) {
            int dec = dr.decisions.dense[i];
            if (dec > 0 || dr.isFailedAssignment(i)) continue;
            Variable varPivot = dr.varIn(dec);
            int idxPivot = dr.idxIn(dec);
            Variable[] convar = this.conflictsVariable[varPivot.num][idxPivot];
            int[] conind = this.conflictsIndex[varPivot.num][idxPivot];
            Variable[][] resvar = this.residuesVariable[varPivot.num][idxPivot];
            int[][] resind = this.residuesIndex[varPivot.num][idxPivot];
            Variable x = this.arcConsistency.solver.futVars.first();
            while (x != null) {
                Variable[] resvar2 = resvar[x.num];
                int[] resind2 = resind[x.num];
                Domain domf = x.dom;
                int sizeBefore = domf.size();
                int idxf = domf.first();
                while (idxf != -1) {
                    if (resvar2[idxf] == null || !resvar2[idxf].dom.isPresent(resind2[idxf])) {
                        boolean found = false;
                        for (int j = 0; !found && j < convar.length; ++j) {
                            if (!convar[j].dom.isPresent(conind[j])) continue;
                            CtrHard binaryConstraint = this.binaryConstraints[convar[j].num][x.num];
                            if (binaryConstraint == null) {
                                resvar2[idxf] = convar[j];
                                resind2[idxf] = conind[j];
                                found = true;
                                continue;
                            }
                            if (binaryConstraint.scp[0] == x) {
                                this.tuple[0] = idxf;
                                this.tuple[1] = conind[j];
                            } else {
                                this.tuple[0] = conind[j];
                                this.tuple[1] = idxf;
                            }
                            if (!binaryConstraint.checkIndexes(this.tuple)) continue;
                            resvar2[idxf] = convar[j];
                            resind2[idxf] = conind[j];
                            found = true;
                        }
                        if (!found) {
                            x.dom.removeElementary(idxf);
                        }
                    }
                    idxf = domf.next(idxf);
                }
                if (sizeBefore != domf.size()) {
                    this.nInferredRemovals += sizeBefore - domf.size();
                    if (domf.size() == 0) {
                        return false;
                    }
                    this.arcConsistency.queue.add(x);
                }
                x = this.arcConsistency.solver.futVars.next(x);
            }
        }
        return this.arcConsistency.propagate();
    }

    public void displayConflictsLists() {
        Variable[] variables = this.arcConsistency.solver.pb.variables;
        for (int i = 0; i < variables.length; ++i) {
            Domain dom = variables[i].dom;
            int idx = dom.first();
            while (idx != -1) {
                System.out.print(variables[i] + "=" + idx + ":: ");
                for (int j = 0; j < this.conflictsVariable[i][idx].length; ++j) {
                    System.out.print(this.conflictsVariable[i][idx][j] + "=" + this.conflictsIndex[i][idx][j] + " ");
                }
                System.out.println();
                idx = dom.next(idx);
            }
        }
    }
}

