/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1;

import constraints.Constraint;
import constraints.hard.extension.CtrExtensionRPWC;
import constraints.hard.extension.structures.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.xcsp.common.Utilities;
import propagation.order1.AC;
import search.Solver;
import utility.Kit;
import variables.Variable;

public final class MaxRPWC
extends AC {
    private int specificTime;
    public int lastBacktrackSpecificTime;
    private int[] t1;
    private int[] t2;
    private boolean test = false;

    public int incrementSpecificTime() {
        return ++this.specificTime;
    }

    private Intersection intersectionOf(CtrExtensionRPWC c1, CtrExtensionRPWC c2) {
        this.t1 = this.t1 == null ? new int[this.solver.pb.stuff.maxCtrArity()] : this.t1;
        this.t2 = this.t2 == null ? new int[this.solver.pb.stuff.maxCtrArity()] : this.t2;
        int cnt = 0;
        if (Variable.areNumsIncreasing(c1.scp) && Variable.areNumsIncreasing(c2.scp)) {
            int i = 0;
            int j = 0;
            while (i < c1.scp.length && j < c2.scp.length) {
                if (c1.scp[i].num < c2.scp[j].num) {
                    ++i;
                    continue;
                }
                if (c1.scp[i].num > c2.scp[j].num) {
                    ++j;
                    continue;
                }
                this.t1[cnt] = i++;
                this.t2[cnt++] = j++;
            }
        } else {
            for (int i = 0; i < c1.scp.length; ++i) {
                int j = Utilities.indexOf((Object)c1.scp[i], (Object[])c2.scp);
                if (j == -1) continue;
                this.t1[cnt] = i;
                this.t2[cnt++] = j;
            }
        }
        return cnt > 1 ? new Intersection(c1, c2, Arrays.copyOf(this.t1, cnt), Arrays.copyOf(this.t2, cnt)) : null;
    }

    public MaxRPWC(Solver solver) {
        super(solver);
        Constraint[] ctrs = solver.pb.constraints;
        List[] lists = new List[ctrs.length];
        int cnt = 0;
        for (int i = 0; i < ctrs.length; ++i) {
            if (!(ctrs[i] instanceof CtrExtensionRPWC)) continue;
            for (int j = i + 1; j < ctrs.length; ++j) {
                Intersection intersection;
                if (!(ctrs[j] instanceof CtrExtensionRPWC) || (intersection = this.intersectionOf((CtrExtensionRPWC)ctrs[i], (CtrExtensionRPWC)ctrs[j])) == null) continue;
                ++cnt;
                for (CtrExtensionRPWC c : intersection.ctrs) {
                    if (lists[c.num] == null) {
                        lists[c.num] = new ArrayList();
                    }
                    lists[c.num].add(intersection);
                }
            }
        }
        for (Constraint c : ctrs) {
            if (!(c instanceof CtrExtensionRPWC) || lists[c.num] == null) continue;
            ((CtrExtensionRPWC)c).addIntersections(lists[c.num]);
        }
        Kit.log.info("Nb pairs of intersecting constraints : " + cnt + "\n");
    }

    @Override
    public boolean runAfterAssignment(Variable x) {
        if (!super.runAfterAssignment(x)) {
            return false;
        }
        if (this.test) {
            this.queue.fill();
            return this.propagate();
        }
        return true;
    }

    @Override
    public boolean runAfterRefutation(Variable x) {
        this.lastBacktrackSpecificTime = this.incrementSpecificTime();
        return super.runAfterRefutation(x);
    }

    public class Intersection {
        public CtrExtensionRPWC[] ctrs;
        private int[][] sharedPositions;
        private Node root;
        private int size;

        private Intersection(CtrExtensionRPWC c1, CtrExtensionRPWC c2, int[] vaps1, int[] vaps2) {
            this.ctrs = new CtrExtensionRPWC[]{c1, c2};
            this.sharedPositions = new int[][]{vaps1, vaps2};
            this.root = new Node(c1.scp[vaps1[0]].dom.initSize());
            this.size = vaps1.length;
            assert (this.controlSharedVariables());
            for (int i = 0; i < this.ctrs.length; ++i) {
                for (int[] tuple : ((Table)this.ctrs[i].extStructure()).tuples) {
                    this.root.add(tuple, i, 0);
                }
            }
        }

        private boolean controlSharedVariables() {
            for (int[] positions : this.sharedPositions) {
                if (positions.length == this.size) continue;
                return false;
            }
            for (int j = 0; j < this.size; ++j) {
                for (int i = 1; i < this.ctrs.length; ++i) {
                    if (this.ctrs[0].scp[this.sharedPositions[0][j]] == this.ctrs[i].scp[this.sharedPositions[i][j]]) continue;
                    return false;
                }
            }
            return true;
        }

        public Leaf getLeafFor(int[] tuple, int source) {
            Node node = this.root;
            for (int vap : this.sharedPositions[source]) {
                node = node.childs[tuple[vap]];
            }
            return (Leaf)node;
        }

        public String toString() {
            return this.ctrs[0] + " " + this.ctrs[1] + " " + Kit.join((Object)this.sharedPositions[0], new String[0]) + " - " + Kit.join((Object)this.sharedPositions[1], new String[0]) + "\n";
        }

        public class Leaf
        extends Node {
            public int[] stamps;

            protected Leaf() {
                this.stamps = Kit.repeat(-1, Intersection.this.ctrs.length);
            }

            @Override
            protected void add(int[] tuple, int source, int i) {
                this.stamps[source] = 0;
            }

            @Override
            protected void display(int[] collect, int pos) {
                Kit.log.finer(Kit.join((Object)collect, pos, new String[0]) + " stamps=" + Kit.join((Object)this.stamps, new String[0]));
            }
        }

        public class Node {
            private Node[] childs;

            protected Node() {
            }

            protected Node(int nbChilds) {
                this.childs = new Node[nbChilds];
            }

            protected void add(int[] tuple, int source, int i) {
                int idx = tuple[Intersection.this.sharedPositions[source][i]];
                if (this.childs[idx] == null) {
                    this.childs[idx] = i == Intersection.this.size - 1 ? new Leaf() : new Node(Intersection.this.ctrs[source].scp[((Intersection)Intersection.this).sharedPositions[source][i + 1]].dom.initSize());
                }
                this.childs[idx].add(tuple, source, i + 1);
            }

            protected void display(int[] collect, int position) {
                for (int i = 0; i < this.childs.length; ++i) {
                    if (this.childs[i] == null) continue;
                    collect[position] = i;
                    this.childs[i].display(collect, position + 1);
                }
            }
        }
    }
}

