/*
 * Decompiled with CFR 0.152.
 */
package problems.xcsp2;

import dashboard.ControlPanel;
import dashboard.Output;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.stream.IntStream;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import problem.Problem;
import problems.xcsp2.XExtension;
import problems.xcsp2.XHandler2;
import problems.xcsp2.XIntension;
import utility.Kit;
import variables.Variable;
import variables.VariableInteger;

abstract class XHandler
extends DefaultHandler {
    public static final double LOAD_FACTOR_LIMIT = 0.7;
    protected final Problem problem;
    protected final Map<String, Variable> mapOfVars;
    protected String currentName;
    protected String currentType;
    protected VariableInteger[] currentScope;
    protected XExtension xextension;
    protected XIntension xintension;
    protected Kit.Contractor contractor;
    protected ControlPanel configuration;
    protected Output output;
    protected StringBuilder currentBuffer;

    public XHandler(Problem problem) {
        this.problem = problem;
        this.mapOfVars = problem.mapForVars;
        this.configuration = problem.rs.cp;
        this.output = problem.rs.output;
        this.currentBuffer = new StringBuilder();
    }

    protected void controlTypeAndFormat(String type, String format) {
        Types.TypeFramework framework = type == null ? Types.TypeFramework.CSP : Types.TypeFramework.valueOf((String)type.toUpperCase());
        Kit.control(framework == this.configuration.framework || framework == Types.TypeFramework.CSP && this.configuration.framework == Types.TypeFramework.MAXCSP || framework == Types.TypeFramework.COP && this.configuration.framework == Types.TypeFramework.CSP, () -> "The framework is " + framework + " for the read instance whereas " + this.configuration.framework + " in configuration");
        if (framework == Types.TypeFramework.CSP && this.configuration.framework == Types.TypeFramework.MAXCSP) {
            Kit.log.warning("You have chosen MAXCSP.");
        }
        if (framework == Types.TypeFramework.COP && this.configuration.framework == Types.TypeFramework.CSP) {
            Kit.log.warning("You are trying to solve a COP as a CSP.");
        }
        Kit.control(format != null);
        Kit.control(!(this instanceof XHandler2) || format.equals("XCSP 2.0") || format.equals("XCSP 2.1"));
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentBuffer.append(ch, start, length);
    }

    private void extractVariables(String s, Map<String, Variable> map, Set<Variable> set) {
        StringTokenizer st = new StringTokenizer(s, " \t\n\r\f()[],");
        while (st.hasMoreTokens()) {
            Variable var = map.get(st.nextToken());
            if (var == null) continue;
            set.add(var);
        }
    }

    public Variable[] extractSortedVariablesFrom(String s, Map<String, Variable> map) {
        TreeSet<Variable> set = new TreeSet<Variable>();
        this.extractVariables(s, map, set);
        return set.toArray(new Variable[set.size()]);
    }

    public final String[] buildStringArrayWithNamesOf(Variable ... vars) {
        String[] variableNames = new String[vars.length];
        for (int i = 0; i < variableNames.length; ++i) {
            variableNames[i] = vars[i].id();
        }
        return variableNames;
    }

    protected String buildUniversalPostfixExpression(String functionalSubExpression, String[] formalParameters, boolean[] found) {
        int leftParenthesisPosition = functionalSubExpression.indexOf("(");
        if (leftParenthesisPosition == -1) {
            if (Utilities.isInteger((String)functionalSubExpression) || formalParameters.length == 0) {
                return functionalSubExpression;
            }
            int position = Utilities.indexOf((String)functionalSubExpression, (String[])formalParameters);
            Kit.control(position != -1, () -> "pb");
            found[position] = true;
            return "%" + position;
        }
        int rightParenthesisPosition = functionalSubExpression.lastIndexOf(")");
        String operator = functionalSubExpression.substring(0, leftParenthesisPosition);
        String content = functionalSubExpression.substring(leftParenthesisPosition + 1, rightParenthesisPosition);
        String postfixExpression = "";
        int arity = 0;
        for (int right = 0; right < content.length(); ++right) {
            ++arity;
            int left = right;
            int nbOpens = 0;
            for (right = left; right < content.length(); ++right) {
                if (content.charAt(right) == '(') {
                    ++nbOpens;
                    continue;
                }
                if (content.charAt(right) == ')') {
                    --nbOpens;
                    continue;
                }
                if (content.charAt(right) == ',' && nbOpens == 0) break;
            }
            postfixExpression = postfixExpression + this.buildUniversalPostfixExpression(content.substring(left, right), formalParameters, found) + " ";
        }
        return postfixExpression + (arity > 2 && !operator.equals(Types.TypeExpr.IF.lcname) ? Integer.valueOf(arity) : "") + operator;
    }

    protected String buildUniversalPostfixExpression(String functionalExpression, String[] formalParameters) {
        boolean[] found = new boolean[formalParameters.length];
        String postfixExpression = this.buildUniversalPostfixExpression(functionalExpression, formalParameters, found);
        assert (IntStream.range(0, found.length).noneMatch(i -> !found[i])) : "One Formal parameter not found in the given expression";
        return postfixExpression;
    }

    protected String[] extractFormalParameters(String formalParametersExpression, boolean controlRedundancy) {
        StringTokenizer st = new StringTokenizer(formalParametersExpression);
        int cnt = 0;
        String[] formalParameters = new String[st.countTokens() / 2];
        while (st.hasMoreTokens()) {
            st.nextToken();
            String token = st.nextToken();
            if (controlRedundancy) {
                for (int j = 0; j < cnt; ++j) {
                    if (!formalParameters[j].equals(token)) continue;
                    return null;
                }
            }
            formalParameters[cnt++] = token;
        }
        return formalParameters;
    }

    protected String[] buildUniversalPostfixExpression(String functionalExpression, String formalParametersExpression) {
        return this.buildUniversalPostfixExpression(functionalExpression, this.extractFormalParameters(formalParametersExpression, false)).split("\\s+");
    }

    protected void treatObjective(String content) {
        if (this.problem.framework == Types.TypeFramework.COP) {
            Types.TypeOptimization opt = Types.TypeOptimization.valueOf((String)this.currentType.toUpperCase());
            if (this.mapOfVars.get(content) != null) {
                if (opt == Types.TypeOptimization.MIN) {
                    this.problem.minimize(this.mapOfVars.get(content));
                } else {
                    this.problem.maximize(this.mapOfVars.get(content));
                }
            } else {
                Kit.exit(content + " cannot be handled for optimization in XCSP2");
            }
        } else if (this.problem.rs.cp.framework != Types.TypeFramework.CSP) {
            Kit.exit("This is a COP instance. Either you set -f=cop or you set -f=csp together with -vfs=v where v is an integer value forcing the value of the objective.");
        }
    }
}

