/*
 * Decompiled with CFR 0.152.
 */
package problems.xcsp2;

import constraints.Constraint;
import constraints.hard.CtrExtension;
import constraints.hard.extension.CtrExtensionMDD;
import constraints.hard.extension.CtrExtensionSTR2;
import constraints.hard.extension.structures.MDD;
import constraints.hard.extension.structures.MDDSplitter;
import constraints.soft.extension.CtrSoftExtension;
import constraints.soft.extension.LayeredSoftTable;
import executables.Integration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xcsp.common.Types;
import problem.Problem;
import problems.xcsp2.XCSP2;
import problems.xcsp2.XConstraint;
import problems.xcsp2.XConstraintExtension;
import problems.xcsp2.XHandler;
import utility.Enums;
import utility.Kit;
import utility.interfaces.TagExperimental;
import variables.Variable;
import variables.VariableInteger;

public final class XExtension {
    private Problem problem;
    private Map<String, XConstraint> mapForScopes;
    private List<XConstraint> collectedCtrs;
    private boolean preserveUniversalConstraints = true;

    XExtension(XHandler handler) {
        this.problem = handler.problem;
        this.mapForScopes = new HashMap<String, XConstraint>();
        this.collectedCtrs = new ArrayList<XConstraint>();
    }

    public void clear() {
        this.mapForScopes.clear();
        this.collectedCtrs.clear();
    }

    public void treat(String name, Variable[] scope, XConstraintExtension.XRelation xrelation) {
        if (!this.preserveUniversalConstraints && xrelation.isUniversalFor(scope)) {
            ++this.problem.stuff.nUniversalCtrs;
        } else if (!this.problem.rs.cp.constraints.normalizeCtrs) {
            this.collectedCtrs.add(new XConstraintExtension(name, scope, xrelation));
        } else {
            String scopeKey = Variable.joinNames((Variable[])Kit.sort((Object[])scope.clone()), "");
            XConstraintExtension xconstraintWithSameScope = (XConstraintExtension)this.mapForScopes.get(scopeKey);
            if (xconstraintWithSameScope == null) {
                XConstraintExtension xconstraint = new XConstraintExtension(name, scope, xrelation);
                this.collectedCtrs.add(xconstraint);
                this.mapForScopes.put(scopeKey, xconstraint);
            } else {
                ++this.problem.stuff.nMergedCtrs;
                xconstraintWithSameScope.mergeWith(name, scope, xrelation);
            }
        }
    }

    private Constraint buildConstraintForIntegration(XConstraintExtension xconstraint, XConstraintExtension.XRelationSoft xrelation) {
        int limit = 0;
        LayeredSoftTable layeredSoftTable = new LayeredSoftTable(xrelation.tuples, xrelation.costs, xrelation.defaultCost, true);
        ((Integration)this.problem.rs).addLayeredSoftTable(layeredSoftTable);
        int[][] selectedTuples = layeredSoftTable.buildTuplesFromLayersLessThanOrEqualTo(0L);
        return CtrExtension.build(this.problem, xconstraint.scope, selectedTuples, xrelation.defaultCost > (long)limit, Problem.UNSTARRED);
    }

    private Constraint buildUnaryConstraintFor(XConstraintExtension xctr) {
        Constraint c = null;
        if (xctr.xrelationMerged.semantics == Enums.ESemantics.SOFT) {
            XConstraintExtension.XRelationSoft xrelation = (XConstraintExtension.XRelationSoft)xctr.xrelationMerged;
            c = this.problem.rs instanceof Integration ? this.buildConstraintForIntegration(xctr, xrelation) : CtrSoftExtension.build(this.problem, xctr.scope, xrelation.tuples, xrelation.costs, xrelation.defaultCost);
        } else {
            boolean positive;
            boolean bl = positive = xctr.xrelationMerged.semantics == Enums.ESemantics.SUPPORTS;
            if (this.problem.rs.mustPreserveUnaryConstraints()) {
                c = CtrExtension.build(this.problem, xctr.scope, xctr.xrelationMerged.tuples, positive, Problem.UNSTARRED);
            } else {
                xctr.scope[0].dom.executeOnValues(v -> {
                    if (Kit.isPresent(v, xctr.xrelationMerged.tuples) != positive) {
                        xctr.scope[0].dom.removeValueAtConstructionTime((int)v);
                    }
                });
            }
        }
        return c;
    }

    private Constraint buildNonunaryConstraintFor(XConstraintExtension xctr) {
        Constraint ctr = null;
        if (xctr.xrelationMerged.semantics == Enums.ESemantics.SOFT) {
            XConstraintExtension.XRelationSoft xrel = (XConstraintExtension.XRelationSoft)xctr.xrelationMerged;
            ctr = this.problem.rs instanceof Integration ? this.buildConstraintForIntegration(xctr, xrel) : CtrSoftExtension.build(this.problem, xctr.scope, xrel.tuples, xrel.costs, xrel.defaultCost);
        } else {
            boolean positive = xctr.xrelationMerged.semantics == Enums.ESemantics.SUPPORTS;
            int[][] tuples = xctr.xrelationMerged.tuples;
            if (this.problem.rs.cp.extension.wcnConversion == Enums.EWCNConversion.NO) {
                ctr = CtrExtension.build(this.problem, xctr.scope, tuples, positive, xctr.xrelationMerged.presentStar);
            } else {
                int k = (int)Math.min(this.problem.rs.cp.optimizing.upperBound, Integer.MAX_VALUE);
                return CtrSoftExtension.build(this.problem, xctr.scope, tuples, positive, this.problem.rs.cp.extension.wcnConversion, k, this.problem.rs.random);
            }
        }
        return ctr;
    }

    private List<Constraint> buildCtrs() {
        ArrayList<Constraint> list = new ArrayList<Constraint>();
        Splitter splitter = this.problem.rs.cp.hardCoding.splitMDDConstraints ? new Splitter(list) : null;
        for (XConstraint cctr : this.collectedCtrs) {
            XConstraintExtension xctr = (XConstraintExtension)cctr;
            Constraint ctr = xctr.scope.length == 1 ? this.buildUnaryConstraintFor(xctr) : this.buildNonunaryConstraintFor(xctr);
            if (ctr == null || splitter != null && splitter.canSplit(ctr)) continue;
            list.add(ctr.setId(xctr.name));
        }
        if (splitter != null) {
            splitter.splitRecordedConstraints();
        }
        return list;
    }

    public void postConstraints() {
        HashMap<String, XConstraintExtension> map = new HashMap<String, XConstraintExtension>();
        for (XConstraint cctr : this.collectedCtrs) {
            XConstraintExtension xctr = (XConstraintExtension)cctr;
            String key = xctr.computeKey();
            XConstraintExtension xconstraintWithSameKey = (XConstraintExtension)map.get(key);
            if (xconstraintWithSameKey == null) {
                xctr.mergeCollectedDefinitions();
                map.put(key, xctr);
                continue;
            }
            xctr.xrelationMerged = xconstraintWithSameKey.xrelationMerged;
        }
        Enums.EBinaryEncoding binaryEncoding = this.problem.rs.cp.problem.binaryEncoding;
        List ctrs = binaryEncoding == Enums.EBinaryEncoding.NO ? this.buildCtrs() : new BinaryEncoder(binaryEncoding).buildCtrs();
        for (Constraint ctr : ctrs) {
            this.problem.addCtr(ctr, new Types.TypeClass[0]);
        }
    }

    private final class Splitter
    implements TagExperimental {
        private List<CtrExtensionMDD> constraintsToBeSplitted;
        private List<Constraint> listOfConstraints;
        private Map<CtrExtensionMDD, Variable[]> map = new HashMap<CtrExtensionMDD, Variable[]>();

        private Splitter(List<Constraint> list) {
            this.listOfConstraints = list;
            this.constraintsToBeSplitted = new LinkedList<CtrExtensionMDD>();
        }

        private void addAuxiliaryVariablesForSplittingFrom(CtrExtensionMDD ctr) {
            MDDSplitter splitter = ((MDD)ctr.extStructure()).getSplitter();
            Variable[] auxVars = new Variable[splitter.getSplitMode().length - 1];
            for (int i = 0; i < auxVars.length; ++i) {
                auxVars[i] = new VariableInteger(XExtension.this.problem, "V" + ((XExtension)XExtension.this).problem.stuff.collectedVarsAtInit.size(), new int[]{0, splitter.getNbAuxiliaryValues(i) - 1, Integer.MAX_VALUE});
                XExtension.this.problem.addVar(auxVars[i]);
            }
            this.map.put(ctr, auxVars);
            XExtension.this.problem.removeCtr(ctr);
        }

        private boolean canSplit(Constraint ctr) {
            if (ctr instanceof CtrExtensionMDD && ((XExtension)XExtension.this).problem.rs.cp.framework == Types.TypeFramework.CSP) {
                this.addAuxiliaryVariablesForSplittingFrom((CtrExtensionMDD)ctr);
                this.constraintsToBeSplitted.add((CtrExtensionMDD)ctr);
                return true;
            }
            return false;
        }

        private void split(CtrExtensionMDD ctr) {
            MDDSplitter splitter = ((MDD)ctr.extStructure()).getSplitter();
            int[] splitMode = splitter.getSplitMode();
            Variable[] auxVars = this.map.get(ctr);
            int initialScopePosition = 0;
            for (int i = 0; i < splitMode.length; ++i) {
                Variable[] pieceScope = new Variable[splitMode[i]];
                int piecePosition = 0;
                if (i != 0) {
                    pieceScope[piecePosition++] = auxVars[i - 1];
                }
                int nbInitialVariables = i == 0 || i == splitMode.length - 1 ? splitMode[i] - 1 : splitMode[i] - 2;
                for (int j = 0; j < nbInitialVariables; ++j) {
                    pieceScope[piecePosition++] = ctr.scp[initialScopePosition++];
                }
                if (i != splitMode.length - 1) {
                    pieceScope[piecePosition++] = auxVars[i];
                }
                CtrExtensionSTR2 pieceConstraint = new CtrExtensionSTR2(XExtension.this.problem, pieceScope);
                pieceConstraint.storeTuples(splitter.getSplitTuples(i), true);
                this.listOfConstraints.add(pieceConstraint);
            }
        }

        private void splitRecordedConstraints() {
            if (this.constraintsToBeSplitted.size() > 0) {
                for (CtrExtensionMDD constraint : this.constraintsToBeSplitted) {
                    this.split(constraint);
                }
            }
        }
    }

    public final class BinaryEncoder {
        private Enums.EBinaryEncoding binaryEncoding;
        private Variable[] orgnVars;
        private Variable[] dualVars;
        private boolean priorityToOriginalVars = true;

        private BinaryEncoder(Enums.EBinaryEncoding binaryEncoding) {
            this.binaryEncoding = binaryEncoding;
        }

        private void addVarsForBinaryEncoding(XConstraintExtension[] xctrs) {
            if (this.binaryEncoding != Enums.EBinaryEncoding.DUAL) {
                this.orgnVars = Kit.sort(((XExtension)XExtension.this).problem.mapForVars.values().toArray(new Variable[0]));
                ((XExtension)XExtension.this).problem.mapForVars.clear();
                for (Variable var : this.orgnVars) {
                    XExtension.this.problem.addVar(var);
                }
            }
            this.dualVars = new Variable[xctrs.length];
            for (int i = 0; i < xctrs.length; ++i) {
                this.dualVars[i] = (Variable)((XExtension)XExtension.this).problem.api.var(xctrs[i].name, ((XExtension)XExtension.this).problem.api.dom(((XExtension)XExtension.this).problem.api.range(xctrs[i].xrelationMerged.tuples.length)), new Types.TypeClass[0]);
            }
            if (this.priorityToOriginalVars && this.orgnVars != null) {
                ((XExtension)XExtension.this).problem.priorityVars = this.orgnVars;
            }
            if (this.binaryEncoding == Enums.EBinaryEncoding.HIDDEN) {
                ((XCSP2)((XExtension)XExtension.this).problem.api).greatestOriginalVariableId = this.orgnVars.length - 1;
            }
        }

        private List<Constraint> buildCtrs() {
            int i;
            ArrayList<Constraint> ctrs = new ArrayList<Constraint>();
            XConstraintExtension[] xctrs = XExtension.this.collectedCtrs.toArray(new XConstraintExtension[XExtension.this.collectedCtrs.size()]);
            this.addVarsForBinaryEncoding(xctrs);
            if (this.binaryEncoding != Enums.EBinaryEncoding.HIDDEN) {
                for (i = 0; i < xctrs.length; ++i) {
                    for (int j = i + 1; j < xctrs.length; ++j) {
                        int[][] mapping = Kit.mappingBetween(xctrs[i].scope, xctrs[j].scope);
                        if (mapping.length <= 0) continue;
                        int[][] tups1 = xctrs[i].xrelationMerged.tuples;
                        int[][] tups2 = xctrs[j].xrelationMerged.tuples;
                        Kit.log.info(xctrs[i].name + " has scope " + Kit.join((Object)xctrs[i].scope, new String[0]) + " and table size  " + tups1.length);
                        Kit.log.info(xctrs[j].name + " has scope " + Kit.join((Object)xctrs[j].scope, new String[0]) + " and table size  " + tups2.length);
                        Kit.log.info(Kit.join((Object)mapping, new String[0]));
                        if (xctrs[i].xrelationMerged.semantics != Enums.ESemantics.SUPPORTS || xctrs[j].xrelationMerged.semantics != Enums.ESemantics.SUPPORTS) {
                            Kit.log.info("skipped");
                            continue;
                        }
                        ArrayList<int[]> tups = new ArrayList<int[]>();
                        for (int p = 0; p < tups1.length; ++p) {
                            for (int q = 0; q < tups2.length; ++q) {
                                if (!Kit.areMappedTuples(tups1[p], tups2[q], mapping)) continue;
                                tups.add(new int[]{p, q});
                                if (tups.size() % 100000 != 0) continue;
                                Kit.log.info("already " + tups.size() + " tuples");
                            }
                        }
                        ctrs.add(CtrExtension.build(XExtension.this.problem, new Variable[]{this.dualVars[i], this.dualVars[j]}, Kit.intArray2D(tups), true, Problem.UNSTARRED));
                        Kit.log.info("constraint  " + ctrs.get(ctrs.size() - 1) + " has table size " + tups.size());
                    }
                }
            }
            if (this.binaryEncoding != Enums.EBinaryEncoding.DUAL) {
                for (i = 0; i < xctrs.length; ++i) {
                    Variable[] scp = xctrs[i].scope;
                    int[][] tuples = xctrs[i].xrelationMerged.tuples;
                    for (int j = 0; j < scp.length; ++j) {
                        ArrayList<int[]> list = new ArrayList<int[]>();
                        for (int p = 0; p < tuples.length; ++p) {
                            list.add(new int[]{p, tuples[p][j]});
                        }
                        CtrExtension ctr = CtrExtension.build(XExtension.this.problem, new Variable[]{this.dualVars[i], scp[j]}, Kit.intArray2D(list), true, Problem.UNSTARRED);
                        ctrs.add(ctr);
                        if (this.binaryEncoding != Enums.EBinaryEncoding.HIDDEN) continue;
                        ctr.data = new DualConstraint(tuples, j);
                    }
                    xctrs[i] = null;
                }
            }
            return ctrs;
        }

        public class DualConstraint {
            public int[][] tuples;
            public int position;

            private DualConstraint(int[][] tuples, int position) {
                this.tuples = tuples;
                this.position = position;
            }
        }
    }
}

