/*
 * Decompiled with CFR 0.152.
 */
package problems.xcsp2;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.xcsp.common.Types;
import problems.xcsp2.XConstraint;
import utility.Kit;
import variables.Variable;

public final class XConstraintIntension
extends XConstraint {
    private List<XPredicate> collectingList = new LinkedList<XPredicate>();
    protected String[] universalPredicateExpression;

    public XConstraintIntension(String name, Variable[] scope, String[] predicate) {
        super(name, scope);
        this.collectingList.add(new XPredicate(predicate));
    }

    public void mergeWith(String otherName, String[] otherPredicate) {
        this.name = this.name + "+" + otherName;
        this.collectingList.add(new XPredicate(otherPredicate));
    }

    private String[] mergePredicates() {
        if (this.collectingList.size() == 1) {
            return this.collectingList.get(0).predicate;
        }
        XPredicate[] xpredicates = Kit.sort(this.collectingList.toArray(new XPredicate[this.collectingList.size()]));
        int size = xpredicates.length - 1;
        for (XPredicate xpredicate : xpredicates) {
            size += xpredicate.predicate.length;
        }
        String[] predicate = new String[size];
        System.arraycopy(xpredicates[0].predicate, 0, predicate, 0, xpredicates[0].predicate.length);
        int cnt = xpredicates[0].predicate.length;
        for (int i = 1; i < xpredicates.length; ++i) {
            System.arraycopy(xpredicates[i].predicate, 0, predicate, cnt, xpredicates[i].predicate.length);
            cnt += xpredicates[i].predicate.length;
            predicate[cnt++] = Types.TypeExpr.AND.lcname;
        }
        return predicate;
    }

    private void modifyPredicateOrder(int[] permutation, String[] predicate) {
        for (int i = 0; i < predicate.length; ++i) {
            String token = predicate[i];
            if (!token.startsWith("%")) continue;
            int id = Integer.parseInt(token.substring(1));
            predicate[i] = "%" + permutation[id];
        }
    }

    @Override
    public void mergeCollectedDefinitions() {
        this.universalPredicateExpression = this.mergePredicates();
        if (this.collectingList.size() > 1) {
            System.out.println("bef=" + Kit.join((Object)this.universalPredicateExpression, new String[0]));
        }
        Object[] sortedScope = Kit.sort((Object[])this.scope.clone(), new MyComparator());
        this.modifyPredicateOrder(Kit.buildMapping(this.scope, sortedScope), this.universalPredicateExpression);
        this.scope = sortedScope;
    }

    private class MyComparator
    implements Comparator<Variable> {
        private MyComparator() {
        }

        @Override
        public int compare(Variable v1, Variable v2) {
            int res = v1.dom.typeName().compareTo(v2.dom.typeName());
            if (res != 0) {
                return res;
            }
            for (String token : XConstraintIntension.this.universalPredicateExpression) {
                if (!token.startsWith("%")) continue;
                int vap = Integer.parseInt(token.substring(1));
                if (XConstraintIntension.this.scope[vap] == v1) {
                    return -1;
                }
                if (XConstraintIntension.this.scope[vap] != v2) continue;
                return 1;
            }
            return 0;
        }
    }

    private class XPredicate
    implements Comparable<XPredicate> {
        private String[] predicate;
        private String keyForSorting;

        private XPredicate(String[] predicate) {
            this.predicate = predicate;
            StringBuilder sb = new StringBuilder();
            for (String s : predicate) {
                sb.append(s.startsWith("%") ? "%" : s).append(' ');
            }
            this.keyForSorting = sb.toString().trim();
        }

        @Override
        public int compareTo(XPredicate xpredicate) {
            return this.keyForSorting.compareTo(xpredicate.keyForSorting);
        }
    }
}

