/*
 * Decompiled with CFR 0.152.
 */
package problems.xcsp2;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.xcsp.common.Utilities;
import problems.xcsp2.XConstraint;
import utility.Enums;
import utility.Kit;
import utility.operations.Calculator;
import utility.sets.SetDense;
import variables.Variable;

public final class XConstraintExtension
extends XConstraint {
    protected String key;
    protected XRelation xrelationMerged;
    private List<XRelationMapped> collectingList = new ArrayList<XRelationMapped>();

    static HardTuples buildHardTuples(int arity, int nbTuples, String stringOfTuples) {
        int[][] tuples = new int[nbTuples][nbTuples == 0 ? 0 : arity];
        boolean presentStar = false;
        StringTokenizer st = new StringTokenizer(stringOfTuples, "| \t\n\r\f");
        for (int[] tuple : tuples) {
            for (int i = 0; i < arity; ++i) {
                String token = st.nextToken();
                if (token.equals("*")) {
                    presentStar = true;
                    tuple[i] = 0x7FFFFFFE;
                    continue;
                }
                tuple[i] = Integer.parseInt(token);
            }
        }
        return new HardTuples(tuples, presentStar);
    }

    static SoftTuples buildSoftTuples(int arity, int nbTuples, String stringOfTuples) {
        int[][] tuples = new int[nbTuples][nbTuples == 0 ? 0 : arity];
        boolean presentStar = false;
        long[] costs = new long[nbTuples];
        long[][] tuplesWithCosts = new long[nbTuples][nbTuples == 0 ? 0 : arity + 1];
        long currentCost = -2L;
        StringTokenizer st1 = new StringTokenizer(stringOfTuples, "|");
        for (int i = 0; i < nbTuples; ++i) {
            StringTokenizer st2 = new StringTokenizer(st1.nextToken().trim());
            String token = st2.nextToken();
            int costFlagPosition = token.lastIndexOf(":");
            if (costFlagPosition != -1) {
                currentCost = Long.parseLong(token.substring(0, costFlagPosition));
                token = token.substring(costFlagPosition + 1);
            }
            assert (currentCost >= 0L);
            costs[i] = currentCost;
            if (token.equals("*")) {
                presentStar = true;
                tuples[i][0] = 0x7FFFFFFE;
                tuplesWithCosts[i][0] = 0x7FFFFFFE;
            } else {
                int n = Integer.parseInt(token);
                tuples[i][0] = n;
                tuplesWithCosts[i][0] = n;
            }
            for (int j = 1; j < arity; ++j) {
                token = st2.nextToken();
                if (token.equals("*")) {
                    presentStar = true;
                    tuples[i][j] = 0x7FFFFFFE;
                    tuplesWithCosts[i][j] = 0x7FFFFFFE;
                    continue;
                }
                int n = Integer.parseInt(token);
                tuples[i][j] = n;
                tuplesWithCosts[i][j] = n;
            }
            tuplesWithCosts[i][arity] = costs[i];
            assert (i == 0 || Utilities.lexComparatorInt.compare(tuples[i - 1], tuples[i]) < 0) : Kit.join((Object)tuples[i - 1], new String[0]) + " and " + Kit.join((Object)tuples[i], new String[0]);
        }
        return new SoftTuples(tuples, presentStar, costs, tuplesWithCosts);
    }

    protected XConstraintExtension(String name, Variable[] scope, XRelation relation) {
        super(name, scope);
        this.collectingList.add(new XRelationMapped(relation, Kit.range(scope.length)));
    }

    protected void mergeWith(String otherName, Variable[] otherScope, XRelation otherRelation) {
        this.name = this.name + "+" + otherName;
        this.collectingList.add(new XRelationMapped(otherRelation, Kit.buildMapping(this.scope, otherScope)));
    }

    protected String computeKey() {
        StringBuilder sb = Variable.signatureFor(this.scope);
        for (XRelationMapped xrelationMapped : Kit.sort(this.collectingList.toArray(new XRelationMapped[this.collectingList.size()]))) {
            sb.append(xrelationMapped.getKey()).append(' ');
        }
        this.key = sb.toString();
        return this.key;
    }

    private XRelation mergeSoftRelations(XRelationMapped[] xrelationsMapped) {
        Kit.control(XRelationMapped.areAllSoftRelations(xrelationsMapped));
        long sumOfDefaultCosts = 0L;
        long[][][] allTuplesWithCosts = new long[xrelationsMapped.length][][];
        for (int i = 0; i < allTuplesWithCosts.length; ++i) {
            XRelationSoft xrelationSoft = (XRelationSoft)xrelationsMapped[i].xrelation;
            allTuplesWithCosts[i] = Kit.sort(Kit.mapTuples(xrelationSoft.tuplesWithCosts, xrelationsMapped[i].mapping), Kit.lexComparatorLong);
            assert (Kit.isLexStrictlyIncreasing(allTuplesWithCosts[i]));
            sumOfDefaultCosts = Calculator.add(sumOfDefaultCosts, xrelationSoft.defaultCost);
        }
        Kit.control(sumOfDefaultCosts <= Long.MAX_VALUE);
        Comparator comparator = (t1, t2) -> {
            for (int i = 0; i < ((long[])t1).length - 1; ++i) {
                if (t1[i] < t2[i]) {
                    return -1;
                }
                if (t1[i] <= t2[i]) continue;
                return 1;
            }
            return 0;
        };
        TreeSet<long[]> setOfTuplesWithCosts = new TreeSet<long[]>(comparator);
        int[] cursors = new int[allTuplesWithCosts.length];
        SetDense denseSet = new SetDense(allTuplesWithCosts.length);
        boolean finished = false;
        while (!finished) {
            denseSet.clear();
            for (int i = 0; i < allTuplesWithCosts.length; ++i) {
                if (cursors[i] == allTuplesWithCosts[i].length) continue;
                if (denseSet.size() == 0) {
                    denseSet.add(i);
                    continue;
                }
                int cursorOfBestTuple = cursors[denseSet.last()];
                int res = comparator.compare(allTuplesWithCosts[denseSet.last()][cursorOfBestTuple], allTuplesWithCosts[i][cursors[i]]);
                if (res == 0) {
                    denseSet.add(i);
                    continue;
                }
                if (res == -1) continue;
                denseSet.clear();
                denseSet.add(i);
            }
            if (denseSet.size() == 0) {
                finished = true;
                continue;
            }
            long[] tupleWithCost = allTuplesWithCosts[denseSet.dense[0]][cursors[denseSet.dense[0]]];
            long cost = sumOfDefaultCosts;
            for (int i = 0; i < denseSet.size(); ++i) {
                int n = denseSet.dense[i];
                int n2 = cursors[n];
                cursors[n] = n2 + 1;
                cost = Calculator.add(cost, Calculator.add(allTuplesWithCosts[denseSet.dense[i]][n2][this.scope.length], -((XRelationSoft)((XRelationMapped)xrelationsMapped[denseSet.dense[i]]).xrelation).defaultCost));
            }
            tupleWithCost[this.scope.length] = cost;
            setOfTuplesWithCosts.add(tupleWithCost);
        }
        return new XRelationSoft(this.scope.length, (long[][])setOfTuplesWithCosts.toArray((T[])new long[setOfTuplesWithCosts.size()][]), sumOfDefaultCosts);
    }

    private XRelation mergeHardRelations(XRelationMapped[] xrelationsMapped) {
        XRelationMapped smallest = XRelationMapped.getSmallestPositiveRelationMapped(xrelationsMapped);
        if (smallest == null) {
            TreeSet<int[]> setOfConflicts = new TreeSet<int[]>(Utilities.lexComparatorInt);
            for (XRelationMapped xrelationMapped : xrelationsMapped) {
                for (int[] tuple : ((XRelationMapped)xrelationMapped).xrelation.tuples) {
                    setOfConflicts.add(Kit.mapTuple(tuple, xrelationMapped.mapping));
                }
            }
            return new XRelationHard(this.scope.length, (int[][])setOfConflicts.toArray((T[])new int[setOfConflicts.size()][]), Enums.ESemantics.CONFLICTS);
        }
        TreeSet<Object> setOfSupports = new TreeSet<Object>(Utilities.lexComparatorInt);
        int[] canonicalTuple = new int[this.scope.length];
        int[] reversedTuple = new int[this.scope.length];
        for (int[] tuple : ((XRelationMapped)smallest).xrelation.tuples) {
            Kit.mapTuple(tuple, canonicalTuple, smallest.mapping);
            boolean allowedTuple = true;
            for (XRelationMapped xrelationMapped : xrelationsMapped) {
                if (xrelationMapped == smallest) continue;
                Kit.mapTuple(canonicalTuple, reversedTuple, xrelationMapped.reverseMapping);
                if (Arrays.binarySearch(((XRelationMapped)xrelationMapped).xrelation.tuples, reversedTuple, Utilities.lexComparatorInt) >= 0 == (((XRelationMapped)xrelationMapped).xrelation.semantics == Enums.ESemantics.SUPPORTS)) continue;
                allowedTuple = false;
                break;
            }
            if (!allowedTuple) continue;
            setOfSupports.add(canonicalTuple.clone());
        }
        return new XRelationHard(this.scope.length, (int[][])setOfSupports.toArray((T[])new int[setOfSupports.size()][]), Enums.ESemantics.SUPPORTS);
    }

    @Override
    public void mergeCollectedDefinitions() {
        XRelationMapped[] xrelationsMapped = this.collectingList.toArray(new XRelationMapped[this.collectingList.size()]);
        if (xrelationsMapped.length == 1) {
            this.xrelationMerged = xrelationsMapped[0].xrelation;
        } else {
            Kit.control(XRelationMapped.areAllClassicalRelations(xrelationsMapped));
            this.xrelationMerged = ((XRelationMapped)xrelationsMapped[0]).xrelation.semantics == Enums.ESemantics.SOFT ? this.mergeSoftRelations(xrelationsMapped) : this.mergeHardRelations(xrelationsMapped);
        }
        assert (Kit.isLexStrictlyIncreasing(this.xrelationMerged.tuples));
    }

    protected static class XRelationMapped
    implements Comparable<XRelationMapped> {
        private XRelation xrelation;
        private int[] mapping;
        private int[] reverseMapping;

        private static boolean areAllSoftRelations(XRelationMapped[] xrelationsMapped) {
            for (XRelationMapped xrelationMapped : xrelationsMapped) {
                if (xrelationMapped.xrelation.semantics == Enums.ESemantics.SOFT) continue;
                return false;
            }
            return true;
        }

        private static boolean areAllClassicalRelations(XRelationMapped[] xrelationsMapped) {
            for (XRelationMapped xrelationMapped : xrelationsMapped) {
                if (!xrelationMapped.xrelation.presentStar) continue;
                return false;
            }
            return true;
        }

        private static XRelationMapped getSmallestPositiveRelationMapped(XRelationMapped[] xrelationsMapped) {
            XRelationMapped smallest = null;
            for (XRelationMapped xrelationMapped : xrelationsMapped) {
                if (xrelationMapped.xrelation.semantics != Enums.ESemantics.SUPPORTS || smallest != null && xrelationMapped.xrelation.tuples.length >= smallest.xrelation.tuples.length) continue;
                smallest = xrelationMapped;
            }
            return smallest;
        }

        protected XRelationMapped(XRelation xrelation, int[] mapping) {
            this.xrelation = xrelation;
            this.mapping = mapping;
            this.reverseMapping = Kit.buildReverseMapping(mapping);
        }

        protected String getKey() {
            return "XR" + this.xrelation.id + " " + Kit.join((Object)this.mapping, new String[0]);
        }

        @Override
        public int compareTo(XRelationMapped xrelationMapped) {
            return this.xrelation.id - xrelationMapped.xrelation.id;
        }

        public String toString() {
            return this.getKey() + " tuples=" + Kit.join((Object)this.xrelation.tuples, " ", ",");
        }
    }

    protected static final class XRelationSoft
    extends XRelation {
        protected long[] costs;
        protected long defaultCost;
        private long[][] tuplesWithCosts;

        public XRelationSoft(int arity, int nbTuples, Enums.ESemantics semantics, long defaultCost) {
            super(arity, nbTuples, semantics);
            this.defaultCost = defaultCost;
        }

        public XRelationSoft(int arity, long[][] tuplesWithCosts, long defaultCost) {
            this(arity, tuplesWithCosts.length, Enums.ESemantics.SOFT, defaultCost);
            this.tuples = new int[this.nbTuples][arity];
            this.costs = new long[this.nbTuples];
            for (int i = 0; i < this.nbTuples; ++i) {
                for (int j = 0; j < arity; ++j) {
                    this.tuples[i][j] = (int)tuplesWithCosts[i][j];
                }
                this.costs[i] = tuplesWithCosts[i][arity];
            }
            this.tuplesWithCosts = tuplesWithCosts;
            assert (!Kit.isPresent(0x7FFFFFFE, this.tuples)) : " star for merged relation not still implemented";
        }

        @Override
        protected void setTuplesFrom(String s) {
            SoftTuples softTuples = XConstraintExtension.buildSoftTuples(this.arity, this.nbTuples, s);
            this.tuples = softTuples.tuples;
            this.presentStar = softTuples.presentStar;
            this.costs = softTuples.costs;
            this.tuplesWithCosts = softTuples.tuplesWithCosts;
            Kit.control(!this.presentStar || this.arity > 1);
        }

        @Override
        protected boolean isUniversalFor(Variable[] scope) {
            return this.tuples.length == 0 && this.defaultCost == 0L;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.semantics.toString());
            for (int i = 0; i < this.tuples.length; ++i) {
                sb.append(' ').append((CharSequence)Kit.join(sb, (Object)this.tuples[i], new String[0]).append(':').append(this.costs[i]));
            }
            return sb.append("default:").append(this.defaultCost).toString();
        }
    }

    protected static final class XRelationHard
    extends XRelation {
        protected XRelationHard(int arity, int nbTuples, Enums.ESemantics semantics) {
            super(arity, nbTuples, semantics);
        }

        protected XRelationHard(int arity, int[][] tuples, Enums.ESemantics semantics) {
            super(arity, tuples, semantics);
            assert (!Kit.isPresent(0x7FFFFFFE, tuples)) : " star for merged relation not still implemented";
        }

        @Override
        protected void setTuplesFrom(String s) {
            HardTuples hardTuples = XConstraintExtension.buildHardTuples(this.arity, this.nbTuples, s.trim());
            this.tuples = hardTuples.tuples;
            this.presentStar = hardTuples.presentStar;
            Kit.control(!this.presentStar || this.arity > 1);
        }

        @Override
        protected boolean isUniversalFor(Variable[] scope) {
            if (this.semantics == Enums.ESemantics.CONFLICTS) {
                return this.tuples.length == 0;
            }
            return Variable.nValidTuples(scope, false).compareTo(BigInteger.valueOf(this.tuples.length)) == 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.semantics.toString());
            for (int[] tuple : this.tuples) {
                sb.append(' ').append((CharSequence)Kit.join(sb, (Object)tuple, new String[0]));
            }
            return sb.toString();
        }
    }

    protected static abstract class XRelation {
        private static int nbRelations;
        protected int id = nbRelations++;
        protected int arity;
        protected int nbTuples;
        protected int[][] tuples;
        protected Enums.ESemantics semantics;
        protected boolean presentStar;

        protected XRelation(int arity, int nbTuples, Enums.ESemantics semantics) {
            this.arity = arity;
            this.nbTuples = nbTuples;
            this.semantics = semantics;
            Kit.control(!(this instanceof XRelationHard) || semantics == Enums.ESemantics.SUPPORTS || semantics == Enums.ESemantics.CONFLICTS);
            Kit.control(!(this instanceof XRelationSoft) || semantics == Enums.ESemantics.SOFT);
        }

        protected XRelation(int arity, int[][] tuples, Enums.ESemantics semantics) {
            this(arity, tuples.length, semantics);
            this.tuples = tuples;
        }

        protected abstract void setTuplesFrom(String var1);

        protected abstract boolean isUniversalFor(Variable[] var1);
    }

    static class SoftTuples
    extends HardTuples {
        public long[] costs;
        public long[][] tuplesWithCosts;

        SoftTuples(int[][] tuples, boolean presentStar, long[] costs, long[][] tuplesWithCosts) {
            super(tuples, presentStar);
            this.costs = costs;
            this.tuplesWithCosts = tuplesWithCosts;
        }
    }

    static class HardTuples {
        public int[][] tuples;
        public boolean presentStar;

        HardTuples(int[][] tuples, boolean presentStar) {
            this.tuples = tuples;
            this.presentStar = presentStar;
        }
    }
}

