/*
 * Decompiled with CFR 0.152.
 */
package problems.todo;

import constraints.hard.CtrAdhoc;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;
import problem.Problem;
import utility.Kit;
import variables.Variable;

public class WordDesign
implements ProblemAPI {
    int n;
    byte[][] words;
    byte[][] complementWords;

    byte[] buildComplementOf(byte[] word) {
        byte[] complementWord = new byte[word.length];
        for (int i = 0; i < complementWord.length; ++i) {
            complementWord[i] = (byte)(word[i] == 65 ? 84 : (word[i] == 84 ? 65 : (word[i] == 67 ? 71 : (word[i] == 71 ? 67 : (int)((Byte)Kit.exit("Bad letter")).byteValue()))));
        }
        return complementWord;
    }

    void data() {
        this.n = this.imp().askInt("Order (number of words to be found)", this.rangeClosed(1, 1000));
        this.words = new byte[17440][];
        this.complementWords = new byte[17440][];
        try (BufferedReader in = new BufferedReader(new FileReader("/home/lecoutre/abssol/WordsDNA.dat"));){
            for (int i = 0; i < this.words.length; ++i) {
                this.words[i] = in.readLine().getBytes();
                this.complementWords[i] = this.buildComplementOf(this.words[i]);
            }
            assert (in.readLine() == null);
        }
        catch (IOException e) {
            Kit.exit("Erreur ouverture fichier ", e);
        }
    }

    private boolean checkPair(int i, int j) {
        int cnt1 = 0;
        int cnt2 = 0;
        int cnt3 = 0;
        byte[] word0 = this.words[i];
        byte[] word1 = this.words[j];
        byte[] complement0 = this.complementWords[i];
        byte[] complement1 = this.complementWords[j];
        for (int k = 0; k < word0.length; ++k) {
            if (word0[k] == word1[k] && ++cnt1 == 5) {
                return false;
            }
            if (word0[7 - k] == complement1[k] && ++cnt2 == 5) {
                return false;
            }
            if (word1[7 - k] != complement0[k] || ++cnt3 != 5) continue;
            return false;
        }
        return true;
    }

    List<int[]> count() {
        ArrayList<int[]> list = new ArrayList<int[]>();
        for (int i = 0; i < this.words.length; ++i) {
            for (int j = i + 1; j < this.words.length; ++j) {
                if (!this.checkPair(i, j)) continue;
                list.add(this.tuple(i, new int[]{j}));
            }
        }
        return list;
    }

    public void model() {
        IVar.Var[] x = this.array("x", this.size(this.n), this.dom(this.range(this.words.length)), "x[i] is the ith word", new Types.TypeClass[0]);
        this.forall(this.range(this.n).range(this.n), (i, j) -> {
            if (i < j) {
                ((Problem)this.imp()).addCtr(new DistinctPositions((Problem)this.imp(), (Variable[])this.vars(x[i], (IVar)x[j])), new Types.TypeClass[0]);
            }
        });
        this.strictlyIncreasing(x).tag(new Types.TypeClass[]{SYMMETRY_BREAKING});
    }

    public static void main(String[] args) {
        try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter("WordsDNA.dat")));){
            WordsGenerator wg = new WordsGenerator();
            int n = (int)Math.pow(4.0, 8.0);
            int cnt = 0;
            for (int i = 0; i < n; ++i) {
                char[] s = wg.decrypt(i);
                if (s == null) continue;
                ++cnt;
                out.println(s);
            }
            System.out.println("cnt=" + cnt);
        }
        catch (IOException e) {
            Kit.exit("Not possible to build file ", e);
        }
    }

    public static class WordsGenerator {
        private char[] word = new char[8];
        private char[] reverseWord = new char[8];
        private char[] watsonCrickWord = new char[8];

        private char giveCorrespondanceFor(int v) {
            return (char)(v == 0 ? 65 : (v == 1 ? 67 : (v == 2 ? 71 : (v == 3 ? 84 : (int)((Character)Kit.exit("Bad letter")).charValue()))));
        }

        private char[] decrypt(int v) {
            int i;
            int cnt = 0;
            for (i = 0; i < this.word.length; ++i) {
                this.word[i] = this.giveCorrespondanceFor(v % 4);
                if (this.word[i] == 'C' || this.word[i] == 'G') {
                    ++cnt;
                }
                v /= 4;
            }
            if (cnt != 4) {
                return null;
            }
            for (i = 0; i < this.reverseWord.length; ++i) {
                this.reverseWord[i] = this.word[8 - i - 1];
            }
            for (i = 0; i < this.watsonCrickWord.length; ++i) {
                this.watsonCrickWord[i] = this.word[i] == 'A' ? 84 : (this.word[i] == 'T' ? 65 : (this.word[i] == 'C' ? 71 : (this.word[i] == 'G' ? 67 : (int)((Character)Kit.exit("Bad letter")).charValue())));
            }
            int cnt2 = 0;
            for (int i2 = 0; i2 < 8; ++i2) {
                if (this.reverseWord[i2] == this.watsonCrickWord[i2]) continue;
                ++cnt2;
            }
            return cnt2 < 4 ? null : this.word;
        }
    }

    class DistinctPositions
    extends CtrAdhoc {
        public DistinctPositions(Problem problem, Variable[] scope) {
            super(problem, scope);
        }

        @Override
        public final boolean checkValues(int[] vals) {
            int cnt1 = 0;
            int cnt2 = 0;
            int cnt3 = 0;
            byte[] word0 = WordDesign.this.words[vals[0]];
            byte[] word1 = WordDesign.this.words[vals[1]];
            byte[] complement0 = WordDesign.this.complementWords[vals[0]];
            byte[] complement1 = WordDesign.this.complementWords[vals[1]];
            for (int i = 0; i < word0.length; ++i) {
                if (word0[i] == word1[i] && ++cnt1 == 5) {
                    return false;
                }
                if (word0[7 - i] == complement1[i] && ++cnt2 == 5) {
                    return false;
                }
                if (word1[7 - i] != complement0[i] || ++cnt3 != 5) continue;
                return false;
            }
            return true;
        }
    }
}

