/*
 * Decompiled with CFR 0.152.
 */
package problems.todo;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;

public class SportsDual
implements ProblemAPI {
    int nTeams;

    public void model() {
        int nWeeks = this.nTeams - 1;
        int nPeriods = this.nTeams / 2;
        if (this.modelVariant("m1")) {
            IVar.Var[][] o = this.array("o", this.size(nWeeks, this.nTeams), this.dom(this.range(this.nTeams)), "o[w][t] gives at week w the opponent of team t", new Types.TypeClass[0]);
            IVar.Var[][] p = this.array("p", this.size(nWeeks, this.nTeams), this.dom(this.range(nPeriods)), "p[w][t] gives the period at week w of team t", new Types.TypeClass[0]);
            IVar.Var[] d = this.array("d", this.size(this.nTeams), this.dom(this.range(nPeriods)), "d[t] gives the dummy period of team t", new Types.TypeClass[0]);
            this.forall(this.range(nWeeks), w -> this.allDifferent(o[w])).note("Each week, all teams have a different opponent");
            this.forall(this.range(nWeeks).range(this.nTeams), (w, t) -> this.different(new Object[]{o[w][t], t})).note("Each week, a team can't play against itself");
            this.forall(this.range(nWeeks).range(this.nTeams).range(this.nTeams), (w, t1, t2) -> {
                if (t1 < t2) {
                    this.equivalence(new Object[]{this.eq(new Object[]{o[w][t1], t2}), this.eq(new Object[]{o[w][t2], t1}), this.eq(new Object[]{p[w][t1], p[w][t2]})});
                }
            }).note("j plays k <=> k plays j <=> j and k play on the same period");
            this.forall(this.range(this.nTeams), t -> this.allDifferent((IVar.Var[])this.columnOf(o, t))).note("Each team has a different opponent every week");
            this.forall(this.range(this.nTeams), t -> this.cardinality((IVar.Var[])this.vars(this.columnOf(p, t), (IVar)d[t]), this.vals(new Object[]{this.range(nPeriods)}), this.occursEachExactly(2)));
            this.forall(this.range(this.nTeams), t -> this.equal(new Object[]{p[0][t], t / 2})).note("Symmetry breaking: assign opponents and periods for week 0");
            this.forall(this.range(0, this.nTeams, 2), t -> this.intension(this.lt(p[1][t], p[1][t + 1]))).note("Symmetry breaking: order periods on week 1");
        }
        if (this.modelVariant("m2")) {
            Object[][] w2 = this.array("w", this.size(this.nTeams, this.nTeams), this.dom(this.range(nWeeks + 1)), "w[t1][t2] gives the week of the match between t1 and t2", new Types.TypeClass[0]);
            this.forall(this.range(this.nTeams).range(this.nTeams), (arg_0, arg_1) -> this.lambda$model$7((IVar.Var[][])w2, nWeeks, arg_0, arg_1)).note("Exactly nPeriods matches each week");
            this.cardinality((IVar.Var[])this.select(w2, (i, j) -> i < j), this.vals(new Object[]{this.range(nWeeks)}), this.occursEachExactly(nPeriods));
            this.forall(this.range(this.nTeams), arg_0 -> this.lambda$model$11((IVar.Var[][])w2, arg_0)).note("A team cannot play twice in the same week");
            this.forall(this.range(1, this.nTeams), arg_0 -> this.lambda$model$12((IVar.Var[][])w2, arg_0)).note("Symmetry breaking: team 0 plays team i on week i-1");
            this.forall(this.range(2, this.nTeams, 2), arg_0 -> this.lambda$model$13((IVar.Var[][])w2, arg_0)).note("Symmetry breaking: matches are assigned for week 0");
        }
    }

    public void prettyDisplay(String[] values) {
        int j;
        int i;
        if (this.modelVariant("m1")) {
            return;
        }
        int nWeeks = this.nTeams - 1;
        int nPeriods = this.nTeams / 2;
        int[][][] matches = new int[nPeriods][nWeeks][];
        for (i = 0; i < nPeriods; ++i) {
            for (j = 0; j < nWeeks; ++j) {
                matches[i][j] = new int[]{-1, -1};
            }
        }
        for (i = 0; i < this.nTeams; ++i) {
            block14: for (j = i + 1; j < this.nTeams; ++j) {
                int matchWeek = Integer.parseInt(values[i * this.nTeams + j]);
                for (int k = 0; k < nPeriods; ++k) {
                    if (matches[k][matchWeek][0] != -1) continue;
                    matches[k][matchWeek][0] = i;
                    matches[k][matchWeek][1] = j;
                    continue block14;
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < nPeriods; ++i2) {
            for (int j2 = 0; j2 < nWeeks; ++j2) {
                sb.append(matches[i2][j2][0] + "vs" + matches[i2][j2][1] + "\t");
            }
            sb.append("\n");
        }
        String result = sb.toString();
        try (BufferedWriter output = new BufferedWriter(new FileWriter("SportsDual.txt"));){
            output.write(result);
            output.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private /* synthetic */ void lambda$model$13(IVar.Var[][] w, int t) {
        this.equal(new Object[]{w[t][t + 1], 0});
    }

    private /* synthetic */ void lambda$model$12(IVar.Var[][] w, int t) {
        this.equal(new Object[]{w[0][t], t - 1});
    }

    private /* synthetic */ void lambda$model$11(IVar.Var[][] w, int t) {
        this.allDifferent((IVar.Var[])this.vars(this.select(w, (i, j) -> i < t && j == t), (IVar[])this.select(w, (i, j) -> i == t && j > t)));
    }

    private /* synthetic */ void lambda$model$7(IVar.Var[][] w, int nWeeks, int i, int j) {
        if (i < j) {
            this.different(new Object[]{w[i][j], nWeeks});
        } else {
            this.equal(new Object[]{w[i][j], nWeeks});
        }
    }
}

