/*
 * Decompiled with CFR 0.152.
 */
package problems.todo;

import java.util.ArrayList;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.modeler.api.ProblemAPI;

public class RKAES1
implements ProblemAPI {
    int n;
    int objective;
    int KEY_BITS = 128;
    int BLOCK_BITS = 128;
    int KC = this.KEY_BITS / 32;
    int BC = this.BLOCK_BITS / 32;
    int NBK = this.KC + this.n * this.BC / this.KC;

    void data() {
        this.n = this.imp().askInt("Order (n)");
        this.objective = this.imp().askInt("Objective");
    }

    public void model() {
        IVar.Var[][][] deltaY = this.array("deltaY", this.size(this.n - 1, this.BC, 4), this.dom(0, new int[]{1}), "State before ARK", new Types.TypeClass[0]);
        IVar.Var[][][] deltaX = this.array("deltaX", this.size(this.n, this.BC, 4), this.dom(0, new int[]{1}), "State after ARK", new Types.TypeClass[0]);
        IVar.Var[][][] deltaSR = this.array("deltaSR", this.size(this.n, this.BC, 4), this.dom(0, new int[]{1}), "State after ShiftRows", new Types.TypeClass[0]);
        IVar.Var[][][] deltaK = this.array("deltaK", this.size(this.n, this.BC, 4), this.dom(0, new int[]{1}), "Key", new Types.TypeClass[0]);
        IVar.Var[][][][] Kcomp = this.array("Kcomp", this.size(this.n, this.BC, 4, this.NBK), this.dom(0, new int[]{1}), "The components of the key", new Types.TypeClass[0]);
        IVar.Var[][][][][] eqK = this.array("eqK", this.size(4, this.n, this.BC, this.n, this.BC), this.dom(0, new int[]{1}), "eqK[i][r1][j1][r2][j2] => The byte values of DeltaK[r1,i,j1] and [r2,i,j2] are equal", new Types.TypeClass[0]);
        IVar.Var[][] colX = this.array("colX", this.size(this.n, this.BC), this.dom(this.range(5)), "colX[r][j] = The sum for i in 0..3 of DeltaY[r][i][j]", new Types.TypeClass[0]);
        IVar.Var[][] colSRX = this.array("colSRX", this.size(this.n, this.BC), this.dom(this.range(5)), "colSRX[r][j] = The sum for i in 0..3 of SR(DeltaY)[r][i][j]", new Types.TypeClass[0]);
        IVar.Var[][] colK = this.array("colK", this.size(this.n, this.BC), this.dom(this.range(5)), "colK[r][j] = The sum for i in 0..3 of DeltaK[r][i][j]", new Types.TypeClass[0]);
        IVar.Var[][] eqSRX = this.array("eqSRX", this.size(this.n * this.BC, this.n * this.BC), (J, J2) -> this.BC <= J && J < J2 ? this.dom(this.range(5)) : null, new Types.TypeClass[0]);
        this.block(() -> {
            this.forall(this.range(this.n).range(this.BC), (r, j) -> this.sum(deltaX[r][j], EQ, colX[r][j]));
            this.forall(this.range(this.n).range(this.BC), (r, j) -> this.sum(deltaK[r][j], EQ, colK[r][j]));
            this.forall(this.range(this.n).range(this.BC), (r, j) -> this.sum(deltaSR[r][j], EQ, colSRX[r][j]));
        }).note("Initialisation of the redundant variables.");
        this.forall(this.range(this.n * this.BC).range(4).range(this.NBK), (J, i, k) -> {
            int r = J / this.BC;
            int j = J % this.BC;
            if (J < this.KC) {
                this.equal(new Object[]{Kcomp[r][j][i][k], k == J ? deltaK[r][j][i] : Integer.valueOf(0)});
            } else if (J % this.KC == 0) {
                this.equal(new Object[]{Kcomp[r][j][i][k], k == J / this.KC * this.BC + j ? deltaK[(J - 1) / this.BC][(J + this.BC - 1) % this.BC][(i + 1) % 4] : Kcomp[(J - this.KC) / this.BC][(J - this.KC) % this.BC][i][k]});
            }
        }).note("Initialization of the components");
        this.forall(this.range(1, this.n).range(this.BC).range(4), (r, j, i) -> this.sum((IVar.Var[])this.vars((IVar)deltaY[r - 1][j][i], (IVar[])new IVar.Var[]{deltaK[r][j][i], deltaX[r][j][i]}), NE, 1L)).note("Add round key");
        this.forall(this.range(this.n).range(this.BC).range(4), (r, j, i) -> this.equal(new Object[]{deltaSR[r][j][i], deltaX[r][(j + i) % this.BC][i]})).note("Shiftrows; MDS property");
        this.forall(this.range(this.n - 1).range(this.BC), (r, j) -> this.sum((IVar.Var[])this.vars((IVar)colSRX[r][j], (IVar[])deltaY[r][j]), IN, this.vals(new Object[]{0, 5, 6, 7, 8}))).note("Mixcolumns; MDS property");
        this.block(() -> {
            this.forall(this.range(this.KC, this.n * this.BC).range(4), (J, i) -> {
                int r = J / this.BC;
                int j = J % this.BC;
                this.sum((IVar.Var[])this.vars((IVar)deltaK[(J - this.KC) / this.BC][(J - this.KC) % this.BC][i], (IVar[])new IVar.Var[]{deltaK[(J - 1) / this.BC][(J + this.BC - 1) % this.BC][J % this.KC == 0 ? (i + 1) % 4 : i], deltaK[r][j][i]}), NE, 1L);
            }).note("Key Sckedule: XOR");
            this.forall(this.range(this.KC, this.n * this.BC).range(4), (J, i) -> {
                int r = J / this.BC;
                int j = J % this.BC;
                if (J % this.KC != 0) {
                    this.equal(new Object[]{eqK[i][(J - 1) / this.BC][(J + this.BC - 1) % this.BC][(J - this.KC) / this.BC][(J - this.KC) % this.BC], this.not(deltaK[r][j][i])});
                    this.equal(new Object[]{eqK[i][r][j][(J - this.KC) / this.BC][(J - this.KC) % this.BC], this.not(deltaK[(J - 1) / this.BC][(J + this.BC - 1) % this.BC][i])});
                    this.equal(new Object[]{eqK[i][r][j][(J - 1) / this.BC][(J + this.BC - 1) % this.BC], this.not(deltaK[(J - this.KC) / this.BC][(J - this.KC) % this.BC][i])});
                }
            }).note("Key Sckedule: eqab eqac eqbc");
            this.forall(this.range(this.KC, this.n * this.BC).range(4), (J, i) -> {
                int r = J / this.BC;
                int j = J % this.BC;
                this.sum((IVar.Var[])this.vars(Kcomp[r][j][i], (IVar)deltaK[r][j][i]), NE, 1L);
            });
            this.forall(this.range(this.KC, this.n * this.BC).range(4).range(this.NBK), (J, i, k) -> {
                int r = J / this.BC;
                int j = J % this.BC;
                if (J % this.KC != 0) {
                    this.extension(this.eq(new Object[]{Kcomp[r][j][i][k], this.ne(new Object[]{this.mul(new Object[]{Kcomp[(J - this.KC) / this.BC][(J - this.KC) % this.BC][i][k], deltaK[(J - this.KC) / this.BC][(J - this.KC) % this.BC][i]}), this.mul(new Object[]{Kcomp[(J - 1) / this.BC][(J + this.BC - 1) % this.BC][i][k], deltaK[(J - 1) / this.BC][(J + this.BC - 1) % this.BC][i]})})}));
                }
            }).note("Key schedule: XOR of the components");
        }).note("Key Schedule");
        this.forall(this.range(this.n * this.BC).range(this.n * this.BC).range(4), (J, J2, i) -> {
            if (J < J2) {
                int r = J / this.BC;
                int j = J % this.BC;
                int r2 = J2 / this.BC;
                int j2 = J2 % this.BC;
                this.extension(this.imp(this.eq(new Object[]{eqK[i][r][j][r2][j2], 1}), this.eq(new Object[]{deltaK[r][j][i], deltaK[r2][j2][i]}))).note("EQ(a,b) implies A=B");
                this.equal(new Object[]{eqK[i][r][j][r2][j2], eqK[i][r][j][r2][j2]}).tag(new Types.TypeClass[]{SYMMETRY_BREAKING});
                this.sum((IVar.Var[])this.vars((IVar)deltaK[r][j][i], (IVar[])new IVar.Var[]{deltaK[r2][j2][i], eqK[i][r][j][r2][j2]}), NE, 0L).note("a+b+EQ(a,b) !=0");
                this.forall(this.range(this.NBK), k -> this.extension(this.imp(this.eq(new Object[]{Kcomp[r][j][i][k], Kcomp[r2][j2][i][k]}), this.eq(new Object[]{eqK[i][r][j][r2][j2], 1})))).note("Va=Vb => EQ(a,b)");
            }
        });
        this.forall(this.range(this.n * this.BC).range(this.n * this.BC).range(4).range(this.NBK), (J, J2, i, k) -> {
            if (J < J2) {
                int r = J / this.BC;
                int j = J % this.BC;
                int r2 = J2 / this.BC;
                int j2 = J2 % this.BC;
                this.extension(this.imp(this.eq(new Object[]{Kcomp[r][j][i][k], Kcomp[r2][j2][i][k]}), this.eq(new Object[]{eqK[i][r][j][r2][j2], 1})));
            }
        }).note("Va=Vb => EQ(a,b)");
        this.forall(this.range(this.n * this.BC).range(this.n * this.BC).range(4).range(this.n * this.BC), (J, J2, i, J3) -> {
            if (J < J2) {
                int r = J / this.BC;
                int j = J % this.BC;
                int r2 = J2 / this.BC;
                int j2 = J2 % this.BC;
                int r3 = J3 / this.BC;
                int j3 = J3 % this.BC;
                if (J3 != J && J3 != J2) {
                    this.sum((IVar.Var[])this.vars((IVar)eqK[i][r][j][r3][j3], (IVar[])new IVar.Var[]{eqK[i][r][j][r2][j2], eqK[i][r2][j2][r3][j3]}), NE, 2L);
                }
            }
        }).note("transitivity");
        this.forall(this.range(this.BC, this.n * this.BC).range(this.n * this.BC), (J, J2) -> {
            if (J < J2) {
                int r = J / this.BC;
                int j = J % this.BC;
                int r2 = J2 / this.BC;
                int j2 = J2 % this.BC;
                IVar.Var[] t1 = deltaSR[r - 1][j];
                IVar.Var[] t2 = deltaSR[r2 - 1][j2];
                this.extension(this.eq(new Object[]{eqSRX[J][J2], this.add(new Object[]{this.eq(new Object[]{this.add(new Object[]{t1[0], t2[0]}), 0}), this.eq(new Object[]{this.add(new Object[]{t1[1], t2[1]}), 0}), this.eq(new Object[]{this.add(new Object[]{t1[2], t2[2]}), 0}), this.eq(new Object[]{this.add(new Object[]{t1[3], t2[3]}), 0})})}));
            }
        });
        this.forall(this.range(this.BC, this.n * this.BC).range(this.n * this.BC), (J, J2) -> {
            if (J < J2) {
                int r = J / this.BC;
                int j = J % this.BC;
                int r2 = J2 / this.BC;
                int j2 = J2 % this.BC;
                ArrayList<XNodeParent> list = new ArrayList<XNodeParent>();
                for (int i = 0; i <= 3; ++i) {
                    list.add(this.ne(new Object[]{deltaSR[r - 1][j][i], deltaSR[r2 - 1][j2][i]}));
                    list.add(this.ne(new Object[]{deltaY[r - 1][j][i], deltaY[r2 - 1][j2][i]}));
                    list.add(this.eq(new Object[]{this.add(new Object[]{eqK[i][r][j][r2][j2], deltaX[r][j][i], deltaX[r2][j2][i]}), 0}));
                    list.add(this.and(new Object[]{this.eq(new Object[]{this.add(new Object[]{eqK[i][r][j][r2][j2], deltaK[r][j][i]}), 2}), this.ne(new Object[]{deltaX[r][j][i], deltaX[r2][j2][i]})}));
                }
                this.extensionDisjunction(list);
            }
        });
    }
}

