/*
 * Decompiled with CFR 0.152.
 */
package problems.test;

import constraints.hard.extension.structures.SmartTuple;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.modeler.api.ProblemAPI;
import utility.Kit;

public class TableBaudouinReader
implements ProblemAPI {
    int nVars;
    int[][] bounds;
    int[][] tuples;

    void data() {
        String fileName = this.imp().askString("Instance filename");
        try {
            if (fileName.endsWith(".lzma")) {
                Process p = Runtime.getRuntime().exec("lzma -d " + fileName);
                p.waitFor();
                p.exitValue();
                p.destroy();
                fileName = fileName.substring(0, fileName.indexOf(".lzma"));
                System.out.println("Test " + fileName);
            }
        }
        catch (Exception e) {
            Kit.exit("Pb when loading file", e);
        }
        try (Scanner scanner = new Scanner(new File(fileName));){
            this.nVars = scanner.nextInt();
            scanner.next();
            this.bounds = (int[][])IntStream.range(0, this.nVars).mapToObj(i -> {
                scanner.next();
                return Stream.of(scanner.next().split("\\.\\.")).mapToInt(tok -> Integer.parseInt(tok)).toArray();
            }).toArray(x$0 -> new int[x$0][]);
            int nTuples = scanner.nextInt();
            scanner.next();
            this.tuples = this.range(nTuples).range(this.nVars).map((i, j) -> scanner.nextInt());
        }
        catch (FileNotFoundException e) {
            Kit.exit("File " + fileName + " not found \n", e);
        }
    }

    private SmartTuple translate(IVar.Var[] x, String[] s) {
        ArrayList<XNodeParent<? extends IVar>> restrictions = new ArrayList<XNodeParent<? extends IVar>>();
        for (int i = 0; i < s.length; ++i) {
            String tok = s[i].trim();
            if (tok.equals("*")) continue;
            String[] t = tok.split("\\s+");
            Integer rop = t[1].startsWith("x") ? x[Integer.parseInt(t[1].substring(1))] : Integer.valueOf(Integer.parseInt(t[1]));
            Types.TypeExpr op = null;
            if (t[0].equals("<")) {
                op = Types.TypeExpr.LT;
            }
            if (t[0].equals("[")) {
                op = Types.TypeExpr.LE;
            }
            if (t[0].equals("]")) {
                op = Types.TypeExpr.GE;
            }
            if (t[0].equals(">")) {
                op = Types.TypeExpr.GT;
            }
            if (t[0].equals("#")) {
                op = Types.TypeExpr.NE;
            }
            if (t[0].equals("=")) {
                op = Types.TypeExpr.EQ;
            }
            restrictions.add((XNodeParent<? extends IVar>)XNodeParent.build((Types.TypeExpr)op, (Object[])new Object[]{x[i], rop}));
        }
        return new SmartTuple(restrictions);
    }

    public void model() {
        IVar.Var[] x = this.array("x", this.size(this.nVars), i -> this.dom(this.rangeClosed(this.bounds[i][0], this.bounds[i][1])), new Types.TypeClass[0]);
        if (this.modelVariant("tab")) {
            this.extension(x, this.tuples);
        }
    }
}

