/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.modeler.api.ProblemAPI;

public class SchedulingJS
implements ProblemAPI {
    Job[] jobs;

    public void model() {
        int n = this.jobs.length;
        int m = this.jobs[0].durations.length;
        int sumDurations = this.sumOf(this.valuesFrom(this.jobs, j -> this.sumOf(j.durations)));
        int maxTime = Stream.of(this.jobs).allMatch(j -> j.dueDate != -1) ? this.maxOf(this.valuesFrom(this.jobs, j -> j.dueDate)) : sumDurations;
        IVar.Var[][] s = this.array("s", this.size(n, m), this.dom(this.range(maxTime)), "s[i][j] is the start time of the jth operation for the ith job", new Types.TypeClass[0]);
        this.forall(this.range(n), i -> this.ordered(s[i], this.jobs[i].durations, INCREASING)).note("operations must be ordered on each job");
        this.forall(this.range(n), i -> {
            if (this.jobs[i].releaseDate > 0) {
                this.greaterEqual(s[i][0], this.jobs[i].releaseDate);
            }
            if (this.jobs[i].dueDate != -1 && this.jobs[i].dueDate < maxTime - 1) {
                this.lessEqual(s[i][m - 1], this.jobs[i].dueDate - this.jobs[i].durations[m - 1]);
            }
        }).note("respecting release and due dates");
        this.forall(this.range(m), j -> {
            IVar.Var[] origins = (IVar.Var[])this.variablesFrom(this.range(n), i -> s[i][Utilities.indexOf((int)j, (int[])this.jobs[i.intValue()].resources)]);
            int[] lengths = this.valuesFrom(this.jobs, job -> job.durations[Utilities.indexOf((int)j, (int[])job.resources)]);
            this.noOverlap(origins, lengths);
        }).note("no overlap on resources");
        this.minimize(MAXIMUM, this.treesFrom(this.range(n), i -> this.add(new Object[]{s[i][m - 1], this.jobs[i.intValue()].durations[m - 1]}))).note("minimizing the makespan");
    }

    class Job {
        int[] durations;
        int[] resources;
        int releaseDate;
        int dueDate;

        Job() {
        }
    }
}

