/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import constraints.Constraint;
import java.util.LinkedList;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;
import org.xcsp.modeler.entities.CtrEntities;

public class Rlfap
implements ProblemAPI {
    int[][] domains;
    RlfapVar[] vars;
    RlfapCtr[] ctrs;
    int[] interferenceCosts;
    int[] mobilityCosts;

    private CtrEntities.CtrEntity hardCtr(int i, IVar.Var[] f) {
        IVar.Var x = f[this.ctrs[i].x];
        IVar.Var y = f[this.ctrs[i].y];
        return this.ctrs[i].operator.equals("=") ? this.equal(new Object[]{this.dist(x, y), this.ctrs[i].limit}) : this.greaterThan(this.dist(x, y), this.ctrs[i].limit);
    }

    public void model() {
        int[] fixedVals;
        IVar.Var[] fixedVars;
        int n = this.vars.length;
        int e = this.ctrs.length;
        IVar.Var[] f = this.array("f", this.size(n), i -> this.dom(this.domains[this.vars[i].domain]), "f[i] is the frequency of the ith radio link", new Types.TypeClass[0]);
        if (this.modelVariant("feas")) {
            int sumOfSoftConstraintWeights = 1;
            LinkedList<Constraint> hardConstraints = new LinkedList<Constraint>();
            for (RlfapCtr c2 : this.ctrs) {
                IVar.Var x2 = f[c2.x];
                IVar.Var y = f[c2.y];
                Constraint constraint = (Constraint)((CtrEntities.CtrAlone)(c2.operator.equals((Object)"=") ? this.equal((Object[])new Object[]{this.dist((Object)x2, (Object)y), Integer.valueOf((int)c2.limit)}) : this.greaterThan((Object)this.dist((Object)x2, (Object)y), (Object)Integer.valueOf((int)c2.limit)))).ctr;
                constraint.cost = this.interferenceCosts[c2.weight];
                sumOfSoftConstraintWeights += this.interferenceCosts[c2.weight];
                if (c2.weight != 0) continue;
                hardConstraints.add(constraint);
            }
            for (Constraint c3 : hardConstraints) {
                c3.cost = sumOfSoftConstraintWeights;
            }
        }
        if (this.modelVariant("span") || this.modelVariant("card")) {
            int[] indexes = this.select(this.range(n), i -> this.vars[i].value != null);
            fixedVars = (IVar.Var[])this.variablesFrom(indexes, index -> f[index]);
            fixedVals = this.valuesFrom(indexes, index -> this.vars[index.intValue()].value);
            this.instantiation(fixedVars, fixedVals).note("managing pre-assigned frequencies");
            this.forall(this.range(e), i -> this.hardCtr(i, f)).note("hard constraints on radio-links");
            if (this.modelVariant("span")) {
                this.minimize(MAXIMUM, (IVar[])f).note("minimizing the largest frequency");
            }
            if (this.modelVariant("card")) {
                this.minimize(NVALUES, (IVar[])f).note("minimizing the number of used frequencies");
            }
        }
        if (this.modelVariant("max")) {
            int[] indexes = this.select(this.range(n), i -> this.vars[i].value != null && this.vars[i].mobility == 0);
            fixedVars = (IVar.Var[])this.variablesFrom(indexes, index -> f[index]);
            fixedVals = this.valuesFrom(indexes, index -> this.vars[index.intValue()].value);
            this.instantiation(fixedVars, fixedVals);
            this.forall(this.range(e), i -> {
                if (this.ctrs[i].weight == 0) {
                    this.hardCtr(i, f);
                }
            });
            IVar.Var[][] zbs = new IVar.Var[5][];
            for (int i2 = 1; i2 <= 4; ++i2) {
                int cost = this.mobilityCosts[i2];
                int nb = (int)Stream.of(this.vars).filter(x -> x.value != null && this.mobilityCosts[x.mobility] == cost).count();
                if (nb <= 0) continue;
                zbs[i2] = this.array("zb" + i2, this.size(nb), j -> this.dom(0, new int[]{cost}), new Types.TypeClass[0]);
                int cnt = 0;
                for (int j2 = 0; j2 < this.vars.length; ++j2) {
                    RlfapVar x3 = this.vars[j2];
                    if (x3.value == null || this.mobilityCosts[x3.mobility] != cost) continue;
                    IVar.Var w = f[j2];
                    IVar.Var z = zbs[i2][cnt++];
                    this.equal(new Object[]{this.ifThenElse(this.eq(new Object[]{w, x3.value}), 0, this.mobilityCosts[x3.mobility]), z});
                }
            }
            IVar.Var[][] zas = new IVar.Var[5][];
            for (int i3 = 1; i3 <= 4; ++i3) {
                int cost = this.interferenceCosts[i3];
                int nb = (int)Stream.of(this.ctrs).filter(c -> this.interferenceCosts[c.weight] == cost).count();
                if (nb <= 0) continue;
                zas[i3] = this.array("za" + i3, this.size(nb), j -> this.dom(0, new int[]{cost}), new Types.TypeClass[0]);
                int cnt = 0;
                for (RlfapCtr c4 : this.ctrs) {
                    if (this.interferenceCosts[c4.weight] != cost) continue;
                    IVar.Var x4 = f[c4.x];
                    IVar.Var y = f[c4.y];
                    IVar.Var z = zas[i3][cnt++];
                    if (c4.operator.equals("=")) {
                        this.equal(new Object[]{this.ifThenElse(this.eq(new Object[]{this.dist(x4, y), c4.limit}), 0, this.interferenceCosts[c4.weight]), z});
                        continue;
                    }
                    this.equal(new Object[]{this.ifThenElse(this.gt(this.dist(x4, y), c4.limit), 0, this.interferenceCosts[c4.weight]), z});
                }
            }
            this.minimize(SUM, this.vars(zbs, (IVar[][])zas));
        }
    }

    class RlfapCtr {
        int x;
        int y;
        String operator;
        int limit;
        int weight;

        RlfapCtr() {
        }
    }

    class RlfapVar {
        int domain;
        Integer value;
        Integer mobility;

        RlfapVar() {
        }
    }
}

