/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;

public class PizzaVoucher
implements ProblemAPI {
    int[] pizzaPrices;
    Voucher[] vouchers;

    public void model() {
        int nPizzas = this.pizzaPrices.length;
        int nVouchers = this.vouchers.length;
        IVar.Var[] v = this.array("v", this.size(nPizzas), this.dom(this.rangeClosed(-nVouchers, nVouchers)), "v[i] is the voucher used for the ith pizza. 0 means that no voucher is used. A negative (resp., positive) value i means that the ith pizza contributes to the the pay (resp., free) part of voucher |i|.", new Types.TypeClass[0]);
        IVar.Var[] p = this.array("p", this.size(nVouchers), i -> this.dom(0, new int[]{this.vouchers[i].payPart}), "p[i] is the number of paid pizzas wrt the ith voucher", new Types.TypeClass[0]);
        IVar.Var[] f = this.array("f", this.size(nVouchers), i -> this.dom(this.range(this.vouchers[i].freePart + 1)), "f[i] is the number of free pizzas wrt the ith voucher", new Types.TypeClass[0]);
        this.forall(this.range(nVouchers), i -> this.count(v, this.takingValue(-i - 1), EQ, p[i])).note("counting paid pizzas");
        this.forall(this.range(nVouchers), i -> this.count(v, this.takingValue(i + 1), EQ, f[i])).note("counting free pizzas");
        this.forall(this.range(nVouchers), i -> this.equivalence(new Object[]{this.eq(new Object[]{f[i], 0}), this.ne(new Object[]{p[i], this.vouchers[i].payPart})})).note("a voucher, if used, must contribute to have at least one free pizza.");
        this.forall(this.range(nPizzas).range(nPizzas), (i, j) -> {
            if (i != j && this.pizzaPrices[i] < this.pizzaPrices[j]) {
                this.disjunction(new Object[]{this.ge(v[i], v[j]), this.ne(new Object[]{v[i], this.neg(v[j])})});
            }
        }).note("a free pizza obtained with a voucher must be cheaper than any pizza paid wrt this voucher");
        this.minimize(SUM, this.treesFrom(this.range(nPizzas), i -> this.le(v[i], 0)), this.pizzaPrices).note("minimizing summed up costs of pizzas");
        this.decisionVariables((IVar[])v);
    }

    class Voucher {
        int payPart;
        int freePart;

        Voucher() {
        }
    }
}

