/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import constraints.hard.extension.CtrExtensionSegmented;
import constraints.hard.extension.structures.SegmentedTuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;
import org.xcsp.modeler.implementation.NotData;
import problem.Problem;
import problems.g4_world.CrosswordDesignSeg2;
import variables.Variable;

public class CrosswordDesignSeg1
implements ProblemAPI {
    private static final int N_LETTERS = 26;
    int n;
    int nMaxWords;
    int wordSizeLimit;
    String mainDict;
    String thematicDict;
    @NotData
    String[] words;
    @NotData
    int[] wordsPoints;
    @NotData
    int[][][] wordsWithPoints;
    @NotData
    int[] oneLetterPositions;

    private static Stream<String> oneLetterWords() {
        return IntStream.range(0, 26).mapToObj(i -> (char)(i + 97) + "");
    }

    private static Stream<String> twoLetterWords() {
        return IntStream.range(0, 26).mapToObj(i -> IntStream.range(0, 26).mapToObj(j -> (char)(i + 97) + "" + (char)(j + 97))).flatMap(s -> s);
    }

    SegmentedTuple buildSpliTuple(List<CrosswordDesignSeg2.WordPattern> wordPatterns, IVar.Var[] a, IVar.Var[] b) {
        int[] prefix = IntStream.range(0, this.n + this.nMaxWords).map(i -> 0x7FFFFFFE).toArray();
        for (CrosswordDesignSeg2.WordPattern wp : wordPatterns) {
            int i2 = wp.start - 1;
            if (i2 >= 0) {
                prefix[i2] = 26;
            }
            if ((i2 = wp.start + wp.length) >= this.n) continue;
            prefix[i2] = 26;
        }
        int nIrrelevantBenefits = b.length - wordPatterns.size();
        for (int i3 = 0; i3 < nIrrelevantBenefits; ++i3) {
            prefix[this.n + this.nMaxWords - 1 - i3] = 0;
        }
        ArrayList<SegmentedTuple.RestrictionTable> list = new ArrayList<SegmentedTuple.RestrictionTable>();
        for (int k = 0; k < wordPatterns.size(); ++k) {
            int kk = k;
            CrosswordDesignSeg2.WordPattern wp = wordPatterns.get(k);
            Variable[] subscp = (Variable[])IntStream.rangeClosed(0, wp.length).mapToObj(i -> i < wp.length ? a[wp.start + i] : b[kk]).toArray(Variable[]::new);
            int[][] subtable = this.wordsWithPoints[wp.length];
            list.add(new SegmentedTuple.RestrictionTable(subscp, subtable));
        }
        return new SegmentedTuple(prefix, list.toArray(new SegmentedTuple.RestrictionTable[0]));
    }

    void buildSpliTuples(List<CrosswordDesignSeg2.WordPattern> wordPatterns, List<SegmentedTuple> splitTuples, IVar.Var[] a, IVar.Var[] b) {
        block4: {
            int i;
            block5: {
                block3: {
                    if (wordPatterns.size() != 0) break block3;
                    for (int i2 = 0; i2 <= 1; ++i2) {
                        for (int l = 1; l <= this.n - i2; ++l) {
                            List<CrosswordDesignSeg2.WordPattern> wordPatternsCloned = wordPatterns.stream().collect(Collectors.toList());
                            wordPatternsCloned.add(new CrosswordDesignSeg2.WordPattern(i2, l));
                            this.buildSpliTuples(wordPatternsCloned, splitTuples, a, b);
                        }
                    }
                    break block4;
                }
                CrosswordDesignSeg2.WordPattern last = wordPatterns.get(wordPatterns.size() - 1);
                i = last.nextStart();
                if (i != this.n && i != this.n + 1) break block5;
                if (wordPatterns.size() > this.nMaxWords) break block4;
                splitTuples.add(this.buildSpliTuple(wordPatterns, a, b));
                break block4;
            }
            for (int l = 1; l <= this.n - i; ++l) {
                List<CrosswordDesignSeg2.WordPattern> wordPatternsCloned = wordPatterns.stream().collect(Collectors.toList());
                wordPatternsCloned.add(new CrosswordDesignSeg2.WordPattern(i, l));
                this.buildSpliTuples(wordPatternsCloned, splitTuples, a, b);
            }
        }
    }

    private void loadWords() {
        this.words = (String[])Stream.concat(Stream.concat(CrosswordDesignSeg1.oneLetterWords(), CrosswordDesignSeg1.twoLetterWords()), Stream.concat(this.readFileLines(this.mainDict), this.readFileLines(this.thematicDict))).filter(w -> w.length() <= (this.wordSizeLimit == -1 ? this.n : this.wordSizeLimit)).distinct().sorted().toArray(String[]::new);
        this.wordsPoints = new int[this.words.length];
        List<String> list = Arrays.asList(this.words);
        this.readFileLines(this.thematicDict).forEach(w -> {
            int pos = list.indexOf(w);
            if (pos != -1) {
                this.wordsPoints[pos] = w.length();
            }
        });
        this.oneLetterPositions = CrosswordDesignSeg1.oneLetterWords().mapToInt(w -> list.indexOf(w)).toArray();
        this.wordsWithPoints = (int[][][])IntStream.range(0, this.n + 1).mapToObj(l -> (int[][])IntStream.range(0, this.words.length).filter(i -> this.words[i].length() == l).mapToObj(i -> IntStream.range(0, l + 1).map(j -> j < l ? this.words[i].charAt(j) - 97 : this.wordsPoints[i]).toArray()).toArray(x$0 -> new int[x$0][])).toArray(x$0 -> new int[x$0][][]);
    }

    public void model() {
        this.loadWords();
        this.nMaxWords = this.nMaxWords == -1 ? (this.n + 1) / 2 : this.nMaxWords;
        IVar.Var[][] x = this.array("x", this.size(this.n, this.n), this.dom(this.range(27)), "x[i][j] is the (number of) letter at row i and col j; 26 stands for a black point", new Types.TypeClass[0]);
        IVar.Var[][] br = this.array("br", this.size(this.n, this.nMaxWords), this.dom(this.range(this.n + 1)), "br[i][k] is the benefit of the k+1th word at row i; 0 means that the word is either absent or from the full dictionary", new Types.TypeClass[0]);
        IVar.Var[][] bc = this.array("bc", this.size(this.n, this.nMaxWords), this.dom(this.range(this.n + 1)), "bc[j][k] is the benfit of the k+1th word at col j; 0 means that the word is either absent or from the full dictionary", new Types.TypeClass[0]);
        ArrayList splitTuples = new ArrayList();
        this.forall(this.range(this.n), i -> {
            splitTuples.clear();
            this.buildSpliTuples(new ArrayList<CrosswordDesignSeg2.WordPattern>(), splitTuples, x[i], br[i]);
            ((Problem)this.imp()).addCtr(new CtrExtensionSegmented((Problem)this.imp(), (Variable[])this.vars(x[i], (IVar[])br[i]), splitTuples.toArray(new SegmentedTuple[0])), new Types.TypeClass[0]);
        });
        this.forall(this.range(this.n), j -> {
            splitTuples.clear();
            this.buildSpliTuples(new ArrayList<CrosswordDesignSeg2.WordPattern>(), splitTuples, (IVar.Var[])this.columnOf(x, j), bc[j]);
            ((Problem)this.imp()).addCtr(new CtrExtensionSegmented((Problem)this.imp(), (Variable[])this.vars(this.columnOf(x, j), (IVar[])bc[j]), splitTuples.toArray(new SegmentedTuple[0])), new Types.TypeClass[0]);
        });
        this.maximize(SUM, this.vars(br, (IVar[][])bc));
    }

    public void prettyDisplay(String[] values) {
        IntStream.range(0, this.n).forEach(i -> System.out.println(IntStream.range(0, this.n).mapToObj(j -> {
            int s = Integer.parseInt(values[i * this.n + j]);
            return s == 26 ? "*" : "" + (char)(97 + s);
        }).collect(Collectors.joining(""))));
    }
}

