/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.structures.Table;
import org.xcsp.modeler.api.ProblemAPI;
import utility.Kit;

public class Crossword
implements ProblemAPI {
    int[][] spots;
    String dictFileName;

    private Map<Integer, List<int[]>> loadWords() {
        HashMap<Integer, List<int[]>> words = new HashMap<Integer, List<int[]>>();
        this.readFileLines(this.dictFileName).forEach(w -> words.computeIfAbsent(w.length(), k -> new ArrayList()).add(Utilities.wordAsIntArray((String)w)));
        return words;
    }

    private List<Hole> findHoles(int[][] t, boolean untransposed) {
        int nRows = t.length;
        int nCols = t[0].length;
        ArrayList<Hole> list = new ArrayList<Hole>();
        for (int i = 0; i < nRows; ++i) {
            int start = -1;
            for (int j = 0; j < nCols; ++j) {
                if (t[i][j] == 1) {
                    if (start != -1 && j - start >= 2) {
                        list.add(new Hole(i, start, j - start, untransposed));
                    }
                    start = -1;
                    continue;
                }
                if (start == -1) {
                    start = j;
                    continue;
                }
                if (j != nCols - 1 || nCols - start < 2) continue;
                list.add(new Hole(i, start, nCols - start, untransposed));
            }
        }
        return list;
    }

    private Hole[] findHoles() {
        List<Hole> list = this.findHoles(this.spots, true);
        list.addAll(this.findHoles(this.transpose(this.spots), false));
        return list.toArray(new Hole[0]);
    }

    private Table compatibleWords(Map<Integer, List<int[]>> words, Hole hole1, Hole hole2) {
        int[] offset = hole1.offsetWith(hole2);
        List<int[]> words1 = words.get(hole1.size);
        List<int[]> words2 = words.get(hole2.size);
        return this.table().addFrom(this.range(words1.size()).range(words2.size()), (i1, i2) -> ((int[])words1.get((int)i1))[offset[0]] == ((int[])words2.get((int)i2))[offset[1]] ? this.tuple((int)i1, new int[]{i2}) : null);
    }

    public void model() {
        Map<Integer, List<int[]>> words = this.loadWords();
        Hole[] holes = this.findHoles();
        System.out.println("Holes=" + Kit.join((Object)holes, new String[0]));
        int nRows = this.spots.length;
        int nCols = this.spots[0].length;
        int nHoles = holes.length;
        if (this.modelVariant("")) {
            IVar.Var[][] x = this.array("x", this.size(nRows, nCols), (i, j) -> this.dom(this.range(26)).when(this.spots[i][j] == 0), "x[i][j] is the letter, number from 0 to 25, at row i and column j (when no spot)", new Types.TypeClass[0]);
            int[] arities = Stream.of(holes).mapToInt(h -> h.size).sorted().distinct().toArray();
            System.out.println("ARITIES " + Kit.join((Object)arities, new String[0]));
            IVar.Var[][] scopes = (IVar.Var[][])Stream.of(holes).map(h -> h.scope(x)).toArray(x$0 -> new IVar.Var[x$0][]);
            this.forall(this.range(nHoles), i -> this.extension(scopes[i], (Collection)words.get(scopes[i].length))).note("fill the grid with words");
            this.forall(this.range(arities.length), i -> this.allDifferentList((IVar.Var[][])Stream.of(scopes).filter(s -> ((IVar.Var[])s).length == arities[i]).toArray(x$0 -> new IVar.Var[x$0][]))).tag(new String[]{"distinct-words"});
        }
        if (this.modelVariant("alt")) {
            IVar.Var[] w = this.array("w", this.size(nHoles), i -> this.dom(this.range(((List)words.get(holes[i].size)).size())), "w[i] is the ith word to be put in the grid", new Types.TypeClass[0]);
            this.forall(this.range(nHoles).range(nHoles), (i, j) -> {
                if (i < j && holes[i].offsetWith(holes[j]) != null) {
                    this.extension((IVar.Var[])this.vars(w[i], (IVar)w[j]), this.compatibleWords(words, holes[i], holes[j]));
                }
            }).note("words must intersect correctly");
            this.forall(this.range(nHoles).range(nHoles), (i, j) -> {
                if (i < j && holes[i].size == holes[j].size) {
                    this.different(new Object[]{w[i], w[j]});
                }
            }).tag(new String[]{"distinct-words"});
        }
    }

    class Hole {
        int row;
        int col;
        int size;
        boolean horizontal;

        Hole(int row, int col, int size, boolean horizontal) {
            this.row = horizontal ? row : col;
            this.col = horizontal ? col : row;
            this.size = size;
            this.horizontal = horizontal;
        }

        IVar.Var[] scope(IVar.Var[][] x) {
            return (IVar.Var[])Crossword.this.variablesFrom(Crossword.this.range(this.size), i -> this.horizontal ? x[this.row][this.col + i] : x[this.row + i][this.col]);
        }

        int[] offsetWith(Hole other) {
            if (this.horizontal == other.horizontal) {
                return null;
            }
            int[] offset = new int[2];
            if (this.horizontal) {
                offset[0] = other.col - this.col;
                if (offset[0] < 0 || offset[0] > this.size - 1) {
                    return null;
                }
                offset[1] = this.row - other.row;
                if (offset[1] < 0 || offset[1] > other.size - 1) {
                    return null;
                }
            } else {
                offset[0] = this.col - other.col;
                if (offset[0] < 0 || offset[0] > other.size - 1) {
                    return null;
                }
                offset[1] = other.row - this.row;
                if (offset[1] < 0 || offset[1] > this.size - 1) {
                    return null;
                }
            }
            return offset;
        }

        public String toString() {
            return "(" + this.row + " " + this.col + " " + this.size + " " + this.horizontal + ")";
        }
    }
}

