/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.predicates.XNode;
import org.xcsp.modeler.api.ProblemAPI;

public class Bacp
implements ProblemAPI {
    int nPeriods;
    int minCredits;
    int maxCredits;
    int minCourses;
    int maxCourses;
    int[] credits;
    int[][] prerequisites;

    private int[][] channelingTable(int c) {
        int[][] tuples = new int[this.nPeriods][this.nPeriods + 1];
        for (int p = 0; p < this.nPeriods; ++p) {
            tuples[p][p] = this.credits[c];
            tuples[p][this.nPeriods] = p;
        }
        return tuples;
    }

    public void model() {
        int nCourses = this.credits.length;
        int nPrerequisites = this.prerequisites.length;
        int ubCredits = this.modelVariant().endsWith("d") ? this.maxCredits * this.maxCourses : this.maxCredits;
        IVar.Var[] s = this.array("s", this.size(nCourses), this.dom(this.range(this.nPeriods)), "s[c] is the period (schedule) for course c", new Types.TypeClass[0]);
        IVar.Var[] co = this.array("co", this.size(this.nPeriods), this.dom(this.range(this.minCourses, this.maxCourses + 1)), "co[p] is the number of courses at period p", new Types.TypeClass[0]);
        IVar.Var[] cr = this.array("cr", this.size(this.nPeriods), this.dom(this.range(this.minCredits, ubCredits + 1)), "cr[p] is the number of credits at period p", new Types.TypeClass[0]);
        if (this.modelVariant().startsWith("m1")) {
            IVar.Var[][] cp = this.array("cp", this.size(nCourses, this.nPeriods), (c, p) -> this.dom(0, new int[]{this.credits[c]}), "cp[c][p] is 0 if the course c is not planned at period p, the number of credits for c otherwise", new Types.TypeClass[0]);
            this.forall(this.range(nCourses), c -> this.extension((IVar.Var[])this.vars(cp[c], (IVar)s[c]), this.channelingTable(c))).note("channeling between arrays cp and s");
            this.forall(this.range(this.nPeriods), p -> this.count(s, this.takingValue(p), EQ, co[p])).note("counting the number of courses in each period");
            this.forall(this.range(this.nPeriods), p -> this.sum((IVar.Var[])this.columnOf(cp, p), EQ, cr[p])).note("counting the number of credits in each period");
        }
        if (this.modelVariant().startsWith("m2")) {
            IVar.Var[][] pc = this.array("pc", this.size(this.nPeriods, nCourses), this.dom(0, new int[]{1}), "pc[p][c] is 1 iff the course c is at period p", new Types.TypeClass[0]);
            this.forall(this.range(this.nPeriods).range(nCourses), (p, c) -> this.equivalence(new Object[]{pc[p][c], this.eq(new Object[]{s[c], p})})).tag(new Types.TypeClass[]{CHANNELING});
            this.forall(this.range(nCourses), c -> this.sum((IVar.Var[])this.columnOf(pc, c), EQ, 1L)).note("ensuring that each course is assigned to a period");
            this.forall(this.range(this.nPeriods), p -> this.sum(pc[p], EQ, co[p])).note("counting the number of courses in each period");
            this.forall(this.range(this.nPeriods), p -> this.sum(pc[p], this.credits, EQ, cr[p])).note("counting the number of credits in each period");
        }
        this.forall(this.range(nPrerequisites), i -> this.lessThan(s[this.prerequisites[i][0]], s[this.prerequisites[i][1]])).note("handling prerequisites");
        if (this.modelVariant().endsWith("d")) {
            IVar.Var mincr = this.var("mincr", this.dom(this.rangeClosed(this.minCredits, ubCredits)), "mincr is the minimum number of credits over the periods", new Types.TypeClass[0]);
            IVar.Var maxcr = this.var("maxcr", this.dom(this.rangeClosed(this.minCredits, ubCredits)), "maxcr is the maximum number of credits over the periods", new Types.TypeClass[0]);
            this.minimum(cr, mincr);
            this.maximum(cr, maxcr);
            this.minimize((XNode)this.sub(maxcr, mincr)).note("minimizing the maximal distance in term of credits");
        } else {
            this.minimize(MAXIMUM, (IVar[])cr).note("minimizing the maximum number of credits in periods");
        }
        this.decisionVariables((IVar[])s);
    }
}

