/*
 * Decompiled with CFR 0.152.
 */
package problems.g4_world;

import cyperlib.graph.Bloc;
import cyperlib.graph.molecular.UMolGraphISIS;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.structures.Table;
import org.xcsp.modeler.api.ProblemAPI;
import org.xcsp.modeler.implementation.NotData;

public class Aromaticity
implements ProblemAPI {
    int multiple;
    String molFileName;
    boolean mergeConstraints;
    @NotData
    UMolGraphISIS graph;

    private Table edgesForLabel(int label) {
        Table table = this.table();
        for (int[] edge : this.graph.getEdgeEndsArray()) {
            if (this.graph.getEdgeLabel(edge[0], edge[1]) != label) continue;
            table.add(edge[0], new int[]{edge[1]});
            table.add(edge[1], new int[]{edge[0]});
        }
        return table;
    }

    private Table twoCCs(List<Integer> sourceVertices) {
        Table table = this.table();
        for (int source = 0; source < this.graph.getVertexNumber(); ++source) {
            Bloc bloc = this.graph.get2connectedComponent_greaterThan(source);
            if (bloc.edges.size() < 2 + this.multiple) continue;
            sourceVertices.add(source);
            int s = source;
            bloc.tops.stream().filter(i -> s < i).forEach(i -> table.add((int[][])new int[][]{this.tuple(s, new int[]{i})}));
        }
        return table;
    }

    private Table ternaryTuplesFrom(int nNodes, int[][] type2Edges) {
        int nTuples = type2Edges.length;
        return this.table(IntStream.range(0, nTuples + nNodes).mapToObj(i -> i < nTuples ? this.tuple(type2Edges[i][0], new int[]{type2Edges[i][1], nNodes}) : this.tuple(0x7FFFFFFE, new int[]{0x7FFFFFFE, i - nTuples})));
    }

    public void model() {
        IVar.Var[] t;
        try {
            this.graph = new UMolGraphISIS(new File(this.molFileName));
        }
        catch (IOException e) {
            System.out.println("Pb when loading the mol filename");
            System.exit(1);
        }
        int type1 = 1;
        int nNodes = this.graph.getVertexNumber();
        Utilities.control((nNodes >= 2 + this.multiple ? 1 : 0) != 0, (String)"");
        int maxCycleLength = nNodes - (nNodes - (2 + this.multiple)) % this.multiple;
        Table type1Edges = this.edgesForLabel(type1);
        Table type2Edges = this.edgesForLabel(type1 == 1 ? 2 : 1);
        Table type1EdgesAnd_2n = this.table(type1Edges).add(nNodes, new int[]{nNodes});
        Table type2EdgesAnd_2n = this.table(type2Edges).add(nNodes, new int[]{nNodes});
        Table type2EdgesAnd_star_n = this.table(type2Edges).add(0x7FFFFFFE, new int[]{nNodes});
        Table type2EdgesOr2StarNextDiff_n = this.ternaryTuplesFrom(nNodes, type2Edges.toArray());
        Table type2EdgesOr2StarNextDiff_n_with_n2 = this.table(type2EdgesOr2StarNextDiff_n).add(0x7FFFFFFE, new int[]{nNodes, nNodes});
        ArrayList<Integer> sources = new ArrayList<Integer>();
        Table le2CCpairs = this.twoCCs(sources);
        Table le2CCpairsAndn = this.table(le2CCpairs).addFrom(this.range(sources.size()), i -> this.tuple((Integer)sources.get((int)i), new int[]{nNodes}));
        IVar.Var[] h = this.array("h", this.size(2 + this.multiple), this.dom(this.range(nNodes)), "head: first 4 or 6 vertices of the cycle", new Types.TypeClass[0]);
        IVar.Var[] varArray = t = maxCycleLength > 2 + this.multiple ? this.array("t", this.size(maxCycleLength - (2 + this.multiple)), this.dom(this.range(nNodes + 1)), "tail", new Types.TypeClass[0]) : new IVar.Var[]{};
        if (maxCycleLength > 2 + this.multiple) {
            this.allDifferent((IVar.Var[])this.vars(h, (IVar[])t), new int[]{this.exceptValue(nNodes)});
        } else {
            this.allDifferent((IVar.Var[])this.vars(h, (IVar[])t));
        }
        this.forall(this.range(1, h.length), i -> this.extension((IVar.Var[])this.vars(h[0], (IVar)h[i]), le2CCpairs)).note("breaking a form of symmetry");
        this.forall(this.range(h.length - 1), i -> this.extension((IVar.Var[])this.vars(h[i], (IVar)h[i + 1]), i % 2 == 0 ? type1Edges : type2Edges)).note("ctrs on head vars");
        if (!this.mergeConstraints) {
            if (maxCycleLength > h.length) {
                this.extension((IVar.Var[])this.vars((IVar)h[0], (IVar[])new IVar.Var[]{h[h.length - 1], t[0]}), type2EdgesOr2StarNextDiff_n);
                this.extension((IVar.Var[])this.vars(h[h.length - 1], (IVar)t[0]), type2EdgesAnd_star_n);
            } else {
                this.extension((IVar.Var[])this.vars(h[0], (IVar)h[h.length - 1]), type2Edges);
            }
            this.forall(this.range(t.length), i -> this.extension((IVar.Var[])this.vars(h[0], (IVar)t[i]), le2CCpairsAndn));
            if (this.multiple == 4) {
                this.forall(this.range(t.length - 1), i -> {
                    if (i % this.multiple == 0 || i % this.multiple == 2) {
                        this.extension((IVar.Var[])this.vars(t[i], (IVar)t[i + 1]), type1EdgesAnd_2n);
                    }
                });
                this.forall(this.range(t.length - 1), i -> {
                    if (i % this.multiple == 1) {
                        this.extension((IVar.Var[])this.vars(t[i], (IVar)t[i + 1]), type2EdgesAnd_2n);
                    }
                });
                this.forall(this.range(t.length - 1), i -> {
                    if (i % this.multiple == 3) {
                        this.extension((IVar.Var[])this.vars((IVar)h[0], (IVar[])new IVar.Var[]{t[i], t[i + 1]}), type2EdgesOr2StarNextDiff_n_with_n2);
                    }
                });
                this.forall(this.range(t.length - 1), i -> {
                    if (i % this.multiple == 3) {
                        this.extension((IVar.Var[])this.vars(t[i], (IVar)t[i + 1]), type2EdgesAnd_star_n);
                    }
                });
                if ((t.length - 1) % this.multiple == 3) {
                    this.extension((IVar.Var[])this.vars(h[0], (IVar)t[t.length - 1]), type2EdgesAnd_star_n);
                }
            } else {
                this.forall(this.range(t.length), i -> {
                    if (i % this.multiple == 0) {
                        this.extension((IVar.Var[])this.vars(t[i], (IVar)t[i + 1]), type1EdgesAnd_2n);
                    }
                });
                this.forall(this.range(t.length - 1), i -> {
                    if (i % this.multiple == 1) {
                        this.extension((IVar.Var[])this.vars((IVar)h[0], (IVar[])new IVar.Var[]{t[i], t[i + 1]}), type2EdgesOr2StarNextDiff_n_with_n2);
                    }
                });
                this.forall(this.range(t.length - 1), i -> {
                    if (i % this.multiple == 1) {
                        this.extension((IVar.Var[])this.vars(t[i], (IVar)t[i + 1]), type2EdgesAnd_star_n);
                    }
                });
                if ((t.length - 1) % this.multiple == 1) {
                    this.extension((IVar.Var[])this.vars(h[0], (IVar)t[t.length - 1]), type2EdgesAnd_star_n);
                }
            }
        } else {
            Table m1 = this.tableIntersection(type2EdgesOr2StarNextDiff_n, this.tableWithNewColumn(type2EdgesAnd_star_n, 0, 0x7FFFFFFE));
            Table m2 = this.tableIntersection(type2EdgesOr2StarNextDiff_n_with_n2, this.tableWithNewColumn(type2EdgesAnd_star_n, 0, 0x7FFFFFFE));
            Table m3 = this.tableIntersection(le2CCpairsAndn, type2EdgesAnd_star_n);
            if (maxCycleLength > h.length) {
                this.extension((IVar.Var[])this.vars((IVar)h[0], (IVar[])new IVar.Var[]{h[h.length - 1], t[0]}), m1);
            } else {
                this.extension((IVar.Var[])this.vars(h[0], (IVar)h[h.length - 1]), type2Edges);
            }
            this.forall(this.range(t.length), i -> {
                int mod = i % this.multiple;
                if (mod == 0 || mod == 2) {
                    this.extension((IVar.Var[])this.vars(h[0], (IVar)t[i]), le2CCpairsAndn);
                    this.extension((IVar.Var[])this.vars(t[i], (IVar)t[i + 1]), type1EdgesAnd_2n);
                } else if (mod == this.multiple - 3) {
                    this.extension((IVar.Var[])this.vars(h[0], (IVar)t[i]), le2CCpairsAndn);
                    this.extension((IVar.Var[])this.vars(t[i], (IVar)t[i + 1]), type2EdgesAnd_2n);
                } else if (mod == this.multiple - 1) {
                    if (i + 1 < t.length) {
                        this.extension((IVar.Var[])this.vars(h[0], (IVar)t[i]), le2CCpairsAndn);
                        this.extension((IVar.Var[])this.vars((IVar)h[0], (IVar[])new IVar.Var[]{t[i], t[i + 1]}), m2);
                    } else {
                        this.extension((IVar.Var[])this.vars(h[0], (IVar)t[i]), m3);
                    }
                } else {
                    Utilities.control((boolean)false, (String)"pb multiple cycle");
                }
            }).note("Constraints on tail variables");
        }
    }
}

