/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.structures.Table;
import org.xcsp.modeler.api.ProblemAPI;

public class Subisomorphism
implements ProblemAPI {
    int nPatternNodes;
    int nTargetNodes;
    int[][] patternEdges;
    int[][] targetEdges;

    private int[] selfLoops(int[][] edges) {
        return Stream.of(edges).filter(t -> t[0] == t[1]).mapToInt(t -> t[0]).toArray();
    }

    private int degree(int[][] edges, int node) {
        return (int)Stream.of(edges).filter(t -> t[0] == node || t[1] == node).count();
    }

    private Table bothWayTable() {
        Table table = this.table();
        table.add(this.targetEdges);
        table.add(Stream.of(this.targetEdges).map(t -> this.tuple(t[1], new int[]{t[0]})));
        return table;
    }

    public void model() {
        int[] pLoops = this.selfLoops(this.patternEdges);
        int[] tLoops = this.selfLoops(this.targetEdges);
        int[] pDegrees = this.range(this.nPatternNodes).map(i -> this.degree(this.patternEdges, i));
        int[] tDegrees = this.range(this.nTargetNodes).map(i -> this.degree(this.targetEdges, i));
        IVar.Var[] x = this.array("x", this.size(this.nPatternNodes), this.dom(this.range(this.nTargetNodes)), "x[i] is the target node to which the ith pattern node is mapped", new Types.TypeClass[0]);
        this.allDifferent(x).note("ensuring injectivity");
        Table bothWayTable = this.bothWayTable();
        this.forall(this.range(this.patternEdges.length), i -> this.extension((IVar.Var[])this.vars(x[this.patternEdges[i][0]], (IVar)x[this.patternEdges[i][1]]), bothWayTable)).note("preserving edges");
        this.forall(this.range(pLoops.length), i -> this.extension(x[pLoops[i]], tLoops)).note("being careful of self-loops");
        this.forall(this.range(this.nPatternNodes), i -> {
            int[] conflicts = this.range(this.nTargetNodes).select(j -> tDegrees[j] < pDegrees[i]);
            if (conflicts.length > 0) {
                this.extension(x[i], conflicts, NEGATIVE);
            }
        }).tag(new Types.TypeClass[]{REDUNDANT_CONSTRAINTS});
    }
}

