/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import constraints.Constraint;
import constraints.hard.extension.CtrExtensionSmart;
import constraints.hard.extension.structures.SmartTuple;
import java.util.ArrayList;
import java.util.stream.IntStream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.modeler.api.ProblemAPI;
import org.xcsp.modeler.implementation.NotData;
import problem.Problem;
import utility.Kit;
import variables.Variable;

public class RoomMate
implements ProblemAPI {
    int[][] preferences;
    @NotData
    int[][] rank;
    @NotData
    int[][] pref;

    private Constraint smart1(IVar.Var[] x, int i) {
        SmartTuple[] smartTuples = (SmartTuple[])IntStream.range(0, this.preferences[i].length).mapToObj(k -> {
            ArrayList<XNodeParent<? extends IVar>> list = new ArrayList<XNodeParent<? extends IVar>>();
            list.add(this.le(x[i], k));
            for (int l = 0; l < k; ++l) {
                int j = this.pref[i][l];
                list.add((XNodeParent<? extends IVar>)this.lt(x[j], this.rank[j][i]));
            }
            return new SmartTuple(list);
        }).toArray(SmartTuple[]::new);
        return new CtrExtensionSmart((Problem)this.imp(), (Variable[])x, smartTuples);
    }

    private int[][] table(int i) {
        int[][] table = new int[this.preferences[i].length][];
        for (int k = 0; k < table.length; ++k) {
            table[k] = Kit.repeat(0x7FFFFFFE, this.preferences.length);
            int j = this.pref[i][k];
            table[k][i] = this.rank[i][j];
            table[k][j] = this.rank[j][i];
        }
        return table;
    }

    private void buildAuxiliaryDataStructures(int n) {
        this.pref = new int[n][n];
        this.rank = new int[n][n];
        for (int i = 0; i < n; ++i) {
            for (int k = 0; k < this.preferences[i].length; ++k) {
                int j = this.preferences[i][k] - 1;
                this.rank[i][j] = k;
                this.pref[i][k] = j;
            }
            this.rank[i][i] = this.preferences[i].length;
            this.pref[i][this.preferences[i].length] = i;
        }
    }

    public void model() {
        int n = this.preferences.length;
        this.buildAuxiliaryDataStructures(n);
        IVar.Var[] x = this.array("x", this.size(n), i -> this.dom(this.range(this.preferences[i].length)), "x[i] is the value of k, meaning that j = pref[i][k] is the paired agent", new Types.TypeClass[0]);
        if (this.modelVariant("")) {
            this.forall(this.range(n).range(n), (i, k) -> {
                if (k < this.preferences[i].length) {
                    this.implication(this.gt(x[i], this.rank[i][this.pref[i][k]]), this.lt(x[this.pref[i][k]], this.rank[this.pref[i][k]][i]));
                }
            });
            this.forall(this.range(n).range(n), (i, k) -> {
                if (k < this.preferences[i].length) {
                    this.implication(this.eq(new Object[]{x[i], this.rank[i][this.pref[i][k]]}), this.eq(new Object[]{x[this.pref[i][k]], this.rank[this.pref[i][k]][i]}));
                }
            });
        }
        if (this.modelVariant("smart")) {
            this.forall(this.range(n), i -> ((Problem)this.imp()).addCtr(this.smart1(x, i), new Types.TypeClass[0]));
            this.forall(this.range(n), i -> this.extension(x, this.table(i)));
        }
    }
}

