/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import java.util.stream.IntStream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.structures.Table;
import org.xcsp.modeler.api.ProblemAPI;

public class OpenStacks
implements ProblemAPI {
    int[][] orders;

    private Table shortTableFor(int max) {
        return this.table(0, new int[]{0, 0}).add(IntStream.range(1, max).mapToObj(i -> this.tuple(i, new int[]{0x7FFFFFFE, 1}))).add(max, new int[]{0, 0}).add(max, new int[]{1, 1});
    }

    private Table shortTable2For(int t) {
        Table table = this.table().add(IntStream.range(0, t).mapToObj(i -> this.tuple(0x7FFFFFFE, new int[]{i, 0}))).add(IntStream.range(t + 1, this.orders[0].length).mapToObj(i -> this.tuple(i, new int[]{0x7FFFFFFE, 0})));
        for (int i2 = 0; i2 <= t; ++i2) {
            int j = t;
            while (j < this.orders[0].length) {
                table.add(i2, new int[]{j++, 1});
            }
        }
        return table;
    }

    public void model() {
        int n = this.orders.length;
        int m = this.orders[0].length;
        if (this.modelVariant().startsWith("m1")) {
            int[] nProducts = IntStream.range(0, n).map(i -> IntStream.of(this.orders[i]).sum()).toArray();
            IVar.Var[] p = this.array("p", this.size(m), this.dom(this.range(m)), "p[j] is the period (time) of the jth product", new Types.TypeClass[0]);
            IVar.Var[][] np = this.array("np", this.size(n, m), (i, j) -> this.dom(this.range(nProducts[i] + 1)), "np[i][j] is the number of products made at time j and required by customer i", new Types.TypeClass[0]);
            IVar.Var[][] r = this.array("r", this.size(n, m), this.dom(0, new int[]{1}), "r[i][t] is 1 iff the product made at time t concerns customer i", new Types.TypeClass[0]);
            IVar.Var[][] o = this.array("o", this.size(n, m), this.dom(0, new int[]{1}), "o[i][t] is 1 iff the stack is open for customer i at time t", new Types.TypeClass[0]);
            IVar.Var[] ns = this.array("ns", this.size(m), this.dom(this.range(m + 1)), "ns[t] is the number of open stacks at time t", new Types.TypeClass[0]);
            this.allDifferent(p);
            this.forall(this.range(n).range(m), (i, j) -> this.element(this.orders[i], p[j], r[i][j]));
            this.forall(this.range(n).range(m), (i, j) -> this.equal(new Object[]{np[i][j], j == 0 ? r[i][j] : this.add(new Object[]{np[i][j - 1], r[i][j]})}));
            this.forall(this.range(n).range(m), (i, j) -> {
                Table shortTable = this.shortTableFor(nProducts[i]);
                int[][] tuples = this.modelVariant("m1") ? shortTable.toArray() : shortTable.toOrdinaryTableArray(new int[]{nProducts[i] + 1, 2, 2});
                this.extension((IVar.Var[])this.vars((IVar)np[i][j], (IVar[])new IVar.Var[]{r[i][j], o[i][j]}), tuples);
            });
            this.forall(this.range(m), j -> this.sum((IVar.Var[])this.columnOf(o, j), EQ, ns[j]));
            this.minimize(MAXIMUM, (IVar[])ns);
        }
        if (this.modelVariant().startsWith("m2")) {
            IVar.Var[] p = this.array("p", this.size(m), this.dom(this.range(m)), "p[j] is the period (time) of the jth product", new Types.TypeClass[0]);
            IVar.Var[] s = this.array("s", this.size(n), this.dom(this.range(m)), "s[i] is the starting time of the ith stack", new Types.TypeClass[0]);
            IVar.Var[] e = this.array("e", this.size(n), this.dom(this.range(m)), "e[i] is the ending time of the ith stack", new Types.TypeClass[0]);
            IVar.Var[][] o = this.array("o", this.size(n, m), this.dom(0, new int[]{1}), "o[i][t] is 1 iff the ith stack is open at time t", new Types.TypeClass[0]);
            IVar.Var[] ns = this.array("ns", this.size(m), this.dom(this.range(m + 1)), "ns[t] is the number of open stacks at time t", new Types.TypeClass[0]);
            this.allDifferent(p).note("all products are scheduled at different times");
            this.forall(this.range(n), i -> this.minimum((IVar.Var[])this.select(p, j -> this.orders[i][j] == 1), s[i])).note("computing starting times of stacks");
            this.forall(this.range(n), i -> this.maximum((IVar.Var[])this.select(p, j -> this.orders[i][j] == 1), e[i])).note("computing ending times of stacks");
            this.forall(this.range(n).range(m), (i, t) -> {
                Table table = this.shortTable2For(t);
                this.extension((IVar.Var[])this.vars((IVar)s[i], (IVar[])new IVar.Var[]{e[i], o[i][t]}), this.modelVariant("m2") ? table.toArray() : table.toOrdinaryTableArray(new int[]{m, m, 2}));
            }).note("inferring when stacks are open");
            this.forall(this.range(m), t -> this.sum((IVar.Var[])this.columnOf(o, t), EQ, ns[t])).note("computing the number of open stacks at any time");
            this.minimize(MAXIMUM, (IVar[])ns).note("minimizing the number of stacks that are simultaneously open");
        }
    }
}

