/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.structures.Automaton;
import org.xcsp.common.structures.Transitions;
import org.xcsp.modeler.api.ProblemAPI;
import utility.Kit;

public class Nonogram
implements ProblemAPI {
    int[][] rowPatterns;
    int[][] colPatterns;

    private List<int[]> buildTuples(List<int[]> list, int[] t, int i, int[] pattern, int patternFrom) {
        if ((long)i + Kit.sum(pattern, patternFrom) + (long)(pattern.length - 1 - patternFrom) > (long)t.length) {
            return list;
        }
        if (i == t.length) {
            list.add((int[])t.clone());
        } else {
            t[i] = 0;
            this.buildTuples(list, t, i + 1, pattern, patternFrom);
            if (patternFrom < pattern.length) {
                for (int j = i; j < i + pattern[patternFrom]; ++j) {
                    t[j] = 1;
                }
                if (i + pattern[patternFrom] == t.length) {
                    this.buildTuples(list, t, i + pattern[patternFrom], pattern, patternFrom + 1);
                } else {
                    t[i + pattern[patternFrom]] = 0;
                    this.buildTuples(list, t, i + pattern[patternFrom] + 1, pattern, patternFrom + 1);
                }
            }
        }
        return list;
    }

    private int[][] tableFor(boolean row, int[] pattern, Map<String, int[][]> cache) {
        String key = (row ? "R" : "C") + Utilities.join((Object)pattern);
        if (!cache.containsKey(key)) {
            List<int[]> tuples = this.buildTuples(new ArrayList<int[]>(), new int[row ? this.colPatterns.length : this.rowPatterns.length], 0, pattern, 0);
            cache.put(key, (int[][])tuples.stream().sorted(Utilities.lexComparatorInt).toArray(x$0 -> new int[x$0][]));
        }
        return cache.get(key);
    }

    private Automaton automatonFor(int[] nonogramPattern) {
        Function<Integer, String> q = i -> "q" + i;
        int nStates = 0;
        Transitions transitions = this.transitions();
        if (nonogramPattern.length == 0) {
            nStates = 1;
            transitions.add(q.apply(0), (Object)0, q.apply(0));
        } else {
            nStates = IntStream.of(nonogramPattern).sum() + nonogramPattern.length;
            int num = 0;
            for (int i2 = 0; i2 < nonogramPattern.length; ++i2) {
                transitions.add(q.apply(num), (Object)0, q.apply(num));
                for (int j = 0; j < nonogramPattern[i2]; ++j) {
                    transitions.add(q.apply(++num), (Object)1, q.apply(num));
                }
                if (i2 >= nonogramPattern.length - 1) continue;
                transitions.add(q.apply(++num), (Object)0, q.apply(num));
            }
            transitions.add(q.apply(num), (Object)0, q.apply(num));
        }
        return this.automaton(q.apply(0), transitions, new String[]{q.apply(nStates - 1)});
    }

    public void model() {
        int nRows = this.rowPatterns.length;
        int nCols = this.colPatterns.length;
        IVar.Var[][] x = this.array("x", this.size(nRows, nCols), this.dom(0, new int[]{1}), "x[i][j] is 1 iff the cell at row i and col j is colored in black", new Types.TypeClass[0]);
        if (this.modelVariant("")) {
            this.forall(this.range(nRows), i -> this.regular(x[i], this.automatonFor(this.rowPatterns[i])));
            this.forall(this.range(nCols), j -> this.regular((IVar.Var[])this.columnOf(x, j), this.automatonFor(this.colPatterns[j])));
        }
        if (this.modelVariant("table")) {
            HashMap cache = new HashMap();
            this.forall(this.range(nRows), i -> this.extension(x[i], this.tableFor(true, this.rowPatterns[i], cache)));
            this.forall(this.range(nCols), j -> this.extension((IVar.Var[])this.columnOf(x, j), this.tableFor(false, this.colPatterns[j], cache)));
        }
    }
}

