/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.modeler.api.ProblemAPI;
import org.xcsp.modeler.implementation.NotData;

public class Dominoes
implements ProblemAPI {
    int[][] grid;
    @NotData
    int nRows;
    @NotData
    int nCols;

    private XNodeParent<IVar> adjacencyPredicate(IVar.Var x, IVar.Var y) {
        return this.or(new Object[]{this.eq(new Object[]{x, this.add(new Object[]{y, this.nCols})}), this.eq(new Object[]{y, this.add(new Object[]{x, this.nCols})}), this.and(new Object[]{this.eq(new Object[]{x, this.add(new Object[]{y, 1})}), this.ne(new Object[]{this.mod(x, this.nCols), 0})}), this.and(new Object[]{this.eq(new Object[]{y, this.add(new Object[]{x, 1})}), this.ne(new Object[]{this.mod(y, this.nCols), 0})})});
    }

    private int[] positionsOf(int value) {
        return this.valuesFrom(this.range(this.nRows).range(this.nCols), (i, j) -> this.grid[i][j] == value ? Integer.valueOf(i * this.nCols + j) : null);
    }

    public void model() {
        this.nRows = this.grid.length;
        this.nCols = this.grid[0].length;
        int nValues = this.nRows;
        IVar.Var[][] x = this.array("x", this.size(nValues, nValues), (i, j) -> this.dom(this.range(this.nRows * this.nCols)).when(i <= j), "x[i][j] concerns the domino (having values) i-j; this is the position of the value i in the grid for this domino", new Types.TypeClass[0]);
        IVar.Var[][] y = this.array("y", this.size(nValues, nValues), (i, j) -> this.dom(this.range(this.nRows * this.nCols)).when(i <= j), "y[i][j] concerns the domino (having values) i-j; this is the position of the value j in the grid for this domino", new Types.TypeClass[0]);
        this.allDifferent((IVar.Var[])this.vars(x, (IVar[][])y)).note("each part of each domino in a different cell");
        this.forall(this.range(nValues), i -> this.forall(this.range(i, nValues), j -> {
            this.belong(x[i][j], this.set(this.positionsOf(i)));
            this.belong(y[i][j], this.set(this.positionsOf(j)));
        })).note("unary constraints");
        this.forall(this.range(nValues), i -> this.forall(this.range(i, nValues), j -> this.intension(this.adjacencyPredicate(x[i][j], y[i][j])))).note("adjacency constraints");
    }
}

