/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;

public class Cutstock
implements ProblemAPI {
    int nPieces;
    int pieceLength;
    Item[] items;

    public void model() {
        int nItems = this.items.length;
        int[] itemLengths = this.valuesFrom(this.items, item -> item.length);
        IVar.Var[] p = this.array("p", this.size(this.nPieces), this.dom(0, new int[]{1}), "p[i] is 1 iff the ith piece of the stock is used", new Types.TypeClass[0]);
        IVar.Var[][] r = this.array("r", this.size(this.nPieces, nItems), (i, j) -> this.dom(this.range(this.items[j].demand + 1)), "r[i][j] is the number of items of type j built using stock piece i", new Types.TypeClass[0]);
        this.forall(this.range(nItems), i -> this.sum((IVar.Var[])this.columnOf(r, i), EQ, this.items[i].demand)).note("each item demand must be exactly satisfied");
        this.forall(this.range(this.nPieces), i -> this.sum((IVar.Var[])this.vars(r[i], (IVar)p[i]), this.weightedBy(this.vals(new Object[]{itemLengths, -this.pieceLength})), LE, 0L)).note("each piece of the stock cannot provide more than its length");
        this.block(() -> {
            this.decreasing(p);
            this.decreasing(r);
        }).tag(new Types.TypeClass[]{SYMMETRY_BREAKING});
        this.minimize(SUM, (IVar[])p).note("minimizing the number of used pieces");
    }

    class Item {
        int length;
        int demand;

        Item() {
        }
    }
}

