/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import java.util.stream.IntStream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;

public class Bugs
implements ProblemAPI {
    int height;
    int width;
    Bug[] bugs;
    BugType[] bugTypes;

    boolean neighbors(int i, int j, int k, int l) {
        return i == k && (j == l + 1 || j == l - 1) || j == l && (i == k + 1 || i == k - 1);
    }

    public void model() {
        int nBugs = this.bugs.length;
        int nBugTypes = this.bugTypes.length;
        IVar.Var[][] x = this.array("x", this.size(this.height, this.width), this.dom(this.range(-1, nBugs)), "one variable per square in the grid, whose domain is -1..nbBugs-1", new Types.TypeClass[0]);
        IVar.Var[] n1 = this.array("n1", this.size(nBugs), this.dom(this.range(nBugs + 1)), "n1[i] corresponds to the number of squares in x with value i", new Types.TypeClass[0]);
        IVar.Var[] n2 = this.array("n2", this.size(nBugs), this.dom(this.range(this.height * this.width + 1)), "n2[i] corresponds to the number of squares in x with a bug on it and with value i", new Types.TypeClass[0]);
        this.forall(this.range(nBugs), i -> this.extension(x[this.bugs[i].row][this.bugs[i].col], this.bugTypes[this.bugs[i].type].cells)).note("each bug square can either take its bug index for value or take the one of another bug of the same type");
        this.forall(this.range(nBugs), i -> this.intension(this.le(x[this.bugs[i].row][this.bugs[i].col], i))).note("symmetry breaking: a bug's square's value is smaller or equal to the bug's index");
        int max = IntStream.range(0, nBugTypes).map(i -> this.bugTypes[i].cells.length).max().orElse(-1);
        this.forall(this.range(nBugTypes).range(1, max), (i, j) -> {
            if (j < this.bugTypes[i].cells.length) {
                this.intension(this.le(n1[this.bugTypes[i].cells[j]], (this.bugTypes[i].cells.length - j) * this.bugTypes[i].length));
            }
        });
        this.cardinality((IVar.Var[])this.vars((IVar[][])x), this.range(nBugs), this.occurExactly(n1));
        this.cardinality((IVar.Var[])this.variablesFrom(this.range(nBugs), i -> x[this.bugs[i.intValue()].row][this.bugs[i.intValue()].col]), this.range(nBugs), this.occurExactly(n2));
        this.forall(this.range(nBugs), i -> this.equal(new Object[]{this.mul(new Object[]{n2[i], this.bugTypes[this.bugs[i].type].length}), n1[i]}));
        this.forall(this.range(this.height).range(this.width).range(this.height).range(this.width).range(this.height).range(this.width), (i, j, k, l, m, n) -> {
            if (!(i > k || this.neighbors(i, j, k, l) || i == k && j >= l || i > m || m > k || Math.min(j, l) > n || n > Math.max(j, l) || m == i && n == j || m == k && n == l)) {
                this.intension(this.or(new Object[]{this.ne(new Object[]{x[i][j], x[k][l]}), this.eq(new Object[]{x[i][j], x[m][n]})}));
            }
        }).note("if two squares have the same value, then all the squares in the rectangle they delimit must take this value");
        this.maximize(SUM, this.treesFrom(this.range(nBugs), i -> this.eq(new Object[]{n2[i], 0}))).note("maximizing the number of times a bug is in a rectangle whose index is different from the one of the bug");
    }

    class BugType {
        int length;
        int[] cells;

        BugType() {
        }
    }

    class Bug {
        int row;
        int col;
        int type;

        Bug() {
        }
    }
}

