/*
 * Decompiled with CFR 0.152.
 */
package problems.g2_academic;

import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;
import utility.Kit;

public class QueenAttacking
implements ProblemAPI {
    int n;

    public void model() {
        int[] primes = Kit.computePrimes(this.n * this.n);
        int m = primes.length;
        IVar.Var q = this.var("q", this.dom(this.range(this.n * this.n)), "q is the cell for the queen", new Types.TypeClass[0]);
        IVar.Var[] x = this.array("x", this.size(this.n * this.n), this.dom(this.range(this.n * this.n)), "x[i] is the cell for the i+1th value", new Types.TypeClass[0]);
        this.allDifferent(x).note("all values are put in different cells");
        this.slide((IVar[])x, this.range(this.n * this.n - 1), i -> this.intension(this.knightAttack((IVar)x[i], (IVar)x[i + 1], this.n))).note("ensuring a knight move between two successive values");
        this.minimize(SUM, this.treesFrom(this.range(m), i -> this.not(this.queenAttack((IVar)q, (IVar)x[primes[i] - 1], this.n)))).note("minimizing the number of free primes");
    }

    public void prettyDisplay(String[] values) {
        for (int i = 0; i < this.n; ++i) {
            block1: for (int j = 0; j < this.n; ++j) {
                for (int k = 1; k <= this.n * this.n; ++k) {
                    if (Integer.parseInt(values[k]) != i * this.n + j) continue;
                    System.out.print((k < 10 ? "0" + k : Integer.valueOf(k)) + " ");
                    continue block1;
                }
            }
            System.out.println();
        }
    }
}

