/*
 * Decompiled with CFR 0.152.
 */
package problems;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Range;
import org.xcsp.common.Utilities;
import org.xcsp.modeler.problems.AllInterval;
import org.xcsp.modeler.problems.Blackhole;
import org.xcsp.modeler.problems.BoardColoration;
import org.xcsp.modeler.problems.MagicSequence;
import org.xcsp.modeler.problems.Rack;
import org.xcsp.modeler.problems.Sudoku;
import org.xcsp.modeler.problems.Warehouse;
import problems.g2_academic.Bibd;
import problems.g2_academic.ColouredQueens;
import problems.g2_academic.CoveringArray;
import problems.g2_academic.CryptoPuzzle;
import problems.g2_academic.DeBruijnSequence;
import problems.g2_academic.DiamondFree;
import problems.g2_academic.Dubois;
import problems.g2_academic.GolombRuler;
import problems.g2_academic.GracefulGraph;
import problems.g2_academic.KnightTour;
import problems.g2_academic.Langford;
import problems.g2_academic.LangfordBin;
import problems.g2_academic.LowAutocorrelation;
import problems.g2_academic.MagicHexagon;
import problems.g2_academic.NumberPartitioning;
import problems.g2_academic.Opd;
import problems.g2_academic.Ortholatin;
import problems.g2_academic.PeacableArmies;
import problems.g2_academic.QuasiGroup;
import problems.g2_academic.QueenAttacking;
import problems.g2_academic.Queens;
import problems.g2_academic.Ramsey;
import problems.g2_academic.SchurrLemma;
import problems.g2_academic.SocialGolfers;
import problems.g2_academic.SportsScheduling;
import problems.g2_academic.Steiner3;
import problems.g2_academic.StillLife;
import problems.g3_pattern.GraphColoring;
import problems.g3_pattern.Kakuro;
import problems.g3_pattern.MagicSquare;
import problems.g3_pattern.RectPacking;
import problems.g3_pattern.RoomMate;
import problems.g3_pattern.StripPacking;
import problems.g3_pattern.Subisomorphism;
import problems.g3_pattern.TravelingSalesman;
import problems.g4_world.Bacp;
import problems.g4_world.CarSequencing;
import problems.g4_world.Crossword;
import problems.g4_world.Fapp;
import problems.g4_world.MisteryShopper;
import problems.g4_world.PizzaVoucher;
import problems.g4_world.QuadraticAssignment;
import problems.g4_world.RadarSurveillance;
import problems.g4_world.Rcpsp;
import problems.g4_world.Rlfap;
import problems.g4_world.SolitaireBattleship;
import problems.g4_world.Tal;
import problems.g5_special.DistinctVectors;
import problems.g5_special.Domino;
import problems.g5_special.Hanoi;
import problems.g5_special.Knights;
import problems.g5_special.Pigeons;
import problems.g5_special.PropStress;
import problems.g5_special.QueensKnights;
import problems.generators.Auction_Parser;
import problems.generators.Bacp_Parser;
import problems.generators.Bacp_ParserZ;
import problems.generators.BinPacking_Parser;
import problems.generators.Blackhole_Random;
import problems.generators.BusSchedulingReaderZ;
import problems.generators.CutstockReaderZ;
import problems.generators.Eternity_Parser;
import problems.generators.Fastfood_ParserZ;
import problems.generators.GraphColoringReader;
import problems.generators.KakuroReader;
import problems.generators.KnapsackRandom;
import problems.generators.LatinSquareReader;
import problems.generators.MagicSquare_Parser;
import problems.generators.MarioReaderZ;
import problems.generators.MarketSplitReader;
import problems.generators.MultiKnapsack_Parser;
import problems.generators.Nonogram_Parser;
import problems.generators.NurseRosteringReader;
import problems.generators.OpenStacks_ParserZ;
import problems.generators.PrizeCollecting_ParserZ;
import problems.generators.PseudoBoolean_Parser;
import problems.generators.QuadraticAssignment_Parser;
import problems.generators.RadarSurveillance_Random;
import problems.generators.RlfapReader;
import problems.generators.SatReader;
import problems.generators.SchedulingFSReader;
import problems.generators.SchedulingJSReader;
import problems.generators.SchedulingOSReader;
import problems.generators.SolitaireBattleshipReader;
import problems.generators.SolitaireBattleshipReaderZ;
import problems.generators.StripPackingReader;
import problems.generators.Sudoku_Parser;
import problems.generators.TppReaderZ;
import problems.generators.TravellingSalesmanRandom;
import problems.generators.VrpReaderZ;
import problems.generators.Warehouse_Parser;
import problems.generators.WwtppReaderZ;
import problems.test.TestSmart;
import problems.tran.RenaultMod;
import utility.Kit;

public final class Series {
    private static final String PATH = "/home/lecoutre/instances/";
    private static final String PATH_MINI = "/home/lecoutre/instances/minizinc-benchmarks-master/";
    private static final String DZN = ".dzn";
    private static final String MZN = ".mzn";
    private static final String JSON = ".json";
    private static final String DAT = ".dat";
    private static final String XCSP2 = "problems.xcsp2.XCSP2";
    private static final String ALL = "all";
    private static final String TEST = "test";
    private static final String RANDOM = "Random";
    private static final String QRANDOM = "QRandom";
    private static final String ALL_INTERVAL = AllInterval.class.getName();
    private static final String BIBD = Bibd.class.getSimpleName();
    private static final String BLACK_HOLE = Blackhole.class.getSimpleName();
    private static final String CHESSBOARD_COLORATION = BoardColoration.class.getSimpleName();
    private static final String COLOURED_QUEENS = ColouredQueens.class.getName();
    private static final String DISTINCT_VECTORS = DistinctVectors.class.getSimpleName();
    private static final String DOMINO = Domino.class.getSimpleName();
    private static final String DUBOIS = Dubois.class.getSimpleName();
    private static final String GOLOMB = GolombRuler.class.getSimpleName();
    private static final String GRACEFUL = GracefulGraph.class.getSimpleName();
    private static final String HANOI = Hanoi.class.getSimpleName();
    private static final String KNAPSACK = KnapsackRandom.class.getName();
    private static final String KNIGHTS = Knights.class.getSimpleName();
    private static final String KNIGHT_TOUR = KnightTour.class.getSimpleName();
    private static final String LANGFORD = Langford.class.getSimpleName();
    private static final String LOW_AUTOCORRELATION = LowAutocorrelation.class.getSimpleName();
    private static final String ORTHOLATIN = Ortholatin.class.getSimpleName();
    private static final String QUADRATIC_ASSIGNMENT = QuadraticAssignment.class.getSimpleName();
    private static final String QUEEN_ATTACKING = QueenAttacking.class.getSimpleName();
    private static final String QUEENS = Queens.class.getSimpleName();
    private static final String QUEENS_KNIGHTS = QueensKnights.class.getSimpleName();
    private static final String RAMSEY = Ramsey.class.getSimpleName();
    private static final String RECT_PACKING = RectPacking.class.getSimpleName();
    private static final String SCHURR = SchurrLemma.class.getSimpleName();
    private static final String STEINER3 = Steiner3.class.getSimpleName();
    private static final String STRIP_PACKING = StripPacking.class.getSimpleName();
    private static final String RADAR_SURVEILLANCE = RadarSurveillance.class.getSimpleName();
    private static final String ROOM_MATE = RoomMate.class.getSimpleName();
    private static final String SOCIAL_GOLFERS = SocialGolfers.class.getSimpleName();
    private static final String SUBISOMORPHISM = Subisomorphism.class.getSimpleName();
    private static final String TRAVELLING_SALESMAN = TravelingSalesman.class.getSimpleName();
    private static final String WAREHOUSE = Warehouse.class.getSimpleName();
    private static final String BASIC = "Basic";
    private static final String CRYPTO_PUZZLE = CryptoPuzzle.class.getSimpleName();
    private static final String KAKURO = Kakuro.class.getSimpleName();
    private static final String MAGIC_SEQUENCE = MagicSequence.class.getSimpleName();
    private static final String SUDOKU = Sudoku.class.getSimpleName();
    private static final String RENAULT_MOD = RenaultMod.class.getSimpleName();
    private static final String RENAULT = "Renault";
    private static final String CAR_SEQUENCING = CarSequencing.class.getSimpleName();
    private static final String CROSSWORD = Crossword.class.getSimpleName();
    private static final String RLFAP = Rlfap.class.getSimpleName();
    private static final String RLFAP_OLD = "RlfapOld";
    private static final String SPORTS_SCHEDULING = SportsScheduling.class.getSimpleName();
    private static final String RCPSP = Rcpsp.class.getSimpleName();
    private static final String GRAPH_COLORING = GraphColoring.class.getSimpleName();
    private static final String LATIN_SQUARE = LatinSquareReader.class.getName();
    private static final String MAGIC_SQUARE = MagicSquare_Parser.class.getName();
    private static final String MARKET_SPLIT = MarketSplitReader.class.getName();
    private static final String MULTI_KNAPSACK = MultiKnapsack_Parser.class.getName();
    private static final String NONOGRAM = Nonogram_Parser.class.getName();
    private static final String SAT = SatReader.class.getName();
    private static final String DRIVER = "Driver";
    private static final String FISCHER = "Fischer";
    private static final String HAYSTACKS = "Haystacks";
    private static final String PRIMES = "Primes";
    private static final String COSTAS_ARRAY = "CostasArray";
    private static final String PIGEONS_PLUS = "PigeonsPlus";
    private static final String SCHEDULING = "Scheduling";
    private static final String PSEUDO_BOOLEAN = PseudoBoolean_Parser.class.getName();
    private static final String SUPER_SOLUTIONS = "SuperSolutions";
    private static final String QUASI_GROUP = QuasiGroup.class.getName();
    private static final String BIN_PACKING = BinPacking_Parser.class.getName();
    private static final String MAX_CSP = "MaxCSP";
    private static final String MIXED = "Mixed";
    private static final String VRP = VrpReaderZ.class.getName();
    private static final String CUTSTOCK = CutstockReaderZ.class.getName();
    private static final String TPP = TppReaderZ.class.getName();
    private static final String MARIO = MarioReaderZ.class.getName();
    private static final String STILL_LIFE = StillLife.class.getName();
    private static final String OPD = Opd.class.getName();
    private static final String PRIZE_COLLECTING = PrizeCollecting_ParserZ.class.getName();
    private static final String BUS_SCHEDULING = BusSchedulingReaderZ.class.getName();
    private static final String FASTFOOD = Fastfood_ParserZ.class.getName();
    private static final String PROP_STRESS = PropStress.class.getName();
    private static final String WWTPP = WwtppReaderZ.class.getName();
    private static final String OPEN_STACKS = OpenStacks_ParserZ.class.getName();
    private static final String RACK = Rack.class.getName();
    private static final String COVERING_ARRAY = CoveringArray.class.getName();
    private static final String DE_BRUIJN = DeBruijnSequence.class.getName();
    private static final String DIAMOND_FREE = DiamondFree.class.getName();
    private static final String MAGIC_HEXAGON = MagicHexagon.class.getName();
    private static final String NUMBER_PARTITIONING = NumberPartitioning.class.getName();
    private static final String AUCTION = Auction_Parser.class.getName();
    private static final String BACP = Bacp.class.getName();
    private static final String ETERNITY = Eternity_Parser.class.getName();
    private static final String MISTERY_SHOPPER = MisteryShopper.class.getName();
    private static final String FAPP = Fapp.class.getName();
    private static final String BATTLESHIP = SolitaireBattleship.class.getName();
    private static final String PEACABLE_ARMIES = PeacableArmies.class.getName();
    private static final String PIGEONS = Pigeons.class.getName();
    private static final String PIZZA_VOUCHER = PizzaVoucher.class.getName();
    private static final String NURSE_ROSTERING = NurseRosteringReader.class.getName();
    private static final String TAL = Tal.class.getName();
    private static final String BAUDOUIN = "Baudouin";
    private static boolean dataexport;
    private static String serieName;
    private static File dir;
    private static File mainDir;
    private static List<String> badCommands;
    private static String exportFile;

    private static FileFilter withExtension(String ... suffixes) {
        return f -> Stream.of(suffixes).anyMatch(s -> f.getName().endsWith((String)s));
    }

    private static int[] vals(Object ... valsToConcat) {
        return Utilities.collectInt((Object[])valsToConcat);
    }

    private static Range rangeC(int minIncluded, int maxIncluded, int step) {
        return new Range(minIncluded, maxIncluded + 1, step);
    }

    private static Range rangeC(int minIncluded, int maxIncluded) {
        return new Range(minIncluded, maxIncluded + 1);
    }

    private static Range range(int length) {
        return new Range(length);
    }

    private static void execute(String command, File dir) {
        try {
            Process process = Runtime.getRuntime().exec(command, null, dir);
            new Thread(new HandleFlow(process.getInputStream())).start();
            new Thread(new HandleFlow(process.getErrorStream())).start();
            process.waitFor();
        }
        catch (Exception e) {
            System.out.println("Pb when executing " + command + " " + e);
            badCommands.add(command);
        }
    }

    private static void exec(String commandPart, int xmx, String variantName, String seriesName) {
        File cdir = new File(dir, dir.getName() + "-" + variantName + "-" + seriesName);
        cdir.mkdir();
        String fullCommand = "java" + (xmx != 0 ? " -Xmx" + xmx + "M" : "") + " ac " + commandPart + (dataexport ? " -dataexport" : "") + " -res=false -mbcs=false " + exportFile + " -puc=true -nc=false -alvalb=3 -ea -ev";
        System.out.println(fullCommand);
        Series.execute(fullCommand, cdir);
    }

    private static void exec(String commandPart, String variant, String seriesName) {
        Series.exec(commandPart, 0, variant, seriesName);
    }

    private static void exec(String commandPart, int xmx, String seriesName) {
        Series.exec(commandPart, xmx, "m1", seriesName);
    }

    private static void exec(String commandPart, String seriesName) {
        Series.exec(commandPart, 0, seriesName);
    }

    private static void exec(String commandPart, int xmx) {
        Series.exec(commandPart, xmx, "s1");
    }

    private static void exec(String commandPart) {
        Series.exec(commandPart, 0);
    }

    private static void execVariant(String commandPart, String variant, String series) {
        Series.exec(commandPart + " -variant=" + variant, variant, series);
    }

    private static void execVariant(String commandPart, String variant) {
        Series.execVariant(commandPart, variant, "s1");
    }

    private static void execVariant(String commandPart, String variant, int xmx) {
        Series.exec(commandPart + " -variant=" + variant, xmx, variant, "s1");
    }

    private static void executePair(String first, String second, String suffix, File dir) {
        Series.execute("java abscon.Resolution " + first + " " + suffix, dir);
        Series.execute("java abscon.Resolution problems.xcsp3.XCSP3 " + second + " " + suffix, dir);
    }

    private static void test() {
        String prefix = "/home/lecoutre/abssol/seriesFullSept2016/";
        File dir = new File("/home/lecoutre");
        Series.executePair("modeler.problems.acad.AllInterval -data=12", prefix + "AllInterval/AllInterval-m1-s1/AllInterval-012.xml.lzma", "-s=all -v=0 -varh=DDegOnDom", dir);
        Series.executePair("modeler.problems.acad.Bibd -data=[6,50,25,3,10] -variant=sum", prefix + "Bibd/Bibd-sum-lex/Bibd-sum-06-050-25-03-10.xml.lzma", "-s=all -v=0 -varh=DDegOnDom", dir);
        Series.executePair("problems.acad.Blackhole 4 3 0", prefix + "Blackhole/Blackhole-m1-s04/Blackhole-04-3-00.xml.lzma", "-s=all -v=0 -varh=Memory", dir);
        Series.executePair("problems.xcsp2.XCSP2 /home/lecoutre/instances/benchmarks2006/blackHole/BH-4-04/Blackhole-4-04-0_X2.xml.bz2", prefix + "Blackhole/Blackhole-xcsp2-s04/Blackhole-4-04-0_X2.xml.lzma", " -varh=DDegOnDom -riv=false", dir);
        Series.executePair("problems.acad.ChessboardColoration  9 9", prefix + "ChessboardColoration/ChessboardColoration-m1-s1/cc-09-09.xml.lzma", "-f=cop -rc=10", dir);
        Series.executePair("problems.acad.ColouredQueens 6 ", prefix + "ColouredQueens/ColouredQueens-m1-s1/ColouredQueens-06.xml.lzma", "", dir);
        Series.executePair("problems.acad.DistinctVectors 40 100 24", prefix + "DistinctVectors/DistinctVectors-m1-s3/DistinctVectors-40-100-24.xml.lzma", " -v=0 -varh=DDegOnDom", dir);
        Series.executePair("problems.acad.Domino 3000 3000", prefix + "Domino/Domino-m1-s1/Domino-3000-3000.xml.lzma", "", dir);
        Series.executePair("problems.acad.Dubois 18", prefix + "Dubois/Dubois-m1-s1/Dubois-018.xml.lzma", "", dir);
        Series.executePair("problems.acad.GolombRuler  7 500 3", prefix + "GolombRuler/GolombRuler-a3-s1/GolombRuler-07-a3.xml.lzma", " -f=cop -varh=DDegOnDom", dir);
        Series.executePair("problems.acad.GolombRuler  8 500 4", prefix + "GolombRuler/GolombRuler-a4-s1/GolombRuler-08-a4.xml.lzma", " -f=cop -varh=DDegOnDom", dir);
        Series.executePair("problems.acad.GracefulGraph 3 6", prefix + "GracefulGraph/GracefulGraph-m1-s1/Graceful-K03-P06.xml.lzma", "", dir);
        Series.executePair("problems.acad.Hanoi 8", prefix + "Hanoi/Hanoi-m1-s1/Hanoi-08.xml.lzma", "", dir);
        Series.executePair("problems.acad.Knights 25 5", prefix + "Knights/Knights-m1-s1/Knights-025-05.xml.lzma", "", dir);
        Series.executePair("problems.acad.KnightTour 8 1", prefix + "KnightTour/KnightTour-int-s1/KnightTour-08-int.xml.lzma", " -rc=10", dir);
        Series.executePair("problems.acad.KnightTour 12 3", prefix + "KnightTour/KnightTour-ext-s1/KnightTour-12-ext03.xml.lzma", " -rc=10", dir);
        Series.executePair("problems.acad.Langford 2 10", prefix + "Langford/Langford-m1-k2/Langford-2-10.xml.lzma", "", dir);
        Series.executePair("problems.acad.Langford 3 12", prefix + "Langford/Langford-m1-k3/Langford-3-12.xml.lzm", "", dir);
        Series.executePair("problems.acad.Queens 12 0", prefix + "Queens/Queens-m1-s1/Queens-0012.xml.lzma", " -s=all -v=0", dir);
        Series.executePair("problems.acad.QueensKnights 20 3 20 5", prefix + "QueensKnights/QueensKnights-m1-s1/QueensKnights-020-5-add.xml.lzma", "", dir);
        Series.executePair("problems.acad.QueensKnights 20 4 20 5", prefix + "QueensKnights/QueensKnights-m1-s1/QueensKnights-020-5-mul.xml.lzma", "", dir);
        Series.executePair("problems.acad.Ramsey 15", prefix + "Ramsey/Ramsey-m1-s1/Ramsey-15.xml.lzma", " -f=cop -rc=10", dir);
        Series.executePair("problems.acad.RectPacking -1", prefix + "RectPacking/RectPacking-m1-perf/RectPacking-001.xml.lzma", " -rc=10 -st -rn=75", dir);
        Series.executePair("problems.acad.SchurrLemma 15 9 1", prefix + "SchurrLemma/SchurrLemma-m1-s1/Lemma-015-9-mod.xml.lzma", "", dir);
        Series.executePair("problems.acad.SchurrLemma 66 4 0", prefix + "SchurrLemma/SchurrLemma-tr-s1/Lemma-066-4.xml.lzma", "", dir);
        Series.executePair("problems.acad.Steiner3 7", prefix + "Steiner3/Steiner3-m1-s1/Steiner3-7.xml.lzma", " -v=0 -s=5000", dir);
        Series.executePair("problems.tran.Sadeh /home/lecoutre/instances/sadeh/instances/enddr1-10-by-5-2", prefix + "Sadeh/Sadeh-m1-s1/enddr1-10-by-5-2.xml.lzma", " -rc=10", dir);
        Series.executePair("problems.tran.GraphDimacs /home/lecoutre/instances/graphColoring/seriesOriginals4XCSP3/mono/1-fullins-5.col", prefix + "GraphDimacs/GraphDimacs-m1-mono/1-fullins-5.xml.lzma", " -f=cop -rc=10", dir);
        Series.executePair("problems.tran.GraphDimacs /home/lecoutre/instances/graphColoring/seriesOriginals4XCSP3/fixed/qwhdec-o18-h120-1.col", prefix + "GraphDimacs/GraphDimacs-m1-fixed/qwhdec-o18-h120-1.xml.lzma", " -f=cop -rc=10", dir);
        Series.executePair("problems.tran.LatinSquareGP /home/lecoutre/instances/seriesPapers/pesant/LatinSquare/qwh-o30-h374-01.pls", prefix + "LatinSquareGP/LatinSquareGP-m1-s1/qwh-o30-h374-01.xml.lzma", " -rc=10 -sing=Last -valh=DRand", dir);
        Series.executePair("problems.tran.LatinSquareGP /home/lecoutre/instances/seriesPapers/PLS-gomez/qwh-o030-h320.pls", prefix + "LatinSquare/LatinSquare-m1-gs/qwh-o030-h320.xml.lzma", "", dir);
        Series.executePair("/home/lecoutre/instances/benchmarks2006/bqwh/bqwh-18-141/bqwh-18-141-00_X2.xml.bz2", prefix + "LatinSquare/LatinSquare-xcsp2-bqwh18-141/bqwh-18-141-00_X2.xml.lzma", " -varh=DDegOnDom", dir);
        Series.executePair("problems.tran.MagicSquareGP /home/lecoutre/instances/seriesPapers/pesant/MagicSquare/magic9-f10-01.dat", prefix + "MagicSquareGP/MagicSquareGP-m1-s1/magic9-f10-01.xml.lzma", " -rc=10 -valh=DRand -sing=Last", dir);
        Series.executePair("problems.tran.MarketSplitGP /home/lecoutre/instances/seriesPapers/pesant/MarketSplit/marketSplit-01.dat", prefix + "MarketSplit/MarketSplit-m1-gp/marketSplit-01.xml.lzma", " -rc=10 -varh=DDegOnDom", dir);
        Series.executePair("problems.tran.MultiKnapsackGP /home/lecoutre/instances/seriesPapers/pesant/MultiKnapsack/mknap2-13.dat", prefix + "MultiKnapsack/MultiKnapsack-m1-gp/mknap2-13.xml.lzma", "", dir);
        Series.executePair("problems.real.Rlfap /home/lecoutre/instances/rlfap 1 10 -1 -1", prefix + "Rlfap/Rlfap-m1-graphs/graph10.xml.lzma", "", dir);
        Series.executePair("problems.real.Rlfap /home/lecoutre/instances/rlfap 0 11 -1 6", prefix + "Rlfap/Rlfap-m1-scens11/scen11-f06.xml.lzma", " -rc=10 -varh=DDegOnDom -lc=3", dir);
        Series.executePair("problems.real.crossword.Crossword 1 /home/lecoutre/instances/crossword/dictionaries/lexDict/lex /home/lecoutre/instances/crossword/grids/herald/h1901 n", prefix + "Crossword/Crossword-m1-lex-herald/crossword-m1-lex-h1901.xml.lzma", " -varh=DDegOnDom -rc=10 -lc=3", dir);
        Series.executePair("problems.real.crossword.Crossword 1 /home/lecoutre/instances/crossword/dictionaries/wordsDict/words /home/lecoutre/instances/crossword/grids/puzzle/p22 n", prefix + "Crossword/Crossword-m1-words-puzzle/crossword-m1-words-p22.xml.lzma", " -varh=DDegOnDom", dir);
        Series.executePair("problems.real.crossword.Crossword 1 /home/lecoutre/instances/crossword/dictionaries/ukDict/uk vg-5-8 n", prefix + "Crossword/Crossword-m1-uk-vg/crossword-m1-uk-vg-5-8.xml.lzma", "", dir);
        Series.executePair("problems.real.crossword.Crossword 1 /home/lecoutre/instances/crossword/dictionaries/ukDict/uk vg-5-8 y", prefix + "Crossword/Crossword-m1dw-uk-vg/crossword-m1dw-uk-vg-5-8.xml.lzma", "", dir);
        Series.executePair("problems.real.crossword.Crossword 1 /home/lecoutre/instances/crossword/dictionaries/ogdDict/ogd vg-6-7 n", prefix + "Crossword/Crossword-m1-ogd-vg/crossword-m1-ogd-vg-6-7.xml.lzma", "", dir);
        Series.executePair("problems.xcsp2.XCSP2 /home/lecoutre/instances/benchmarks2006/composed/composed-75/composed-75-01-80-9.xml.bz2", prefix + "Composed/Composed-m1-s75/composed-75-01-80-9.xml.lzma", "", dir);
        Series.executePair("problems.xcsp2.XCSP2 /home/lecoutre/instances/benchmarks2006/dimacs/aim-200/aim-200-1-6-sat-1.xml.bz2", prefix + "Dimacs/Dimacs-m1-aim200/aim-200-1-6-sat-1.xml.lzma", "", dir);
        Series.executePair("problems.xcsp2.XCSP2 /home/lecoutre/instances/benchmarks2006/dimacs/jnh/jnh-220.xml.bz2", prefix + "Dimacs/Dimacs-m1-jnh/jnh-220.xml.lzma", "", dir);
        Series.executePair("problems.xcsp2.XCSP2 /home/lecoutre/instances/benchmarks2006/dimacs/varDimacs/pret-060-75.xml.bz2", prefix + " Dimacs/Dimacs-m1-various/pret-060-75.xml.lzma", " -rc=10 -sing=last -varh=Memory", dir);
        Series.executePair("problems.xcsp2.XCSP2 /home/lecoutre/instances/benchmarks2006/ehi/ehi-90/ehi-90-315-71.xml.bz2", prefix + "Ehi/Ehi-m1-ehi-90/ehi-90-315-71.xml.lzma", " -varh=DDegOnDom -lc=5", dir);
        Series.executePair("problems.xcsp2.XCSP2 /home/lecoutre/instances/benchmarks2006/frb/frbLow/frb-35-17-3.xml.bz2", prefix + "Frb/Frb-m1-low/frb-35-17-3.xml.lzma", " -varh=DDegOnDom -nc=false", dir);
        Series.executePair("problems.xcsp2.XCSP2 /home/lecoutre/instances/benchmarks2006/geometric/geometric-50-20-d4-75-34.xml.bz2", prefix + "Geometric/Geometric-m1-rw/geometric-50-20-d4-75-34.xml.lzma", "", dir);
        Series.executePair("problems.xcsp2.XCSP2 /home/lecoutre/instances/benchmarks2006/haystacks/haystacks-06.xml.bz2", prefix + "Haystacks/Haystacks-m1-s1/haystacks-06.xml.lzma", "-varh=DDegOnDom", dir);
        Series.executePair("problems.xcsp2.XCSP2 /home/lecoutre/instances/benchmarks2006/lard/lard-92-92.xml.bz2", prefix + "Lard/Lard-m1-s1/lard-92-92.xml.lzma", "", dir);
        Series.executePair("problems.xcsp2.XCSP2 /home/lecoutre/instances/benchmarks2006/tightness/tightness010/rand-2-40-8-753-100-78.xml.bz2", prefix + "Tightness/Tightness-m1-s010/rand-2-40-8-753-100-78.xml.lzma", "", dir);
    }

    private static void cX2(String dir, String variant, String series) {
        for (File f : new File(PATH + dir).listFiles()) {
            Series.exec("problems.xcsp2.XCSP2 " + f.getAbsolutePath(), variant, series);
        }
    }

    private static void cZn(String dir, String pb) {
        for (File f : new File(PATH_MINI + dir).listFiles(Series.withExtension(DZN))) {
            Series.exec(pb + " " + f.getAbsolutePath(), "zinc", "s1");
        }
    }

    /*
     * Opcode count of 14981 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        int f322;
        int i2;
        int n;
        if (!(args.length == 1 || args.length == 2 && args[1].equals("-dataexport"))) {
            System.out.println("Usage : java " + Series.class.getName() + " <seriesName> [-dataexport]");
            return;
        }
        dataexport = args.length == 2 && args[1].toLowerCase().equals("-dataexport");
        serieName = args[0].trim().toLowerCase();
        if (serieName.equals(TEST)) {
            Series.test();
            return;
        }
        if (serieName.equals(ALL)) {
            mainDir = new File(Instant.now().toString().substring(0, 13));
            Kit.control(mainDir.mkdir(), () -> "Directory already present");
        }
        if (Series.dirFor(RANDOM)) {
            Series.cX2("random/marc", "m1", "marc");
            Series.cX2("random/rand-2-23-23", "B", "2-23-23");
            Series.cX2("random/rand-2-24-24", "B", "2-24-24");
            Series.cX2("random/rand-2-25-25", "B", "2-25-25");
            Series.cX2("random/rand-2-26-26", "B", "2-26-26");
            Series.cX2("random/rand-2-27-27", "B", "2-27-27");
            Series.cX2("random/tightness010", "D", "s010");
            Series.cX2("random/tightness020", "D", "s020");
            Series.cX2("random/tightness035", "D", "s035");
            Series.cX2("random/tightness050", "D", "s050");
            Series.cX2("random/tightness065", "D", "s065");
            Series.cX2("random/tightness080", "D", "s080");
            Series.cX2("random/tightness090", "D", "s090");
            Series.cX2("random/frbLow", "RB", "low");
            Series.cX2("random/frbHigh", "RB", "high");
            Series.cX2("random/rand-2-30-15", "RB", "2-30-15");
            Series.cX2("random/rand-2-30-15f", "RB", "2-30-15f");
            Series.cX2("random/rand-2-40-19", "RB", "2-40-19");
            Series.cX2("random/rand-2-40-19f", "RB", "2-40-19f");
            Series.cX2("random/rand-2-50-23", "RB", "2-50-23");
            Series.cX2("random/rand-2-50-23f", "RB", "2-50-23f");
            Series.cX2("random/rand-3-20-20", "RB", "3-20-20");
            Series.cX2("random/rand-3-20-20f", "RB", "3-20-20f");
            Series.cX2("random/rand-3-24-24", "RB", "3-24-24");
            Series.cX2("random/rand-3-24-24f", "RB", "3-24-24f");
            Series.cX2("random/rand-3-28-28", "RB", "3-28-28");
            Series.cX2("random/rand-3-28-28f", "RB", "3-28-28f");
            Series.cX2("random/rand-5-12-12", "m1", "5-12-12");
            Series.cX2("random/rand-5-12-12t", "m1", "5-12-12t");
            Series.cX2("random/rand-7-40-8t", "m1", "7-40-8t");
            Series.cX2("random/rand-8-20-5", "m1", "8-20-5");
            Series.cX2("random/rand-10-20-10", "m1", "10-20-10");
            Series.cX2("random/rand-10-60-20", "m1", "10-60-20");
            Series.cX2("random/rand-15-23-3", "m1", "15-23-3");
            Series.cX2("random/rand-5-2X-05c", "m1", "5-X2X-05c");
            Series.cX2("random/rand-5-4X-05c", "m1", "5-4X-05c");
            Series.cX2("random/rand-5-8X-05c", "m1", "5-8X-05c");
            Series.cX2("random/rand-5-10-10", "m1", "5-10-10");
        }
        if (Series.dirFor(QRANDOM)) {
            Series.cX2("qrandom/bdd-15-21-2", "bdd", "15-21-2");
            Series.cX2("qrandom/bdd-18-21-2", "bdd", "18-21-2");
            Series.cX2("qrandom/mdd-7-25-5", "mdd", "7-25-5");
            Series.cX2("qrandom/mdd-7-25-5-p7", "mdd", "7-25-5-p7");
            Series.cX2("qrandom/mdd-7-25-5-p9", "mdd", "7-25-5-p9");
            Series.cX2("qrandom/composed-25", "composed", "s25");
            Series.cX2("qrandom/composed-75", "composed", "s75");
            Series.cX2("qrandom/ehi-85", "ehi", "s85");
            Series.cX2("qrandom/ehi-90", "ehi", "s90");
            Series.cX2("qrandom/geometric", "geometric", "rw");
            Series.cX2("qrandom/lard", "m1", "lard");
            Series.cX2("seriesPapers/yves/normalized/regular", "reg2ext", "s1");
        }
        if (Series.dirFor(ALL_INTERVAL)) {
            IntStream.of(Series.vals(Series.rangeC(5, 20), Series.rangeC(25, 100, 5))).forEach(i -> Series.exec(ALL_INTERVAL + " -data=" + i + " -dataFormat=%03d  -iag=true"));
        }
        if (Series.dirFor(BIBD)) {
            BiConsumer<int[], String> biConsumer = (t, s) -> {
                String data = "-data=[" + (((int[])t).length == 3 ? t[0] + ",0,0," + t[1] + "," + t[2] : Kit.join(t, ",")) + "]";
                String format = "-dataFormat=" + (((int[])t).length == 3 ? "[%02d,,,%02d,%02d]" : "[%02d,%03d,%02d,%02d,%02d]");
                Series.exec(Bibd.class.getName() + " -variant=sc " + data + " " + format, "sc", s);
                Series.exec(Bibd.class.getName() + " -variant=sum " + data + " " + format, "sum", s);
            };
            for (int[] t2 : new int[][]{{6, 50, 25, 3, 10}, {6, 60, 30, 3, 12}, {6, 70, 35, 3, 10}, {10, 90, 27, 3, 6}, {9, 108, 36, 3, 9}, {15, 70, 14, 3, 2}, {12, 88, 22, 3, 4}, {9, 120, 40, 3, 10}, {10, 120, 36, 3, 8}, {13, 104, 24, 3, 4}}) {
                biConsumer.accept(t2, "lex");
            }
            for (int[] t2 : new int[][]{{7, 7, 3, 3, 1}, {6, 10, 5, 3, 2}, {7, 14, 6, 3, 2}, {9, 12, 4, 3, 1}, {6, 20, 10, 3, 4}, {7, 21, 9, 3, 3}, {6, 30, 15, 3, 6}, {7, 28, 12, 3, 4}, {9, 24, 8, 3, 2}, {6, 40, 20, 3, 8}, {7, 35, 15, 3, 5}, {7, 42, 18, 3, 6}, {10, 30, 9, 3, 2}, {6, 50, 25, 3, 10}, {9, 36, 12, 3, 3}, {13, 26, 6, 3, 1}, {7, 49, 21, 3, 7}, {6, 60, 30, 3, 12}, {7, 56, 24, 3, 8}, {6, 70, 35, 3, 14}, {9, 48, 16, 3, 4}, {7, 63, 27, 3, 9}, {8, 56, 21, 3, 6}, {6, 80, 40, 3, 6}, {7, 70, 30, 3, 10}, {15, 35, 7, 3, 1}, {12, 44, 11, 3, 2}, {7, 77, 33, 3, 11}, {9, 60, 20, 3, 5}, {7, 84, 26, 3, 12}, {10, 60, 18, 3, 4}, {11, 55, 15, 3, 3}, {7, 91, 39, 3, 13}, {9, 72, 24, 3, 6}, {13, 52, 12, 3, 2}, {9, 84, 28, 3, 7}, {9, 36, 32, 3, 8}, {10, 90, 27, 3, 6}, {9, 108, 36, 3, 9}, {13, 78, 18, 3, 3}, {15, 70, 14, 3, 2}, {12, 88, 22, 3, 4}, {9, 120, 40, 3, 10}, {19, 57, 9, 3, 1}, {10, 120, 36, 3, 8}, {11, 110, 30, 3, 6}, {16, 80, 15, 3, 2}, {13, 104, 24, 3, 4}}) {
                biConsumer.accept(t2, "sym");
            }
            for (int[] t2 : new int[][]{{8, 4, 6}, {7, 3, 10}, {6, 3, 10}, {6, 3, 12}, {12, 6, 5}, {13, 4, 2}, {9, 3, 9}, {9, 3, 10}, {11, 5, 4}, {16, 6, 3}, {16, 4, 1}, {10, 3, 6}, {19, 9, 4}, {12, 3, 4}, {10, 3, 8}, {13, 3, 4}, {16, 6, 2}, {15, 3, 1}, {15, 3, 2}, {15, 5, 2}, {25, 9, 3}, {25, 5, 1}, {21, 5, 1}, {22, 7, 2}}) {
                biConsumer.accept(t2, "stab1");
            }
            for (int[] t2 : new int[][]{{6, 3, 2}, {7, 3, 1}, {6, 3, 4}, {9, 3, 1}, {7, 3, 2}, {8, 4, 3}, {6, 3, 6}, {11, 5, 2}, {10, 4, 2}, {7, 3, 3}, {13, 4, 1}, {6, 3, 8}, {9, 4, 3}, {16, 4, 1}, {7, 3, 4}, {6, 3, 10}, {9, 3, 2}, {16, 6, 2}, {15, 5, 2}, {13, 3, 1}, {7, 3, 5}, {15, 7, 3}, {21, 5, 1}, {25, 5, 1}, {10, 5, 4}, {7, 3, 6}, {22, 7, 2}, {7, 3, 7}, {8, 4, 6}, {19, 9, 4}, {10, 3, 2}, {31, 6, 1}, {7, 3, 8}, {9, 3, 3}, {7, 3, 9}, {15, 3, 1}, {21, 6, 2}, {13, 4, 2}, {11, 5, 4}, {12, 6, 5}, {25, 9, 3}, {16, 6, 3}}) {
                biConsumer.accept(t2, "stab2");
            }
            for (int[] t2 : new int[][]{{3, 3, 1}, {4, 2, 1}, {6, 3, 2}, {7, 3, 1}, {7, 3, 2}, {8, 4, 3}, {9, 3, 1}, {11, 5, 2}, {13, 3, 1}, {13, 4, 1}, {15, 3, 1}, {15, 7, 3}, {16, 4, 1}, {19, 3, 1}, {25, 5, 1}, {28, 4, 1}}) {
                biConsumer.accept(t2, "mini");
            }
            int[][] nArrayArray = new int[][]{{46, 69, 9, 6, 1}, {51, 85, 10, 6, 1}, {61, 122, 12, 6, 1}, {22, 33, 12, 8, 4}, {40, 52, 13, 10, 3}, {46, 69, 15, 10, 3}, {65, 80, 16, 13, 3}, {81, 81, 16, 16, 3}, {49, 98, 18, 9, 3}, {55, 99, 18, 10, 3}, {85, 102, 18, 15, 3}, {39, 57, 19, 13, 6}, {61, 122, 20, 10, 3}, {46, 92, 20, 10, 4}, {45, 75, 20, 12, 5}, {57, 76, 20, 15, 5}, {57, 133, 21, 9, 3}, {40, 60, 21, 14, 7}, {85, 105, 21, 17, 4}, {45, 90, 22, 11, 5}, {45, 66, 22, 15, 7}, {55, 132, 24, 10, 4}, {69, 92, 24, 18, 6}, {51, 85, 25, 15, 7}, {51, 75, 25, 17, 8}, {55, 135, 27, 11, 5}, {55, 99, 27, 15, 7}, {57, 84, 28, 19, 9}, {57, 76, 28, 21, 10}, {85, 85, 28, 28, 9}, {34, 85, 30, 12, 10}, {58, 87, 30, 20, 10}, {56, 88, 33, 21, 12}, {78, 117, 33, 22, 9}, {64, 96, 33, 22, 11}, {97, 97, 33, 33, 11}, {69, 102, 34, 23, 11}, {46, 161, 35, 10, 7}, {51, 85, 35, 21, 14}, {64, 80, 35, 28, 15}, {69, 138, 36, 18, 9}, {52, 104, 36, 18, 12}, {49, 84, 36, 21, 15}, {55, 90, 36, 22, 14}, {70, 105, 36, 24, 12}, {85, 85, 36, 36, 15}, {75, 111, 37, 25, 12}, {58, 116, 38, 19, 12}, {76, 114, 39, 26, 13}, {66, 99, 39, 26, 15}, {57, 152, 40, 15, 10}, {65, 104, 40, 25, 15}};
            n = nArrayArray.length;
            for (int j = 0; j < n; ++j) {
                int[] t2 = nArrayArray[j];
                biConsumer.accept(t2, "open");
            }
        }
        if (Series.dirFor(BLACK_HOLE)) {
            void var1_9;
            void var1_7;
            void var1_5;
            void var1_3;
            boolean bl = false;
            while (var1_3 < 20) {
                Series.exec(Blackhole_Random.class.getName() + " 4 3 " + (int)var1_3, "s04");
                ++var1_3;
            }
            boolean bl2 = false;
            while (var1_5 < 20) {
                Series.exec(Blackhole_Random.class.getName() + " 7 3 " + (int)var1_5, "s07");
                ++var1_5;
            }
            boolean bl3 = false;
            while (var1_7 < 20) {
                Series.exec(Blackhole_Random.class.getName() + " 10 3 " + (int)var1_7, "s10");
                ++var1_7;
            }
            boolean bl4 = false;
            while (var1_9 < 20) {
                Series.exec(Blackhole_Random.class.getName() + " 13 3 " + (int)var1_9, "s13");
                ++var1_9;
            }
            Series.cX2("benchmarks2006/blackHole/BH-4-04", "xcsp2", "s04");
            Series.cX2("benchmarks2006/blackHole/BH-4-07", "xcsp2", "s07");
            Series.cX2("benchmarks2006/blackHole/BH-4-13", "xcsp2", "s13");
        }
        if (Series.dirFor(CHESSBOARD_COLORATION)) {
            int[] nArray = Series.vals(Series.rangeC(5, 20), Series.rangeC(25, 40, 5));
            int n2 = nArray.length;
            for (n = 0; n < n2; ++n) {
                int i32 = nArray[n];
                Series.exec(BoardColoration.class.getName() + " -data=[" + i32 + "," + i32 + "] -dataFormat=[%02d,%02d] -f=cop ", 12000, "s1");
            }
            int[] nArray2 = Series.vals(Series.rangeC(5, 20), Series.rangeC(25, 40, 5));
            int n3 = nArray2.length;
            for (n = 0; n < n3; ++n) {
                i2 = nArray2[n];
                Series.exec(BoardColoration.class.getName() + " -data=[" + (i2 - 2) + "," + i2 + "] -dataFormat=[%02d,%02d] -f=cop ", 8000, "s2");
            }
        }
        if (Series.dirFor(COLOURED_QUEENS)) {
            Series.rangeC(3, 19).execute(i -> Series.exec(COLOURED_QUEENS + " -data=" + i));
        }
        if (Series.dirFor(DISTINCT_VECTORS)) {
            int[] nArray = new int[]{5, 10, 20, 50, 100, 200};
            int n4 = nArray.length;
            for (n = 0; n < n4; ++n) {
                i2 = nArray[n];
                Series.exec(DistinctVectors.class.getName() + " -data=[30," + i2 + ",2] -dataFormat=[%02d,%03d,%02d]", "s1");
            }
            int[] nArray3 = new int[]{5, 10, 20, 50};
            int n5 = nArray3.length;
            for (n = 0; n < n5; ++n) {
                i2 = nArray3[n];
                Series.exec(DistinctVectors.class.getName() + " -data=[" + i2 + ",100,2] -dataFormat=[%02d,%03d,%02d]", "s1");
            }
            int[] nArray4 = new int[]{2, 8, 16, 24, 32, 40};
            int n6 = nArray4.length;
            for (n = 0; n < n6; ++n) {
                i2 = nArray4[n];
                Series.exec(DistinctVectors.class.getName() + " -data=[40,100," + i2 + "] -dataFormat=[%02d,%03d,%02d]", "s1");
            }
        }
        if (Series.dirFor(DOMINO)) {
            void var1_24;
            void var1_22;
            void var1_20;
            void var1_18;
            int n7 = 100;
            while (var1_18 <= 1000) {
                Series.exec(Domino.class.getName() + " -data=[100," + (int)var1_18 + "]");
                var1_18 += 100;
            }
            int n8 = 100;
            while (var1_20 <= 1000) {
                Series.exec(Domino.class.getName() + " -data=[" + (int)var1_20 + ",100]");
                var1_20 += 100;
            }
            int n9 = 100;
            while (var1_22 < 1000) {
                Series.exec(Domino.class.getName() + " -data=[" + (int)var1_22 + "," + (int)var1_22 + "]");
                var1_22 += 100;
            }
            int n10 = 1000;
            while (var1_24 <= 10000) {
                Series.exec(Domino.class.getName() + " -data=[" + (int)var1_24 + "," + (int)var1_24 + "]");
                var1_24 += 1000;
            }
        }
        if (Series.dirFor(DUBOIS)) {
            int[] nArray = Series.vals(Series.rangeC(15, 30), Series.rangeC(35, 100, 5));
            int n11 = nArray.length;
            for (n = 0; n < n11; ++n) {
                i2 = nArray[n];
                Series.exec(Dubois.class.getName() + " -data=" + i2 + " -dataFormat=%03d");
            }
        }
        if (Series.dirFor(GOLOMB)) {
            void var1_33;
            void var1_31;
            void var1_29;
            void var1_27;
            int n12 = 5;
            while (var1_27 < 20) {
                Series.exec("problems.acad.GolombRuler -data=" + (int)var1_27 + " -dataFormat=%02d -variant=a3 -f=cop ", "a3", "s1");
                ++var1_27;
            }
            int n13 = 5;
            while (var1_29 < 20) {
                Series.exec("problems.acad.GolombRuler -data=" + (int)var1_29 + " -dataFormat=%02d -variant=a4 -f=cop ", "a4", "s1");
                ++var1_29;
            }
            int n14 = 20;
            while (var1_31 < 30) {
                Series.exec("problems.acad.GolombRuler -data=" + (int)var1_31 + " -dataFormat=%02d -variant=a3 -f=cop ", 12000, "a3", "s1");
                ++var1_31;
            }
            int n15 = 20;
            while (var1_33 < 30) {
                Series.exec("problems.acad.GolombRuler -data=" + (int)var1_33 + " -dataFormat=%02d -variant=a4 -f=cop ", 12000, "a4", "s1");
                ++var1_33;
            }
        }
        if (Series.dirFor(GRACEFUL)) {
            void var1_35;
            int n16 = 2;
            while (var1_35 < 15) {
                void var2_193;
                int n17 = 2;
                while (var2_193 < 10) {
                    Series.exec(GracefulGraph.class.getName() + " -data=[" + (int)var1_35 + "," + (int)var2_193 + "] -dataFormat=[K%02d,P%02d] ");
                    ++var2_193;
                }
                ++var1_35;
            }
        }
        if (Series.dirFor(HANOI)) {
            void var1_37;
            int n18 = 3;
            while (var1_37 < 10) {
                Series.exec(Hanoi.class.getName() + " -data=" + (int)var1_37 + " -dataFormat=%02d", 8000);
                ++var1_37;
            }
        }
        if (Series.dirFor(KNAPSACK)) {
            Series.range(20).execute(i -> Series.exec(KNAPSACK + " 30 100 " + i + " -f=cop ", "s30"));
            Series.range(20).execute(i -> Series.exec(KNAPSACK + " 40 150 " + i + " -f=cop ", "s40"));
            Series.range(20).execute(i -> Series.exec(KNAPSACK + " 50 200 " + i + " -f=cop ", "s50"));
            Series.range(20).execute(i -> Series.exec(KNAPSACK + " 60 250 " + i + " -f=cop ", "s60"));
        }
        if (Series.dirFor(KNIGHTS)) {
            int[] nArray = new int[]{8, 10, 12, 15, 20, 25, 50, 80, 100};
            int n19 = nArray.length;
            for (n = 0; n < n19; ++n) {
                i2 = nArray[n];
                for (int j2 : new int[]{5, 9, 25}) {
                    if (j2 != 5 && (j2 != 9 || i2 < 12) && (j2 != 25 || i2 < 50)) continue;
                    Series.exec(Knights.class.getName() + " -data=[" + i2 + "," + j2 + "] -dataFormat=[%03d,%02d] -exai=no -exmo=yes");
                }
            }
        }
        if (Series.dirFor(KNIGHT_TOUR)) {
            void var1_42;
            void var1_40;
            int n20 = 4;
            while (var1_40 <= 17) {
                Series.exec(KnightTour.class.getName() + " -data=" + (int)var1_40 + " -dataFormat=%02d -variant=int -exai=no -exmo=yes", 12000, "int", "s1");
                ++var1_40;
            }
            int n21 = 4;
            while (var1_42 <= 17) {
                void var2_196;
                int n22 = 2;
                while (var2_196 < var1_42) {
                    if (var1_42 % (var2_196 - true) == false && (var1_42 != 16 || var2_196 != 9)) {
                        Series.exec(KnightTour.class.getName() + " -data=" + (int)var1_42 + " -dataFormat=%02d -variant=ext" + (int)var2_196 + " -exai=no -exmo=yes", 12000, "ext", "s1");
                    }
                    ++var2_196;
                }
                ++var1_42;
            }
        }
        if (Series.dirFor(LANGFORD)) {
            void var1_44;
            int n23 = 2;
            while (var1_44 <= 4) {
                int[] nArray = Series.vals(Series.rangeC(2, 25), Series.rangeC(30, 50, 5), Series.rangeC(60, 90, 10));
                n = nArray.length;
                for (i2 = 0; i2 < n; ++i2) {
                    int n6 = nArray[i2];
                    Series.exec(Langford.class.getName() + " -data=[" + (int)var1_44 + "," + n6 + "] -dataFormat=[%01d,%02d]", "k" + (int)var1_44);
                }
                ++var1_44;
            }
            int[] nArray = Series.vals(Series.rangeC(2, 25), Series.rangeC(30, 50, 5), Series.rangeC(60, 90, 10));
            int n24 = nArray.length;
            for (n = 0; n < n24; ++n) {
                int n9 = nArray[n];
                Series.exec(LangfordBin.class.getName() + " -data=" + n9 + " -dataFormat=%02d", "m2", "s1");
            }
        }
        if (Series.dirFor(LOW_AUTOCORRELATION)) {
            void var1_47;
            int n25 = 3;
            while (var1_47 < 100) {
                Series.exec(LowAutocorrelation.class.getName() + " -data=" + (int)var1_47 + " -dataFormat=%03d -f=cop");
                ++var1_47;
            }
        }
        if (Series.dirFor(ORTHOLATIN)) {
            void var1_49;
            int n26 = 2;
            while (var1_49 < 30) {
                Series.exec(Ortholatin.class.getName() + " -data=" + (int)var1_49 + " -dataFormat=%03d -iag=true");
                ++var1_49;
            }
        }
        if (Series.dirFor(QUADRATIC_ASSIGNMENT)) {
            File[] fileArray = new File("/home/lecoutre/instances/qap/data").listFiles();
            int n27 = fileArray.length;
            for (n = 0; n < n27; ++n) {
                File f4 = fileArray[n];
                Series.exec(QuadraticAssignment_Parser.class.getName() + " " + f4.getAbsolutePath() + " -f=cop", 12000);
            }
        }
        if (Series.dirFor(QUEEN_ATTACKING)) {
            void var1_53;
            File[] fileArray = new File("/home/lecoutre/instances/benchmarks2006/queenAttacking").listFiles();
            int n28 = fileArray.length;
            for (n = 0; n < n28; ++n) {
                File f5 = fileArray[n];
                Series.exec("problems.xcsp2.XCSP2 " + f5.getAbsolutePath() + " -exai=no -exmo=yes", "xcsp2", "s1");
            }
            int n29 = 3;
            while (var1_53 <= 20) {
                Series.exec(QueenAttacking.class.getName() + " -data=" + (int)var1_53 + " -dataFormat=%02d -f=cop -exai=no -exmo=yes");
                ++var1_53;
            }
        }
        if (Series.dirFor(QUEENS)) {
            int[] nArray = Series.vals(Series.rangeC(4, 12), 15, 20, 30, 50, 80, 100, 120, 150, 180, 200, 300, 400, 500, 800, 1000);
            int n30 = nArray.length;
            for (n = 0; n < n30; ++n) {
                i2 = nArray[n];
                Series.exec("problems.acad.Queens " + i2 + " 0", 8000);
            }
        }
        if (Series.dirFor(QUEENS_KNIGHTS)) {
            int n31;
            int[] nArray = new int[]{8, 10, 12, 15, 20, 25, 50, 80, 100};
            int n32 = nArray.length;
            for (n = 0; n < n32; ++n) {
                n31 = nArray[n];
                Series.exec(QueensKnights.class.getName() + " -data=[" + n31 + "," + n31 + ",5] -dataFormat=[%03d,%03d,%02d] -variant=add -exai=yes -exmo=yes");
            }
            int[] nArray5 = new int[]{8, 10, 12, 15, 20, 25, 50, 80, 100};
            int n33 = nArray5.length;
            for (n = 0; n < n33; ++n) {
                n31 = nArray5[n];
                Series.exec(QueensKnights.class.getName() + " -data=[" + n31 + "," + n31 + ",5] -dataFormat=[%03d,%03d,%02d] -variant=mul -exai=yes -exmo=yes");
            }
        }
        if (Series.dirFor(RAMSEY)) {
            void var1_58;
            int n34 = 8;
            while (var1_58 < 51) {
                Series.exec(Ramsey.class.getName() + " -data=" + (int)var1_58 + " -dataFormat=%02d -f=cop");
                ++var1_58;
            }
        }
        if (Series.dirFor(RECT_PACKING)) {
            File[] fileArray = new File("/home/lecoutre/instances/DataJSON/RectPacking/dataPerf2").listFiles();
            int n35 = fileArray.length;
            for (n = 0; n < n35; ++n) {
                File f6 = fileArray[n];
                Series.exec(RectPacking.class.getName() + " -data=" + f6.getAbsolutePath(), "perf");
            }
        }
        if (Series.dirFor(SCHURR)) {
            int[] nArray = Series.vals(12, 15, 20, 30, 50, 100);
            int n36 = nArray.length;
            for (n = 0; n < n36; ++n) {
                i2 = nArray[n];
                Series.exec(SchurrLemma.class.getName() + " -data=[" + i2 + ",9] -dataFormat=[%03d,%01d] -variant=mod", "mod", "s1");
            }
            Series.exec(SchurrLemma.class.getName() + " -data=[23,3] -dataFormat=[%03d,%01d] -variant=nor", "nor", "s1");
            Series.exec(SchurrLemma.class.getName() + " -data=[24,3] -dataFormat=[%03d,%01d] -variant=nor", "nor", "s1");
            Series.exec(SchurrLemma.class.getName() + " -data=[66,4] -dataFormat=[%03d,%01d] -variant=nor", "nor", "s1");
            Series.exec(SchurrLemma.class.getName() + " -data=[67,4] -dataFormat=[%03d,%01d] -variant=nor", "nor", "s1");
        }
        if (Series.dirFor(STEINER3)) {
            Series.rangeC(5, 14).execute(i -> Series.exec(Steiner3.class.getName() + " -data=" + i + " -dataFormat=%02d", 12000));
        }
        if (Series.dirFor(STRIP_PACKING)) {
            Series.range(21).execute(i -> Series.exec(StripPackingReader.class.getName() + " " + PATH + "tdsp/data/series1.txt " + i, "series1"));
            Series.range(36).execute(i -> Series.exec(StripPackingReader.class.getName() + " " + PATH + "tdsp/data/seriesN.txt " + i, "seriesN"));
            Series.range(36).execute(i -> Series.exec(StripPackingReader.class.getName() + " " + PATH + "tdsp/data/seriesT.txt " + i, "seriesT"));
        }
        if (Series.dirFor(RADAR_SURVEILLANCE)) {
            void var1_66;
            void var1_64;
            void var1_62;
            boolean bl = false;
            while (var1_62 < 50) {
                Series.exec(RadarSurveillance_Random.class.getName() + " 8 24 3 2 0 " + (int)var1_62 + " -iag=true", "s8-24");
                ++var1_62;
            }
            boolean bl5 = false;
            while (var1_64 < 50) {
                Series.exec(RadarSurveillance_Random.class.getName() + " 8 30 3 0 0 " + (int)var1_64 + " -iag=true", "s8-30");
                ++var1_64;
            }
            boolean bl6 = false;
            while (var1_66 < 50) {
                Series.exec(RadarSurveillance_Random.class.getName() + " 9 28 4 2 0 " + (int)var1_66 + " -iag=true", "s9-28");
                ++var1_66;
            }
        }
        if (Series.dirFor(ROOM_MATE)) {
            File[] fileArray = new File("/home/lecoutre/instances/roommate").listFiles();
            int n37 = fileArray.length;
            for (n = 0; n < n37; ++n) {
                File f322 = fileArray[n];
                Series.exec(RoomMate.class.getName() + "problems.patt.RoomMate " + f322.getAbsolutePath() + " -variant=int", 12000, "int", "s1");
            }
        }
        if (Series.dirFor(SOCIAL_GOLFERS)) {
            void var1_69;
            Series.cX2("benchmarks2006/socialGolfers", "xcsp2", "s1");
            int n38 = 2;
            while (var1_69 <= 9) {
                void var2_208;
                int n39 = 2;
                while (var2_208 <= 9) {
                    for (int k = 3; k <= 9; ++k) {
                        Series.exec("problems.patt.SocialGolfers -data=[" + (int)var1_69 + "," + (int)var2_208 + "," + k + "] -variant=cp", "cp", "s1");
                    }
                    ++var2_208;
                }
                ++var1_69;
            }
        }
        if (Series.dirFor(SUBISOMORPHISM)) {
            int j;
            void var2_210;
            File[] fileArray = new File("/home/lecoutre/instances/isoGraphs/newSIPbenchmarks/LV").listFiles();
            Arrays.sort(fileArray, (f1, f2) -> f1.getName().compareTo(f2.getName()));
            boolean bl = false;
            while (var2_210 < fileArray.length) {
                for (j = var2_210 + true; j < fileArray.length; ++j) {
                    Series.exec("problems.patt.Subisomorphism " + fileArray[var2_210].getAbsolutePath() + " " + fileArray[j].getAbsolutePath(), "LV");
                }
                ++var2_210;
            }
            for (File f7 : new File("/home/lecoutre/instances/isoGraphs/newSIPbenchmarks/scalefree").listFiles()) {
                Series.exec("problems.patt.Subisomorphism " + f7.getAbsolutePath() + "/pattern " + f7.getAbsolutePath() + "/target", "SF");
            }
            for (File f8 : new File("/home/lecoutre/instances/isoGraphs/newSIPbenchmarks/si/si2-bvg").listFiles()) {
                Series.exec("problems.patt.Subisomorphism " + f8.getAbsolutePath() + "/pattern " + f8.getAbsolutePath() + "/target", "si2-bvg");
            }
            for (File f9 : new File("/home/lecoutre/instances/isoGraphs/newSIPbenchmarks/si/si2-m4D").listFiles()) {
                Series.exec("problems.patt.Subisomorphism " + f9.getAbsolutePath() + "/pattern " + f9.getAbsolutePath() + "/target", "si2-m4D");
            }
            for (File f10 : new File("/home/lecoutre/instances/isoGraphs/newSIPbenchmarks/si/si2-rand").listFiles()) {
                Series.exec("problems.patt.Subisomorphism " + f10.getAbsolutePath() + "/pattern " + f10.getAbsolutePath() + "/target", "si2-rand");
            }
            for (File f11 : new File("/home/lecoutre/instances/isoGraphs/newSIPbenchmarks/si/si4-bvg").listFiles()) {
                Series.exec("problems.patt.Subisomorphism " + f11.getAbsolutePath() + "/pattern " + f11.getAbsolutePath() + "/target", "si4-bvg");
            }
            for (File f12 : new File("/home/lecoutre/instances/isoGraphs/newSIPbenchmarks/si/si4-m4D").listFiles()) {
                Series.exec("problems.patt.Subisomorphism " + f12.getAbsolutePath() + "/pattern " + f12.getAbsolutePath() + "/target", "si4-m4D");
            }
            for (File f13 : new File("/home/lecoutre/instances/isoGraphs/newSIPbenchmarks/si/si4-rand").listFiles()) {
                Series.exec("problems.patt.Subisomorphism " + f13.getAbsolutePath() + "/pattern " + f13.getAbsolutePath() + "/target", "si4-rand");
            }
            for (File f14 : new File("/home/lecoutre/instances/isoGraphs/newSIPbenchmarks/si/si6-bvg").listFiles()) {
                Series.exec("problems.patt.Subisomorphism " + f14.getAbsolutePath() + "/pattern " + f14.getAbsolutePath() + "/target", "si6-bvg");
            }
            for (File f15 : new File("/home/lecoutre/instances/isoGraphs/newSIPbenchmarks/si/si6-m4D").listFiles()) {
                Series.exec("problems.patt.Subisomorphism " + f15.getAbsolutePath() + "/pattern " + f15.getAbsolutePath() + "/target", "si6-m4D");
            }
            File[] fileArray2 = new File("/home/lecoutre/instances/isoGraphs/newSIPbenchmarks/si/si6-rand").listFiles();
            j = fileArray2.length;
            for (f322 = 0; f322 < j; ++f322) {
                File f16 = fileArray2[f322];
                Series.exec("problems.patt.Subisomorphism " + f16.getAbsolutePath() + "/pattern " + f16.getAbsolutePath() + "/target", "si6-rand");
            }
        }
        if (Series.dirFor(TRAVELLING_SALESMAN)) {
            Series.cX2("benchmarks2006/travellingSalesman/tsp-20", "xcsp2", "s20");
            Series.cX2("benchmarks2006/travellingSalesman/tsp-25", "xcsp2", "s25");
            Series.cX2("seriesPapers/yves/normalized/TSP-20-QUAT", "xcsp2", "s20a4");
            Function<String, String> function = data -> TravellingSalesmanRandom.class.getName() + " " + data + " -dataFormat=[%03d,%02d,%02d] -f=cop ";
            Iterator iterator = Series.rangeC(15, 50, 5).iterator();
            while (iterator.hasNext()) {
                int nCities = (Integer)iterator.next();
                Series.range(20).execute(seed -> Series.exec((String)f17.apply(nCities + " 30 " + seed), "n" + nCities));
            }
            int[] nArray = Series.vals(75, 100, 150);
            n = nArray.length;
            for (f322 = 0; f322 < n; ++f322) {
                int nCities = nArray[f322];
                Series.range(20).execute(seed -> Series.exec((String)function.apply(nCities + " 50 " + seed), "n" + nCities));
            }
        }
        if (Series.dirFor(WAREHOUSE)) {
            File[] fileArray = new File("/home/lecoutre/instances/warehouse").listFiles();
            int n40 = fileArray.length;
            for (n = 0; n < n40; ++n) {
                File f18 = fileArray[n];
                Series.exec(Warehouse_Parser.class.getName() + " " + f18.getAbsolutePath() + " -f=cop");
            }
        }
        if (Series.dirFor(BASIC)) {
            Series.exec("problems.puzz.Allergy -iag=true");
            Series.exec("problems.puzz.Change -data=[82,100] -f=cop");
            Series.exec("problems.puzz.Purdey -iag=true");
            Series.exec("problems.puzz.Recipe -f=cop");
            Series.exec("problems.puzz.Dominoes /home/lecoutre/instances/puzzles/dominoes/txt/grid1.txt -exai=yes -exmo=yes");
            Series.exec("problems.puzz.LabeledDice");
            Series.exec("problems.puzz.Zebra -iag=true");
        }
        if (Series.dirFor(CRYPTO_PUZZLE)) {
            String[] stringArray = new String[]{"donald gerald robert", "summer school coolest", "send more money", "no no yes", "cross roads danger", "europa planets neptune", "comet uranus saturn", "black green orange", "ivory purple violet", "piccolo violin panpipe", " bell flute violin", "kyoto osaka tokyo", "kendo kimono sashimi", "cabbage lettuce eggplant", "pepper potato celery", "basic simula pascal", "ada scala cobol", "monitor network internet", "apple floppy reboot", "okayama yamagata kanazawa", "tottori yamagata yokohama"};
            int n41 = stringArray.length;
            for (n = 0; n < n41; ++n) {
                String s3 = stringArray[n];
                String[] t3 = s3.trim().toUpperCase().split("\\s+");
                Series.exec(CryptoPuzzle.class.getName() + " -data=[" + t3[0] + "," + t3[1] + "," + t3[2] + "]");
            }
        }
        if (Series.dirFor(KAKURO)) {
            void var1_79;
            void var1_77;
            void var1_75;
            boolean bl = false;
            while (var1_75 < 172) {
                Series.exec(KakuroReader.class.getName() + " " + PATH + "kakuro/data/data_generated_easy.ecl " + (int)var1_75 + " -variant=sumdiff", "sumdiff", "easy");
                ++var1_75;
            }
            boolean bl7 = false;
            while (var1_77 < 192) {
                Series.exec(KakuroReader.class.getName() + " " + PATH + "kakuro/data/data_generated_medium.ecl " + (int)var1_77 + " -variant=sumdiff", "sumdiff", "medium");
                ++var1_77;
            }
            boolean bl8 = false;
            while (var1_79 < 187) {
                Series.exec(KakuroReader.class.getName() + " " + PATH + "kakuro/data/data_generated_hard.ecl " + (int)var1_79 + " -variant=suumdiff", "sumdiff", "hard");
                ++var1_79;
            }
        }
        if (Series.dirFor(MAGIC_SEQUENCE)) {
            int[] nArray = Series.vals(Series.rangeC(3, 20), Series.rangeC(25, 50, 5), Series.rangeC(60, 100, 10), Series.rangeC(120, 200, 20), Series.rangeC(300, 1000, 100), 2000);
            int n42 = nArray.length;
            for (n = 0; n < n42; ++n) {
                i2 = nArray[n];
                Series.exec(MagicSequence.class.getName() + " -data=" + i2 + " -dataFormat=%03d -variant=card ", "card", "s1");
            }
        }
        if (Series.dirFor(SUDOKU)) {
            File[] fileArray = new File("/home/lecoutre/instances/sudoku/series1").listFiles();
            int n43 = fileArray.length;
            for (n = 0; n < n43; ++n) {
                File f19 = fileArray[n];
                Series.exec(Sudoku_Parser.class.getName() + " 9 " + f19.getAbsolutePath() + " -variant=table", "table", "s1");
            }
            File[] fileArray3 = new File("/home/lecoutre/instances/sudoku/series1").listFiles();
            int n44 = fileArray3.length;
            for (n = 0; n < n44; ++n) {
                File f20 = fileArray3[n];
                Series.exec(Sudoku_Parser.class.getName() + " 9 " + f20.getAbsolutePath() + " -variant=alldiff", "alldiff", "s1");
            }
        }
        if (Series.dirFor(CAR_SEQUENCING)) {
            File[] fileArray = new File("/home/lecoutre/instances/vincent/carSequencing/jcr").listFiles();
            int n45 = fileArray.length;
            for (n = 0; n < n45; ++n) {
                File f21 = fileArray[n];
                Series.exec(CarSequencing.class.getName() + " " + f21.getAbsolutePath(), "jcr");
            }
            File[] fileArray4 = new File("/home/lecoutre/instances/vincent/carSequencing/gagne").listFiles();
            int n46 = fileArray4.length;
            for (n = 0; n < n46; ++n) {
                File f22 = fileArray4[n];
                Series.exec(CarSequencing.class.getName() + " " + f22.getAbsolutePath(), "gagne");
            }
        }
        if (Series.dirFor(RENAULT_MOD)) {
            File[] fileArray = new File("/home/lecoutre/instances/modifiedRenault/originals").listFiles();
            int n47 = fileArray.length;
            for (n = 0; n < n47; ++n) {
                File f23 = fileArray[n];
                Series.exec("problems.tran.RenaultMod " + f23.getAbsolutePath());
            }
        }
        if (Series.dirFor(RENAULT)) {
            File[] fileArray = new File("/home/lecoutre/instances/helene/xcsp2").listFiles();
            int n48 = fileArray.length;
            for (n = 0; n < n48; ++n) {
                File f24 = fileArray[n];
                Series.exec(f24.getAbsolutePath());
            }
        }
        if (Series.dirFor(RLFAP_OLD)) {
            void var1_95;
            void var1_93;
            void var1_88;
            boolean bl = true;
            while (var1_88 <= 14) {
                Series.exec("problems.real.Rlfap /home/lecoutre/instances/rlfap 1 " + (int)var1_88 + " -1 -1 ", "graphs");
                ++var1_88;
            }
            int[] nArray = Series.vals(Series.rangeC(1, 9), 11);
            int n49 = nArray.length;
            for (n = 0; n < n49; ++n) {
                i2 = nArray[n];
                Series.exec("problems.real.Rlfap /home/lecoutre/instances/rlfap 0 " + i2 + " -1 -1 ", "scens");
            }
            int[][] nArrayArray = new int[][]{{2, -1, 24}, {2, -1, 25}, {8, -1, 10}, {8, -1, 11}, {9, -1, 9}, {9, -1, 10}, {12, 0, -1}, {12, 1, -1}, {13, 0, -1}, {13, 1, -1}, {14, -1, 27}, {14, -1, 28}};
            int n50 = nArrayArray.length;
            for (n = 0; n < n50; ++n) {
                int[] t4 = nArrayArray[n];
                Series.exec("problems.real.Rlfap /home/lecoutre/instances/rlfap 1 " + Kit.join((Object)t4, new String[0]), "graphsMod");
            }
            int[][] nArrayArray2 = new int[][]{{1, -1, 8}, {1, -1, 9}, {2, -1, 24}, {2, -1, 25}, {3, -1, 10}, {3, -1, 11}, {6, 1, 2}, {6, 1, -1}, {6, 2, -1}, {7, 1, 4}, {7, 1, 5}, {9, 1, 3}};
            int n51 = nArrayArray2.length;
            for (n = 0; n < n51; ++n) {
                int[] t5 = nArrayArray2[n];
                Series.exec("problems.real.Rlfap /home/lecoutre/instances/rlfap 0 " + Kit.join((Object)t5, new String[0]), "scensMod");
            }
            boolean bl9 = true;
            while (var1_93 <= 12) {
                Series.exec("problems.real.Rlfap /home/lecoutre/instances/rlfap 0 11 -1 " + (int)var1_93, "scens11");
                ++var1_93;
            }
            int n52 = 2;
            while (var1_95 <= 3) {
                for (int j = 0; j <= 4; ++j) {
                    if (var1_95 == 3 && j == 0) continue;
                    Series.exec("problems.real.Rlfap /home/lecoutre/instances/rlfap " + (int)var1_95 + " " + j + " -1 -1 ", "subs");
                }
                ++var1_95;
            }
        }
        if (Series.dirFor(CROSSWORD)) {
            String[] stringArray = new String[]{"lex", "words", "uk", "ogd", "ogd2008"};
            int n53 = stringArray.length;
            for (n = 0; n < n53; ++n) {
                String dict = stringArray[n];
                String prefix = "problems.real.crossword.Crossword -data=[/home/lecoutre/instances/crossword/dictionaries/" + dict + "Dict/" + dict;
                for (File f25 : new File("/home/lecoutre/instances/crossword/grids/herald/").listFiles()) {
                    try {
                        Series.exec(prefix + "," + f25.getAbsolutePath() + "] -variant=m1", dict + "-herald");
                    }
                    catch (Exception exception) {
                        System.err.println("Not possible for " + f25.getAbsolutePath());
                    }
                }
                for (File f3 : new File("/home/lecoutre/instances/crossword/grids/puzzle/").listFiles()) {
                    try {
                        Series.exec(prefix + "," + f3.getAbsolutePath() + "] -variant=m1", dict + "-puzzle");
                    }
                    catch (Exception exception) {
                        System.err.println("Not possible for " + f3.getAbsolutePath());
                    }
                }
                for (int i22 = 4; i22 <= 16; ++i22) {
                    for (int j3 = i22; j3 < i22 + 5; ++j3) {
                        Series.exec(prefix + ",vg-" + i22 + "-" + j3 + "] -variant=m1", dict + "-vg");
                    }
                }
            }
        }
        if (Series.dirFor(SPORTS_SCHEDULING)) {
            Series.rangeC(4, 40, 2).execute(i -> Series.exec(SportsScheduling.class.getName() + " -data=" + i + " -dataFormat=%02d"));
        }
        if (Series.dirFor(RCPSP)) {
            File[] fileArray = new File("/home/lecoutre/instances/rcpsp/j30").listFiles();
            int n54 = fileArray.length;
            for (n = 0; n < n54; ++n) {
                File f26 = fileArray[n];
                Series.exec("problems.real.Rcpsp " + f26.getAbsolutePath() + " -f=cop", "j30");
            }
            File[] fileArray5 = new File("/home/lecoutre/instances/rcpsp/j60").listFiles();
            int n55 = fileArray5.length;
            for (n = 0; n < n55; ++n) {
                File f27 = fileArray5[n];
                Series.exec("problems.real.Rcpsp " + f27.getAbsolutePath() + " -f=cop", "j60");
            }
            File[] fileArray6 = new File("/home/lecoutre/instances/rcpsp/j90").listFiles();
            int n56 = fileArray6.length;
            for (n = 0; n < n56; ++n) {
                File f28 = fileArray6[n];
                Series.exec("problems.real.Rcpsp " + f28.getAbsolutePath() + " -f=cop", "j90");
            }
            File[] fileArray7 = new File("/home/lecoutre/instances/rcpsp/j120").listFiles();
            int n57 = fileArray7.length;
            for (n = 0; n < n57; ++n) {
                File f29 = fileArray7[n];
                Series.exec("problems.real.Rcpsp " + f29.getAbsolutePath() + " -f=cop", "j120");
            }
        }
        if (Series.dirFor(GRAPH_COLORING)) {
            File[] fileArray = new File("/home/lecoutre/instances/graphColoring/seriesOriginals4XCSP3/mono").listFiles();
            int n58 = fileArray.length;
            for (n = 0; n < n58; ++n) {
                File f30 = fileArray[n];
                Series.exec(GraphColoringReader.class.getName() + " " + f30.getAbsolutePath() + " -f=cop", "mono");
            }
            File[] fileArray8 = new File("/home/lecoutre/instances/graphColoring/seriesOriginals4XCSP3/fixed").listFiles();
            int n59 = fileArray8.length;
            for (n = 0; n < n59; ++n) {
                File f31 = fileArray8[n];
                Series.exec(GraphColoringReader.class.getName() + " " + f31.getAbsolutePath() + " -f=cop", "fixed");
            }
        }
        if (Series.dirFor(LATIN_SQUARE)) {
            File[] fileArray = new File("/home/lecoutre/instances/seriesPapers/pesant/LatinSquare/").listFiles();
            int n60 = fileArray.length;
            for (n = 0; n < n60; ++n) {
                File f323 = fileArray[n];
                Series.exec(LATIN_SQUARE + " " + f323.getAbsolutePath(), "gp");
            }
            File[] fileArray9 = new File("/home/lecoutre/instances/seriesPapers/PLS-gomez/").listFiles();
            int n61 = fileArray9.length;
            for (n = 0; n < n61; ++n) {
                File f33 = fileArray9[n];
                Series.exec(LATIN_SQUARE + " " + f33.getAbsolutePath(), "gs");
            }
            Series.cX2("benchmarks2006/bqwh/bqwh-15-106", "xcsp2", "bqwh15-106");
            Series.cX2("benchmarks2006/bqwh/bqwh-18-141", "xcsp2", "bqwh18-141");
            Series.cX2("benchmarks2006/qcp-qwh/QCP-10", "xcsp2", "qcp10");
            Series.cX2("benchmarks2006/qcp-qwh/QCP-15", "xcsp2", "qcp15");
            Series.cX2("benchmarks2006/qcp-qwh/QCP-20", "xcsp2", "qcp20");
            Series.cX2("benchmarks2006/qcp-qwh/QCP-25", "xcsp2", "qcp25");
            Series.cX2("benchmarks2006/qcp-qwh/QWH-10", "xcsp2", "qwh10");
            Series.cX2("benchmarks2006/qcp-qwh/QWH-15", "xcsp2", "qwh15");
            Series.cX2("benchmarks2006/qcp-qwh/QWH-20", "xcsp2", "qwh20");
            Series.cX2("benchmarks2006/qcp-qwh/QWH-25", "xcsp2", "qwh25");
        }
        if (Series.dirFor(MAGIC_SQUARE)) {
            void var1_111;
            void var1_109;
            void var1_107;
            File[] fileArray = new File("/home/lecoutre/instances/seriesPapers/pesant/MagicSquare/").listFiles(Series.withExtension(DAT));
            int n62 = fileArray.length;
            for (n = 0; n < n62; ++n) {
                File f34 = fileArray[n];
                Series.exec(MAGIC_SQUARE + " " + f34.getAbsolutePath() + " -variant=sum", "gp");
            }
            int n63 = 3;
            while (var1_107 <= 30) {
                Series.exec(MagicSquare.class.getName() + " -data=[" + (int)var1_107 + ",-] -dataFormat=[%02d,-] -variant=sum", "sum", "s1");
                ++var1_107;
            }
            int n64 = 3;
            while (var1_109 <= 6) {
                Series.exec(MagicSquare.class.getName() + " -data=[" + (int)var1_109 + ",-] -dataFormat=[%02d,-] -variant=ext", 12000, "table", "s1");
                ++var1_109;
            }
            int n65 = 3;
            while (var1_111 <= 30) {
                Series.exec(MagicSquare.class.getName() + " -data=[" + (int)var1_111 + ",-] -dataFormat=[%02d,-] -variant=mdd", 12000, "mdd", "s1");
                ++var1_111;
            }
        }
        if (Series.dirFor(MARKET_SPLIT)) {
            File[] fileArray = new File("/home/lecoutre/instances/seriesPapers/pesant/MarketSplit/").listFiles(Series.withExtension(DAT));
            int n66 = fileArray.length;
            for (n = 0; n < n66; ++n) {
                File f35 = fileArray[n];
                Series.exec(MARKET_SPLIT + " " + f35.getAbsolutePath(), "gp");
            }
        }
        if (Series.dirFor(MULTI_KNAPSACK)) {
            Series.cX2("benchmarks2006/mknap", "xcsp2", "s1");
            File[] fileArray = new File("/home/lecoutre/instances/seriesPapers/pesant/MultiKnapsack/").listFiles(Series.withExtension(DAT));
            int n67 = fileArray.length;
            for (n = 0; n < n67; ++n) {
                File f36 = fileArray[n];
                Series.exec(MULTI_KNAPSACK + " " + f36.getAbsolutePath(), "opt", "gp");
            }
        }
        if (Series.dirFor(NONOGRAM)) {
            File[] fileArray = new File("/home/lecoutre/instances/seriesPapers/pesant/Nonograms/").listFiles(Series.withExtension(DAT));
            int n68 = fileArray.length;
            for (n = 0; n < n68; ++n) {
                File f37 = fileArray[n];
                Series.exec(NONOGRAM + " " + f37.getAbsolutePath() + " -variant=table", 10000, "table", "gp");
            }
            File[] fileArray10 = new File("/home/lecoutre/instances/seriesPapers/pesant/Nonograms/").listFiles(Series.withExtension(DAT));
            int n69 = fileArray10.length;
            for (n = 0; n < n69; ++n) {
                File f38 = fileArray10[n];
                Series.exec(NONOGRAM + " " + f38.getAbsolutePath() + " -variant=regular ", 10000, "regular", "gp");
            }
        }
        if (Series.dirFor(SAT)) {
            File[] fileArray = new File("/home/lecoutre/instances/sat/flat200-479").listFiles();
            int n70 = fileArray.length;
            for (n = 0; n < n70; ++n) {
                File f39 = fileArray[n];
                Series.exec(SAT + " " + f39.getAbsolutePath() + " -variant=clause", "clause", "flat200-479");
            }
            File[] fileArray11 = new File("/home/lecoutre/instances/sat/flat200-479").listFiles();
            int n71 = fileArray11.length;
            for (n = 0; n < n71; ++n) {
                File f40 = fileArray11[n];
                Series.exec(SAT + " " + f40.getAbsolutePath() + " -variant=sum", "sum", "flat200-479");
            }
            File[] fileArray12 = new File("/home/lecoutre/instances/sat/flat200-479").listFiles();
            int n72 = fileArray12.length;
            for (n = 0; n < n72; ++n) {
                File f41 = fileArray12[n];
                Series.exec(SAT + " " + f41.getAbsolutePath() + " -variant=dual", "dual", "flat200-479");
            }
            Series.cX2("benchmarks2006/dimacs/aim-050", "m1", "aim050");
            Series.cX2("benchmarks2006/dimacs/aim-100", "m1", "aim100");
            Series.cX2("benchmarks2006/dimacs/aim-200", "m1", "aim200");
            Series.cX2("benchmarks2006/dimacs/jnh", "m1", "jnh");
            Series.cX2("benchmarks2006/dimacs/varDimacs", "m1", "various");
            File[] fileArray13 = new File("/home/lecoutre/instances/benchmarks2006/bmc").listFiles();
            int n73 = fileArray13.length;
            for (n = 0; n < n73; ++n) {
                File f42 = fileArray13[n];
                Series.exec("problems.xcsp2.XCSP2 " + f42.getAbsolutePath() + " nc=false", "xcsp2", "bmc");
            }
        }
        if (Series.dirFor(DRIVER)) {
            File[] fileArray = new File("/home/lecoutre/instances/benchmarks2006/driver").listFiles();
            int n74 = fileArray.length;
            for (n = 0; n < n74; ++n) {
                File f43 = fileArray[n];
                Series.exec("problems.xcsp2.XCSP2 " + f43.getAbsolutePath());
            }
        }
        if (Series.dirFor(FISCHER)) {
            File[] fileArray = new File("/home/lecoutre/instances/benchmarks2006/fischer").listFiles();
            int n75 = fileArray.length;
            for (n = 0; n < n75; ++n) {
                File f44 = fileArray[n];
                Series.exec("problems.xcsp2.XCSP2 " + f44.getAbsolutePath(), 10000);
            }
        }
        if (Series.dirFor(HAYSTACKS)) {
            File[] fileArray = new File("/home/lecoutre/instances/benchmarks2006/haystacks").listFiles();
            int n76 = fileArray.length;
            for (n = 0; n < n76; ++n) {
                File f45 = fileArray[n];
                Series.exec("problems.xcsp2.XCSP2 " + f45.getAbsolutePath() + " -exai=no ");
            }
        }
        if (Series.dirFor(PRIMES)) {
            Series.cX2("benchmarks2006/primes/primes-10", "m1", "p10");
            Series.cX2("benchmarks2006/primes/primes-15", "m1", "p15");
            Series.cX2("benchmarks2006/primes/primes-20", "m1", "p20");
            Series.cX2("benchmarks2006/primes/primes-25", "m1", "p25");
            Series.cX2("benchmarks2006/primes/primes-30", "m1", "p30");
        }
        if (Series.dirFor(COSTAS_ARRAY)) {
            Series.cX2("XCSP2/costasArray", "m1", "s1");
        }
        if (Series.dirFor(PIGEONS_PLUS)) {
            File[] fileArray = new File("/home/lecoutre/instances/seriesPapers/pigeonsPlus/xml").listFiles();
            int n77 = fileArray.length;
            for (n = 0; n < n77; ++n) {
                File f46 = fileArray[n];
                Series.exec("problems.xcsp2.XCSP2 " + f46.getAbsolutePath(), 12000);
            }
        }
        if (Series.dirFor(SCHEDULING)) {
            File[] fileArray = new File("/home/lecoutre/instances/scheduling/sadeh/instances").listFiles();
            int n78 = fileArray.length;
            for (n = 0; n < n78; ++n) {
                File f47 = fileArray[n];
                Series.exec(SchedulingJSReader.Sadeh.class.getName() + " " + f47.getAbsolutePath(), "js", "sadeh");
            }
            File[] fileArray14 = new File("/home/lecoutre/instances/scheduling/taillard/fs").listFiles();
            int n79 = fileArray14.length;
            for (n = 0; n < n79; ++n) {
                File f48 = fileArray14[n];
                if (f48.getName().equals("fs-500-20.txt")) continue;
                for (int i25 = 0; i25 < 10; ++i25) {
                    Series.exec(SchedulingFSReader.class.getName() + " " + f48.getAbsolutePath() + " " + i25, "fs", "taillard");
                }
            }
            File[] fileArray15 = new File("/home/lecoutre/instances/scheduling/taillard/js").listFiles();
            int n80 = fileArray15.length;
            for (n = 0; n < n80; ++n) {
                File f49 = fileArray15[n];
                for (int i26 = 0; i26 < 10; ++i26) {
                    Series.exec(SchedulingJSReader.Taillard.class.getName() + " " + f49.getAbsolutePath() + " " + i26, "js", "taillard");
                }
            }
            File[] fileArray16 = new File("/home/lecoutre/instances/scheduling/taillard/os").listFiles();
            int n81 = fileArray16.length;
            for (n = 0; n < n81; ++n) {
                File f50 = fileArray16[n];
                for (int i27 = 0; i27 < 10; ++i27) {
                    Series.exec(SchedulingOSReader.Taillard.class.getName() + " " + f50.getAbsolutePath() + " " + i27, "os", "taillard");
                }
            }
            File[] fileArray17 = new File("/home/lecoutre/instances/scheduling/openShop/os-gp/xcsp2/os-gp").listFiles();
            int n82 = fileArray17.length;
            for (n = 0; n < n82; ++n) {
                File f51 = fileArray17[n];
                Series.exec("problems.xcsp2.XCSP2 " + f51.getAbsolutePath(), "xcsp2", "os-gp");
            }
            File[] fileArray18 = new File("/home/lecoutre/instances/scheduling/tamura/cjss").listFiles();
            int n83 = fileArray18.length;
            for (n = 0; n < n83; ++n) {
                File f52 = fileArray18[n];
                Series.exec("problems.xcsp2.XCSP2 " + f52.getAbsolutePath(), "xcsp2", "cjss");
            }
        }
        if (Series.dirFor(PSEUDO_BOOLEAN)) {
            Stringx3Consumer stringx3Consumer = (dir, variant, series) -> {
                boolean cop = variant.equals("opt");
                for (File f : new File("/home/lecoutre/instances/PB-RECUP/" + dir).listFiles()) {
                    Series.exec(PSEUDO_BOOLEAN + " " + f.getAbsolutePath() + (cop ? " -f=cop" : ""), 1200, variant, series);
                }
            };
            stringx3Consumer.accept("06-sat-small/armies", "dec", "armies");
            stringx3Consumer.accept("06-sat-small/FPGA_SAT05", "dec", "fpga");
            stringx3Consumer.accept("06-sat-small/robin", "dec", "robin");
            stringx3Consumer.accept("06-sat-small/roussel", "dec", "pigeon");
            stringx3Consumer.accept("06-sat-small/tsp", "dec", "tsp");
            stringx3Consumer.accept("06-sat-small/wnqueen", "dec", "queen");
            stringx3Consumer.accept("12-dec-small/ShortestPathBA", "dec", "spba");
            stringx3Consumer.accept("12-dec-small/ShortestPathNG", "dec", "spng");
            stringx3Consumer.accept("12-dec-small/ShortestPathTate", "dec", "sptate");
            stringx3Consumer.accept("06-opt-small/bounded_golomb_rulers", "opt", "bgr");
            stringx3Consumer.accept("06-opt-small/domset", "opt", "domset");
            stringx3Consumer.accept("06-opt-small/factor", "opt", "factor");
            stringx3Consumer.accept("06-opt-small/frb", "opt", "frb");
            stringx3Consumer.accept("06-opt-small/garden", "opt", "garden");
            stringx3Consumer.accept("06-opt-small/golomb-rulers", "opt", "gr");
            stringx3Consumer.accept("06-opt-small/haplotype", "opt", "haplotype");
            stringx3Consumer.accept("06-opt-small/logic-synthesis", "opt", "logic-synthesis");
            stringx3Consumer.accept("06-opt-small/market-split", "opt", "market-split");
            stringx3Consumer.accept("06-opt-small/miplib", "opt", "mps");
            stringx3Consumer.accept("06-opt-small/primes-dimacs-cnf", "opt", "dimacs");
            stringx3Consumer.accept("06-opt-small/radar", "opt", "radar");
            stringx3Consumer.accept("06-opt-small/routing", "opt", "routing");
            stringx3Consumer.accept("06-opt-small/vtxcov", "opt", "vtxcov");
            stringx3Consumer.accept("06-opt-small/ttp", "opt", "ttp");
            stringx3Consumer.accept("06-opt-small/wnq", "opt", "wnq");
            stringx3Consumer.accept("09-opt-small/featureSubscription", "opt", "fs");
            stringx3Consumer.accept("09-opt-small/flexray", "opt", "fx");
            stringx3Consumer.accept("06-sat-small/dbst", "dec", "dbst");
        }
        if (Series.dirFor(SUPER_SOLUTIONS)) {
            Series.cX2("XCSP2/superSolutions/SuperQueens", "Queens", "s1");
            Series.cX2("XCSP2/superSolutions/SuperSadeh", "Sadeh", "js");
            Series.cX2("XCSP2/superSolutions/SuperTaillard/SuperTaillard-os-04", "Taillard", "os04");
            Series.cX2("XCSP2/superSolutions/SuperTaillard/SuperTaillard-os-05", "Taillard", "os05");
            Series.cX2("XCSP2/superSolutions/SuperTaillard/SuperTaillard-os-07", "Taillard", "os07");
            Series.cX2("XCSP2/superSolutions/SuperTaillard/SuperTaillard-os-10", "Taillard", "os10");
            Series.cX2("XCSP2/superSolutions/SuperTaillard/SuperTaillard-os-15", "Taillard", "os15");
            Series.cX2("XCSP2/superSolutions/SuperTaillard/SuperTaillard-os-20", "Taillard", "os20");
            Series.cX2("XCSP2/superSolutions/SuperTaillard/SuperTaillard-js-15", "Taillard", "js15");
            Series.cX2("XCSP2/superSolutions/SuperTaillard/SuperTaillard-js-20", "Taillard", "js20");
            Series.cX2("XCSP2/superSolutions/SuperTaillard/SuperTaillard-js-20-15", "Taillard", "js20-15");
        }
        if (Series.dirFor(QUASI_GROUP)) {
            Consumer<Integer> consumer = v -> {
                for (int i = 4; i <= 40; ++i) {
                    Series.exec(QUASI_GROUP + " -data=" + i + " -variant=v" + v + " -dataFormat=%02d", "elt", "qg" + v);
                }
            };
            consumer.accept(3);
            consumer.accept(4);
            consumer.accept(5);
            consumer.accept(7);
        }
        if (Series.dirFor(BIN_PACKING)) {
            BiConsumer<String, String> biConsumer = (s1, s2) -> {
                for (File f : new File("/home/lecoutre/instances/binPacking/" + s1 + "/" + s2).listFiles()) {
                    Series.exec(BIN_PACKING + " " + f.getAbsolutePath() + " -variant=tab -f=cop", 12000, "tab", s2);
                }
                for (File f : new File("/home/lecoutre/instances/binPacking/" + s1 + "/" + s2).listFiles()) {
                    Series.exec(BIN_PACKING + " " + f.getAbsolutePath() + " -variant=mdd -f=cop", 12000, "mdd", s2);
                }
                for (File f : new File("/home/lecoutre/instances/binPacking/" + s1 + "/" + s2).listFiles()) {
                    Series.exec(BIN_PACKING + " " + f.getAbsolutePath() + " -variant=sum -f=cop", 12000, "sum", s2);
                }
            };
            biConsumer.accept("Falkenauer", "ft");
            biConsumer.accept("Falkenauer", "fu");
            biConsumer.accept("Scholl", "skj1");
            biConsumer.accept("Scholl", "skj2");
            biConsumer.accept("Scholl", "skj3");
            biConsumer.accept("Wascher", "wg");
            biConsumer.accept("Schwerin", "sw100");
            biConsumer.accept("Schwerin", "sw120");
            biConsumer.accept("Schoenfield", "s28");
        }
        if (Series.dirFor(MAX_CSP)) {
            BiConsumer<String, String> biConsumer = (s1, s2) -> {
                for (File f : new File("/home/lecoutre/instances/MaxCSP/" + s1 + (s2.length() > 0 ? "/" + s2 : "")).listFiles()) {
                    Series.exec("problems.xcsp2.XCSP2 " + f.getAbsolutePath(), s1, s2.length() > 0 ? s2 : "s1");
                }
            };
            biConsumer.accept("cnf", "s2-40");
            biConsumer.accept("cnf", "s2-80");
            biConsumer.accept("cnf", "s3-40");
            biConsumer.accept("cnf", "s3-80");
            biConsumer.accept("kbtree", "s5-2");
            biConsumer.accept("kbtree", "s9-2");
            biConsumer.accept("kbtree", "s9-5");
            biConsumer.accept("kbtree", "s9-7");
            biConsumer.accept("maxclique", "");
            biConsumer.accept("maxcut", "s30");
            biConsumer.accept("maxcut", "s40");
            biConsumer.accept("maxcut", "s50");
            biConsumer.accept("maxcut", "s60");
            biConsumer.accept("pedigree", "");
            biConsumer.accept("Pi", "s20-10-20-t60");
            biConsumer.accept("Pi", "s20-10-20-t70");
            biConsumer.accept("Pi", "s30-10-25-t48");
            biConsumer.accept("Pi", "s30-10-25-t58");
            biConsumer.accept("Pi", "s40-10-08-t60");
            biConsumer.accept("planning", "");
            biConsumer.accept("random", "completeLoose");
            biConsumer.accept("random", "completeTight");
            biConsumer.accept("random", "denseLoose");
            biConsumer.accept("random", "denseTight");
            biConsumer.accept("random", "sparseLoose");
            biConsumer.accept("random", "sparseTight");
            biConsumer.accept("rlfap", "");
            biConsumer.accept("spot5", "");
            biConsumer.accept("warehouses", "");
        }
        if (Series.dirFor(MIXED)) {
            Series.cX2("benchmarks2006/nengfa", "xcsp2", "nengfa");
            Series.cX2("benchmarks2006/cril", "xcsp2", "cril");
        }
        if (Series.dirFor(VRP)) {
            Series.cZn("vrp", VRP);
        }
        if (Series.dirFor(CUTSTOCK)) {
            Series.cZn("cutstock", CUTSTOCK);
        }
        if (Series.dirFor(TPP)) {
            Series.cZn("tpp", TPP);
        }
        if (Series.dirFor(MARIO)) {
            Series.cZn("mario", MARIO);
        }
        if (Series.dirFor(STILL_LIFE)) {
            void var1_137;
            void var1_135;
            int n84 = 3;
            while (var1_135 <= 15) {
                void var2_265;
                void var2_264 = var1_135;
                while (var2_265 <= 15) {
                    Series.exec(STILL_LIFE + " -data=[" + (int)var1_135 + "," + (int)var2_265 + "] -dataFormat=[%02d,%02d] -f=cop ", "m1", "s1");
                    ++var2_265;
                }
                ++var1_135;
            }
            int n85 = 3;
            while (var1_137 <= 50) {
                Series.exec(STILL_LIFE + " -data=[" + (int)var1_137 + "," + (int)var1_137 + "] -dataFormat=[%02d,-] -variant=wastage -f=cop ", "wst", "s1");
                ++var1_137;
            }
        }
        if (Series.dirFor(OPD)) {
            String string = " -dataFormat=[%02d,%03d,%03d] -variant=sum -f=cop";
            for (int[] t6 : new int[][]{{10, 8, 3}, {9, 8, 3}, {8, 8, 3}, {9, 37, 12}, {10, 15, 6}, {10, 25, 8}, {10, 37, 14}, {10, 38, 10}, {7, 7, 3}, {8, 14, 7}, {9, 18, 8}, {9, 24, 8}, {10, 30, 9}, {10, 33, 15}, {19, 20, 9}, {15, 21, 7}, {15, 21, 7}, {19, 19, 9}, {25, 25, 9}, {7, 13, 6}, {11, 11, 5}, {15, 15, 4}, {16, 8, 3}, {10, 38, 28}, {10, 31, 22}, {10, 26, 4}, {10, 27, 8}, {10, 32, 9}, {10, 31, 9}, {10, 30, 9}, {10, 30, 10}, {10, 9, 1}, {10, 20, 1}, {11, 22, 10}, {13, 26, 6}}) {
                Series.exec(OPD + " -data=[" + t6[0] + "," + t6[1] + "," + t6[2] + "] " + string, "sum", "small");
            }
            for (int i29 : Series.vals(Series.rangeC(2, 17), 22, 29, 46, 99)) {
                Series.exec(OPD + " -data=[" + i29 + ",350,100] " + string, "sum", "large");
            }
            for (int i30 : Series.vals(Series.rangeC(2, 17), 22, 29, 46, 99)) {
                Series.exec(OPD + " -data=[" + i30 + ",35,10] " + string, "sum", "large");
            }
            int[][] nArrayArray = new int[][]{{9, 300, 100}, {10, 325, 100}, {10, 360, 120}, {15, 350, 100}, {10, 100, 30}};
            n = nArrayArray.length;
            for (int f52 = 0; f52 < n; ++f52) {
                int[] t7 = nArrayArray[f52];
                Series.exec(OPD + " -data=[" + t7[0] + "," + t7[1] + "," + t7[2] + "] " + string, "sum", "large");
            }
        }
        if (Series.dirFor(PRIZE_COLLECTING)) {
            File[] fileArray = new File("/home/lecoutre/instances/minizinc-benchmarks-master/prize-collecting").listFiles(Series.withExtension(DZN));
            int n86 = fileArray.length;
            for (n = 0; n < n86; ++n) {
                File f53 = fileArray[n];
                Series.exec(PRIZE_COLLECTING + " " + f53.getAbsolutePath(), "jok", "s1");
            }
        }
        if (Series.dirFor(BUS_SCHEDULING)) {
            File[] fileArray = new File("/home/lecoutre/instances/minizinc-benchmarks-master/bus_scheduling").listFiles(Series.withExtension(DZN));
            int n87 = fileArray.length;
            for (n = 0; n < n87; ++n) {
                File f54 = fileArray[n];
                Series.execVariant(BUS_SCHEDULING + " " + f54.getAbsolutePath(), "cnt", 12000);
            }
        }
        if (Series.dirFor(FASTFOOD)) {
            File[] fileArray = new File("/home/lecoutre/instances/minizinc-benchmarks-master/fast-food").listFiles(Series.withExtension(DZN));
            int n88 = fileArray.length;
            for (n = 0; n < n88; ++n) {
                File f55 = fileArray[n];
                Series.exec(FASTFOOD + " " + f55.getAbsolutePath(), "m1", "s1");
            }
        }
        if (Series.dirFor(PROP_STRESS)) {
            int[] nArray = Series.vals(Series.rangeC(20, 100, 20), Series.rangeC(150, 700, 50));
            int n89 = nArray.length;
            for (n = 0; n < n89; ++n) {
                i2 = nArray[n];
                Series.exec(PROP_STRESS + " -data=" + i2 + " -dataFormat=%04d", 12000, "m1", "s1");
            }
        }
        if (Series.dirFor(WWTPP)) {
            File[] fileArray = new File("/home/lecoutre/instances/minizinc-benchmarks-master/wwtpp-real").listFiles(Series.withExtension(DZN));
            int n90 = fileArray.length;
            for (n = 0; n < n90; ++n) {
                File f56 = fileArray[n];
                Series.execVariant(WWTPP + " " + f56.getAbsolutePath(), "ord");
            }
        }
        if (Series.dirFor(OPEN_STACKS)) {
            File[] fileArray = new File("/home/lecoutre/instances/minizinc-benchmarks-master/open_stacks").listFiles(f -> f.getName().endsWith(DZN) && !f.getName().equals("gp-100-1.dzn"));
            int n91 = fileArray.length;
            for (n = 0; n < n91; ++n) {
                File f57 = fileArray[n];
                Series.execVariant(OPEN_STACKS + " " + f57.getAbsolutePath(), "m1", 12000);
                Series.execVariant(OPEN_STACKS + " " + f57.getAbsolutePath(), "m2", 12000);
            }
        }
        if (Series.dirFor(RACK)) {
            File[] fileArray = new File("/home/lecoutre/instances/Rack").listFiles(Series.withExtension(JSON));
            int n92 = fileArray.length;
            for (n = 0; n < n92; ++n) {
                File f58 = fileArray[n];
                Series.exec(RACK + " -data=" + f58.getAbsolutePath());
            }
        }
        if (Series.dirFor(COVERING_ARRAY)) {
            int[][] nArrayArray = new int[][]{{4, 9}, {5, 10}, {6, 12}, {7, 12}, {8, 12}, {9, 12}, {10, 12}, {11, 12}};
            int n93 = nArrayArray.length;
            for (n = 0; n < n93; ++n) {
                int[] t8 = nArrayArray[n];
                Series.exec(COVERING_ARRAY + " -data=[3," + t8[0] + ",2," + (t8[1] - 1) + "] -dataFormat=[%01d,%02d,%01d,%02d] ", "dec", "s1");
                Series.exec(COVERING_ARRAY + " -data=[3," + t8[0] + ",2," + t8[1] + "] -dataFormat=[%01d,%02d,%01d,%02d] ", "dec", "s1");
            }
        }
        if (Series.dirFor(DE_BRUIJN)) {
            void var1_148;
            int n94 = 2;
            while (var1_148 <= 5) {
                void var2_279;
                void var2_278 = var1_148;
                while (var2_279 < 10) {
                    Series.exec(DE_BRUIJN + " -data=[" + (int)var1_148 + "," + (int)var2_279 + "] -dataFormat=[%02d,%02d]", 12000, "m1", "s1");
                    ++var2_279;
                }
                ++var1_148;
            }
        }
        if (Series.dirFor(DIAMOND_FREE)) {
            int[] nArray = Series.vals(Series.rangeC(4, 40), Series.rangeC(45, 100, 5));
            int n95 = nArray.length;
            for (n = 0; n < n95; ++n) {
                i2 = nArray[n];
                Series.exec(DIAMOND_FREE + " -data=" + i2 + " -dataFormat=%03d", 12000, "m1", "s1");
            }
        }
        if (Series.dirFor(MAGIC_HEXAGON)) {
            int[][] nArrayArray = new int[][]{{2, -3}, {2, 0}, {2, 3}, {3, -29}, {3, -24}, {3, -19}, {3, -14}, {3, -9}, {3, -4}, {3, 1}, {3, 6}, {3, 11}, {3, 16}, {3, 21}, {3, 26}, {4, -60}, {4, -53}, {4, -46}, {4, -39}, {4, -32}, {4, -25}, {4, -18}, {4, -11}, {4, -4}, {4, 3}, {4, 10}, {4, 17}, {4, 24}, {5, -93}, {5, -84}, {5, -75}, {5, -66}, {5, -57}, {5, -48}, {5, -39}, {5, -30}, {5, -21}, {5, -12}, {5, -3}, {5, 6}, {5, 15}, {5, 24}, {5, 33}, {6, -155}, {6, -144}, {6, -133}, {6, -122}, {6, -111}, {6, -100}, {6, -89}, {6, -78}, {6, -67}, {6, -56}, {6, -45}, {6, -34}, {6, -23}, {6, -12}, {6, -1}, {6, 10}, {6, 21}, {6, 32}, {6, 43}, {6, 54}, {7, -193}, {7, -180}, {7, -167}, {7, -154}, {7, -141}, {7, -128}, {7, -115}, {7, -102}, {7, -89}, {7, -76}, {7, -63}, {7, -50}, {7, -37}, {7, -24}, {7, -11}, {7, 2}, {7, 15}, {7, 28}, {7, 41}, {7, 54}, {7, 67}, {7, 80}, {8, -189}, {8, -174}, {8, -159}, {8, -144}, {8, -129}, {8, -114}, {8, -99}, {8, -84}, {8, -69}, {8, -54}, {8, -39}, {8, -24}, {8, -9}, {8, 6}, {8, 21}, {8, 36}, {8, 51}, {8, 66}, {8, 81}, {8, 96}, {9, -193}, {9, -176}, {9, -159}, {9, -142}, {9, -125}, {9, -108}, {9, -91}, {9, -74}, {9, -57}, {9, -40}, {9, -23}, {9, -6}, {9, 11}, {9, 28}, {9, 45}, {9, 62}, {9, 79}, {9, 96}, {9, 113}, {9, 130}, {10, -192}, {10, -173}, {10, -154}, {10, -135}, {10, -116}, {10, -97}, {10, -78}, {10, -59}, {10, -40}, {10, -21}, {10, -2}, {10, 17}, {10, 36}, {10, 55}, {10, 74}, {10, 93}, {10, 112}, {10, 131}, {10, 150}, {10, 169}, {11, -186}, {11, -165}, {11, -144}, {11, -123}, {11, -102}, {11, -81}, {11, -60}, {11, -39}, {11, -18}, {11, 3}, {11, 24}, {11, 45}, {11, 66}, {11, 87}, {11, 108}, {11, 129}, {11, 150}, {11, 171}, {11, 192}, {12, -198}, {12, -175}, {12, -152}, {12, -129}, {12, -106}, {12, -83}, {12, -60}, {12, -37}, {12, -14}, {12, 9}, {12, 32}, {12, 55}, {12, 78}, {12, 101}, {12, 124}, {12, 147}, {12, 170}, {12, 193}};
            int n96 = nArrayArray.length;
            for (n = 0; n < n96; ++n) {
                int[] t9 = nArrayArray[n];
                Series.exec(MAGIC_HEXAGON + " -data=[" + t9[0] + "," + t9[1] + "] -dataFormat=[%02d,%04d]", 12000, "m1", "s1");
            }
        }
        if (Series.dirFor(NUMBER_PARTITIONING)) {
            int[] nArray = Series.vals(Series.rangeC(4, 12, 2), Series.rangeC(16, 200, 4));
            int n97 = nArray.length;
            for (n = 0; n < n97; ++n) {
                i2 = nArray[n];
                Series.exec(NUMBER_PARTITIONING + " -data=" + i2 + " -dataFormat=%03d", 12000, "m1", "s1");
            }
        }
        if (Series.dirFor(AUCTION)) {
            Series.exec(AUCTION + " " + PATH + "auction/example.txt -variant=cnt");
            Series.exec(AUCTION + " " + PATH + "auction/example.txt -variant=sum");
            BiConsumer<String, String> biConsumer = (variant, series) -> Stream.of(new File("/home/lecoutre/instances/auction/" + series).listFiles()).forEach(f -> Series.execVariant(AUCTION + " " + f.getAbsolutePath(), variant, series));
            biConsumer.accept("cnt", "cast");
            biConsumer.accept("cnt", "sand");
            biConsumer.accept("cnt", "groupes");
            biConsumer.accept("sum", "cast");
            biConsumer.accept("sum", "sand");
            biConsumer.accept("sum", "groupes");
        }
        if (Series.dirFor(BACP)) {
            File[] fileArray = new File("/home/lecoutre/instances/bacp/dataCompet2018").listFiles();
            int n98 = fileArray.length;
            for (n = 0; n < n98; ++n) {
                File f59 = fileArray[n];
                Series.execVariant(BACP + " -data=" + f59.getAbsolutePath(), "m1");
            }
            File[] fileArray19 = new File("/home/lecoutre/instances/bacp/dataCompet2018").listFiles();
            int n99 = fileArray19.length;
            for (n = 0; n < n99; ++n) {
                File f60 = fileArray19[n];
                Series.execVariant(BACP + " -data=" + f60.getAbsolutePath(), "m2");
            }
            File[] fileArray20 = new File("/home/lecoutre/instances/minizinc-benchmarks-master/bacp").listFiles(Series.withExtension(MZN));
            int n100 = fileArray20.length;
            for (n = 0; n < n100; ++n) {
                File f61 = fileArray20[n];
                Series.execVariant(Bacp_ParserZ.class.getName() + " " + f61.getAbsolutePath(), "m1", "zn");
            }
            File[] fileArray21 = new File("/home/lecoutre/instances/minizinc-benchmarks-master/bacp").listFiles(Series.withExtension(MZN));
            int n101 = fileArray21.length;
            for (n = 0; n < n101; ++n) {
                File f62 = fileArray21[n];
                Series.execVariant(Bacp_ParserZ.class.getName() + " " + f62.getAbsolutePath(), "m2", "zn");
            }
            File[] fileArray22 = new File("/home/lecoutre/instances/bacp/ps/instances12").listFiles();
            int n102 = fileArray22.length;
            for (n = 0; n < n102; ++n) {
                File f63 = fileArray22[n];
                Series.execVariant(Bacp_Parser.class.getName() + " " + f63.getAbsolutePath(), "m1d", "ps");
            }
            File[] fileArray23 = new File("/home/lecoutre/instances/bacp/ps/instances12").listFiles();
            int n103 = fileArray23.length;
            for (n = 0; n < n103; ++n) {
                File f64 = fileArray23[n];
                Series.execVariant(Bacp_Parser.class.getName() + " " + f64.getAbsolutePath(), "m2d", "ps");
            }
        }
        if (Series.dirFor(BATTLESHIP)) {
            void var1_160;
            boolean bl = false;
            while (var1_160 < 303) {
                Series.exec(SolitaireBattleshipReader.class.getName() + " " + PATH + "solitaireBattleship/battleship_instances.pl " + (int)var1_160);
                ++var1_160;
            }
            File[] fileArray = new File("/home/lecoutre/instances/solitaireBattleship/sb_MiniZinc_Benchmarks").listFiles();
            int n104 = fileArray.length;
            for (n = 0; n < n104; ++n) {
                File f65 = fileArray[n];
                Series.exec(SolitaireBattleshipReaderZ.class.getName() + " " + f65.getAbsolutePath(), "m1", "zinc");
            }
        }
        if (Series.dirFor(ETERNITY)) {
            File[] fileArray = new File("/home/lecoutre/instances/eternity/eternityOscar/brendan").listFiles();
            int n105 = fileArray.length;
            for (n = 0; n < n105; ++n) {
                File f66 = fileArray[n];
                Series.exec(ETERNITY + " " + f66.getAbsolutePath());
            }
        }
        if (Series.dirFor(FAPP)) {
            File[] fileArray = new File("/home/lecoutre/instances/fapp/allInstances").listFiles();
            int n106 = fileArray.length;
            for (n = 0; n < n106; ++n) {
                File f67 = fileArray[n];
                Series.exec(Fapp.class.getName() + " " + f67.getAbsolutePath() + " -variant=m2 -positive=v -f=cop", 12000);
            }
        }
        if (Series.dirFor(MISTERY_SHOPPER)) {
            File[] fileArray = new File("/home/lecoutre/instances/misteryShopper/dataCompet2018").listFiles();
            int n107 = fileArray.length;
            for (n = 0; n < n107; ++n) {
                File f68 = fileArray[n];
                Series.exec(MISTERY_SHOPPER + " -data=" + f68.getAbsolutePath());
            }
        }
        if (Series.dirFor(NURSE_ROSTERING)) {
            File[] fileArray = new File("/home/lecoutre/instances/nurseRostering/24Instances").listFiles();
            int n108 = fileArray.length;
            for (n = 0; n < n108; ++n) {
                File f69 = fileArray[n];
                Series.exec(NURSE_ROSTERING + " " + f69.getAbsolutePath(), 12000);
            }
        }
        if (Series.dirFor(PEACABLE_ARMIES)) {
            int[] nArray = Series.vals(Series.rangeC(2, 30));
            int n109 = nArray.length;
            for (n = 0; n < n109; ++n) {
                i2 = nArray[n];
                Series.execVariant(PEACABLE_ARMIES + " -data=" + i2 + " -dataFormat=%02d", "m1");
            }
            int[] nArray6 = Series.vals(Series.rangeC(2, 30));
            int n110 = nArray6.length;
            for (n = 0; n < n110; ++n) {
                i2 = nArray6[n];
                Series.execVariant(PEACABLE_ARMIES + " -data=" + i2 + " -dataFormat=%02d", "m2");
            }
        }
        if (Series.dirFor(PIGEONS)) {
            int[] nArray = Series.vals(Series.rangeC(4, 20), Series.rangeC(25, 50, 5), Series.rangeC(60, 100, 10));
            int n111 = nArray.length;
            for (n = 0; n < n111; ++n) {
                i2 = nArray[n];
                Series.execVariant(PIGEONS + " -data=" + i2 + " -dataFormat=%03d", "int", 12000);
            }
            int[] nArray7 = Series.vals(Series.rangeC(4, 20), Series.rangeC(25, 50, 5), Series.rangeC(60, 100, 10));
            int n112 = nArray7.length;
            for (n = 0; n < n112; ++n) {
                i2 = nArray7[n];
                Series.execVariant(PIGEONS + " -data=" + i2 + " -dataFormat=%03d", "glb", 12000);
            }
        }
        if (Series.dirFor(PIZZA_VOUCHER)) {
            File[] fileArray = new File("/home/lecoutre/instances/pizzaVoucher/data").listFiles();
            int n113 = fileArray.length;
            for (n = 0; n < n113; ++n) {
                File f70 = fileArray[n];
                Series.exec(PIZZA_VOUCHER + " -data=" + f70.getAbsolutePath());
            }
        }
        if (Series.dirFor(RLFAP)) {
            int[] nArray = Series.vals(5);
            int n114 = nArray.length;
            for (n = 0; n < n114; ++n) {
                i2 = nArray[n];
                Series.exec(RlfapReader.class.getName() + " " + PATH + "rlfap 0 " + i2 + " -variant=span");
            }
            int[] nArray8 = Series.vals(1, 2, 3, 4, 11);
            int n115 = nArray8.length;
            for (n = 0; n < n115; ++n) {
                i2 = nArray8[n];
                Series.exec(RlfapReader.class.getName() + " " + PATH + "rlfap 0 " + i2 + " -variant=card");
            }
            int[] nArray9 = Series.vals(6, 7, 8, 9, 10);
            int n116 = nArray9.length;
            for (n = 0; n < n116; ++n) {
                i2 = nArray9[n];
                Series.exec(RlfapReader.class.getName() + " " + PATH + "rlfap 0 " + i2 + " -variant=max");
            }
            int[] nArray10 = Series.vals(3, 4, 10);
            int n117 = nArray10.length;
            for (n = 0; n < n117; ++n) {
                i2 = nArray10[n];
                Series.exec(RlfapReader.class.getName() + " " + PATH + "rlfap 1 " + i2 + " -variant=span");
            }
            int[] nArray11 = Series.vals(1, 2, 8, 9, 14);
            int n118 = nArray11.length;
            for (n = 0; n < n118; ++n) {
                i2 = nArray11[n];
                Series.exec(RlfapReader.class.getName() + " " + PATH + "rlfap 1 " + i2 + " -variant=card");
            }
            int[] nArray12 = Series.vals(5, 6, 7, 11, 12, 13);
            int n119 = nArray12.length;
            for (n = 0; n < n119; ++n) {
                i2 = nArray12[n];
                Series.exec(RlfapReader.class.getName() + " " + PATH + "rlfap 1 " + i2 + " -variant=max");
            }
        }
        if (Series.dirFor(TAL)) {
            for (String s4 : new String[]{"7 15-11-13-9-1-11-7-4", "7 9-10-12-13-4-16-8", "9 14-13-2", "9 15-11-13-9-10-12", "9 15-5-3-12-10-3-4-11-2-10-3-11-3", "9 15-5-3-12-10-3-4-11-2-10-3", "9 27-35-38-22-15-13-26-28", "9 9-10-12-13-13-9-16-10-15-9-12", "9 9-13-13-10-16-12-15-9-12", "9 9-13-13-16-10-12-9-15-9-12"}) {
                Series.exec(TAL + " " + PATH + "tal/compiler2solver/fr.observed.tuples " + s4 + " -1 -f=cop", 1200);
            }
        }
        if (Series.dirFor(BAUDOUIN)) {
            void var1_179;
            int n120 = 4;
            while (var1_179 <= 7) {
                Series.exec(TestSmart.class.getName() + " -data=[" + (int)var1_179 + ",4] -variant=distinctv -s4b", 12000, "distinctv");
                ++var1_179;
            }
        }
        System.out.println("Nb bad commands = " + badCommands.size());
        badCommands.stream().forEach(s -> System.out.println("\t" + s));
    }

    private static boolean dirFor(String name) {
        int pos = (name = name.indexOf(".") != -1 ? name.substring(name.lastIndexOf(".") + 1) : name).indexOf("_");
        if (pos != -1) {
            name = name.substring(0, pos);
        }
        if (serieName.equals(ALL) || serieName.equals(name.toLowerCase())) {
            dir = new File(mainDir, name.startsWith("X2_") ? name.substring(3) : name);
            dir.mkdir();
            return true;
        }
        return false;
    }

    static {
        badCommands = new ArrayList<String>();
        exportFile = "-export=file";
    }

    static class Perfect {
        public static int[][] t = new int[][]{{112, 2, 4, 6, 7, 8, 9, 11, 15, 16, 17, 18, 19, 24, 25, 27, 29, 33, 35, 37, 42, 50}, {110, 2, 3, 4, 6, 7, 8, 12, 13, 14, 15, 16, 17, 18, 21, 22, 23, 24, 26, 27, 28, 50, 60}, {110, 1, 2, 3, 4, 6, 8, 9, 12, 14, 16, 17, 18, 19, 21, 22, 23, 24, 26, 27, 28, 50, 60}, {139, 1, 2, 3, 4, 7, 8, 10, 17, 18, 20, 21, 22, 24, 27, 28, 29, 30, 31, 32, 38, 59, 80}, {147, 1, 3, 4, 5, 8, 9, 17, 20, 21, 23, 25, 26, 29, 31, 32, 40, 43, 44, 47, 48, 52, 55}, {147, 2, 4, 8, 10, 11, 12, 15, 19, 21, 22, 23, 25, 26, 32, 34, 37, 41, 43, 45, 47, 55, 59}, {154, 2, 5, 9, 11, 16, 17, 19, 21, 22, 24, 26, 30, 31, 33, 35, 36, 41, 46, 47, 50, 52, 61}, {172, 1, 2, 3, 4, 9, 11, 13, 16, 17, 18, 19, 22, 24, 33, 36, 38, 39, 42, 44, 53, 75, 97}, {192, 4, 8, 9, 10, 12, 14, 17, 19, 26, 28, 31, 35, 36, 37, 41, 47, 49, 57, 59, 62, 71, 86}, {110, 1, 2, 3, 4, 5, 7, 8, 10, 12, 13, 14, 15, 16, 19, 21, 28, 29, 31, 32, 37, 38, 41, 44}, {139, 1, 2, 7, 8, 12, 13, 14, 15, 16, 18, 19, 20, 21, 22, 24, 26, 27, 28, 32, 33, 38, 59, 80}, {140, 1, 2, 3, 4, 5, 8, 10, 13, 16, 19, 20, 23, 27, 28, 29, 31, 33, 38, 42, 45, 48, 53, 54}, {140, 2, 3, 4, 7, 8, 9, 12, 15, 16, 18, 22, 23, 24, 26, 28, 30, 33, 36, 43, 44, 47, 50, 60}, {145, 1, 2, 3, 4, 6, 8, 9, 12, 15, 20, 22, 24, 25, 26, 27, 29, 30, 31, 32, 34, 36, 61, 84}, {180, 2, 4, 8, 10, 11, 12, 15, 19, 21, 22, 23, 25, 26, 32, 33, 34, 37, 41, 43, 45, 47, 88, 92}, {188, 2, 4, 8, 10, 11, 12, 15, 19, 21, 22, 23, 25, 26, 32, 33, 34, 37, 45, 47, 49, 51, 92, 96}, {208, 1, 3, 4, 9, 10, 11, 12, 16, 17, 18, 22, 23, 24, 40, 41, 60, 62, 65, 67, 70, 71, 73, 75}, {215, 1, 3, 4, 9, 10, 11, 12, 16, 17, 18, 22, 23, 24, 40, 41, 60, 66, 68, 70, 71, 74, 76, 79}, {228, 2, 7, 9, 10, 15, 16, 17, 18, 22, 23, 25, 28, 36, 39, 42, 56, 57, 68, 69, 72, 73, 87, 99}, {257, 2, 3, 9, 11, 14, 15, 17, 20, 22, 24, 28, 29, 32, 33, 49, 55, 57, 60, 63, 66, 79, 123, 134}, {332, 1, 15, 17, 24, 26, 30, 31, 38, 47, 48, 49, 50, 53, 56, 58, 68, 83, 89, 91, 112, 120, 123, 129}, {120, 3, 4, 5, 6, 8, 9, 10, 12, 13, 14, 15, 16, 17, 19, 20, 23, 25, 32, 33, 34, 40, 41, 46, 47}, {186, 2, 3, 4, 7, 8, 9, 12, 15, 16, 18, 22, 23, 24, 26, 28, 30, 33, 36, 43, 46, 47, 60, 90, 96}, {194, 2, 3, 7, 9, 10, 16, 17, 18, 19, 20, 23, 25, 28, 34, 36, 37, 42, 53, 54, 61, 65, 68, 69, 72}, {195, 2, 4, 7, 10, 11, 16, 17, 18, 21, 26, 27, 30, 39, 41, 42, 45, 47, 49, 52, 53, 54, 61, 63, 80}, {196, 1, 2, 5, 10, 11, 15, 17, 18, 20, 21, 24, 26, 29, 31, 32, 34, 36, 40, 44, 47, 48, 51, 91, 105}, {201, 1, 3, 4, 6, 9, 10, 11, 12, 17, 18, 20, 21, 22, 23, 26, 38, 40, 46, 50, 52, 53, 58, 98, 103}, {201, 1, 4, 5, 8, 9, 10, 11, 15, 16, 18, 19, 20, 22, 24, 26, 39, 42, 44, 49, 52, 54, 56, 93, 108}, {203, 1, 2, 5, 10, 11, 15, 17, 18, 20, 21, 24, 26, 29, 31, 32, 34, 36, 40, 44, 48, 54, 58, 98, 105}, {247, 3, 5, 6, 9, 12, 14, 19, 23, 24, 25, 28, 32, 34, 36, 40, 45, 46, 48, 56, 62, 63, 66, 111, 136}, {253, 2, 4, 5, 9, 13, 18, 20, 23, 24, 27, 28, 31, 38, 40, 44, 50, 61, 70, 72, 77, 79, 86, 88, 104}, {255, 3, 5, 10, 11, 16, 17, 20, 22, 23, 25, 26, 27, 28, 32, 41, 44, 52, 53, 59, 63, 65, 74, 118, 137}, {288, 2, 7, 9, 10, 15, 16, 17, 18, 22, 23, 25, 28, 36, 39, 42, 56, 57, 60, 68, 72, 73, 87, 129, 159}, {288, 1, 5, 7, 8, 9, 14, 17, 20, 21, 26, 30, 32, 34, 36, 48, 51, 54, 59, 64, 69, 72, 93, 123, 165}, {290, 2, 3, 8, 9, 11, 12, 14, 17, 21, 30, 31, 33, 40, 42, 45, 48, 59, 61, 63, 65, 82, 84, 124, 166}, {292, 1, 2, 3, 8, 12, 15, 16, 17, 20, 22, 24, 26, 29, 33, 44, 54, 57, 60, 63, 67, 73, 102, 117, 175}, {304, 3, 5, 7, 11, 12, 17, 20, 22, 25, 29, 35, 47, 48, 55, 56, 57, 69, 72, 76, 92, 96, 100, 116, 132}, {304, 3, 4, 7, 12, 16, 20, 23, 24, 27, 28, 30, 32, 33, 36, 37, 44, 53, 57, 72, 76, 85, 99, 129, 175}, {314, 2, 4, 11, 12, 16, 17, 18, 19, 28, 29, 40, 44, 47, 59, 62, 64, 65, 78, 79, 96, 97, 105, 113, 139}, {316, 3, 9, 10, 12, 13, 14, 15, 23, 24, 33, 36, 37, 48, 52, 54, 55, 57, 65, 66, 78, 79, 93, 144, 172}, {326, 1, 6, 10, 11, 14, 15, 18, 24, 29, 32, 43, 44, 53, 56, 63, 65, 71, 80, 83, 101, 104, 106, 119, 142}, {423, 2, 9, 15, 17, 27, 29, 31, 32, 33, 36, 47, 49, 50, 60, 62, 77, 105, 114, 123, 127, 128, 132, 168, 186}, {435, 1, 2, 8, 10, 13, 19, 23, 33, 44, 45, 56, 74, 76, 78, 80, 88, 93, 100, 112, 131, 142, 143, 150, 192}, {435, 3, 5, 9, 11, 12, 21, 24, 27, 30, 44, 45, 50, 54, 55, 63, 95, 101, 112, 117, 123, 134, 140, 178, 200}, {459, 8, 9, 10, 11, 16, 30, 36, 38, 45, 55, 57, 65, 68, 84, 95, 98, 100, 116, 117, 126, 135, 144, 180, 198}, {459, 4, 6, 9, 10, 17, 21, 23, 25, 31, 33, 36, 38, 45, 50, 83, 115, 117, 126, 133, 135, 144, 146, 180, 198}, {479, 5, 6, 17, 23, 24, 26, 28, 29, 35, 43, 44, 52, 60, 68, 77, 86, 130, 140, 150, 155, 160, 164, 174, 175}, {147, 3, 4, 5, 6, 8, 9, 10, 12, 13, 14, 15, 16, 17, 19, 20, 23, 25, 27, 32, 33, 34, 40, 41, 73, 74}, {208, 1, 2, 3, 4, 5, 7, 8, 11, 12, 17, 18, 24, 26, 28, 29, 30, 36, 39, 44, 45, 50, 59, 60, 89, 119}, {213, 3, 5, 6, 7, 13, 16, 17, 20, 21, 23, 24, 25, 26, 28, 31, 35, 36, 47, 49, 56, 58, 74, 76, 81, 90}, {215, 1, 4, 6, 7, 11, 15, 24, 26, 27, 33, 37, 39, 40, 41, 42, 43, 45, 47, 51, 55, 60, 62, 63, 69, 83}, {216, 1, 2, 3, 4, 5, 7, 8, 11, 16, 17, 18, 19, 25, 30, 32, 33, 39, 41, 45, 49, 54, 59, 64, 103, 113}, {236, 1, 2, 4, 9, 11, 12, 13, 14, 15, 16, 19, 24, 38, 40, 44, 46, 47, 48, 59, 64, 65, 70, 81, 85, 107}, {242, 1, 3, 6, 7, 9, 13, 14, 16, 17, 19, 23, 25, 26, 28, 30, 31, 47, 51, 54, 57, 60, 64, 67, 111, 131}, {244, 1, 2, 4, 5, 7, 10, 15, 17, 19, 20, 21, 22, 26, 27, 30, 37, 40, 41, 45, 65, 66, 68, 70, 110, 134}, {252, 4, 7, 10, 11, 12, 13, 23, 25, 29, 31, 32, 34, 36, 37, 38, 40, 42, 44, 62, 67, 68, 71, 77, 108, 113}, {253, 2, 4, 5, 6, 9, 10, 12, 14, 20, 24, 27, 35, 36, 37, 38, 42, 43, 45, 50, 54, 63, 66, 70, 120, 133}, {260, 1, 4, 6, 7, 10, 15, 24, 26, 27, 28, 29, 31, 33, 34, 37, 38, 44, 65, 70, 71, 77, 78, 83, 100, 112}, {264, 3, 7, 8, 12, 16, 18, 19, 20, 22, 24, 26, 31, 34, 37, 38, 40, 42, 53, 54, 61, 64, 69, 70, 130, 134}, {264, 3, 8, 12, 13, 16, 18, 20, 21, 22, 24, 26, 29, 34, 38, 40, 42, 43, 47, 54, 59, 64, 70, 71, 130, 134}, {264, 1, 3, 4, 6, 9, 10, 11, 12, 16, 17, 18, 20, 21, 22, 39, 42, 54, 56, 61, 66, 68, 69, 73, 129, 135}, {265, 1, 3, 4, 6, 9, 10, 11, 12, 16, 17, 18, 20, 21, 22, 39, 42, 54, 56, 62, 66, 68, 69, 74, 130, 135}, {273, 1, 4, 8, 10, 11, 12, 17, 19, 21, 22, 27, 29, 30, 33, 37, 43, 52, 62, 65, 86, 88, 89, 91, 96, 120}, {273, 1, 6, 9, 14, 16, 17, 18, 21, 22, 23, 25, 31, 32, 38, 44, 46, 48, 50, 54, 62, 65, 68, 78, 133, 140}, {275, 2, 3, 7, 13, 17, 24, 25, 31, 33, 34, 35, 37, 41, 49, 51, 53, 55, 60, 68, 71, 74, 81, 94, 100, 107}, {276, 1, 5, 8, 9, 11, 18, 19, 21, 30, 36, 41, 44, 45, 46, 47, 51, 53, 58, 63, 69, 71, 84, 87, 105, 120}, {280, 5, 6, 11, 17, 18, 20, 21, 24, 27, 28, 32, 34, 41, 42, 50, 53, 54, 55, 68, 78, 85, 88, 95, 97, 117}, {280, 2, 3, 7, 8, 14, 18, 30, 36, 37, 39, 44, 50, 52, 54, 56, 60, 63, 64, 65, 72, 75, 78, 79, 96, 106}, {284, 1, 2, 11, 12, 14, 16, 18, 19, 23, 26, 29, 37, 38, 39, 40, 42, 59, 68, 69, 77, 78, 97, 106, 109, 110}, {286, 1, 4, 5, 7, 10, 12, 15, 16, 20, 23, 28, 30, 32, 33, 35, 37, 53, 54, 64, 68, 74, 79, 80, 133, 153}, {289, 2, 3, 5, 8, 13, 14, 17, 20, 21, 32, 36, 41, 50, 52, 60, 61, 62, 68, 74, 76, 83, 87, 100, 102, 104}, {289, 2, 3, 4, 5, 7, 12, 16, 17, 19, 21, 23, 25, 29, 31, 32, 44, 57, 64, 65, 68, 72, 76, 84, 140, 149}, {290, 1, 2, 10, 11, 13, 14, 15, 17, 18, 28, 29, 34, 36, 38, 50, 56, 60, 69, 77, 80, 85, 91, 94, 111, 119}, {293, 5, 6, 11, 17, 18, 20, 21, 24, 27, 28, 32, 34, 41, 42, 50, 54, 55, 66, 68, 78, 85, 88, 95, 110, 130}, {297, 2, 7, 8, 9, 10, 15, 16, 17, 18, 23, 25, 26, 28, 36, 38, 43, 53, 60, 61, 68, 69, 77, 99, 137, 160}, {308, 1, 3, 4, 7, 10, 12, 13, 23, 25, 34, 37, 38, 39, 43, 44, 45, 62, 77, 79, 85, 87, 108, 113, 115, 116}, {308, 1, 5, 6, 7, 8, 9, 13, 16, 19, 28, 33, 36, 38, 43, 45, 48, 70, 71, 73, 84, 86, 102, 104, 120, 133}, {309, 7, 8, 14, 16, 23, 24, 25, 26, 31, 33, 34, 39, 48, 56, 59, 60, 62, 70, 76, 82, 92, 100, 101, 108, 117}, {311, 2, 7, 8, 9, 10, 15, 16, 17, 18, 23, 25, 26, 28, 36, 38, 43, 53, 60, 61, 68, 83, 91, 99, 151, 160}, {314, 1, 6, 7, 11, 16, 22, 26, 29, 32, 36, 38, 44, 51, 53, 64, 69, 70, 73, 74, 75, 85, 87, 101, 116, 128}, {316, 1, 3, 9, 12, 21, 26, 30, 33, 34, 35, 38, 39, 40, 41, 53, 56, 59, 69, 79, 85, 96, 103, 111, 117, 120}, {317, 1, 5, 6, 7, 8, 9, 16, 17, 19, 32, 37, 40, 42, 47, 49, 52, 59, 75, 81, 92, 94, 110, 112, 113, 126}, {320, 2, 7, 8, 9, 12, 14, 15, 21, 23, 35, 38, 44, 46, 49, 53, 54, 56, 63, 96, 101, 103, 105, 108, 112, 116}, {320, 3, 8, 9, 11, 17, 18, 22, 25, 26, 27, 29, 30, 31, 33, 35, 49, 51, 67, 72, 73, 80, 85, 95, 152, 168}, {320, 1, 4, 6, 7, 8, 13, 14, 16, 24, 28, 30, 33, 34, 38, 41, 42, 57, 60, 69, 78, 81, 90, 92, 150, 170}, {320, 3, 4, 6, 8, 9, 14, 15, 16, 24, 28, 30, 31, 34, 38, 39, 42, 59, 60, 71, 78, 79, 90, 92, 150, 170}, {322, 3, 4, 8, 9, 10, 16, 18, 20, 22, 23, 24, 28, 31, 38, 44, 47, 64, 65, 68, 76, 80, 81, 97, 144, 178}, {322, 3, 4, 8, 10, 15, 16, 18, 19, 20, 22, 24, 28, 35, 38, 44, 53, 59, 64, 68, 76, 80, 85, 93, 144, 178}, {323, 2, 3, 4, 7, 10, 13, 15, 18, 23, 32, 34, 35, 36, 42, 46, 50, 57, 60, 66, 72, 78, 87, 98, 159, 164}, {323, 3, 8, 9, 11, 17, 18, 22, 25, 26, 27, 29, 30, 31, 33, 35, 49, 51, 67, 72, 73, 83, 88, 95, 155, 168}, {323, 2, 6, 9, 11, 13, 14, 18, 19, 20, 23, 27, 28, 29, 42, 46, 48, 60, 64, 72, 74, 79, 82, 98, 146, 177}, {325, 3, 5, 6, 11, 12, 13, 18, 23, 25, 28, 32, 37, 40, 43, 45, 46, 51, 79, 92, 99, 103, 108, 112, 114, 134}, {326, 1, 4, 8, 10, 12, 16, 21, 22, 24, 27, 28, 35, 36, 37, 38, 46, 49, 68, 70, 75, 88, 90, 93, 158, 168}, {327, 2, 9, 10, 12, 13, 16, 19, 21, 23, 26, 36, 44, 46, 52, 55, 61, 62, 74, 84, 87, 100, 103, 104, 120, 140}, {328, 2, 3, 4, 7, 8, 10, 14, 17, 26, 27, 28, 36, 38, 40, 42, 45, 53, 58, 73, 74, 79, 94, 102, 152, 176}, {334, 1, 4, 8, 10, 12, 16, 21, 22, 24, 27, 28, 35, 36, 37, 38, 46, 49, 68, 75, 78, 88, 93, 98, 166, 168}, {336, 2, 3, 4, 7, 8, 10, 14, 17, 26, 27, 28, 36, 38, 40, 45, 50, 53, 58, 73, 74, 79, 94, 110, 152, 184}, {338, 1, 4, 8, 10, 12, 16, 19, 22, 24, 25, 28, 36, 37, 38, 39, 46, 53, 68, 70, 73, 94, 96, 101, 164, 174}, {338, 4, 5, 8, 10, 12, 15, 16, 21, 22, 24, 28, 33, 36, 38, 43, 46, 57, 68, 70, 77, 94, 96, 97, 164, 174}, {340, 1, 4, 5, 6, 11, 13, 16, 17, 22, 24, 44, 46, 50, 51, 52, 53, 61, 64, 66, 79, 84, 85, 92, 169, 171}, {344, 2, 3, 8, 11, 14, 17, 19, 21, 23, 25, 27, 36, 39, 44, 48, 53, 56, 71, 77, 83, 86, 89, 98, 169, 175}, {359, 7, 8, 9, 10, 14, 17, 18, 23, 25, 27, 29, 31, 40, 41, 43, 46, 69, 74, 82, 85, 90, 98, 102, 172, 187}, {361, 2, 6, 7, 8, 9, 14, 20, 22, 26, 27, 32, 34, 36, 47, 49, 56, 66, 67, 74, 82, 89, 98, 107, 156, 205}, {363, 1, 4, 6, 12, 13, 20, 21, 25, 26, 27, 28, 32, 37, 41, 45, 53, 58, 64, 69, 91, 97, 102, 106, 155, 208}, {364, 2, 3, 4, 6, 8, 9, 13, 14, 16, 19, 23, 24, 28, 29, 52, 57, 64, 75, 82, 91, 98, 100, 109, 173, 191}, {367, 1, 4, 6, 12, 13, 20, 21, 25, 26, 27, 28, 32, 37, 41, 49, 53, 58, 64, 69, 91, 97, 102, 110, 155, 212}, {368, 1, 6, 15, 16, 17, 18, 22, 25, 31, 33, 39, 42, 45, 46, 47, 48, 51, 69, 72, 88, 91, 96, 112, 160, 208}, {371, 1, 2, 7, 8, 20, 21, 22, 24, 26, 28, 30, 38, 43, 46, 50, 51, 64, 65, 70, 90, 95, 102, 109, 160, 211}, {373, 3, 6, 7, 8, 15, 17, 22, 23, 31, 32, 35, 41, 43, 60, 62, 68, 79, 87, 104, 105, 114, 120, 121, 138, 148}, {378, 2, 3, 10, 17, 18, 20, 21, 22, 24, 27, 31, 38, 41, 48, 51, 56, 68, 78, 80, 85, 87, 96, 117, 165, 213}, {378, 1, 2, 7, 13, 15, 17, 18, 25, 27, 29, 30, 31, 42, 43, 46, 56, 61, 68, 73, 93, 100, 105, 112, 161, 217}, {380, 4, 7, 17, 18, 19, 20, 21, 26, 31, 33, 35, 40, 45, 48, 49, 60, 67, 73, 79, 81, 87, 107, 113, 186, 194}, {380, 4, 5, 6, 9, 13, 15, 16, 17, 22, 24, 33, 38, 44, 49, 50, 56, 60, 67, 82, 84, 95, 108, 121, 177, 203}, {381, 12, 13, 21, 23, 25, 27, 35, 36, 42, 45, 54, 57, 59, 60, 79, 82, 84, 85, 92, 95, 96, 100, 110, 111, 186}, {384, 1, 4, 8, 9, 11, 12, 19, 21, 27, 32, 35, 44, 45, 46, 47, 51, 60, 67, 84, 89, 96, 108, 120, 180, 204}, {384, 1, 4, 8, 9, 11, 12, 15, 17, 19, 25, 26, 31, 32, 37, 44, 57, 60, 81, 84, 96, 99, 108, 120, 180, 204}, {384, 3, 5, 7, 11, 12, 17, 20, 22, 25, 29, 35, 47, 48, 55, 56, 57, 69, 72, 76, 80, 96, 100, 116, 172, 212}, {385, 1, 2, 7, 13, 15, 17, 18, 25, 27, 29, 30, 31, 43, 46, 49, 56, 61, 68, 73, 93, 100, 105, 119, 161, 224}, {392, 4, 7, 8, 15, 23, 26, 29, 30, 31, 32, 34, 43, 48, 55, 56, 68, 77, 88, 98, 106, 116, 135, 141, 151, 153}, {392, 10, 12, 14, 16, 19, 21, 25, 27, 31, 35, 39, 41, 51, 52, 54, 55, 73, 92, 98, 115, 121, 123, 129, 148, 171}, {392, 1, 4, 5, 8, 11, 14, 16, 21, 22, 24, 27, 28, 30, 31, 52, 64, 81, 83, 96, 97, 98, 99, 114, 195, 197}, {393, 4, 8, 16, 20, 23, 24, 25, 27, 29, 37, 44, 45, 50, 53, 64, 66, 68, 69, 73, 85, 91, 101, 116, 186, 207}, {396, 1, 4, 5, 14, 16, 32, 35, 36, 46, 47, 48, 49, 68, 69, 73, 93, 94, 97, 99, 104, 110, 111, 125, 126, 160}, {396, 1, 4, 5, 8, 11, 14, 16, 21, 22, 24, 27, 28, 30, 31, 52, 64, 81, 83, 98, 99, 100, 101, 114, 197, 199}, {396, 3, 8, 9, 11, 14, 16, 17, 18, 31, 32, 41, 45, 48, 56, 60, 66, 73, 75, 81, 82, 98, 99, 117, 180, 216}, {398, 2, 6, 7, 11, 15, 17, 23, 28, 29, 39, 44, 46, 53, 56, 58, 65, 68, 99, 100, 119, 120, 134, 144, 145, 154}, {400, 3, 6, 21, 23, 24, 26, 29, 35, 37, 40, 41, 47, 53, 55, 64, 76, 79, 81, 99, 100, 121, 122, 137, 142, 179}, {404, 3, 6, 7, 14, 17, 20, 21, 26, 28, 31, 32, 39, 46, 53, 54, 68, 71, 80, 88, 92, 100, 111, 113, 199, 205}, {404, 4, 7, 10, 11, 12, 13, 16, 18, 20, 23, 25, 28, 29, 32, 47, 62, 70, 88, 93, 96, 101, 114, 127, 189, 215}, {408, 2, 3, 7, 13, 16, 18, 20, 27, 30, 33, 41, 43, 46, 52, 54, 57, 72, 79, 84, 100, 105, 108, 116, 195, 213}, {412, 3, 11, 12, 15, 21, 26, 32, 39, 43, 47, 54, 60, 68, 73, 83, 85, 86, 87, 89, 99, 114, 129, 139, 144, 169}, {413, 5, 7, 17, 20, 34, 38, 39, 48, 56, 57, 59, 60, 64, 65, 70, 72, 75, 81, 105, 106, 110, 125, 148, 153, 155}, {416, 2, 4, 7, 11, 13, 24, 25, 30, 35, 37, 39, 40, 44, 58, 62, 65, 82, 104, 112, 120, 128, 135, 143, 153, 169}, {416, 1, 2, 3, 8, 12, 15, 16, 17, 20, 22, 24, 26, 29, 31, 64, 75, 85, 88, 91, 94, 98, 104, 133, 179, 237}, {421, 1, 2, 4, 5, 7, 9, 12, 16, 20, 22, 23, 35, 38, 48, 56, 83, 94, 104, 116, 118, 128, 140, 150, 153, 177}, {421, 5, 11, 12, 17, 18, 20, 23, 26, 29, 36, 38, 40, 44, 51, 55, 59, 72, 92, 97, 102, 105, 107, 117, 199, 222}, {422, 2, 4, 7, 13, 16, 18, 20, 23, 28, 29, 38, 43, 46, 51, 59, 68, 74, 79, 86, 93, 100, 111, 132, 179, 243}, {425, 3, 4, 5, 9, 10, 12, 13, 14, 16, 19, 20, 31, 46, 48, 56, 79, 102, 104, 116, 126, 128, 140, 142, 157, 181}, {441, 5, 6, 7, 16, 18, 23, 24, 27, 38, 39, 47, 51, 52, 62, 66, 72, 80, 84, 92, 101, 102, 118, 120, 219, 222}, {454, 1, 2, 11, 17, 29, 34, 35, 46, 48, 51, 53, 55, 63, 69, 79, 87, 88, 91, 109, 134, 136, 143, 150, 161, 184}, {456, 5, 7, 10, 11, 13, 15, 18, 19, 31, 49, 50, 52, 59, 60, 63, 72, 77, 115, 128, 129, 135, 142, 148, 179, 193}, {465, 6, 9, 13, 14, 19, 21, 24, 25, 31, 32, 53, 56, 64, 73, 74, 82, 91, 111, 125, 127, 137, 139, 153, 173, 201}, {472, 7, 9, 13, 15, 26, 34, 35, 44, 47, 51, 58, 61, 65, 81, 87, 103, 104, 115, 118, 123, 128, 133, 136, 148, 221}, {477, 3, 5, 12, 16, 19, 22, 25, 26, 37, 41, 49, 72, 76, 77, 82, 86, 87, 115, 117, 135, 141, 149, 167, 169, 193}, {492, 2, 9, 15, 17, 27, 29, 31, 32, 33, 36, 47, 49, 50, 60, 62, 69, 77, 105, 114, 123, 127, 128, 132, 237, 255}, {492, 3, 5, 9, 11, 12, 21, 24, 27, 30, 44, 45, 50, 54, 55, 57, 63, 95, 101, 112, 117, 123, 134, 140, 235, 257}, {503, 4, 15, 16, 19, 22, 23, 25, 27, 33, 34, 50, 62, 67, 87, 88, 93, 100, 113, 135, 143, 149, 157, 167, 179, 211}, {506, 1, 7, 24, 26, 33, 35, 40, 45, 47, 51, 55, 69, 87, 90, 93, 96, 117, 125, 134, 145, 146, 147, 160, 162, 199}, {507, 2, 3, 7, 11, 13, 15, 28, 34, 43, 50, 57, 64, 80, 83, 86, 89, 107, 115, 116, 127, 149, 163, 175, 183, 217}, {512, 1, 7, 8, 9, 10, 15, 22, 32, 34, 46, 51, 65, 69, 71, 91, 105, 109, 111, 136, 139, 152, 157, 173, 200, 203}, {512, 1, 6, 7, 8, 9, 13, 17, 19, 35, 45, 47, 57, 62, 73, 88, 93, 104, 107, 128, 130, 151, 163, 184, 198, 221}, {513, 6, 9, 10, 17, 19, 24, 28, 29, 37, 39, 64, 65, 68, 81, 98, 99, 102, 115, 145, 147, 153, 159, 165, 189, 201}, {517, 5, 6, 7, 16, 20, 24, 28, 33, 38, 43, 63, 71, 80, 83, 86, 92, 98, 122, 132, 148, 164, 166, 173, 180, 205}, {524, 9, 12, 20, 21, 33, 35, 37, 39, 54, 55, 61, 62, 87, 90, 98, 101, 125, 132, 135, 141, 145, 159, 163, 164, 220}, {527, 11, 12, 13, 14, 19, 30, 41, 47, 50, 52, 59, 68, 71, 81, 94, 97, 107, 132, 147, 151, 155, 169, 175, 183, 197}, {528, 2, 9, 15, 17, 27, 29, 31, 32, 33, 36, 47, 49, 50, 60, 62, 69, 77, 123, 127, 128, 132, 141, 150, 255, 273}, {529, 9, 12, 20, 21, 33, 35, 37, 39, 54, 55, 61, 62, 87, 90, 98, 101, 125, 132, 140, 141, 145, 159, 163, 169, 225}, {531, 6, 9, 10, 17, 19, 24, 29, 31, 39, 40, 67, 68, 71, 84, 101, 102, 105, 118, 151, 153, 159, 165, 171, 195, 207}, {532, 16, 18, 26, 27, 33, 39, 41, 50, 51, 55, 69, 71, 84, 87, 91, 94, 132, 133, 141, 143, 164, 168, 169, 173, 195}, {534, 11, 13, 15, 17, 18, 27, 38, 44, 49, 52, 60, 61, 68, 81, 87, 94, 107, 135, 149, 153, 159, 171, 174, 189, 210}, {535, 2, 8, 26, 27, 36, 41, 45, 57, 62, 77, 88, 95, 97, 99, 101, 102, 109, 114, 117, 118, 141, 147, 168, 192, 226}, {536, 1, 8, 21, 30, 31, 32, 33, 41, 44, 46, 49, 55, 57, 61, 84, 91, 113, 134, 137, 139, 150, 155, 176, 205, 247}, {536, 3, 5, 9, 11, 12, 21, 24, 27, 30, 44, 45, 50, 54, 55, 57, 63, 95, 117, 123, 134, 140, 145, 156, 257, 279}, {540, 1, 7, 8, 9, 10, 14, 19, 34, 36, 51, 58, 69, 81, 83, 97, 109, 111, 115, 136, 149, 152, 167, 183, 208, 221}, {540, 6, 13, 15, 25, 28, 36, 43, 47, 55, 57, 58, 59, 60, 65, 82, 89, 91, 107, 124, 127, 144, 163, 183, 233, 250}, {540, 8, 9, 10, 11, 16, 30, 36, 38, 45, 55, 57, 65, 68, 81, 84, 95, 98, 100, 116, 117, 126, 135, 144, 261, 279}, {540, 8, 9, 10, 11, 16, 30, 36, 38, 45, 55, 57, 65, 68, 81, 84, 95, 98, 100, 116, 117, 126, 135, 144, 261, 279}, {540, 4, 6, 9, 10, 17, 21, 23, 25, 31, 33, 36, 38, 45, 50, 81, 83, 115, 117, 126, 133, 135, 144, 146, 261, 279}, {540, 4, 6, 9, 10, 17, 21, 23, 25, 31, 33, 36, 38, 45, 50, 81, 83, 115, 117, 126, 133, 135, 144, 146, 261, 279}, {541, 3, 4, 11, 13, 16, 17, 21, 25, 26, 44, 46, 64, 75, 86, 87, 97, 106, 109, 133, 141, 165, 185, 191, 215, 217}, {541, 3, 5, 27, 32, 33, 37, 47, 50, 53, 56, 57, 69, 71, 78, 97, 98, 109, 111, 126, 144, 165, 169, 183, 189, 232}, {544, 1, 7, 24, 26, 33, 35, 40, 45, 47, 51, 55, 69, 87, 90, 93, 96, 117, 125, 134, 145, 147, 184, 198, 199, 200}, {544, 6, 8, 20, 21, 23, 41, 42, 48, 59, 61, 77, 80, 81, 85, 90, 92, 93, 102, 115, 132, 139, 168, 198, 207, 244}, {547, 3, 5, 16, 22, 26, 27, 35, 47, 49, 59, 67, 71, 72, 85, 87, 102, 103, 111, 137, 144, 150, 197, 200, 203, 207}, {549, 4, 10, 14, 24, 26, 31, 34, 36, 38, 40, 43, 48, 59, 63, 74, 89, 97, 105, 117, 124, 136, 152, 156, 241, 308}, {550, 1, 2, 5, 13, 19, 20, 25, 30, 39, 43, 58, 59, 73, 75, 76, 90, 95, 103, 116, 128, 130, 132, 172, 262, 288}, {550, 1, 11, 16, 23, 24, 27, 29, 36, 41, 43, 44, 47, 59, 70, 71, 80, 99, 103, 111, 116, 128, 156, 167, 227, 323}, {551, 3, 5, 24, 25, 26, 30, 35, 36, 39, 40, 42, 57, 68, 76, 94, 109, 120, 128, 152, 162, 166, 175, 176, 200, 223}, {552, 5, 17, 18, 22, 25, 27, 32, 33, 39, 59, 62, 87, 91, 100, 102, 111, 112, 135, 137, 149, 165, 168, 183, 201, 204}, {552, 1, 3, 4, 7, 8, 9, 10, 15, 18, 19, 21, 41, 52, 54, 73, 93, 95, 123, 125, 136, 138, 153, 168, 261, 291}, {556, 6, 8, 10, 13, 19, 25, 32, 37, 49, 54, 58, 76, 84, 91, 92, 100, 107, 128, 145, 156, 165, 185, 195, 205, 206}, {556, 3, 12, 13, 15, 19, 23, 27, 34, 35, 39, 42, 45, 48, 52, 53, 87, 140, 145, 158, 166, 171, 184, 189, 201, 227}, {556, 3, 12, 13, 15, 19, 23, 27, 34, 35, 39, 42, 45, 48, 52, 53, 87, 140, 145, 158, 166, 171, 184, 189, 201, 227}, {556, 1, 5, 7, 8, 9, 10, 12, 14, 20, 27, 31, 43, 47, 50, 74, 93, 97, 121, 125, 139, 143, 153, 167, 264, 292}, {562, 2, 3, 5, 8, 13, 19, 20, 29, 33, 47, 53, 54, 64, 65, 76, 93, 119, 123, 142, 157, 161, 180, 184, 221, 259}, {570, 3, 9, 10, 33, 36, 38, 40, 42, 50, 51, 60, 69, 72, 75, 77, 90, 113, 140, 141, 151, 152, 189, 200, 229, 230}, {575, 4, 6, 14, 16, 31, 39, 63, 69, 74, 81, 88, 103, 107, 111, 115, 120, 131, 132, 133, 147, 156, 159, 164, 198, 218}, {576, 1, 4, 9, 11, 15, 19, 22, 34, 36, 53, 60, 76, 82, 84, 104, 126, 127, 128, 153, 156, 165, 174, 183, 219, 237}, {576, 8, 9, 10, 11, 16, 30, 36, 38, 45, 55, 57, 65, 68, 81, 84, 95, 98, 100, 116, 135, 144, 153, 162, 279, 297}, {576, 4, 6, 9, 10, 17, 21, 23, 25, 31, 33, 36, 38, 45, 50, 81, 83, 115, 133, 135, 144, 146, 153, 162, 279, 297}, {580, 2, 5, 7, 10, 12, 13, 19, 21, 22, 29, 36, 40, 61, 65, 74, 101, 135, 139, 161, 179, 183, 192, 205, 209, 236}, {580, 5, 6, 11, 13, 16, 17, 21, 25, 34, 44, 54, 68, 80, 88, 100, 112, 120, 135, 142, 145, 170, 173, 195, 215, 265}, {580, 11, 12, 16, 17, 29, 32, 39, 41, 53, 55, 59, 60, 68, 70, 81, 84, 92, 124, 125, 128, 129, 156, 171, 280, 300}, {593, 13, 14, 15, 35, 48, 51, 55, 67, 73, 79, 83, 91, 94, 105, 109, 116, 119, 124, 133, 150, 171, 173, 196, 217, 226}, {595, 4, 13, 18, 19, 22, 35, 40, 48, 58, 61, 62, 77, 78, 82, 83, 86, 118, 149, 163, 168, 187, 192, 202, 206, 240}, {601, 7, 8, 25, 34, 41, 42, 46, 48, 54, 55, 62, 70, 71, 74, 98, 103, 116, 143, 168, 169, 190, 192, 193, 218, 240}, {603, 7, 11, 12, 14, 21, 25, 32, 40, 52, 56, 60, 67, 68, 81, 91, 92, 132, 144, 149, 163, 177, 191, 196, 235, 263}, {603, 13, 23, 26, 27, 35, 44, 45, 49, 53, 54, 57, 66, 75, 99, 101, 110, 122, 126, 144, 158, 175, 180, 189, 234, 270}, {607, 6, 8, 10, 13, 19, 25, 32, 37, 49, 54, 58, 76, 84, 91, 92, 100, 107, 128, 156, 185, 196, 205, 206, 216, 246}, {609, 9, 14, 15, 17, 32, 45, 47, 58, 67, 74, 76, 79, 80, 83, 97, 111, 125, 126, 150, 170, 186, 188, 215, 224, 235}, {611, 1, 10, 22, 26, 32, 41, 45, 54, 57, 61, 62, 66, 85, 86, 87, 95, 97, 101, 119, 132, 136, 167, 176, 268, 343}, {614, 15, 22, 24, 31, 33, 49, 53, 54, 57, 60, 63, 68, 74, 81, 83, 104, 109, 151, 155, 163, 167, 217, 229, 230, 234}, {634, 15, 17, 24, 26, 33, 43, 44, 54, 57, 60, 63, 73, 79, 81, 88, 109, 119, 160, 161, 172, 173, 227, 234, 235, 239}, {643, 2, 9, 21, 29, 38, 40, 41, 42, 58, 62, 67, 76, 82, 83, 85, 96, 104, 166, 172, 186, 192, 201, 207, 250, 270}, {644, 7, 9, 13, 18, 19, 22, 31, 49, 53, 61, 66, 68, 71, 87, 93, 94, 119, 164, 178, 192, 199, 206, 227, 239, 253}, {655, 10, 14, 15, 21, 25, 26, 31, 40, 51, 53, 54, 57, 65, 83, 84, 86, 151, 152, 173, 193, 194, 215, 216, 246, 288}, {661, 5, 7, 17, 18, 23, 31, 36, 38, 41, 64, 73, 77, 83, 84, 102, 106, 111, 161, 175, 196, 203, 210, 238, 248, 262}};

        Perfect() {
        }
    }

    static interface Stringx3Consumer {
        public void accept(String var1, String var2, String var3);
    }

    private static class HandleFlow
    implements Runnable {
        private InputStream inputStream;

        private HandleFlow(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public void run() {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(this.inputStream));){
                String line = br.readLine();
                while (line != null) {
                    System.out.println(line);
                    line = br.readLine();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

