/*
 * Decompiled with CFR 0.152.
 */
package problem;

import constraints.Constraint;
import constraints.hard.CtrExtension;
import constraints.hard.CtrIntension;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xcsp.common.IVar;
import org.xcsp.common.Size;
import org.xcsp.common.Types;
import org.xcsp.modeler.Compiler;
import org.xcsp.modeler.definitions.ICtr;
import problem.Problem;
import problem.Subproblem;
import problems.xcsp2.XCSP2;
import utility.Kit;
import utility.exceptions.MissingImplementationException;
import variables.Variable;

public final class Compiler3Abscon
extends Compiler {
    protected final Problem pb;
    protected final Subproblem subpb;

    public Compiler3Abscon(Subproblem subpb) {
        super(subpb.pb.api);
        this.pb = subpb.pb;
        this.subpb = subpb;
        this.ignoreAutomaticGroups = this.pb.rs.cp.xml.ignoreAutomaticGroups;
        this.saveImmediatelyStored = this.pb.rs.cp.xml.saveImmediatelyStored;
    }

    protected Document buildDocument() {
        this.specificAbscon();
        return super.buildDocument();
    }

    protected void putInMap(IVar x, Map<IVar, String> map) {
        map.put(x, ((Variable)x).dom.stringListOfValues());
    }

    protected Element variables() {
        if (!this.subpb.isFullProblem()) {
            throw new MissingImplementationException();
        }
        return super.variables();
    }

    protected void handleCtr(Element parent, ICtr ctr) {
        if (((Constraint)ctr).pb.optimizationPilot != null && ((Constraint)ctr).pb.optimizationPilot.ctr == ctr) {
            return;
        }
        super.handleCtr(parent, ctr);
    }

    protected void setSpecificFrameworkAttributes(Element rootOfConstraints) {
        if (this.imp.typeFramework() == Types.TypeFramework.WCSP) {
            if (this.pb.rs.cp.optimizing.lowerBound != 0L && this.pb.rs.cp.optimizing.lowerBound != Long.MIN_VALUE) {
                rootOfConstraints.setAttribute(Types.TypeAtt.lb.name(), this.pb.rs.cp.optimizing.lowerBound + "");
            }
            if (this.pb.rs.cp.optimizing.upperBound != Long.MAX_VALUE) {
                rootOfConstraints.setAttribute(Types.TypeAtt.ub.name(), this.pb.rs.cp.optimizing.upperBound + "");
            }
            Kit.control(this.pb.rs.cp.optimizing.upperBound > 0L);
        }
    }

    protected Element constraints() {
        if (!this.subpb.isFullProblem()) {
            throw new MissingImplementationException();
        }
        return super.constraints();
    }

    private void specificAbscon() {
        Kit.control(this.subpb.isFullProblem(), () -> "currently, only full problems handled");
        if (this.pb.ctrEntities.ctrToCtrArray.size() == 0 && !this.ignoreAutomaticGroups) {
            ICtr[] cis;
            ICtr[] ces = (CtrExtension[])Stream.of(this.pb.constraints).filter(c -> c instanceof CtrExtension).map(c -> (CtrExtension)c).toArray(CtrExtension[]::new);
            if (ces.length > 1) {
                this.pb.ctrEntities.newCtrArrayEntity(ces, false, new Types.TypeClass[0]);
            }
            if ((cis = (CtrIntension[])Stream.of(this.pb.constraints).filter(c -> c instanceof CtrIntension).map(c -> (CtrIntension)c).toArray(CtrIntension[]::new)).length > 1) {
                this.pb.ctrEntities.newCtrArrayEntity(cis, false, new Types.TypeClass[0]);
            }
        }
        if (this.pb.api instanceof XCSP2) {
            Kit.control(this.pb.framework == Types.TypeFramework.CSP);
            Map<Integer, List<Variable>> map = Arrays.stream(this.pb.variables).collect(Collectors.groupingBy(x -> x.dom.typeIdentifier()));
            long nRealArrays = map.values().stream().filter(v -> v.size() > 1).count();
            boolean keepXCSP2OriginalVariableNames = false;
            if (!keepXCSP2OriginalVariableNames) {
                if (map.size() > 10 && 3 * map.size() > this.pb.variables.length) {
                    IntStream.range(0, this.pb.variables.length).forEach(i -> this.pb.variables[i].setId("x" + i));
                } else {
                    int cnt = 0;
                    for (Map.Entry<Integer, List<Variable>> entry : map.entrySet()) {
                        String s;
                        Variable[] vars = entry.getValue().toArray(new Variable[0]);
                        String string = nRealArrays > 4L ? "x" + entry.getKey() : (vars.length == 1 ? "v" + entry.getKey() : (nRealArrays == 4L ? (cnt == 0 ? "w" : (cnt == 1 ? "x" : (cnt == 2 ? "y" : "z"))) : (cnt == 0 ? "x" : (s = cnt == 1 ? "y" : "z"))));
                        if (vars.length == 1) {
                            vars[0].setId(s);
                            continue;
                        }
                        this.pb.varEntities.newVarArrayEntity(s, (Size)this.pb.api.size(vars.length), (Object)vars, null, new Types.TypeClass[0]);
                        IntStream.range(0, vars.length).forEach(i -> vars[i].setId(s + this.pb.variableNameSuffixFor(new int[]{i})));
                        ++cnt;
                    }
                }
            }
        }
    }
}

