/*
 * Decompiled with CFR 0.152.
 */
package objectives;

import dashboard.Arguments;
import objectives.OptimizationCompatible;
import org.xcsp.common.Types;
import problem.Problem;
import propagation.soft.LowerBoundCapability;
import search.backtrack.SolverBacktrack;
import search.local.SolverLocal;
import utility.Enums;
import utility.Kit;
import variables.Variable;

public abstract class OptimizationPilot {
    private static Long sharedMinBound = Long.MIN_VALUE;
    private static Long sharedMaxBound = Long.MAX_VALUE;
    public final Problem pb;
    public final boolean minimization;
    public final OptimizationCompatible ctr;
    protected long minBound;
    protected long maxBound;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean possiblyUpdateSharedBounds() {
        if (!Arguments.multiThreads) {
            return false;
        }
        boolean modified = false;
        Long l = sharedMinBound;
        synchronized (l) {
            if (this.minBound > sharedMinBound) {
                sharedMinBound = this.minBound;
                modified = true;
            }
        }
        l = sharedMaxBound;
        synchronized (l) {
            if (this.maxBound < sharedMaxBound) {
                sharedMaxBound = this.maxBound;
                modified = true;
            }
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean possiblyUpdateLocalBounds() {
        if (!Arguments.multiThreads) {
            return false;
        }
        boolean modified = false;
        Long l = sharedMinBound;
        synchronized (l) {
            if (sharedMinBound > this.minBound) {
                this.minBound = sharedMinBound;
                modified = true;
            }
        }
        l = sharedMaxBound;
        synchronized (l) {
            if (sharedMaxBound < this.maxBound) {
                this.maxBound = sharedMaxBound;
                modified = true;
            }
        }
        if (modified) {
            Kit.log.fine("New Bounds updated from other workers : " + this.stringBounds());
            this.pb.solver.restarter.optimizationStop = true;
        }
        return modified;
    }

    public OptimizationPilot(Problem pb, Types.TypeOptimization opt, OptimizationCompatible ctr) {
        this.pb = pb;
        Kit.control(opt != null);
        this.minimization = opt == Types.TypeOptimization.MIN;
        this.ctr = ctr;
        this.minBound = Math.max(pb.rs.cp.optimizing.lowerBound, ctr != null ? ctr.minComputableObjectiveValue() : Long.MIN_VALUE);
        this.maxBound = Math.min(pb.rs.cp.optimizing.upperBound, ctr != null ? ctr.maxComputableObjectiveValue() : Long.MAX_VALUE);
    }

    public final long value() {
        assert (Variable.areAllFixed(this.pb.variables));
        if (this.ctr != null) {
            return this.ctr.objectiveValue();
        }
        if (this.pb.solver.propagation instanceof LowerBoundCapability) {
            return ((LowerBoundCapability)((Object)this.pb.solver.propagation)).getLowerBound();
        }
        return ((SolverLocal)this.pb.solver).nMinViolatedCtrs;
    }

    public final boolean isBetterBound(long bound) {
        return this.minimization ? bound <= this.maxBound : bound >= this.minBound;
    }

    protected abstract void shiftLimitWhenSuccess();

    protected abstract void shiftLimitWhenFailure();

    public void afterRun() {
        Kit.control(this.pb.rs.cp.framework == Types.TypeFramework.COP);
        if (this.pb.solver.restarter.optimizationStop) {
            if (this.minimization) {
                this.maxBound = this.pb.solver.solManager.bestBound - 1L;
            } else {
                this.minBound = this.pb.solver.solManager.bestBound + 1L;
            }
            this.possiblyUpdateLocalBounds();
            Kit.control(this.minBound - 1L <= this.maxBound || this.pb.rs.cp.optimizing.upperBound != Long.MAX_VALUE);
            this.possiblyUpdateSharedBounds();
            if (this.minBound > this.maxBound) {
                this.pb.solver.stoppingType = Enums.EStopping.FULL_EXPLORATION;
            } else {
                this.shiftLimitWhenSuccess();
            }
        } else if (this.pb.solver.stoppingType == Enums.EStopping.FULL_EXPLORATION) {
            long limit = this.ctr.getLimit();
            if (this.minimization) {
                this.minBound = limit == Long.MAX_VALUE ? Long.MAX_VALUE : limit + 1L;
            } else {
                this.maxBound = limit == Long.MIN_VALUE ? Long.MIN_VALUE : limit - 1L;
            }
            Kit.log.fine("\n  New Bounds: " + this.stringBounds());
            if (this.minBound <= this.maxBound) {
                this.pb.solver.stoppingType = null;
                Kit.control(this.pb.stuff.nValuesRemovedAtConstructionTime == 0, () -> "Not handled for the moment");
                this.pb.solver.restarter.optimizationStop = true;
                ((SolverBacktrack)this.pb.solver).restoreProblem();
                this.shiftLimitWhenFailure();
            }
            if (((SolverBacktrack)this.pb.solver).learnerNogoods != null) {
                ((SolverBacktrack)this.pb.solver).learnerNogoods.reset();
            }
        }
    }

    public void shiftLimit(int offset) {
        Kit.control(offset >= 0 && this.minBound + (long)offset <= this.maxBound);
        long newLimit = this.minimization ? this.maxBound - (long)offset : this.minBound + (long)offset;
        Kit.log.finer("  New Limit: " + newLimit + "\n");
        this.ctr.setLimit(newLimit);
    }

    public boolean areBoundsConsistent() {
        return this.minBound <= this.maxBound;
    }

    public final String stringBounds() {
        return (this.minBound == Long.MIN_VALUE ? "-infty" : Long.valueOf(this.minBound)) + ".." + (this.maxBound == Long.MAX_VALUE ? "+infty" : Long.valueOf(this.maxBound));
    }

    public String toString() {
        return (this.minimization ? Types.TypeOptimization.MIN : Types.TypeOptimization.MAX).toString().toLowerCase() + " " + this.ctr.toString();
    }
}

