/*
 * Decompiled with CFR 0.152.
 */
package objectives;

import objectives.Obj;
import org.xcsp.common.Types;
import problem.Problem;
import utility.Kit;
import variables.Variable;

public abstract class ObjVar
extends Obj {
    protected Variable x;

    @Override
    public long objectiveValue() {
        return this.x.dom.uniqueValue();
    }

    public ObjVar(Problem pb, Variable x, int limit) {
        super(pb, new Variable[]{x}, limit);
        this.x = x;
    }

    public static final class ObjVarGE
    extends ObjVar {
        public ObjVarGE(Problem pb, Variable x, int limit) {
            super(pb, x, limit);
        }

        @Override
        public boolean checkValues(int[] vals) {
            return vals[0] >= this.limit;
        }

        @Override
        public boolean runPropagator(Variable evt) {
            if (this.entailed) {
                return true;
            }
            Kit.control(this.pb.solver.depth() == 0);
            if (!this.x.dom.removeValues(Types.TypeOperatorRel.LT, this.limit)) {
                return false;
            }
            this.entailed = true;
            assert (this.x.dom.size() > 0);
            return true;
        }
    }

    public static final class ObjVarLE
    extends ObjVar {
        public ObjVarLE(Problem pb, Variable x, int limit) {
            super(pb, x, limit);
        }

        @Override
        public boolean checkValues(int[] vals) {
            return vals[0] <= this.limit;
        }

        @Override
        public boolean runPropagator(Variable evt) {
            if (this.entailed) {
                return true;
            }
            Kit.control(this.pb.solver.depth() == 0);
            if (!this.x.dom.removeValues(Types.TypeOperatorRel.GT, this.limit)) {
                return false;
            }
            this.entailed = true;
            assert (this.x.dom.size() > 0);
            return true;
        }
    }
}

