/*
 * Decompiled with CFR 0.152.
 */
package learning;

import constraints.Constraint;
import java.util.Arrays;
import learning.LearnerStates;
import learning.LearnerStatesEquivalence;
import propagation.order1.AC;
import search.Solver;
import search.backtrack.SolverBacktrack;
import utility.Kit;
import variables.Variable;
import variables.domains.Domain;

public final class ReductionOperator {
    private LearnerStates learner;
    private boolean isGACGuaranteed;
    private boolean binaryNetwork;
    private final boolean[] selectedVariables;
    private boolean eliminateEntailedVariables;
    private boolean eliminateInitialDomainVariables;
    private boolean eliminateJustifiedVariables;
    private boolean eliminateDegreeVariables;
    private boolean eliminateNotInProofVariables;
    private double nbSEliminableVariables;
    private double nbREliminableVariables;
    private double nbIEliminableVariables;
    private double nbDEliminableVariables;
    private double nbPEliminableVariables;
    private int nbExtractions;
    private final int[] tmpVariable;
    private Constraint[] nonUniversal;

    public double getProportionOfNbSEliminableVariables() {
        return this.nbSEliminableVariables / (double)this.nbExtractions;
    }

    public double getProportionOfNbREliminableVariables() {
        return this.nbREliminableVariables / (double)this.nbExtractions;
    }

    public double getProportionOfNbIEliminableVariables() {
        return this.nbIEliminableVariables / (double)this.nbExtractions;
    }

    public double getProportionOfNbDEliminableVariables() {
        return this.nbDEliminableVariables / (double)this.nbExtractions;
    }

    public double getProportionOfNbPEliminableVariables() {
        return this.nbPEliminableVariables / (double)this.nbExtractions;
    }

    public boolean enablePElimination() {
        return this.eliminateNotInProofVariables;
    }

    private boolean parse(char c) {
        return c == '0' ? false : (c == '1' ? true : (Boolean)Kit.exit("The expected character should have been 0 or 1"));
    }

    private void parseReductionMode(String s) {
        Kit.control(s.length() == 5);
        this.eliminateEntailedVariables = this.parse(s.charAt(0));
        this.eliminateInitialDomainVariables = this.parse(s.charAt(1));
        this.eliminateDegreeVariables = this.parse(s.charAt(2));
        this.eliminateJustifiedVariables = this.parse(s.charAt(3));
        this.eliminateNotInProofVariables = this.parse(s.charAt(4));
        if (this.eliminateNotInProofVariables && this.learner instanceof LearnerStatesEquivalence) {
            this.eliminateNotInProofVariables = false;
            Kit.log.warning("partial state operator 'eliminateNotInProofVariables' set to false");
        }
    }

    public ReductionOperator(LearnerStates learner) {
        this.learner = learner;
        SolverBacktrack solver = learner.solver;
        this.isGACGuaranteed = solver.propagation.getClass() == AC.class && Constraint.isGuaranteedGACOn(solver.pb.constraints);
        this.binaryNetwork = solver.pb.stuff.maxCtrArity() == 2;
        this.tmpVariable = new int[solver.pb.variables.length];
        this.parseReductionMode(learner.solver.rs.cp.learning.stateOperators);
        this.selectedVariables = new boolean[solver.pb.variables.length];
    }

    private int getNbFreeVariablesIn(Constraint ctr) {
        int cnt = 0;
        for (int i = ctr.futvars.limit; i >= 0; --i) {
            if (ctr.scp[ctr.futvars.dense[i]].dom.size() == 1) continue;
            ++cnt;
        }
        return cnt;
    }

    private boolean canEliminateSingleton(Variable x) {
        assert (x.dom.size() == 1);
        if (!this.isGACGuaranteed) {
            return false;
        }
        if (this.binaryNetwork) {
            return true;
        }
        for (Constraint c : x.ctrs) {
            if (this.getNbFreeVariablesIn(c) <= 1) continue;
            return false;
        }
        return true;
    }

    private void initEliminateDegree() {
        if (this.nonUniversal == null) {
            this.nonUniversal = new Constraint[this.learner.solver.pb.variables.length];
        } else {
            Arrays.fill(this.nonUniversal, null);
        }
        for (Constraint c : this.learner.solver.pb.constraints) {
            if (this.getNbFreeVariablesIn(c) < 2) continue;
            for (Variable x : c.scp) {
                this.nonUniversal[x.num] = this.nonUniversal[x.num] == null ? c : Constraint.TAG;
            }
        }
    }

    private boolean canEliminateDegree(Variable x) {
        Constraint c = this.nonUniversal[x.num];
        if (c == null) {
            return true;
        }
        if (c == Constraint.TAG) {
            return false;
        }
        int cnt = 0;
        for (Variable y : c.scp) {
            if (this.nonUniversal[y.num] != Constraint.TAG || ++cnt <= 1) continue;
            return false;
        }
        return true;
    }

    public boolean canEliminate(Variable x) {
        if (this.eliminateEntailedVariables && x.dom.size() == 1 && this.canEliminateSingleton(x)) {
            this.nbSEliminableVariables += 1.0;
            return true;
        }
        if (this.eliminateInitialDomainVariables && x.dom.size() == x.dom.initSize()) {
            this.nbREliminableVariables += 1.0;
            return true;
        }
        if (this.eliminateDegreeVariables && this.canEliminateDegree(x)) {
            this.nbDEliminableVariables += 1.0;
            return true;
        }
        return false;
    }

    private boolean canEliminateDeduced(Variable x) {
        Domain dom = x.dom;
        int a = dom.lastRemoved();
        while (a != -1) {
            Constraint explanation = this.learner.justifier.justifications[x.num][a];
            if (explanation == null) {
                return false;
            }
            if (explanation != Constraint.TAG) {
                for (Variable y : explanation.scp) {
                    if (x == y || this.selectedVariables[y.num]) continue;
                    return false;
                }
            }
            a = dom.prevRemoved(a);
        }
        this.nbIEliminableVariables += 1.0;
        return true;
    }

    public int[] extract() {
        int i;
        Object proofVariables;
        ++this.nbExtractions;
        int selectionLimit = 0;
        Arrays.fill(this.selectedVariables, false);
        if (this.eliminateDegreeVariables) {
            this.initEliminateDegree();
        }
        SolverBacktrack solver = this.learner.solver;
        Variable[] variables = solver.pb.variables;
        if (this.eliminateNotInProofVariables) {
            proofVariables = solver.proofer.getProofVariablesAt(((Solver)solver).depth());
            for (i = 0; i < ((boolean[])proofVariables).length; ++i) {
                if (proofVariables[i]) {
                    if (this.canEliminate(variables[i])) continue;
                    this.tmpVariable[selectionLimit++] = i;
                    this.selectedVariables[i] = true;
                    continue;
                }
                this.nbPEliminableVariables += 1.0;
            }
        } else if (solver.pb.stuff.maxCtrArity() == 2) {
            this.nbSEliminableVariables += (double)solver.futVars.nDiscarded();
            proofVariables = solver.futVars.iterator();
            while (proofVariables.hasNext()) {
                Variable x = (Variable)proofVariables.next();
                if (this.canEliminate(x)) continue;
                this.tmpVariable[selectionLimit++] = x.num;
                this.selectedVariables[x.num] = true;
            }
        } else {
            for (boolean x : (Object)variables) {
                if (this.canEliminate((Variable)x)) continue;
                this.tmpVariable[selectionLimit++] = x.num;
                this.selectedVariables[x.num] = true;
            }
        }
        if (this.eliminateJustifiedVariables) {
            int nbSelectedVariables = 0;
            for (i = 0; i < selectionLimit; ++i) {
                if (this.canEliminateDeduced(variables[this.tmpVariable[i]])) continue;
                this.tmpVariable[nbSelectedVariables++] = this.tmpVariable[i];
            }
            selectionLimit = nbSelectedVariables;
        }
        int[] t = new int[selectionLimit];
        for (i = 0; i < selectionLimit; ++i) {
            t[i] = this.tmpVariable[i];
        }
        return t;
    }

    public int[] extractForAllSolutions() {
        SolverBacktrack solver = this.learner.solver;
        int selectionLimit = 0;
        if (solver.pb.stuff.maxCtrArity() == 2) {
            this.nbSEliminableVariables += (double)solver.futVars.nDiscarded();
            for (Variable x : solver.futVars) {
                if (x.dom.size() != 1 || !this.canEliminateSingleton(x)) continue;
                this.tmpVariable[selectionLimit++] = x.num;
            }
        } else {
            for (Variable x : solver.pb.variables) {
                if (x.dom.size() != 1 || !this.canEliminateSingleton(x)) continue;
                this.tmpVariable[selectionLimit++] = x.num;
            }
        }
        int[] variableIndices = new int[selectionLimit];
        System.arraycopy(this.tmpVariable, 0, variableIndices, 0, selectionLimit);
        return variableIndices;
    }

    public int[] extract2() {
        ++this.nbExtractions;
        SolverBacktrack solver = this.learner.solver;
        boolean[] proofVariables = solver.proofer.getProofVariablesAt(((Solver)solver).depth());
        int selectionLimit = 0;
        for (int i = 0; i < solver.pb.variables.length; ++i) {
            if (!proofVariables[i]) continue;
            this.tmpVariable[selectionLimit++] = i;
        }
        int[] t = new int[selectionLimit];
        for (int i = 0; i < selectionLimit; ++i) {
            t[i] = this.tmpVariable[i];
        }
        return t;
    }
}

