/*
 * Decompiled with CFR 0.152.
 */
package learning;

import learning.LearnerStates;
import learning.State;
import search.backtrack.GlobalObserver;
import search.backtrack.SolverBacktrack;
import utility.Enums;
import utility.Kit;
import utility.observers.ObserverBacktrackingUnsystematic;
import utility.operations.Bit;
import variables.Variable;
import variables.domains.Domain;

public final class LearnerStatesDominance
extends LearnerStates {
    protected State[] waitingNogoods;
    protected WatchCell[] watches;
    protected WatchCell free;
    protected int nbTotalRemovals;
    protected int nbWipeout;
    protected int nbHyperNogoods;
    public int nbGeneratedHyperNogoods;
    private int[] offsets;
    private State[] quarantine = new State[100];
    private int quarantineSize;
    private int[] topBeforeRefutations;

    public LearnerStatesDominance(SolverBacktrack solver) {
        super(solver);
        Kit.control(solver.propagation != null);
        int capacity = 0;
        this.offsets = new int[solver.pb.variables.length];
        for (int i = 0; i < this.offsets.length; ++i) {
            this.offsets[i] = capacity;
            capacity += solver.pb.variables[i].dom.initSize();
        }
        this.watches = new WatchCell[capacity];
        if (this.reductionOperator.enablePElimination()) {
            this.topBeforeRefutations = new int[this.offsets.length + 1];
        } else {
            this.waitingNogoods = new State[this.offsets.length + 1];
        }
        solver.propagation.queue.setStateDominanceManager(this);
    }

    private void insertHyperNogood(State hyperNogood, int accessKey) {
        if (this.free == null) {
            this.watches[accessKey] = new WatchCell(hyperNogood, this.watches[accessKey]);
        } else {
            WatchCell cell = this.free;
            this.free = this.free.nextCell;
            cell.state = hyperNogood;
            cell.nextCell = this.watches[accessKey];
            this.watches[accessKey] = cell;
        }
    }

    private boolean canFindAnotherWatch(State hyperNogood, int watchPosition) {
        long[] binDom = this.variables[hyperNogood.getVariableIdWatchedAt((int)watchPosition)].dom.binaryRepresentation();
        int pos = Bit.firstPositionOfNonInclusion(binDom, hyperNogood.getDomainRepresentationOfWatchedVariableAt(watchPosition));
        if (pos != -1) {
            this.insertHyperNogood(hyperNogood, this.offsets[hyperNogood.getVariableIdWatchedAt(watchPosition)] + pos);
            hyperNogood.setIndex(watchPosition, pos);
            return true;
        }
        int[] vids = hyperNogood.vids;
        for (int i = 0; i < vids.length; ++i) {
            if (hyperNogood.isWatched(vids[i]) || (pos = Bit.firstPositionOfNonInclusion(binDom = this.variables[vids[i]].dom.binaryRepresentation(), hyperNogood.getDomainRepresentationOfVariableAtPosition(i))) == -1) continue;
            this.insertHyperNogood(hyperNogood, this.offsets[vids[i]] + pos);
            hyperNogood.setWatch(watchPosition, i, pos);
            return true;
        }
        return false;
    }

    public boolean checkWatchesOf(int vid, int idx) {
        int lit = this.offsets[vid] + idx;
        WatchCell previous = null;
        WatchCell current = this.watches[lit];
        while (current != null) {
            State hyperNogood = current.state;
            int watchPosition = hyperNogood.getWatchPositionOf(vid);
            if (this.canFindAnotherWatch(hyperNogood, watchPosition)) {
                WatchCell tmp = current.nextCell;
                if (previous == null) {
                    this.watches[lit] = current.nextCell;
                } else {
                    previous.nextCell = current.nextCell;
                }
                current.nextCell = this.free;
                this.free = current;
                current = tmp;
                continue;
            }
            previous = current;
            current = current.nextCell;
            if (this.dealWithInference(hyperNogood, hyperNogood.getVariablePositionAt(watchPosition == 0 ? 1 : 0))) continue;
            return false;
        }
        return true;
    }

    private boolean canFindAWatch(State hyperNogood, int pos) {
        int[] vids = hyperNogood.vids;
        for (int i = 0; i < vids.length; ++i) {
            long[] binDom;
            int indexPosition;
            if (i == pos || (indexPosition = Bit.firstPositionOfNonInclusion(binDom = this.variables[vids[i]].dom.binaryRepresentation(), hyperNogood.getDomainRepresentationOfVariableAtPosition(i))) == -1) continue;
            hyperNogood.setWatch(pos == -1 ? 0 : 1, i, indexPosition);
            return true;
        }
        return false;
    }

    protected boolean dealWithInference(State hyperNogood, int pos) {
        Variable var = this.solver.pb.variables[hyperNogood.vids[pos]];
        long[] domainRepresentation = hyperNogood.getDomainRepresentationAt(pos);
        Domain dom = var.dom;
        if (var.isAssigned() && Bit.isPresent(domainRepresentation, dom.first())) {
            this.solver.proofer.updateProof(hyperNogood.vids);
            ++this.nbWipeout;
            return false;
        }
        int sizeBefore = dom.size();
        int idx = dom.first();
        while (idx != -1) {
            if (Bit.isPresent(domainRepresentation, idx)) {
                dom.removeElementary(idx);
            }
            idx = dom.next(idx);
        }
        int nbRemovals = sizeBefore - dom.size();
        if (nbRemovals > 0) {
            this.solver.proofer.updateProof(hyperNogood.vids);
            if (dom.size() == 0) {
                ++this.nbWipeout;
            } else {
                this.nbTotalRemovals += nbRemovals;
            }
            if (!dom.afterElementaryCalls(sizeBefore)) {
                return false;
            }
        }
        return true;
    }

    private boolean manageQuarantine() {
        for (int i = 0; i < this.quarantineSize; ++i) {
            State hyperNogood = this.quarantine[i];
            int[] vids = hyperNogood.vids;
            if (vids.length == 1) {
                if (this.dealWithInference(hyperNogood, 0)) continue;
                return false;
            }
            if (!this.canFindAWatch(hyperNogood, -1)) {
                this.solver.proofer.updateProof(hyperNogood.vids);
                ++this.nbWipeout;
                return false;
            }
            int pos = hyperNogood.getVariablePositionAt(0);
            if (this.canFindAWatch(hyperNogood, pos)) {
                this.insertHyperNogood(hyperNogood, this.offsets[hyperNogood.getVariableIdWatchedAt(0)] + hyperNogood.getIndexWatchedAt(0));
                this.insertHyperNogood(hyperNogood, this.offsets[hyperNogood.getVariableIdWatchedAt(1)] + hyperNogood.getIndexWatchedAt(1));
                --this.quarantineSize;
                this.quarantine[i--] = this.quarantine[this.quarantineSize];
                ++this.nbHyperNogoods;
                continue;
            }
            if (this.dealWithInference(hyperNogood, pos)) continue;
            return false;
        }
        return true;
    }

    private void preparePartialBacktrack(int level) {
        GlobalObserver variablesObserver = this.solver.observerVars;
        int topStack = variablesObserver.top;
        ObserverBacktrackingUnsystematic[] globalStack = variablesObserver.stack;
        this.topBeforeRefutations[level] = topStack;
        if (topStack == -1 || ((Variable)globalStack[topStack]).dom.lastRemovedLevel() < level) {
            return;
        }
        int i = topStack;
        while (globalStack[i] != null) {
            ((Variable)globalStack[i]).dom.setMark(level);
            --i;
        }
    }

    @Override
    public boolean dealWhenOpeningNode() {
        if (this.reductionOperator.enablePElimination()) {
            this.topBeforeRefutations[this.solver.depth()] = -2;
        }
        if (!this.manageQuarantine() || !this.solver.propagation.propagate()) {
            return false;
        }
        if (this.reductionOperator.enablePElimination()) {
            this.preparePartialBacktrack(this.solver.depth());
        } else {
            this.waitingNogoods[this.solver.depth()] = new State(this, this.reductionOperator.extract());
        }
        return true;
    }

    private void performPartialBacktrack(int topBefore, int depth) {
        int i;
        GlobalObserver variablesObserver = this.solver.observerVars;
        int topStack = variablesObserver.top;
        ObserverBacktrackingUnsystematic[] globalStack = variablesObserver.stack;
        if (topStack == -1 || ((Variable)globalStack[topStack]).dom.lastRemovedLevel() < depth) {
            return;
        }
        variablesObserver.top = topBefore;
        for (i = topStack; i > topBefore; --i) {
            if (globalStack[i] == null) {
                assert (i == topBefore + 1);
                return;
            }
            ((Variable)globalStack[i]).dom.restoreBefore(depth);
        }
        i = topBefore;
        while (globalStack[i] != null) {
            ((Variable)globalStack[i]).dom.restoreAtMark(depth);
            --i;
        }
    }

    @Override
    public void dealWhenClosingNode() {
        int level = this.solver.depth();
        if (level == 0) {
            return;
        }
        State state = null;
        if (this.reductionOperator.enablePElimination()) {
            int topBefore = this.topBeforeRefutations[level];
            if (topBefore == -2) {
                return;
            }
            this.performPartialBacktrack(topBefore, level);
            state = new State(this, this.reductionOperator.extract());
        } else {
            state = this.waitingNogoods[level];
        }
        assert (state != null);
        if (state.vids.length == 0) {
            Kit.log.info("empty nogood");
            this.solver.stoppingType = Enums.EStopping.FULL_EXPLORATION;
        } else {
            if (this.quarantineSize + 1 > this.quarantine.length) {
                State[] t = new State[this.quarantine.length * 2];
                System.arraycopy(this.quarantine, 0, t, 0, this.quarantine.length);
                this.quarantine = t;
            }
            this.quarantine[this.quarantineSize++] = state;
        }
    }

    @Override
    public void displayStats() {
        Kit.log.info("nbHyperNogoods=" + this.nbGeneratedHyperNogoods + " nbTotalRemovals=" + this.nbTotalRemovals + " nbWipeouts=" + this.nbWipeout);
    }

    public void display() {
        Kit.log.fine("Nb Hyper Nogoods = " + this.nbHyperNogoods);
        for (int i = 0; i < this.watches.length; ++i) {
            String s = "Watches for " + this.solver.pb.variables[i] + " ";
            WatchCell cell = this.watches[i];
            while (cell != null) {
                s = s + cell.state.toString();
                cell = cell.nextCell;
            }
            Kit.log.fine(s);
        }
    }

    class WatchCell {
        State state;
        WatchCell nextCell;

        WatchCell(State state, WatchCell nextCell) {
            this.state = state;
            this.nextCell = nextCell;
        }
    }
}

