/*
 * Decompiled with CFR 0.152.
 */
package learning;

import learning.Justifier;
import learning.ReductionOperator;
import search.backtrack.SolverBacktrack;
import utility.Kit;
import utility.observers.ObserverRuns;
import variables.Variable;

public abstract class LearnerStates
implements ObserverRuns {
    protected int memoryLimit = 600000000;
    protected SolverBacktrack solver;
    protected Variable[] variables;
    public ReductionOperator reductionOperator;
    protected Justifier justifier;
    protected boolean stop = false;
    public int nbInferences;

    @Override
    public void beforeRun() {
    }

    @Override
    public void afterRun() {
        this.displayStats();
    }

    public boolean isStopped() {
        return this.stop;
    }

    public void clear() {
    }

    public LearnerStates(SolverBacktrack solver) {
        this.solver = solver;
        this.variables = solver.pb.variables;
        this.reductionOperator = new ReductionOperator(this);
        this.justifier = new Justifier(this);
    }

    protected boolean mustStop() {
        return Kit.getUsedMemory() > (long)this.memoryLimit;
    }

    public abstract boolean dealWhenOpeningNode();

    public abstract void dealWhenClosingNode();

    public void displayStats() {
    }
}

