/*
 * Decompiled with CFR 0.152.
 */
package learning;

import dashboard.ControlPanel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import learning.LearnerNogoods;
import learning.Nogood;
import org.xcsp.common.Utilities;
import search.backtrack.SolverBacktrack;
import utility.Enums;
import utility.Kit;
import utility.observers.ObserverRuns;
import utility.sets.SetDense;
import variables.Variable;
import variables.domains.Domain;

public final class LearnerNogoodsAdvanced
extends LearnerNogoods
implements ObserverRuns {
    private Nogood[] nogoods;
    private WatchCell[][] positiveWatchLists;
    private WatchCell[][] negativeWatchLists;
    private WatchCell free;
    private Map<Integer, Integer>[] mapOfSymmetryGroupGenerators;
    private Set<int[]>[] nogoodsSetsBySize;
    private int[][] tmps;
    private List<Integer> unaryNogoodsToHandle = new ArrayList<Integer>();
    private LinkedList<int[]> naryNogoodsToHandle = new LinkedList();
    private int[] tmp;
    private ControlPanel cfg;
    public Set<Integer> decisionsToBePerformedAtNextRun = new HashSet<Integer>();

    @Override
    public void beforeRun() {
        boolean effective = false;
        for (int decision : this.decisionsToBePerformedAtNextRun) {
            Variable x = this.dr.varIn(decision);
            int a = this.dr.idxIn(decision);
            Kit.log.info("Inset Remove Unary sym nogood : " + this.dr.stringOf(decision));
            if (!x.dom.isPresent(a)) continue;
            x.dom.removeElementary(a);
            Kit.log.info("Remove Unary sym nogood : " + this.dr.stringOf(decision));
            if (x.dom.size() == 0) {
                this.solver.stoppingType = Enums.EStopping.FULL_EXPLORATION;
                break;
            }
            effective = true;
        }
        this.decisionsToBePerformedAtNextRun.clear();
        if (this.solver.stoppingType != Enums.EStopping.FULL_EXPLORATION && effective && !this.solver.propagation.runInitially()) {
            this.solver.stoppingType = Enums.EStopping.FULL_EXPLORATION;
        }
    }

    @Override
    public void afterRun() {
    }

    @Override
    public void reset() {
        super.reset();
        Kit.fill(this.positiveWatchLists, null);
        Kit.fill(this.negativeWatchLists, null);
        Kit.control(this.cfg.learning.nogood != Enums.ELearningNogood.RST_SYM);
        this.unaryNogoodsToHandle = new ArrayList<Integer>();
        this.naryNogoodsToHandle = new LinkedList();
    }

    public boolean isBinaryNogoodPresent(int[] decs) {
        WatchCell firstCell;
        assert (decs.length == 2);
        WatchCell cell = firstCell = decs[0] > 0 ? this.positiveWatchLists[this.dr.numIn(decs[0])][this.dr.idxIn(decs[0])] : this.negativeWatchLists[this.dr.numIn(decs[0])][this.dr.idxIn(decs[0])];
        while (cell != null) {
            int[] cellDecisions = ((WatchCell)cell).nogood.decisions;
            if (cellDecisions.length == 2 && (decs[0] == cellDecisions[0] && decs[1] == cellDecisions[1] || decs[0] == cellDecisions[1] && decs[1] == cellDecisions[0])) {
                return true;
            }
            cell = cell.nextCell;
        }
        return false;
    }

    private void addWatchFor(Nogood nogood, int position, boolean firstWatch) {
        int decision = nogood.decisions[position];
        WatchCell[] cells = decision > 0 ? this.positiveWatchLists[this.dr.numIn(decision)] : this.negativeWatchLists[this.dr.numIn(decision)];
        int a = this.dr.idxIn(decision);
        if (this.free == null) {
            cells[a] = new WatchCell(nogood, cells[a]);
        } else {
            WatchCell cell = this.free;
            this.free = this.free.nextCell;
            cell.nogood = nogood;
            cell.nextCell = cells[a];
            cells[a] = cell;
        }
        nogood.setWatchedPosition(position, firstWatch);
    }

    private boolean canBeWatched(int decision) {
        assert (decision != 0);
        Variable x = this.dr.varIn(decision);
        int a = this.dr.idxIn(decision);
        return decision > 0 ? x.dom.isPresent(a) : x.dom.size() > 1 || !x.dom.isPresent(a);
    }

    private boolean canFindAnotherWatchFor(Nogood nogood, boolean firstWatch) {
        int i;
        int[] decs = nogood.decisions;
        int start = nogood.getWatchedPosition(firstWatch);
        for (i = start + 1; i < decs.length; ++i) {
            if (nogood.isPositionWatched(i) || !this.canBeWatched(decs[i])) continue;
            this.addWatchFor(nogood, i, firstWatch);
            return true;
        }
        for (i = 0; i < start; ++i) {
            if (nogood.isPositionWatched(i) || !this.canBeWatched(decs[i])) continue;
            this.addWatchFor(nogood, i, firstWatch);
            return true;
        }
        return false;
    }

    private boolean dealWithInference(int inferenceDecision) {
        Variable x = this.dr.varIn(inferenceDecision);
        int a = this.dr.idxIn(inferenceDecision);
        Domain dom = x.dom;
        if (inferenceDecision > 0) {
            if (!dom.isPresent(a)) {
                return false;
            }
            if (dom.size() == 1) {
                return true;
            }
            int b = dom.first();
            while (b != -1) {
                if (b != a) {
                    dom.removeElementary(b);
                }
                b = dom.next(b);
            }
        } else {
            if (!dom.isPresent(a)) {
                return true;
            }
            if (dom.size() == 1) {
                return false;
            }
            dom.removeElementary(a);
        }
        this.solver.propagation.queue.add(x);
        return true;
    }

    private boolean checkWatchesOf(WatchCell[] watchCells, int a, int watchedDecision) {
        WatchCell previous = null;
        WatchCell current = watchCells[a];
        while (current != null) {
            Nogood nogood = current.nogood;
            int watchedDecision2 = nogood.getSecondWatchedDecision(watchedDecision);
            if (!this.dr.varIn((int)watchedDecision2).dom.isPresent(this.dr.idxIn(watchedDecision2))) {
                previous = current;
                current = current.nextCell;
                continue;
            }
            if (this.canFindAnotherWatchFor(nogood, nogood.isDecisionWatchedByFirstWatch(watchedDecision))) {
                WatchCell tmp = current.nextCell;
                if (previous == null) {
                    watchCells[a] = current.nextCell;
                } else {
                    previous.nextCell = current.nextCell;
                }
                current.nextCell = this.free;
                this.free = current;
                current = tmp;
                continue;
            }
            previous = current;
            current = current.nextCell;
            if (this.dealWithInference(nogood.getSecondWatchedDecision(watchedDecision))) continue;
            if (this.cfg.learning.incrementNogoodWeight) {
                for (int decision : nogood.decisions) {
                    this.dr.varIn((int)decision).wdeg += 1.0;
                }
            }
            return false;
        }
        assert (this.controlWatches());
        return true;
    }

    @Override
    public boolean checkWatchesOf(Variable x, int a, boolean positive) {
        if (positive) {
            return this.checkWatchesOf(this.positiveWatchLists[x.num], a, this.dr.positiveDecisionFor(x.num, a));
        }
        return this.checkWatchesOf(this.negativeWatchLists[x.num], a, this.dr.negativeDecisionFor(x.num, a));
    }

    public LearnerNogoodsAdvanced(SolverBacktrack solver) {
        super(solver);
        this.cfg = solver.rs.cp;
        this.nogoods = new Nogood[this.cfg.learning.nogoodBaseLimit];
        Variable[] variables = solver.pb.variables;
        this.positiveWatchLists = new WatchCell[variables.length][];
        this.negativeWatchLists = new WatchCell[variables.length][];
        for (int i = 0; i < variables.length; ++i) {
            this.positiveWatchLists[i] = new WatchCell[variables[i].dom.initSize()];
            this.negativeWatchLists[i] = new WatchCell[variables[i].dom.initSize()];
        }
        this.tmp = new int[solver.pb.variables.length];
        if (this.cfg.learning.nogood == Enums.ELearningNogood.RST_SYM) {
            this.mapOfSymmetryGroupGenerators = new Map[solver.pb.symmetryGroupGenerators.size()];
            int cnt = 0;
            for (List<int[]> generator : solver.pb.symmetryGroupGenerators) {
                this.mapOfSymmetryGroupGenerators[cnt] = new HashMap<Integer, Integer>();
                HashMap<Integer, Integer> map = this.mapOfSymmetryGroupGenerators[cnt];
                for (int[] cycle : generator) {
                    for (int i = 0; i < cycle.length; ++i) {
                        map.put(cycle[i], cycle[(i + 1) % cycle.length]);
                    }
                }
                ++cnt;
            }
            this.tmps = new int[variables.length + 1][];
            this.nogoodsSetsBySize = new TreeSet[variables.length + 1];
        }
        solver.propagation.queue.setLearnerNogood(this);
    }

    private void addNogoodFrom(int[] decs, boolean toBeSorted) {
        if (this.nNogoods < this.nogoods.length) {
            decs = toBeSorted ? Kit.sort(decs) : decs;
            Nogood nogood = new Nogood(decs);
            this.nogoods[this.nNogoods++] = nogood;
            Nogood nogood2 = nogood;
            this.addWatchFor(nogood2, decs.length - 2, true);
            this.addWatchFor(nogood2, decs.length - 1, false);
            if (this.cfg.learning.nogood == Enums.ELearningNogood.RST_SYM) {
                (this.nogoodsSetsBySize[decs.length] == null ? (this.nogoodsSetsBySize[decs.length] = new TreeSet<int[]>(Utilities.lexComparatorInt)) : this.nogoodsSetsBySize[decs.length]).add(decs);
            }
        }
    }

    @Override
    public void addNogoodFrom(int[] decs) {
        this.addNogoodFrom(decs, true);
    }

    private int[] copy(SetDense denseSet, int coefficient) {
        int[] dst = new int[denseSet.size()];
        int[] dense = denseSet.dense;
        for (int i = dst.length - 1; i >= 0; --i) {
            dst[i] = coefficient * dense[i];
        }
        return dst;
    }

    @Override
    public void addCurrentNogood() {
        if (!this.cfg.learning.nogood.isRstType() && this.nNogoods < this.nogoods.length && this.solver.depth() >= 2) {
            int[] decs;
            int[] nArray = decs = this.cfg.learning.nogood == Enums.ELearningNogood.MIN_STD ? this.solver.rs.getAuxiliarySolver().minimalNogoodExtractor.extractMinimalNogoodFrom(this.solver, this.dr.decisions) : this.copy(this.dr.decisions, -1);
            if (decs != null && decs.length > 3) {
                this.addNogoodFrom(decs);
            }
            assert (this.controlWatches());
        }
    }

    private void handleSymmetricUnaryNogoods(int decision) {
        if (this.cfg.learning.nogood == Enums.ELearningNogood.RST_SYM) {
            this.unaryNogoodsToHandle.clear();
            this.unaryNogoodsToHandle.add(decision);
            for (int i = 0; i < this.cfg.learning.unarySymmetryLimit && this.unaryNogoodsToHandle.size() != 0; ++i) {
                int pickedDecision = this.unaryNogoodsToHandle.remove(this.unaryNogoodsToHandle.size() - 1);
                int a = this.dr.idxIn(pickedDecision);
                int x = this.dr.numIn(pickedDecision);
                for (Map<Integer, Integer> map : this.mapOfSymmetryGroupGenerators) {
                    int symmetricDecision;
                    Integer y = map.get(x);
                    if (y == null || this.decisionsToBePerformedAtNextRun.contains(symmetricDecision = this.dr.negativeDecisionFor(y, a))) continue;
                    this.decisionsToBePerformedAtNextRun.add(symmetricDecision);
                    this.unaryNogoodsToHandle.add(symmetricDecision);
                }
            }
        }
    }

    private void handleSymmetricNaryNogoods(int[] initialNogood) {
        if (this.cfg.learning.nogood == Enums.ELearningNogood.RST_SYM) {
            this.naryNogoodsToHandle.clear();
            this.naryNogoodsToHandle.add(initialNogood);
            int currentSpace = 0;
            while (currentSpace < this.cfg.learning.nonunarySymmetryLimit && this.naryNogoodsToHandle.size() != 0) {
                int[] nArray;
                int[] pickedNogood = this.naryNogoodsToHandle.poll();
                assert (Kit.isIncreasing(pickedNogood));
                if (this.tmps[pickedNogood.length] == null) {
                    this.tmps[pickedNogood.length] = new int[pickedNogood.length];
                    nArray = this.tmps[pickedNogood.length];
                } else {
                    nArray = this.tmps[pickedNogood.length];
                }
                int[] currentSymmetricNogood = nArray;
                for (Map<Integer, Integer> map : this.mapOfSymmetryGroupGenerators) {
                    boolean changed = false;
                    for (int j = 0; j < pickedNogood.length; ++j) {
                        int a = this.dr.idxIn(pickedNogood[j]);
                        int x = this.dr.numIn(pickedNogood[j]);
                        Integer y = map.get(x);
                        if (y != null) {
                            currentSymmetricNogood[j] = this.dr.negativeDecisionFor(y, a);
                            changed = true;
                            continue;
                        }
                        currentSymmetricNogood[j] = this.dr.negativeDecisionFor(x, a);
                    }
                    if (!changed) continue;
                    Arrays.sort(currentSymmetricNogood);
                    if (this.nogoodsSetsBySize[currentSymmetricNogood.length].contains(currentSymmetricNogood)) continue;
                    int[] symmetricNogood = (int[])currentSymmetricNogood.clone();
                    this.addNogoodFrom(symmetricNogood, false);
                    this.naryNogoodsToHandle.add(symmetricNogood);
                    currentSpace += symmetricNogood.length * symmetricNogood.length;
                    this.display(symmetricNogood);
                }
            }
        }
    }

    @Override
    public void addNogoodsOfCurrentBranch() {
        if (!this.cfg.learning.nogood.isRstType() || this.dr.decisions.size() < 2) {
            return;
        }
        boolean bottomUp = true;
        int nbMetPositiveDecisions = 0;
        for (int i = 0; i < this.dr.decisions.size(); ++i) {
            int dec = this.dr.decisions.dense[i];
            if (dec > 0) {
                this.tmp[nbMetPositiveDecisions++] = dec;
                continue;
            }
            if (nbMetPositiveDecisions > 0) {
                int[] currentNogood = new int[nbMetPositiveDecisions + 1];
                if (this.cfg.learning.nogood == Enums.ELearningNogood.RST_MIN && this.dr.isFailedAssignment(i)) {
                    int j;
                    if (bottomUp) {
                        for (j = 0; j < nbMetPositiveDecisions; ++j) {
                            currentNogood[j] = this.tmp[nbMetPositiveDecisions - j - 1];
                        }
                    } else {
                        for (j = 0; j < nbMetPositiveDecisions; ++j) {
                            currentNogood[j] = this.tmp[j];
                        }
                    }
                    currentNogood[currentNogood.length - 1] = -dec;
                    int[] minimizedNogood = this.solver.minimalNogoodExtractor.extractMinimalNogoodFrom(currentNogood);
                    if (minimizedNogood != null) {
                        if (minimizedNogood.length == 0) {
                            Kit.log.fine("Empty nogood => Inconistency");
                            return;
                        }
                        this.addNogoodFrom(minimizedNogood, this.cfg.learning.nogood == Enums.ELearningNogood.RST_SYM);
                    }
                } else {
                    for (int j = 0; j < currentNogood.length - 1; ++j) {
                        currentNogood[j] = -this.tmp[j];
                    }
                    currentNogood[currentNogood.length - 1] = dec;
                    this.addNogoodFrom(currentNogood, this.cfg.learning.nogood == Enums.ELearningNogood.RST_SYM);
                }
                this.handleSymmetricNaryNogoods(currentNogood);
                continue;
            }
            this.handleSymmetricUnaryNogoods(dec);
        }
        assert (this.controlWatches());
    }

    protected void display(int[] decs) {
        Kit.log.fine(Arrays.stream(decs).mapToObj(dec -> this.dr.stringOf(dec)).collect(Collectors.joining(" ")));
    }

    @Override
    public void display() {
        Kit.log.fine(this.nNogoods + " nogoods");
        IntStream.range(0, this.nNogoods).forEach(i -> this.display(this.nogoods[i].decisions));
    }

    private boolean control(WatchCell[][] watches, boolean positive) {
        for (int i = 0; i < watches.length; ++i) {
            for (int j = 0; j < watches[i].length; ++j) {
                WatchCell cell = watches[i][j];
                while (cell != null) {
                    if (!cell.nogood.isDecisionWatched(positive ? this.dr.positiveDecisionFor(i, j) : this.dr.negativeDecisionFor(i, j))) {
                        Kit.log.warning("nogood = " + cell.nogood + " does not watch");
                        return false;
                    }
                    cell = cell.nextCell;
                }
            }
        }
        return true;
    }

    private boolean controlNogood(int wdec, Nogood nogood) {
        WatchCell firstCell;
        WatchCell cell = firstCell = wdec > 0 ? this.positiveWatchLists[this.dr.numIn(wdec)][this.dr.idxIn(wdec)] : this.negativeWatchLists[this.dr.numIn(wdec)][this.dr.idxIn(wdec)];
        while (cell != null) {
            if (cell.nogood == nogood) {
                return true;
            }
            cell = cell.nextCell;
        }
        return false;
    }

    @Override
    protected boolean controlWatches() {
        if (!this.control(this.positiveWatchLists, true) || !this.control(this.negativeWatchLists, false)) {
            return false;
        }
        for (int i = 0; i < this.nNogoods; ++i) {
            if (this.nogoods[i] == null || this.controlNogood(this.nogoods[i].getWatchedDecision(true), this.nogoods[i]) && this.controlNogood(this.nogoods[i].getWatchedDecision(false), this.nogoods[i])) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        TreeSet<int[]> set = new TreeSet<int[]>(Utilities.lexComparatorInt);
        int[] t1 = new int[]{3, 4};
        int[] t2 = new int[]{3, 4};
        set.add(t1);
        System.out.println(set.contains(t2));
    }

    private class WatchCell {
        private Nogood nogood;
        private WatchCell nextCell;

        private WatchCell(Nogood nogood, WatchCell nextCell) {
            this.nogood = nogood;
            this.nextCell = nextCell;
        }
    }
}

