/*
 * Decompiled with CFR 0.152.
 */
package heuristics.values.fixed;

import constraints.Constraint;
import constraints.CtrHard;
import heuristics.values.HeuristicValuesFixed;
import variables.Variable;

public class SampledConflicts
extends HeuristicValuesFixed {
    private int samplingSize = 100;

    public SampledConflicts(Variable x, boolean antiHeuristic) {
        super(x, antiHeuristic);
    }

    @Override
    public double scoreOf(int a) {
        double nConflicts = 0.0;
        for (Constraint c : this.x.ctrs) {
            int px = c.positionOf(this.x);
            int[] tuple = c.tupleManager.localTuple;
            for (int cnt = 0; cnt < this.samplingSize; ++cnt) {
                for (int p = 0; p < tuple.length; ++p) {
                    tuple[p] = p == px ? a : c.doms[p].random();
                }
                if (((CtrHard)c).checkIndexes(tuple)) continue;
                nConflicts += 1.0;
            }
        }
        return nConflicts;
    }
}

