/*
 * Decompiled with CFR 0.152.
 */
package heuristics.revisions;

import heuristics.revisions.HeuristicRevisions;
import propagation.PropagationQueue;
import utility.interfaces.TagMaximize;

public abstract class HeuristicRevisionsDynamic
extends HeuristicRevisions {
    public HeuristicRevisionsDynamic(PropagationQueue queue, boolean antiHeuristic) {
        super(queue, antiHeuristic);
    }

    @Override
    public int bestPosition() {
        int bestPos = 0;
        double bestScore = this.scoreOf(0) * (double)this.scoreCoeff;
        for (int i = 1; i < this.queue.size(); ++i) {
            double score = this.scoreOf(i) * (double)this.scoreCoeff;
            if (!(score > bestScore)) continue;
            bestPos = i;
            bestScore = score;
        }
        return bestPos;
    }

    public static final class Lexico
    extends HeuristicRevisionsDynamic {
        public Lexico(PropagationQueue queue, boolean antiHeuristic) {
            super(queue, antiHeuristic);
        }

        @Override
        protected double scoreOf(int i) {
            return this.queue.var((int)i).num;
        }
    }

    public static final class WDegOnDom
    extends HeuristicRevisionsDynamic
    implements TagMaximize {
        public WDegOnDom(PropagationQueue queue, boolean antiHeuristic) {
            super(queue, antiHeuristic);
        }

        @Override
        protected double scoreOf(int i) {
            return this.queue.var(i).wdegOnDom();
        }
    }

    public static final class WDeg
    extends HeuristicRevisionsDynamic
    implements TagMaximize {
        public WDeg(PropagationQueue queue, boolean antiHeuristic) {
            super(queue, antiHeuristic);
        }

        @Override
        protected double scoreOf(int i) {
            return this.queue.var((int)i).wdeg;
        }
    }

    public static final class DDegOnDom
    extends HeuristicRevisionsDynamic
    implements TagMaximize {
        public DDegOnDom(PropagationQueue queue, boolean antiHeuristic) {
            super(queue, antiHeuristic);
        }

        @Override
        protected double scoreOf(int i) {
            return this.queue.var(i).ddegOnDom();
        }
    }

    public static final class DDeg
    extends HeuristicRevisionsDynamic
    implements TagMaximize {
        public DDeg(PropagationQueue queue, boolean antiHeuristic) {
            super(queue, antiHeuristic);
        }

        @Override
        protected double scoreOf(int i) {
            return this.queue.var(i).ddeg();
        }
    }

    public static final class Dom
    extends HeuristicRevisionsDynamic {
        public Dom(PropagationQueue queue, boolean antiHeuristic) {
            super(queue, antiHeuristic);
        }

        @Override
        protected double scoreOf(int i) {
            return this.queue.var((int)i).dom.size();
        }
    }
}

